/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.db;

import com.trs.cms.auth.persistent.User;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.db.IInfoViewDBMgr;
import com.trs.components.infoview.db.InfoViewDataType;
import com.trs.components.infoview.db.LetterConvertor;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.TableInfo;
import org.apache.log4j.Logger;

public class InfoViewDBMgr
implements IInfoViewDBMgr {
    public static double RATE_OF_FIELD_LENGTH = 1.5;
    private static Logger logger = Logger.getLogger(InfoViewDBMgr.class);
    private DBManager m_oDBMgr = DBManager.getDBManager();

    @Override
    public void createDBTable(User _currUser, int _nInfoViewId) throws WCMException {
        String sNewTableName = InfoViewConstants.makeTrueTableName(_nInfoViewId);
        if (this.m_oDBMgr.getTableInfo(sNewTableName) != null) {
            return;
        }
        this.createTableInDB(_currUser, _nInfoViewId, sNewTableName);
        if (sNewTableName != null) {
            this.m_oDBMgr.reloadTableInfo(sNewTableName);
        }
    }

    private void createTableInDB(User _currUser, int _nInfoViewId, String _sTableName) throws WCMException {
        if (this.m_oDBMgr.getTableInfo(_sTableName) != null) {
            return;
        }
        String sCreateNewTableSQL = this.m_oDBMgr.getDBType().sqlCreateTableWithPrimary(_sTableName, InfoViewConstants.getIdFieldName(_sTableName));
        this.m_oDBMgr.sqlExecuteUpdate(sCreateNewTableSQL);
        this.m_oDBMgr.reloadTableInfo(_sTableName);
        this.appendDefaultFields(_currUser, _nInfoViewId);
        String sRandom = String.valueOf(System.currentTimeMillis());
        sRandom = sRandom.substring(sRandom.length() - 9);
        String sIndexName = "IXIV_" + _nInfoViewId + "_" + sRandom;
        String sCreateIndexSQL = "create unique index " + sIndexName + " on " + _sTableName + "(" + "DocumentId" + ")";
        this.m_oDBMgr.sqlExecuteUpdate(sCreateIndexSQL);
    }

    private void createDBField(User _currUser, int _nInfoViewId, int _nIVFieldId) throws WCMException {
        String sNewColumnName;
        String sTableName = InfoViewConstants.makeTrueTableName(_nInfoViewId);
        if (this.m_oDBMgr.getFieldInfo(sTableName, sNewColumnName = InfoViewConstants.makeTrueFieldName(_nIVFieldId)) != null) {
            return;
        }
        this.createFieldInDB(_currUser, _nIVFieldId, sTableName);
        this.m_oDBMgr.reloadTableInfo(sTableName);
    }

    private void createFieldInDB(User _currUser, int _nIVFieldId, String _sTableName) throws WCMException {
        InfoViewField oField = InfoViewField.findById(_nIVFieldId);
        String sNewColumnName = InfoViewConstants.makeTrueFieldName(_nIVFieldId);
        String sCreateSQL = this.m_oDBMgr.getDBType().sqlAddField(_sTableName, sNewColumnName, oField.getDataType(), oField.getMaxLength(), !oField.isNillable(), oField.getDefaultValue(), 0);
        this.m_oDBMgr.sqlExecuteUpdate(sCreateSQL);
        oField.setTrueFieldName(sNewColumnName);
        oField.save(_currUser);
    }

    public String createTableSQL(int _nInfoViewId) throws WCMException {
        String sTableName = InfoViewConstants.makeTrueTableName(_nInfoViewId);
        String sPrimaryFieldName = sTableName + "Id";
        DBType currType = this.m_oDBMgr.getDBType();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(currType.sqlCreateTable());
        sbSQL.append(" ");
        sbSQL.append(sTableName);
        sbSQL.append("\n");
        sbSQL.append("(\n");
        sbSQL.append("      ");
        sbSQL.append(sPrimaryFieldName);
        sbSQL.append(" ");
        sbSQL.append(currType.getTypeName(4));
        sbSQL.append(" Primary Key \n");
        sbSQL.append(")");
        return sbSQL.toString();
    }

    private void deleteDBField(User _currUser, int _nInfoViewId, int _nIVFiedlId) throws WCMException {
        String sFieldName;
        DBType dbType = this.m_oDBMgr.getDBType();
        String sTableName = InfoViewConstants.makeTrueTableName(_nInfoViewId);
        if (this.m_oDBMgr.getFieldInfo(sTableName, sFieldName = InfoViewConstants.makeTrueFieldName(_nIVFiedlId)) != null) {
            String sDropSQL = null;
            try {
                sDropSQL = dbType.sqlDropField(sTableName, sFieldName);
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label3", "\u751f\u6210\u5220\u9664\u5b57\u6bb5\u811a\u672c\u51fa\u9519\uff01"), e);
            }
            this.m_oDBMgr.sqlExecuteUpdate(sDropSQL);
            this.m_oDBMgr.getTableInfos().getTableInfo(sTableName).removeFieldInfo(sFieldName);
        }
    }

    @Override
    public void deleteDBField(User _currUser, InfoView _view, InfoViewField _viewField) throws WCMException {
        int nFromInfoViewId = InfoViewDBMgr.getNewRuleFromInfoViewId();
        if (_view.getId() < nFromInfoViewId) {
            this.deleteDBField(_currUser, _view.getId(), _viewField.getId());
            return;
        }
        String sDBFieldName = _viewField.getName();
        sDBFieldName = LetterConvertor.convertToFirstLetter(sDBFieldName);
        String sTableName = InfoViewConstants.makeTrueTableName(_view.getId());
        if (this.m_oDBMgr.getFieldInfo(sTableName, sDBFieldName) == null) {
            return;
        }
        String sDropSQL = null;
        try {
            sDropSQL = this.m_oDBMgr.getDBType().sqlDropField(sTableName, sDBFieldName);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label3", "\u751f\u6210\u5220\u9664\u5b57\u6bb5\u811a\u672c\u51fa\u9519\uff01"), e);
        }
        this.m_oDBMgr.sqlExecuteUpdate(sDropSQL);
        this.m_oDBMgr.getTableInfos().getTableInfo(sTableName).removeFieldInfo(sDBFieldName);
    }

    @Override
    public void deleteDBTable(User _currUser, int _nInfoViewId) throws WCMException {
        DBType dbType = this.m_oDBMgr.getDBType();
        String sTableName = InfoViewConstants.makeTrueTableName(_nInfoViewId);
        if (this.m_oDBMgr.getTableInfo(sTableName) != null) {
            String sDropSQL = null;
            try {
                sDropSQL = dbType.sqlDropTable(sTableName);
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label4", "\u751f\u6210\u5220\u9664\u8868\u811a\u672c\u51fa\u9519\uff01"), e);
            }
            this.m_oDBMgr.sqlExecuteUpdate(sDropSQL);
            this.m_oDBMgr.getTableInfos().removeTableInfo(sTableName);
        }
    }

    public void appendDefaultFields(User _currUser, int _nInfoViewId) throws WCMException {
        String sTableName = InfoViewConstants.makeTrueTableName(_nInfoViewId);
        this.appendDefaultFields(sTableName);
    }

    private void appendDefaultFields(String _sTableName) throws WCMException {
        TableInfo tableInfo = this.m_oDBMgr.getTableInfo(_sTableName);
        if (tableInfo == null) {
            logger.info((Object)(I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label5", "\u6307\u5b9a\u7684\u8868[") + _sTableName + I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label6", "]\u4e0d\u5b58\u5728\uff01")));
            return;
        }
        boolean bCreateNewField = false;
        for (int i = 0; i < InfoViewConstants.DEFAULT_FIELDS.getDataTypesCount(); ++i) {
            InfoViewDataType fieldType = InfoViewConstants.DEFAULT_FIELDS.getDataTypeAt(i);
            String sFieldName = fieldType.getKey();
            if (tableInfo.getFieldInfo(sFieldName) != null) {
                logger.info((Object)(I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label5", "\u6307\u5b9a\u7684\u8868[") + _sTableName + I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label7", "]\u7684\u5b57\u6bb5[") + sFieldName + I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label1", "]\u5df2\u7ecf\u5b58\u5728\uff01")));
                continue;
            }
            bCreateNewField = true;
            String sCreateSQL = this.m_oDBMgr.getDBType().sqlAddField(_sTableName, sFieldName, fieldType.getSqlDataType(), fieldType.getMaxLength(), true, null, 0);
            this.m_oDBMgr.sqlExecuteUpdate(sCreateSQL);
        }
        if (bCreateNewField) {
            this.m_oDBMgr.reloadTableInfo(_sTableName);
        }
    }

    @Override
    public void createDBField(User user, InfoView _view, InfoViewField _viewField) throws WCMException {
        int nFromInfoViewId = InfoViewDBMgr.getNewRuleFromInfoViewId();
        if (_view.getId() < nFromInfoViewId) {
            this.createDBField(user, _view.getId(), _viewField.getId());
            return;
        }
        String sDBFieldName = _viewField.getName();
        sDBFieldName = LetterConvertor.convertToFirstLetter(sDBFieldName);
        String sTableName = InfoViewConstants.makeTrueTableName(_view.getId());
        if (this.m_oDBMgr.getFieldInfo(sTableName, sDBFieldName) != null) {
            return;
        }
        int nMaxLength = (int)((double)_viewField.getMaxLength() * RATE_OF_FIELD_LENGTH);
        String sCreateSQL = this.m_oDBMgr.getDBType().sqlAddField(sTableName, sDBFieldName, _viewField.getDataType(), nMaxLength, !_viewField.isNillable(), _viewField.getDefaultValue(), 0);
        this.m_oDBMgr.sqlExecuteUpdate(sCreateSQL);
        _viewField.setTrueFieldName(sDBFieldName);
        _viewField.save(user);
        this.m_oDBMgr.reloadTableInfo(sTableName);
    }

    private static int getNewRuleFromInfoViewId() throws WCMException {
        int nFromInfoViewId = -1;
        String sConfigValue = ConfigServer.getServer().getSysConfigValue("NEWRULE_FROM_INFOVIEWID", "-1");
        try {
            nFromInfoViewId = Integer.parseInt(sConfigValue);
        }
        catch (NumberFormatException e) {
            logger.error((Object)(I18NMessage.get(InfoViewDBMgr.class, "InfoViewDBMgr.label8", "\u65b0\u89c4\u5219\u8d77\u59cb\u7684ID\u914d\u7f6e\u9519\u8bef![") + sConfigValue + "]"), (Throwable)e);
            nFromInfoViewId = -1;
        }
        return nFromInfoViewId;
    }
}

