/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.TemplateServiceProvider;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.widget.IMasterMgr;
import com.trs.components.common.publish.widget.IVisualTemplateServiceProvider;
import com.trs.components.common.publish.widget.IWidgetInstParameterMgr;
import com.trs.components.common.publish.widget.IWidgetInstanceMgr;
import com.trs.components.common.publish.widget.IWidgetParameterMgr;
import com.trs.components.common.publish.widget.IWidgetServer;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.MasterServiceProvider;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.WidgetInstParameter;
import com.trs.components.common.publish.widget.WidgetInstParameters;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.common.publish.widget.WidgetInstances;
import com.trs.components.common.publish.widget.WidgetParameter;
import com.trs.components.common.publish.widget.WidgetParameters;
import com.trs.components.common.publish.widget.acceptor.IWidgetAcceptorSelector;
import com.trs.components.common.publish.widget.acceptor.WidgetAcceptorContext;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class VisualTemplateServiceProvider
implements IVisualTemplateServiceProvider {
    private IMasterMgr m_oMasterMgr = null;
    private TemplateMgr m_oTemplateMgr = null;
    private List m_oWidgetList = new ArrayList();
    IWidgetServer m_oWidgetServer = (IWidgetServer)DreamFactory.createObjectById("IWidgetServer");
    IWidgetInstanceMgr m_oWidgetInstanceMgr;
    IWidgetInstParameterMgr m_oWidgetInstParameterMgr = (IWidgetInstParameterMgr)DreamFactory.createObjectById("IWidgetInstParameterMgr");
    IWidgetAcceptorSelector m_oWidgetAcceptorSelector;
    IWidgetParameterMgr oWidgetParameterMgr;
    private static Logger logger = Logger.getLogger(VisualTemplateServiceProvider.class);

    public VisualTemplateServiceProvider() {
        this.m_oWidgetInstanceMgr = (IWidgetInstanceMgr)DreamFactory.createObjectById("IWidgetInstanceMgr");
        this.m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        this.m_oMasterMgr = (IMasterMgr)DreamFactory.createObjectById("IMasterMgr");
        this.m_oWidgetAcceptorSelector = (IWidgetAcceptorSelector)DreamFactory.createObjectById("IWidgetAcceptorSelector");
        this.oWidgetParameterMgr = (IWidgetParameterMgr)DreamFactory.createObjectById("IWidgetParameterMgr");
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public String parseTemplate(MethodContext context) throws Throwable {
        int nObjId = context.getValue("objectId", 0);
        int nObjType = context.getValue("objectType", 0);
        IPublishElement oPublishElement = PublishElementFactory.lookupElement(nObjType, nObjId);
        int nTemplateId = context.getValue("TemplateId", 0);
        Template oTemplate = Template.findById(nTemplateId);
        return this.m_oWidgetServer.parseToEditContent(oPublishElement, oTemplate);
    }

    @Override
    public String parseWidgetInstance(MethodContext context) throws Throwable {
        int nObjId = context.getValue("objectId", 0);
        int nObjType = context.getValue("objectType", 0);
        IPublishElement oPublishElement = PublishElementFactory.lookupElement(nObjType, nObjId);
        int nWidgetInstanceId = context.getValue("WidgetInstanceId", 0);
        WidgetInstance oWidgetInstance = WidgetInstance.findById(nWidgetInstanceId);
        return this.m_oWidgetServer.parseToEditContent(oPublishElement, oWidgetInstance);
    }

    @Override
    public int saveToTemplate(MethodContext context) throws Throwable {
        int nTemplateId = context.getValue("templateId", 0);
        String sVisualHtml = context.getValue("html");
        String sTemplateText = this.m_oWidgetServer.parseToTemplate(sVisualHtml);
        Template template = Template.findById(nTemplateId);
        template.setText(sTemplateText);
        this.m_oTemplateMgr.save(template, null, true, 2);
        return nTemplateId;
    }

    @Override
    public void synchronizeWidgetInstances(MethodContext methodContext) throws WCMException {
        int nTemplateId = methodContext.getValue("templateId", 0);
        Template template = Template.findById(nTemplateId);
        if (template == null) {
            throw new WCMException("\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u6a21\u677f[id=" + nTemplateId + "]");
        }
        this.m_oWidgetServer.synchronizeWidgetInstances(template);
    }

    public void syncWidgetInstancesToChildChnl(MethodContext methodContext) throws WCMException {
        int nChnlId = methodContext.getValue("ChnlId", 0);
        int nWIId = methodContext.getValue("WidgetInstanceId", 0);
        Channel chnl = Channel.findById(nChnlId);
        if (chnl == null) {
            throw new WCMException("\u6ca1\u6709\u83b7\u53d6\u5230\u680f\u76ee[id=" + nChnlId + "]");
        }
        this.m_oWidgetList.clear();
        List<Channel> list = chnl.getChildren(ContextHelper.getLoginUser());
        for (int i = 0; i < list.size(); ++i) {
            this.syncWidgetInstanceToChnl(WidgetInstance.findById(nWIId), list.get(i));
        }
    }

    private void syncWidgetInstanceToChnl(WidgetInstance widget, Channel chnl) throws WCMException {
        if (widget == null || chnl == null) {
            return;
        }
        IPublishFolder publishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(chnl);
        WCMFolderPublishConfig folderConfig = new WCMFolderPublishConfig(publishFolder);
        String sOutlineTemplateIds = folderConfig.getOutlineTemplateIds();
        int nDetailTemplateIds = folderConfig.getDetailTemplateId();
        if (CMyString.isEmpty(sOutlineTemplateIds)) {
            return;
        }
        String sTemplateIds = sOutlineTemplateIds + "," + nDetailTemplateIds;
        String sWhere = "TEMPLATEID in(" + sTemplateIds + ") and WIDGETID=" + widget.getWidgetId();
        WCMFilter filter = new WCMFilter("", sWhere, "");
        WidgetInstances widgets = WidgetInstances.openWCMObjs(null, filter);
        for (int i = widgets.size() - 1; i >= 0; --i) {
            if (this.m_oWidgetList.contains(new Integer(widgets.getAt(i).getId()))) continue;
            this.syncWidgetInstanceToInstance(widget, (WidgetInstance)widgets.getAt(i));
            this.m_oWidgetList.add(new Integer(widgets.getAt(i).getId()));
        }
    }

    private void syncWidgetInstanceToInstance(WidgetInstance srcWidget, WidgetInstance tarWidget) throws WCMException {
        if (srcWidget == null || tarWidget == null || srcWidget.getWidgetId() != tarWidget.getWidgetId()) {
            return;
        }
        this.m_oWidgetInstParameterMgr.saveParameters(tarWidget, this.m_oWidgetInstParameterMgr.getParameters(srcWidget));
        this.m_oWidgetServer.refreshWidgetForTemplate(tarWidget);
    }

    @Override
    public String preview(MethodContext context) throws Exception {
        int nObjId = context.getValue("objectId", 0);
        int nObjType = context.getValue("objectType", 0);
        IPublishElement publishElement = PublishElementFactory.lookupElement(nObjType, nObjId);
        String sVisualHtml = context.getValue("html");
        String sTempateText = this.m_oWidgetServer.parseToTemplate(sVisualHtml);
        String[] aResult = TagParseHelper.parseContent(publishElement, sTempateText);
        String sPreviewContent = "";
        if (aResult != null && aResult.length > 0) {
            sPreviewContent = aResult[0];
        }
        String sTempFileName = "visualTemplate_preview_tempFile.html";
        PublishPathCompass compass = new PublishPathCompass();
        String sLocalPath = compass.getPreviewLocalPath(publishElement) + sTempFileName;
        CMyFile.writeFile(sLocalPath, sPreviewContent, "utf-8");
        return compass.getPreviewHttpPath(publishElement) + sTempFileName;
    }

    public int saveWidgetInstance(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nWidgetInstanceId = context.getValue("WIDGETINSTANCEID", 0);
        WidgetInstance oCurrWidgetInstance = null;
        oCurrWidgetInstance = nWidgetInstanceId > 0 ? WidgetInstance.findById(nWidgetInstanceId) : new WidgetInstance();
        String[] pLogicFields = new String[]{"WIDGETINSTANCEID"};
        oCurrWidgetInstance = (WidgetInstance)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, oCurrWidgetInstance, pLogicFields);
        WidgetInstance currWidgetInstance = this.m_oWidgetInstanceMgr.save(loginUser, oCurrWidgetInstance);
        return currWidgetInstance.getId();
    }

    public int saveWidgetInstParameter(MethodContext context) throws Throwable {
        int nWidgetInstanceId = context.getValue("widgetInstanceId", 0);
        boolean bAdd = context.getValue("bAdd", true);
        WidgetInstance currWidgetInstance = WidgetInstance.findById(nWidgetInstanceId);
        if (currWidgetInstance == null) {
            throw new WCMException(200006, "\u6ca1\u6709\u4f20\u5165\u6709\u6548\u7684widgetInstanceId");
        }
        Map parameters = new HashMap();
        parameters = context.getParams();
        if (parameters.size() < 0) {
            logger.error((Object)"\u672a\u4f20\u9012\u53c2\u6570\uff01");
            return 0;
        }
        Widget oWidget = currWidgetInstance.getWidget();
        WidgetParameters oWidgetParameters = this.oWidgetParameterMgr.query(oWidget);
        int nSize = oWidgetParameters.size();
        for (int i = 0; i < nSize; ++i) {
            String sParaName;
            String sParamValue;
            WidgetParameter oWidgetParameter = (WidgetParameter)oWidgetParameters.getAt(i);
            if (oWidgetParameter == null || CMyString.isEmpty(sParamValue = (String)parameters.get((sParaName = oWidgetParameter.getWidgetParamName()).toUpperCase()))) continue;
            WidgetInstParameter oWidgetInstParameter = this.m_oWidgetInstParameterMgr.saveParameter(currWidgetInstance, oWidgetParameter, sParamValue);
            return oWidgetInstParameter.getId();
        }
        return 0;
    }

    public int saveWidgetInstParameters(MethodContext context) throws Throwable {
        int nWidgetInstanceId = context.getValue("widgetInstanceId", 0);
        String sContentHtml = context.getValue("DefalutHtmlContent");
        String sWStyleId = context.getValue("WSTYLEID");
        context.setValue("DefalutHtmlContent", "");
        boolean bAdd = context.getValue("bAdd", true);
        WidgetInstance currWidgetInstance = WidgetInstance.findById(nWidgetInstanceId);
        if (currWidgetInstance == null) {
            throw new WCMException(200006, "\u6ca1\u6709\u4f20\u5165\u6709\u6548\u7684widgetInstanceId");
        }
        Map<String, String> parameters = new HashMap();
        parameters = context.getParams();
        if (!CMyString.isEmpty(sWStyleId)) {
            parameters.put("WSTYLEID", sWStyleId);
        }
        if (!CMyString.isEmpty(sContentHtml)) {
            if (sContentHtml.indexOf("Copyright@2013") > 0) {
                parameters.put("\u7248\u6743\u5185\u5bb9", sContentHtml);
            }
            if (sContentHtml.indexOf("37606308") > 0) {
                parameters.put("\u5185\u5bb9", sContentHtml);
            }
        }
        WidgetInstParameters oWidgetInstParameters = null;
        oWidgetInstParameters = bAdd ? this.m_oWidgetInstParameterMgr.addParameters(currWidgetInstance, parameters) : this.m_oWidgetInstParameterMgr.saveParameters(currWidgetInstance, parameters);
        return oWidgetInstParameters.size();
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        int nMasterFileType;
        User loginUser = this.getLoginUser();
        int nObjectId = context.getObjectId();
        int nMasterId = context.getValue("MasterId", 0);
        int nTemplateType = context.getValue("TEMPTYPE", 0);
        Template oTemplate = null;
        IPublishFolder folder = this.findPublishFolder(context);
        if (nObjectId == 0) {
            this.validateRight(loginUser, folder, 21, "\u65b0\u5efa\u6a21\u677f");
        } else {
            oTemplate = Template.findById(nObjectId);
            if (oTemplate == null) {
                throw new WCMException("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f\u3010ID=" + nObjectId + "\u3011\uff01");
            }
            folder = oTemplate.getFolder();
            this.validateRight(loginUser, folder, 21, "\u4fee\u6539\u6a21\u677f");
        }
        int n = nMasterFileType = nTemplateType == 2 ? 3 : 1;
        if (nObjectId == 0) {
            if (nMasterId == 0) {
                throw new WCMException("\u60a8\u5fc5\u987b\u4f20\u5165\u53c2\u6570\u6bcd\u7248\u7684Id\u624d\u80fd\u8fdb\u884c\u53ef\u89c6\u5316\u6a21\u677f\u7684\u4fdd\u5b58\uff01");
            }
            Master oMaster = Master.findById(nMasterId);
            if (oMaster == null) {
                throw new WCMException("\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u6bcd\u7248\u3010ID=" + nMasterId + "\u3011\u5bf9\u8c61\uff01");
            }
            IWidgetServer oWidgetServer = (IWidgetServer)DreamFactory.createObjectById("IWidgetServer");
            oTemplate = oWidgetServer.createTemplateFromMaster(folder, oMaster, nMasterFileType);
        }
        String[] pLogicFields = new String[]{"ObjectId", "HostType", "HostId"};
        oTemplate = (Template)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, oTemplate, pLogicFields);
        this.m_oTemplateMgr.save(oTemplate, null, true, 2);
        return oTemplate.getId();
    }

    @Override
    public void deleteWidgetInstance(MethodContext context) throws Throwable {
    }

    @Override
    public void delete(MethodContext context) throws Throwable {
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }

    private IPublishFolder findPublishFolder(MethodContext _methodContext) throws WCMException {
        return this.findPublishFolder(_methodContext, null);
    }

    private IPublishFolder findPublishFolder(MethodContext _methodContext, String _sClassPre) throws WCMException {
        String sClassPre = _sClassPre == null ? "Host" : _sClassPre;
        int nObjectType = _methodContext.getValue(sClassPre + "Type", 0);
        if (nObjectType == 0) {
            throw new WCMException(1101, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label36", "\u6ca1\u6709\u6307\u5b9a[") + sClassPre + "Type]!");
        }
        int nObjectId = _methodContext.getValue(sClassPre + "Id", 0);
        if (nObjectId == 0) {
            throw new WCMException(1101, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label36", "\u6ca1\u6709\u6307\u5b9a[") + sClassPre + "Id]!");
        }
        IPublishElement publishElement = PublishElementFactory.lookupElement(nObjectType, nObjectId);
        if (publishElement == null) {
            throw new WCMException(200006, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label37", "\u6307\u5b9a\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01(Type=") + nObjectType + ", Id=" + nObjectId + ")");
        }
        if (!(publishElement instanceof IPublishFolder)) {
            throw new WCMException(10, I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label38", "\u6307\u5b9a\u7684\u5bf9\u8c61(") + publishElement.getInfo() + I18NMessage.get(TemplateServiceProvider.class, "TemplateServiceProvider.label39", ")\u4e0d\u662fFolder!"));
        }
        return (IPublishFolder)publishElement;
    }

    private void validateRight(User _loginUser, IPublishFolder _folder, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (AuthServer.hasRight(_loginUser, _folder.getSubstance(), _nRightIndex)) {
            return;
        }
        IPublishFolder parent = _folder.getParent();
        if (parent == null || parent == _folder) {
            throw new WCMException("\u5bf9\u4e0d\u8d77\uff0c\u60a8[" + _loginUser.getName() + "]\u6ca1\u6709\u6743\u9650\u6267\u884c " + _sOperDesc + " !");
        }
        this.validateRight(_loginUser, parent, _nRightIndex, _sOperDesc);
    }

    @Override
    public String copyWidgetInstance(MethodContext context) throws Exception {
        int nWidgetInstanceId = context.getValue("objectId", 0);
        WidgetInstance srcWidgetInstance = WidgetInstance.findById(nWidgetInstanceId);
        WidgetInstance newWidgetInstance = (WidgetInstance)srcWidgetInstance.cloneToNewObj();
        newWidgetInstance.save(this.getLoginUser());
        Map oParameters = this.m_oWidgetInstParameterMgr.getParameters(srcWidgetInstance);
        this.m_oWidgetInstParameterMgr.addParameters(newWidgetInstance, oParameters);
        return String.valueOf(newWidgetInstance.getId());
    }

    public Reports copyVisualTemplate(MethodContext _context) throws Exception {
        int i;
        String sToChannelIds = _context.getValue("ToChannelIds");
        User currUser = this.getLoginUser();
        if (CMyString.isEmpty(sToChannelIds)) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u7c7b\u4f3c\u521b\u5efa\u5230\u7684\u680f\u76ee");
        }
        Channels toChannels = Channels.findByIds(currUser, sToChannelIds);
        int nTemplateId = _context.getValue("TemplateId", 0);
        if (nTemplateId == 0) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u539f\u6a21\u677f\u7684Id");
        }
        Template srcTemplate = Template.findById(nTemplateId);
        if (srcTemplate == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230\u6307\u5b9aId\u4e3a[" + nTemplateId + "]\u7684\u6a21\u677f");
        }
        Channels nothasRightChnls = Channels.createNewInstance(currUser);
        int nSize = toChannels.size();
        for (i = nSize - 1; i >= 0; --i) {
            Channel currChannel = (Channel)toChannels.getAt(i);
            if (currChannel == null) continue;
            IPublishElement publishElement = PublishElementFactory.lookupElement(101, currChannel.getId());
            try {
                this.validateRight(currUser, (IPublishFolder)publishElement, 21, "\u65b0\u5efa\u6a21\u677f");
                continue;
            }
            catch (WCMException ex) {
                nothasRightChnls.addElement(currChannel);
                toChannels.remove(currChannel, false);
            }
        }
        Reports reports = this.m_oTemplateMgr.copyVisualTempToChnls(toChannels, srcTemplate);
        int nSize2 = nothasRightChnls.size();
        for (i = 0; i < nSize2; ++i) {
            Channel channel = (Channel)nothasRightChnls.getAt(i);
            if (channel == null) continue;
            reports.addFailedReport("\u5728\u680f\u76ee\u3010" + channel + "\u3011\u4e0b\u7c7b\u4f3c\u521b\u5efa\u6a21\u677f\u5931\u8d25\uff01", new WCMException(1002, "\u7528\u6237\u5728\u680f\u76ee\u3010" + channel + "\u3011\u4e0b\u6ca1\u6709\u65b0\u5efa\u6a21\u677f\u6743\u9650"));
        }
        return reports;
    }

    @Override
    public int saveToMaster(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nMasterId = context.getObjectId();
        Master currMaster = null;
        if (nMasterId == 0) {
            currMaster = new Master();
        } else {
            currMaster = Master.findById(nMasterId);
            if (currMaster == null) {
                throw new WCMException(CMyString.format(I18NMessage.get(MasterServiceProvider.class, "MasterServiceProvider.label2", "\u6307\u5b9aId\u4e3a[{0}]\u7684\u6bcd\u677f\u4e0d\u5b58\u5728"), new int[]{nMasterId}));
            }
        }
        if (currMaster.isAddMode()) {
            if (!SpecialAuthServer.hasRight(loginUser, currMaster, 21)) {
                throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u6bcd\u677f");
            }
        } else if (!SpecialAuthServer.hasRight(loginUser, currMaster, 22)) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u6bcd\u677f\u3010" + currMaster.getMName() + "\u3011");
        }
        String[] pLogicFields = new String[]{"ObjectId"};
        currMaster = (Master)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, currMaster, pLogicFields);
        Master oMaster = this.m_oMasterMgr.save(loginUser, currMaster);
        return oMaster.getId();
    }

    @Override
    public String createWidgetInstanceFromWidgetAcceptor(MethodContext context) throws Exception {
        int nChannelId = context.getValue("channelid", 0);
        Channel channel = Channel.findById(nChannelId);
        int left = context.getValue("left", 0);
        int top = context.getValue("top", 0);
        int width = context.getValue("width", 0);
        int nTemplateId = context.getValue("templateid", 0);
        int nObjId = context.getValue("objectId", 0);
        int nObjType = context.getValue("objectType", 0);
        WidgetAcceptorContext acceptorContext = new WidgetAcceptorContext(context);
        acceptorContext.setHost(channel);
        acceptorContext.setLeft(left);
        acceptorContext.setTop(top);
        acceptorContext.setWidth(width);
        Widget oWidget = this.m_oWidgetAcceptorSelector.getWidget(acceptorContext);
        if (oWidget == null) {
            return "";
        }
        WidgetInstance oWidgetInstance = new WidgetInstance();
        oWidgetInstance.setWidgetId(oWidget.getId());
        oWidgetInstance.setTemplateId(nTemplateId);
        this.m_oWidgetInstanceMgr.save(this.getLoginUser(), oWidgetInstance);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("\u6240\u5c5e\u680f\u76ee", String.valueOf(nChannelId));
        parameters.put("\u7236\u680f\u76ee", String.valueOf(nChannelId));
        Map tempParameters = acceptorContext.getWidgetParameters();
        if (tempParameters != null) {
            parameters.putAll(tempParameters);
        }
        this.m_oWidgetInstParameterMgr.saveParameters(oWidgetInstance, parameters);
        return String.valueOf(oWidgetInstance.getId());
    }
}

