/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.distribute;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class PublishDistribution
extends CMSObj {
    public static final int OBJ_TYPE = 955;
    public static final String DB_TABLE_NAME = "WCMPUBLISHDISTRIBUTION";
    public static final String DB_ID_NAME = "PUBLISHDISTRIBUTIONID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 955;
    }

    public IPublishFolder getFolder() throws WCMException {
        return (IPublishFolder)PublishElementFactory.lookupElement(this.getFolderType(), this.getFolderId());
    }

    public int getFolderType() {
        return this.getPropertyAsInt("FOLDERTYPE", 0);
    }

    public int getFolderId() {
        return this.getPropertyAsInt("FOLDERID", 0);
    }

    public boolean setFolder(int _nType, int _nId) throws WCMException {
        return this.setProperty("FOLDERTYPE", _nType) && this.setProperty("FOLDERID", _nId);
    }

    public boolean setFolder(IPublishFolder _folder) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.setFolder(_folder.getType(), _folder.getId());
    }

    public String getTargetType() {
        return this.getPropertyAsString("TARGETTYPE");
    }

    public boolean setTargetType(String _sName) throws WCMException {
        return this.setProperty("TARGETTYPE", _sName);
    }

    public String getTargetServer() {
        return this.getPropertyAsString("TARGETSERVER");
    }

    public boolean setTargetServer(String _sServerAddress) throws WCMException {
        return this.setProperty("TARGETSERVER", _sServerAddress);
    }

    public int getTargetPort() {
        return this.getPropertyAsInt("TARGETPORT", 0);
    }

    public boolean setTargetPort(int _nServerPort) throws WCMException {
        return this.setProperty("TARGETPORT", _nServerPort);
    }

    public String getLoginUser() {
        return this.getPropertyAsString("LOGINUSER");
    }

    public boolean setLoginUser(String _sLoginUser) throws WCMException {
        return this.setProperty("LOGINUSER", _sLoginUser);
    }

    public String getLoginPassword() {
        return this.getPropertyAsString("LOGINPASSWORD");
    }

    public boolean setLoginPassword(String _sLoginPassword) throws WCMException {
        return this.setProperty("LOGINPASSWORD", _sLoginPassword);
    }

    public String getDataPath() {
        return this.getPropertyAsString("DATAPATH");
    }

    public boolean setDataPath(String _sDataPath) throws WCMException {
        return this.setProperty("DATAPATH", _sDataPath);
    }

    public boolean isAnonymous() {
        return this.getPropertyAsBoolean("ANONYMFTP", false);
    }

    public boolean setAnonymous(boolean _zAnonymous) throws WCMException {
        return this.setProperty("ANONYMFTP", _zAnonymous);
    }

    public boolean getPassiveMode() {
        return this.getPropertyAsBoolean("PASSIVEMODE", true);
    }

    public boolean setPassiveMode(boolean _bEnabled) throws WCMException {
        return this.setProperty("PASSIVEMODE", _bEnabled);
    }

    public boolean isEnabled() {
        return this.getPropertyAsBoolean("ENABLED", true);
    }

    public boolean setEnabled(boolean _bEnabled) throws WCMException {
        return this.setProperty("ENABLED", _bEnabled);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("FOLDERTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(PublishDistribution.class, "PublishDistribution.label1", "\u5c5e\u6027FolderType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("FOLDERID") == null) {
                throw new WCMException(1106, I18NMessage.get(PublishDistribution.class, "PublishDistribution.label2", "\u5c5e\u6027FolderId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("TARGETTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(PublishDistribution.class, "PublishDistribution.label3", "\u5c5e\u6027TargetType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("DATAPATH") == null) {
                throw new WCMException(1106, I18NMessage.get(PublishDistribution.class, "PublishDistribution.label4", "\u5c5e\u6027DataPath\u6ca1\u6709\u8bbe\u7f6e"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(PublishDistribution.class, "PublishDistribution.label5", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            if (this.getProperty("ENABLED") == null) {
                this.setEnabled(true);
            }
            super.insert(_currUser);
        }
    }

    public static final PublishDistribution findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (PublishDistribution)BaseObj.findById(PublishDistribution.class, _nId);
    }

    public static final PublishDistribution createNewInstance() throws WCMException {
        return (PublishDistribution)BaseObj.createNewInstance(PublishDistribution.class);
    }

    public static final PublishDistribution findByKey(Object _oKey) throws WCMException {
        return (PublishDistribution)BaseObj.findByKey(PublishDistribution.class, _oKey);
    }

    @Override
    public String toString() {
        String sResult = I18NMessage.get(PublishDistribution.class, "PublishDistribution.label6", "\u5206\u53d1\u4fe1\u606f[Type=") + this.getTargetType() + "  Server=" + this.getTargetServer() + " FolderTypeConfig=" + this.getFolderType() + " FolderId=" + this.getFolderId() + "]";
        return sResult;
    }
}

