/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TemplateQuoteMgr {
    private static final Logger logger = Logger.getLogger((String)TemplateQuoteMgr.class.getName());

    public void save(TemplateQuote _quote) throws WCMException {
        if (_quote == null) {
            throw new WCMException(10, "Valid quote required!");
        }
        _quote.save(ContextHelper.getLoginUser());
    }

    public void save(List _quotes) throws WCMException {
        if (_quotes == null || _quotes.isEmpty()) {
            return;
        }
        try {
            User currUser = ContextHelper.getLoginUser();
            for (int i = 0; i < _quotes.size(); ++i) {
                TemplateQuote aQuote = (TemplateQuote)_quotes.get(i);
                if (aQuote == null) continue;
                aQuote.save(currUser);
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to save the template quotes list!", ex);
        }
    }

    int clearQuotesOfTemplate(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(1100, "Valid template required!");
        }
        return this.clearQuotesOfTemplate(_template.getId());
    }

    int clearQuotesOfTemplate(int _nTemplateId) throws WCMException {
        String SQL = "DELETE FROM WCMTEMPLATEQUOTE WHERE TEMPLATEID=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("DELETE FROM WCMTEMPLATEQUOTE WHERE TEMPLATEID=?");
            oPreStmt.setInt(1, _nTemplateId);
            int n = oPreStmt.executeUpdate();
            return n;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to clear template quotes record!", ex);
        }
        finally {
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    public int clearQuotesOfFolder(IPublishFolder _folder) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.clearQuotesOfFolder(_folder.getType(), _folder.getId());
    }

    public int clearQuotesOfFolder(int _nFolderType, int _nFolderId) throws WCMException {
        String SQL = "DELETE FROM WCMTEMPLATEQUOTE WHERE QUOTEDFOLDERID=? AND QUOTEDFOLDERTYPE=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("DELETE FROM WCMTEMPLATEQUOTE WHERE QUOTEDFOLDERID=? AND QUOTEDFOLDERTYPE=?");
            oPreStmt.setInt(1, _nFolderId);
            oPreStmt.setInt(2, _nFolderType);
            int n = oPreStmt.executeUpdate();
            return n;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to clear template quotes record!", ex);
        }
        finally {
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    private boolean isExcludeFolder(List _quotersList, IPublishFolder _quotedFolder, IPublishElement _currPublishElement) throws WCMException {
        if (_currPublishElement == null) {
            return true;
        }
        if (_quotersList != null && _quotersList.contains(_currPublishElement)) {
            return true;
        }
        if (_currPublishElement == null || !_currPublishElement.isFolder() || !((IPublishFolder)_currPublishElement).canDoOutlinePageTask()) {
            return true;
        }
        if (_currPublishElement.getType() == _quotedFolder.getType() && _currPublishElement.getId() == _quotedFolder.getId()) {
            return true;
        }
        IPublishFolder folder = (IPublishFolder)_currPublishElement;
        return folder.isDeleted();
    }

    public List getFoldersWhoseOutlineQuotesContentsOf(IPublishFolder _quotedFolder) throws WCMException {
        String sQueryChnlNameQuote = "select distinct EmployerType, EmployerId from WCMTemplateEmploy where TemplateType=1 and exists(   select TemplateId from WCMTemplateQuote     where QuotedFolderId=? and QuotedFolderType=? and QuoteType=1 and FamilyIndex=-1     and WCMTemplateEmploy.TemplateId=WCMTemplateQuote.TemplateId  )";
        String sQueryChnlNameQuoteOfNest = "select distinct EmployerType, EmployerId from WCMTemplateEmploy where TemplateType=1 and  exists( select WCMTemplateNest.TemplateId from WCMTemplateNest       where WCMTemplateEmploy.TemplateId=WCMTemplateNest.TemplateId        and exists(        select TemplateId from WCMTemplateQuote              where QuotedFolderId=? and QuotedFolderType=?  and QuoteType=1 and FamilyIndex=-1             and WCMTemplateNest.NestedTemplateId=WCMTemplateQuote.TemplateId        )     )";
        String sQueryChildIndexQuote = "select distinct FolderType, FolderId from WCMChannelChildIndexQuote where QuoteChannelId=?";
        DebugTimer timer = new DebugTimer();
        timer.start();
        ArrayList<IPublishElement> quotersList = null;
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet rsData = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            IPublishElement aFolder;
            int nFolderId;
            int nFolderType;
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("select distinct EmployerType, EmployerId from WCMTemplateEmploy where TemplateType=1 and exists(   select TemplateId from WCMTemplateQuote     where QuotedFolderId=? and QuotedFolderType=? and QuoteType=1 and FamilyIndex=-1     and WCMTemplateEmploy.TemplateId=WCMTemplateQuote.TemplateId  )");
            oPreStmt.setInt(1, _quotedFolder.getId());
            oPreStmt.setInt(2, _quotedFolder.getType());
            rsData = oPreStmt.executeQuery();
            quotersList = new ArrayList<IPublishElement>();
            while (rsData.next()) {
                nFolderType = rsData.getInt(1);
                aFolder = PublishElementFactory.lookupElement(nFolderType, nFolderId = rsData.getInt(2));
                if (this.isExcludeFolder(null, _quotedFolder, aFolder)) continue;
                quotersList.add(aFolder);
            }
            rsData.close();
            oPreStmt.close();
            oPreStmt = oConn.prepareStatement("select distinct EmployerType, EmployerId from WCMTemplateEmploy where TemplateType=1 and  exists( select WCMTemplateNest.TemplateId from WCMTemplateNest       where WCMTemplateEmploy.TemplateId=WCMTemplateNest.TemplateId        and exists(        select TemplateId from WCMTemplateQuote              where QuotedFolderId=? and QuotedFolderType=?  and QuoteType=1 and FamilyIndex=-1             and WCMTemplateNest.NestedTemplateId=WCMTemplateQuote.TemplateId        )     )");
            oPreStmt.setInt(1, _quotedFolder.getId());
            oPreStmt.setInt(2, _quotedFolder.getType());
            rsData = oPreStmt.executeQuery();
            while (rsData.next()) {
                nFolderType = rsData.getInt(1);
                aFolder = PublishElementFactory.lookupElement(nFolderType, nFolderId = rsData.getInt(2));
                if (this.isExcludeFolder(quotersList, _quotedFolder, aFolder)) continue;
                quotersList.add(aFolder);
            }
            if (!_quotedFolder.isRoot()) {
                rsData.close();
                oPreStmt.close();
                oPreStmt = oConn.prepareStatement("select distinct FolderType, FolderId from WCMChannelChildIndexQuote where QuoteChannelId=?");
                oPreStmt.setInt(1, _quotedFolder.getId());
                rsData = oPreStmt.executeQuery();
                while (rsData.next()) {
                    nFolderType = rsData.getInt(1);
                    aFolder = PublishElementFactory.lookupElement(nFolderType, nFolderId = rsData.getInt(2));
                    if (this.isExcludeFolder(quotersList, _quotedFolder, aFolder)) continue;
                    quotersList.add(aFolder);
                }
            }
            rsData.close();
            rsData = null;
            oPreStmt.close();
            oPreStmt = null;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to Desc!", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
        timer.stop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get[" + _quotedFolder.getInfo() + "] quote use [" + timer.getTime() + "]ms"));
        }
        return quotersList;
    }
}

