/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.config.persistent.TemplateParseConfig;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import org.apache.log4j.Logger;

public class TemplateCacheMgr
implements ICacheMgr {
    private static Logger logger = Logger.getLogger(TemplateCacheMgr.class);
    public static long LRU_CACHE_EXPIRES = 3600000L;
    private static Cache cache = (Cache)DreamFactory.createObjectById("lruCache");

    @Override
    public synchronized boolean init() {
        try {
            TemplateParseConfig myConfig = PublishServerConfigMapper.getTemplateParseConfig();
            cache.setMaxSize(myConfig.getNameCacheMaxSize());
            logger.info((Object)("Template name cache maximum size: " + myConfig.getNameCacheMaxSize()));
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to load configuration from publish server config!", (Throwable)ex);
        }
        return true;
    }

    @Override
    public boolean reinit() {
        this.clear();
        return this.init();
    }

    @Override
    public synchronized void clear() {
    }

    public Template lookupByName(IPublishFolder _root, String _sName) throws WCMException {
        if (_root == null) {
            throw new WCMException(10, "Valid root folder required!");
        }
        String key = this.makeKey(_root, _sName);
        Integer templateId = (Integer)cache.get(key);
        if (templateId != null) {
            return Template.findById(templateId);
        }
        Template template = null;
        BaseObjs templates = null;
        try {
            WCMFilter filter = new WCMFilter("", "RooTId=? AND TEMPNAME=? AND ROOTTYPE=?", "");
            templates = new Templates(ContextHelper.getLoginUser(), 1, 1);
            templates.setMaxSize(1);
            filter.addSearchValues(_root.getId());
            filter.addSearchValues(_sName);
            filter.addSearchValues(_root.getType());
            templates.open(filter);
            if (!templates.isEmpty()) {
                template = (Template)templates.getAt(0);
            }
            if (template != null) {
                cache.set(key, template.getKey());
                cache.pexpire(key, LRU_CACHE_EXPIRES);
            }
            Template template2 = template;
            return template2;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to lookup template [" + _sName + "]", ex);
        }
        finally {
            if (templates != null) {
                templates.clear();
            }
        }
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) {
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        try {
            Template template = (Template)_oObjDeleted;
            IPublishFolder root = template.getRoot();
            if (root == null) {
                logger.error((Object)("Template[" + template.getId() + "] root is not found!"));
                return;
            }
            String key = this.makeKey(root, template.getName());
            cache.clear(key);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to remove the template from cache.", ex);
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (_oObjModified.isChangeProperty("TEMPNAME")) {
            try {
                Template template = (Template)_oObjModified;
                IPublishFolder root = template.getRoot();
                if (root == null) {
                    logger.error((Object)("Template[" + template.getId() + "] root is not found!"));
                    return;
                }
                String key = this.makeKey(root, template.getName());
                cache.clear(key);
                String sNewKey = this.makeKey(root, template.getNewPropertyAsString("TEMPNAME"));
                cache.set(sNewKey, template.getKey());
                cache.pexpire(sNewKey, LRU_CACHE_EXPIRES);
            }
            catch (Exception ex) {
                throw new WCMException(1100, "Failed to update template cache after name is changed.", ex);
            }
        }
    }

    private String makeKey(IPublishFolder _root, String _sTemplateName) {
        return this.getKey(Integer.toHexString(_root.getType()) + "/" + Integer.toHexString(_root.getId()) + "/" + _sTemplateName);
    }

    private String getKey(String key) {
        return this.getKey() + "." + key;
    }

    private String getKey() {
        return this.getClass().getName();
    }
}

