/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.config;

import com.trs.components.common.publish.config.persistent.TargetTypeConfig;
import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.AttributesString;

public class PublishDistributionTargetType {
    private String m_sName;
    private String m_sDesc;
    private String m_sDistributorClassName;
    private AttributesString m_parameters;
    private Class m_classDistributor = null;

    public String getName() {
        return this.m_sName;
    }

    public void setName(String _sName) throws WCMException {
        if (_sName == null || (_sName = _sName.trim()).length() == 0) {
            throw new WCMException(10, "Valid name required!");
        }
        this.m_sName = _sName;
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDesc(String desc) {
        this.m_sDesc = desc;
    }

    public String getDistributorClassName() {
        return this.m_sDistributorClassName;
    }

    public void setParameters(String _sParameters) {
        if (this.m_parameters == null) {
            this.m_parameters = new AttributesString(_sParameters);
        } else {
            this.m_parameters.setAttributes(_sParameters);
        }
    }

    public AttributesString getParameters() {
        return this.m_parameters;
    }

    public void setDistributorClassName(String _sClassName) throws WCMException {
        if (_sClassName == null || (_sClassName = _sClassName.trim()).length() == 0) {
            throw new WCMException(10, "Distributor class name required!");
        }
        if (this.m_classDistributor != null && this.m_sDistributorClassName.equals(_sClassName)) {
            return;
        }
        this.m_sDistributorClassName = _sClassName;
        try {
            this.m_classDistributor = Class.forName(_sClassName);
        }
        catch (Exception ex) {
            throw new WCMException(11, "Invalid distributor class: " + _sClassName, ex);
        }
    }

    public IFileDistristributor createDistributor() throws WCMException {
        try {
            return (IFileDistristributor)this.m_classDistributor.newInstance();
        }
        catch (Exception ex) {
            throw new WCMException(11, "Failed to create distributor instance for " + this.m_sDistributorClassName, ex);
        }
    }

    public void fromConfigElement(TargetTypeConfig _element) throws WCMException {
        if (_element == null) {
            throw new WCMException(10, "Valid CMyXMLElement object required!");
        }
        try {
            this.setName(_element.getName());
            this.setDesc(_element.getDesc());
            this.setDistributorClassName(_element.getDistributor());
            this.setParameters(_element.getParameters());
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to read from CMyXMLElement.", ex);
        }
    }

    public String toString() {
        return "Name=" + this.m_sName + "&Desc=" + this.m_sDesc + "&Distributor=" + this.m_sDistributorClassName + "&Parameters=" + this.m_parameters.toString();
    }
}

