/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message.notify;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.common.message.notify.NotificationConfig;
import com.trs.components.common.message.notify.NotificationSchemeConfig;
import com.trs.components.common.message.notify.NotificationServer;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Notifier {
    private static final Logger logger = Logger.getLogger((String)Notifier.class.getName());
    private HashMap m_parameters = new HashMap();

    public void setParameter(String _sName, String _sValue) {
        this.m_parameters.put(_sName, _sValue);
    }

    public String getParameter(String _sName) {
        return (String)this.m_parameters.get(_sName);
    }

    public void executeOnEvent(String _sEvent) throws WCMException {
        NotificationSchemeConfig scheme = NotificationServer.getInstance().lookupSchemeForEvent(_sEvent);
        if (scheme == null) {
            logger.debug((Object)("NotificationConfig scheme for event " + _sEvent + " is not found!"));
            return;
        }
        if (!scheme.isEnabled()) {
            logger.debug((Object)("NotificationConfig scheme for event " + _sEvent + " is disabled!"));
            return;
        }
        logger.debug((Object)("NotificationConfig scheme for event " + _sEvent + " is found and enabled!"));
        this.execute(scheme);
    }

    public void execute(NotificationSchemeConfig _scheme) throws WCMException {
        if (_scheme == null) {
            return;
        }
        try {
            logger.debug((Object)("to execute notification scheme for event " + _scheme.getEvent()));
            String sTitle = this.parseTemplate(_scheme.getTitle());
            String sMsgBody = this.parseTemplate(_scheme.getMsgBody());
            ArrayList notifications = _scheme.getNotifications();
            for (int i = 0; i < notifications.size(); ++i) {
                String sUserIds;
                NotificationConfig aNotification = (NotificationConfig)notifications.get(i);
                if (aNotification == null) continue;
                logger.debug((Object)("to notify through " + aNotification.getSendType() + " ..."));
                String sUserNames = aNotification.getUserNames();
                if (sUserNames == null) {
                    sUserIds = null;
                } else {
                    sUserNames = this.parseTemplate(sUserNames);
                    sUserIds = this.getUserIdsByName(sUserNames);
                }
                String sGroupIds = aNotification.getGroupIds();
                String sRoleIds = aNotification.getRoleIds();
                if (CMyString.isEmpty(sUserIds) && CMyString.isEmpty(sGroupIds) && CMyString.isEmpty(sRoleIds)) {
                    return;
                }
                Message message = Message.createNewInstance();
                message.setTitle(sTitle);
                message.setBody(sMsgBody);
                message.setProperty("MsgType", 2L);
                message.setSendTypes(new String[]{aNotification.getSendType()});
                message.setFlag(0);
                message.setValidTime(CMyDateTime.now());
                if (sUserIds != null && sUserIds.length() > 0) {
                    message.setReceivers(204, sUserIds);
                }
                if (sGroupIds != null && sGroupIds.length() > 0) {
                    message.setReceivers(201, sGroupIds);
                }
                if (sRoleIds != null && sRoleIds.length() > 0) {
                    message.setReceivers(203, sRoleIds);
                }
                MessageServer.send(message);
                logger.debug((Object)("finished to notify through " + aNotification.getSendType()));
            }
            logger.debug((Object)("finished to execute notification scheme for event " + _scheme.getEvent()));
        }
        catch (Exception ex) {
            throw new WCMException(1352, "Failed to execute notification scheme!", ex);
        }
    }

    private String parseTemplate(String _sTemplate) throws WCMException {
        if (_sTemplate == null) {
            return null;
        }
        StringBuffer buffResult = null;
        StringBuffer buffVarName = null;
        try {
            char[] template = _sTemplate.toCharArray();
            int nPos = 0;
            int nLength = template.length;
            buffResult = new StringBuffer();
            while (nPos < template.length) {
                char aChar;
                if ((aChar = template[nPos++]) == '$' && nPos < nLength && template[nPos] == '{') {
                    buffVarName = new StringBuffer(16);
                    while (true) {
                        int n = ++nPos;
                        ++nPos;
                        aChar = template[n];
                        if (aChar == '}') break;
                        buffVarName.append(aChar);
                    }
                    String sVarName = buffVarName.toString();
                    buffVarName.setLength(0);
                    String sParameterValue = this.getParameter(sVarName);
                    if (sParameterValue == null) {
                        buffResult.append(sVarName);
                        continue;
                    }
                    buffResult.append(sParameterValue);
                    continue;
                }
                buffResult.append(aChar);
            }
            String string = buffResult.toString();
            return string;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to parse the template: " + _sTemplate, ex);
        }
        finally {
            if (buffResult != null) {
                buffResult.setLength(0);
            }
            if (buffVarName != null) {
                buffVarName.setLength(0);
            }
        }
    }

    private String getUserIdsByName(String _sNames) throws Exception {
        String sIds = null;
        StringTokenizer stNames = new StringTokenizer(_sNames, ",");
        while (stNames.hasMoreElements()) {
            String sName = stNames.nextToken();
            User user = User.findByName(sName);
            if (user == null) continue;
            if (sIds == null) {
                sIds = String.valueOf(user.getId());
                continue;
            }
            sIds = sIds + ',' + String.valueOf(user.getId());
        }
        return sIds;
    }
}

