/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.job;

import com.trs.components.common.job.BaseStatefulScheduleWorker;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.TableInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FileOnWCMDBTable
extends BaseStatefulScheduleWorker {
    private static Logger logger = Logger.getLogger(FileOnWCMDBTable.class);
    private static final String TABLE_SUFFIX = "ONFILE";

    private void ensureTableExists(String sTableName) {
        try {
            TableInfo oTable = DBManager.getDBManager().getTableInfo(sTableName);
            if (oTable != null) {
                return;
            }
            String sCreateTableSQL = "";
            DBManager dbManager = DBManager.getDBManager();
            int nDBType = dbManager.getDBTypeAsInt();
            switch (nDBType) {
                case 2: 
                case 4: {
                    sCreateTableSQL = "select * into " + sTableName + TABLE_SUFFIX + " from " + sTableName + " where 1 <> 1";
                    break;
                }
                default: {
                    sCreateTableSQL = "create table " + sTableName + TABLE_SUFFIX + " as select * from " + sTableName + " where 1 <> 1";
                }
            }
            dbManager.sqlExecuteUpdate(sCreateTableSQL);
        }
        catch (Exception e) {
            logger.error((Object)("\u5f52\u6863[" + sTableName + "]\u8868\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 "), (Throwable)e);
        }
    }

    @Override
    protected void execute() {
        final String sTableName = this.getArgAsString("TABLENAME");
        String sTimeField = this.getArgAsString("TIMEFIELD");
        String sBeforeDays = this.getArgAsString("EXPIRE");
        long nBeforeDays = Integer.parseInt(sBeforeDays);
        try {
            Date date = new Date(new Date().getTime() - 86400000L * nBeforeDays);
            String sDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date);
            DBType currDBType = DBManager.getDBManager().getDBType();
            String sStartTime = currDBType.sqlDate(sDate);
            logger.debug((Object)("[startTime: ]" + sStartTime));
            HashMap<String, String> dateMap = new HashMap<String, String>();
            dateMap.put("STARTTIME", sStartTime);
            String sInsertIntoSQL = "insert into " + sTableName + TABLE_SUFFIX + " select * from " + sTableName + " where " + sTimeField + " < ${STARTTIME}";
            final String sFinalInsertIntoSQL = CMyString.parsePageVariables(sInsertIntoSQL, dateMap);
            logger.debug((Object)("[insertSQL: ]" + sFinalInsertIntoSQL));
            String sDeleteSQL = "delete from " + sTableName + " where " + sTimeField + " < ${STARTTIME}";
            final String sFinalDeleteSQL = CMyString.parsePageVariables(sDeleteSQL, dateMap);
            logger.debug((Object)("[deleteSQL: ]" + sFinalDeleteSQL));
            new Thread(){

                @Override
                public void run() {
                    try {
                        DBManager dbManager = DBManager.getDBManager();
                        dbManager.sqlExecuteUpdate(new String[]{sFinalInsertIntoSQL, sFinalDeleteSQL});
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u5f52\u6863[" + sTableName + "]\u8868\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 "), (Throwable)e);
                    }
                }
            }.start();
        }
        catch (Exception ex) {
            logger.error((Object)("\u5f52\u6863[" + sTableName + "]\u8868\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38: "), (Throwable)ex);
        }
    }
}

