/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.bookmark;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.bookmark.MarkKind;
import com.trs.components.common.bookmark.MarkKinds;
import com.trs.components.common.bookmark.MarkShares;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class BookMark
extends CMSObj {
    public static final int OBJ_TYPE = 303;
    public static final String DB_TABLE_NAME = "WCMBOOKMARK";
    public static final String DB_ID_NAME = "MARKID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 303;
    }

    public String getName() {
        return (String)this.getProperty("MNAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("MNAME", _name);
    }

    public String getLink() {
        return (String)this.getProperty("MLINK");
    }

    public boolean setLink(String _link) throws WCMException {
        return this.setProperty("MLINK", _link);
    }

    public String getIcon() {
        return (String)this.getProperty("MICON");
    }

    public boolean setIcon(String _icon) throws WCMException {
        return this.setProperty("MICON", _icon);
    }

    public int getKindId() {
        return this.getPropertyAsInt("MKIND", 0);
    }

    public MarkKind getKind() throws WCMException {
        WCMFilter filter = new WCMFilter("wcmMarkKinds", "KindId=" + this.getKind(), "");
        MarkKinds aMarkKinds = new MarkKinds(User.getSystem(), 1, 1);
        MarkKind aMarkKind = null;
        try {
            aMarkKinds.open(filter);
            aMarkKind = aMarkKinds.isEmpty() ? null : (MarkKind)aMarkKinds.getAt(0);
            aMarkKinds.clear();
            return aMarkKind;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(BookMark.class, "BookMark.label1", "\u53d6\u4e66\u7b7e\u6240\u5c5e\u7c7b\u522b\u65f6\u51fa\u9519(BookMark.getKind)"), ex);
        }
    }

    public boolean setKind(int _nKindId) throws WCMException {
        if (_nKindId < 0) {
            throw new WCMException(1104, I18NMessage.get(BookMark.class, "BookMark.label2", "\u65e0\u6548\u7684\u4e66\u7b7e\u7c7b\u522b(BookMark.setKind)"));
        }
        return this.setProperty("MKIND", _nKindId);
    }

    public boolean setKind(MarkKind _markKind) throws WCMException {
        if (_markKind == null || !_markKind.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(BookMark.class, "BookMark.label3", "\u65e0\u6548\u7684\u6807\u7b7e\u7c7b\u522b\u5bf9\u8c61\uff08BookMark.setKind\uff09"));
        }
        return this.setKind(_markKind.getId());
    }

    @Override
    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    @Override
    public boolean setAttribute(String _attribute) throws WCMException {
        return this.setProperty("ATTRIBUTE", _attribute);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        Number iKind = null;
        if (this.isAddMode()) {
            sName = (String)this.getAllProperty().get("MNAME");
            iKind = (Number)this.getAllProperty().get("MKIND");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(BookMark.class, "BookMark.label4", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(BookMark.isValid)"));
            }
            if (iKind == null) {
                throw new WCMException(1106, I18NMessage.get(BookMark.class, "BookMark.label5", "\u5c5e\u6027Kind\u6ca1\u6709\u8bbe\u7f6e(BookMark.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(BookMark.class, "BookMark.label6", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(BookMark.isValid)"));
            }
            sName = (String)this.getNewProperty("MNAME");
            iKind = (Number)this.getNewProperty("MKIND");
            if (sName != null && iKind == null) {
                iKind = (Number)this.getAllProperty().get("MKIND");
            }
            if (iKind != null && sName == null) {
                sName = (String)this.getAllProperty().get("MNAME");
            }
        }
        if (sName != null || iKind != null) {
            String strCondition = " (CrUser='" + this.getCrUserName() + "') and (MKind=" + iKind + " ) and (MName='" + CMyString.filterForSQL(sName) + "')";
            if (!this.isAddMode()) {
                strCondition = strCondition + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(strCondition)) {
                throw new WCMException(1108, I18NMessage.get(BookMark.class, "BookMark.label7", "\u76f8\u540c\u4e66\u7b7e\u5df2\u7ecf\u5b58\u5728\uff08BookMark.isValid\uff09"));
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    public MarkShares getMarkShares(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ObjType=303 and ObjId=" + this.getId(), "");
        MarkShares aMarkShares = new MarkShares(_currUser);
        try {
            aMarkShares.open(filter);
            return aMarkShares;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(BookMark.class, "BookMark.label8", "\u53d6\u4e66\u7b7e\u5171\u4eab\u4fe1\u606f\u65f6\u51fa\u9519(BookMark.getMarkShares)"), ex);
        }
    }

    public boolean isShared(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ObjType=303 and ObjId=" + this.getId(), "", "ShareId");
        MarkShares aMarkShares = new MarkShares(_currUser, 1, 1);
        try {
            aMarkShares.open(filter);
            boolean bIsShared = !aMarkShares.isEmpty();
            aMarkShares.clear();
            return bIsShared;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(BookMark.class, "BookMark.label9", "\u53d6\u4e66\u7b7e\u662f\u5426\u5171\u4eab\u65f6\u51fa\u9519(BookMark.isShared)"), ex);
        }
    }

    public static final BookMark findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (BookMark)BaseObj.findById(BookMark.class, _nId);
    }

    public static final BookMark createNewInstance() throws WCMException {
        return (BookMark)BaseObj.createNewInstance(BookMark.class);
    }

    public static final BookMark findByKey(Object _oKey) throws WCMException {
        return (BookMark)BaseObj.findByKey(BookMark.class, _oKey);
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(BookMark.class, "BookMark.label10", "[\u4e66\u7b7e-") + this.getId() + "]";
    }
}

