/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.FilterForFlowContentFactory;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.FlowContentNotifyFactory;
import com.trs.cms.process.FlowEngineHelper;
import com.trs.cms.process.FlowingDocOptMarkScouter;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowNotify;
import com.trs.cms.process.IFlowNotifyWorker;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.IWorkflowDelegateMgr;
import com.trs.cms.process.QueryFlowDocContext;
import com.trs.cms.process.config.FlowConfigServer;
import com.trs.cms.process.config.ToUsersCreatorConfig;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.cms.process.definition.FlowRule;
import com.trs.cms.process.definition.IFlowRuleCacheServer;
import com.trs.cms.process.engine.ContentProcessInfo;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.cms.process.engine.RuleExecuteHelper;
import com.trs.components.common.message.MessageServer;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.database.FieldInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class FlowServerImpl
extends BaseServer
implements IFlowServer {
    private static Logger logger = Logger.getLogger(FlowServerImpl.class);
    private IFlowNotifyWorker m_oNotify = null;
    private IFlowRuleCacheServer m_oRuleCacheServer = null;
    private FlowConfigServer m_oFlowConfigServer = null;
    public static final float INCREASE_FIELD_LENGTH_FACTOR = 1.5f;

    public FlowServerImpl() {
        try {
            this.m_oNotify = (IFlowNotifyWorker)DreamFactory.createObjectById("Flow.Notify.Worker");
        }
        catch (Throwable e) {
            logger.error((Object)I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label1", "\u521b\u5efa\u6d88\u606f\u901a\u77e5\u5668\u5931\u8d25\uff01"), e);
        }
        try {
            this.m_oRuleCacheServer = (IFlowRuleCacheServer)DreamFactory.createObjectById("IFlowRuleCacheServer");
        }
        catch (Throwable e) {
            logger.error((Object)I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label2", "\u521b\u5efa\u89c4\u5219\u7f13\u51b2\u5668\u5931\u8d25\uff01"), e);
        }
        try {
            this.m_oFlowConfigServer = (FlowConfigServer)DreamFactory.createObjectById("FlowConfigServer");
        }
        catch (Throwable e) {
            logger.error((Object)I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label3", "\u521b\u5efa\u914d\u7f6e\u670d\u52a1\u5668\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    public boolean backTo(FlowContext _oFlowContext) throws WCMException {
        boolean bCurrIsBackFlowDoc;
        FlowDoc currFlowDoc;
        _oFlowContext.validate();
        boolean bApplyExtension = false;
        if ("1".equals(_oFlowContext.getProperty("ApplyExtension"))) {
            bApplyExtension = true;
        }
        if ((currFlowDoc = _oFlowContext.getCurrFlowDoc()).getNode().isStartNode()) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label4", "\u60a8\u5df2\u7ecf\u5904\u4e8e\u5f00\u59cb\u8282\u70b9\uff0c\u4e0d\u80fd\u6267\u884c\u6253\u56de\u64cd\u4f5c"));
        }
        if (currFlowDoc.isWorked()) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label5", "\u6d41\u7a0b\u5df2\u7ecf\u5904\u7406\uff0c\u4e0d\u80fd\u6267\u884c\u8981\u6c42\u8fd4\u5de5\u64cd\u4f5c\uff01"));
        }
        if (currFlowDoc.getFlag() == 8) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label6", "\u5bf9\u4e8e\u5df2\u62d2\u7edd\u7684\u6d41\u8f6c\u5bf9\u8c61\uff0c\u60a8\u4e0d\u80fd\u518d\u8fd4\u5de5\uff0c\u53ea\u80fd\u91cd\u65b0\u9009\u62e9\u5904\u7406\u4eba\u3002"));
        }
        currFlowDoc.validCanEditAndLock(_oFlowContext.getCurrUser());
        currFlowDoc.setWorked(true);
        currFlowDoc.update(_oFlowContext.getCurrUser());
        this.setOtherSiblingsWorked(currFlowDoc);
        this.setParentWorked(currFlowDoc);
        Users toUsers = new Users(null, 1, 1);
        FlowDoc oRealBackToFlowDoc = currFlowDoc;
        while (oRealBackToFlowDoc.getFlag() == 4) {
            if ((oRealBackToFlowDoc = oRealBackToFlowDoc.getPreFlowDoc()) != null) continue;
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label7", "\u6570\u636e\u6709\u8bef\uff01[FlowDocId=") + currFlowDoc.getId() + "]");
        }
        int nNodeId = oRealBackToFlowDoc.getPreNodeId();
        int nPreNodeId = oRealBackToFlowDoc.getNodeId();
        int nPreFlowDocId = oRealBackToFlowDoc.getId();
        boolean bl = bCurrIsBackFlowDoc = oRealBackToFlowDoc.getFlag() == 2;
        if (oRealBackToFlowDoc.getFlag() == 2 || oRealBackToFlowDoc.getFlag() == 12) {
            oRealBackToFlowDoc = FlowServerImpl.lookupRealBackFlowDocAgain(oRealBackToFlowDoc);
            switch (oRealBackToFlowDoc.getWorkModal()) {
                case 1: {
                    if (oRealBackToFlowDoc.getParentId() > 0) {
                        toUsers.addElement(oRealBackToFlowDoc.getPostUser());
                        break;
                    }
                    toUsers = oRealBackToFlowDoc.getToUsers(null);
                    break;
                }
                default: {
                    toUsers.addElement(oRealBackToFlowDoc.getPostUser());
                    break;
                }
            }
        } else {
            toUsers.addElement(oRealBackToFlowDoc.getPostUser());
        }
        if (bCurrIsBackFlowDoc) {
            nPreNodeId = oRealBackToFlowDoc.getNodeId();
            nNodeId = oRealBackToFlowDoc.getPreNodeId();
            nPreFlowDocId = oRealBackToFlowDoc.getId();
        }
        if (toUsers == null || toUsers.isEmpty()) {
            logger.warn((Object)(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label8", "\u6253\u56de\u627e\u4e0d\u5230\u63a5\u6536\u4eba\uff0c\u5efa\u8bae\u5c3d\u5feb\u548cTRS\u652f\u6301\u4eba\u5458\u8054\u7cfb\uff01[FlowDocId=") + currFlowDoc.getId() + "]"));
            return false;
        }
        int nSize = toUsers.size();
        FlowDoc transmitFlowDoc = new FlowDoc();
        transmitFlowDoc.setContentType(oRealBackToFlowDoc.getContentType());
        transmitFlowDoc.setContentId(oRealBackToFlowDoc.getContentId());
        transmitFlowDoc.setPostUser(_oFlowContext.getPostUser());
        transmitFlowDoc.setPostTime(CMyDateTime.now());
        transmitFlowDoc.setPostDesc(_oFlowContext.getPostDesc());
        transmitFlowDoc.setToUsers(toUsers.getIdListAsString());
        if (bApplyExtension) {
            transmitFlowDoc.setFlag(13);
        } else {
            transmitFlowDoc.setFlag(2);
        }
        transmitFlowDoc.setPreNode(nPreNodeId);
        transmitFlowDoc.setNode(nNodeId);
        transmitFlowDoc.setPreFlowDoc(nPreFlowDocId);
        transmitFlowDoc.setWorkModal(oRealBackToFlowDoc.getWorkModal());
        transmitFlowDoc.setNextId();
        if (nSize == 1) {
            transmitFlowDoc.setToUser(toUsers.getIdAt(0));
            transmitFlowDoc.setWorkModal(0);
            this.sendNotify(_oFlowContext.getPostUser(), (User)toUsers.getAt(0), _oFlowContext.getNotifyTypes(), transmitFlowDoc.getId(), _oFlowContext.getFlowContent());
        } else {
            for (int i = 0; i < nSize; ++i) {
                User toUser = (User)toUsers.getAt(i);
                if (toUser == null) continue;
                FlowDoc childFlowDoc = new FlowDoc();
                childFlowDoc.setContentType(oRealBackToFlowDoc.getContentType());
                childFlowDoc.setContentId(oRealBackToFlowDoc.getContentId());
                childFlowDoc.setPostUser(_oFlowContext.getPostUser());
                childFlowDoc.setPostTime(CMyDateTime.now());
                childFlowDoc.setPostDesc(_oFlowContext.getPostDesc());
                childFlowDoc.setToUser(toUser);
                childFlowDoc.setFlag(2);
                childFlowDoc.setPreNode(nPreNodeId);
                childFlowDoc.setNode(nNodeId);
                childFlowDoc.setPreFlowDoc(nPreFlowDocId);
                childFlowDoc.setWorkModal(oRealBackToFlowDoc.getWorkModal());
                childFlowDoc.setParent(transmitFlowDoc.getId());
                childFlowDoc.setSerialNum(_oFlowContext.getSerialNum());
                childFlowDoc.setBranchSerialNum(_oFlowContext.getBranchSerialNum());
                childFlowDoc.insert(_oFlowContext.getCurrUser());
                this.sendNotify(_oFlowContext.getPostUser(), toUser, _oFlowContext.getNotifyTypes(), childFlowDoc.getId(), _oFlowContext.getFlowContent());
            }
        }
        transmitFlowDoc.setSerialNum(_oFlowContext.getSerialNum());
        transmitFlowDoc.setBranchSerialNum(_oFlowContext.getBranchSerialNum());
        transmitFlowDoc.insert(_oFlowContext.getCurrUser());
        String sStatusId = ConfigServer.getServer().getSysConfigValue("BACK_TO_STATUS", String.valueOf(15));
        int nStatusId = Integer.parseInt(sStatusId);
        if (nStatusId > 0) {
            _oFlowContext.getFlowContent().updateStatus(_oFlowContext.getCurrUser(), nStatusId);
        }
        if (!bApplyExtension) {
            this.onEvent(_oFlowContext, 4);
        }
        FlowingDocOptMarkScouter.updateOperationMark(_oFlowContext);
        this.autodeleteMessage(_oFlowContext);
        return true;
    }

    public static FlowDoc lookupRealBackFlowDocAgain(FlowDoc _flowDoc) throws WCMException {
        if (_flowDoc == null) {
            return null;
        }
        FlowDoc preFlowDoc = null;
        switch (_flowDoc.getFlag()) {
            case 2: {
                preFlowDoc = _flowDoc.getPreFlowDoc();
                if (preFlowDoc == null) {
                    throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label9", "\u6570\u636e\u4e0d\u6b63\u786e\uff01"));
                }
                if (preFlowDoc.getFlag() == 0) {
                    throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label10", "\u60a8\u662f\u6700\u5148\u53d1\u8d77\u4eba\uff0c\u4e0d\u80fd\u8fdb\u884c\u8fd4\u5de5\u64cd\u4f5c\u3002"));
                }
                return FlowServerImpl.lookupRealBackFlowDocAgain(preFlowDoc.getPreFlowDoc());
            }
            case 12: {
                preFlowDoc = _flowDoc.getPreFlowDoc();
                if (preFlowDoc.getFlag() == 8) {
                    return FlowServerImpl.lookupRealBackFlowDocAgain(preFlowDoc);
                }
                return preFlowDoc.getParent();
            }
        }
        return _flowDoc;
    }

    @Override
    public boolean refuse(FlowContext _oFlowContext) throws WCMException {
        _oFlowContext.validate();
        FlowDoc currFlowDoc = _oFlowContext.getCurrFlowDoc();
        if (currFlowDoc.getNode().isStartNode()) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label11", "\u60a8\u5df2\u7ecf\u5904\u4e8e\u5f00\u59cb\u8282\u70b9\uff0c\u4e0d\u80fd\u6267\u884c\u62d2\u7edd\u64cd\u4f5c"));
        }
        if (currFlowDoc.isWorked()) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label12", "\u6d41\u7a0b\u5df2\u7ecf\u5904\u7406\uff0c\u4e0d\u80fd\u6267\u884c\u62d2\u7edd\u64cd\u4f5c\uff01"));
        }
        if (currFlowDoc.getFlag() == 8) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label13", "\u5bf9\u4e8e\u5df2\u62d2\u7edd\u7684\u6d41\u8f6c\u5bf9\u8c61\uff0c\u60a8\u4e0d\u80fd\u518d\u62d2\u7edd\uff0c\u53ea\u80fd\u91cd\u65b0\u9009\u62e9\u5904\u7406\u4eba\u3002"));
        }
        if (currFlowDoc.getWorkModal() == 3) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label42", "\u5e76\u8054\u5ba1\u6279\u7ed3\u675f\u8282\u70b9\u4e0d\u5141\u8bb8\u8fdb\u884c\u62d2\u7edd\u64cd\u4f5c\u3002"));
        }
        if (currFlowDoc.getFlag() == 2) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label43", "\u5bf9\u4e8e\u8fd4\u5de5\u7684\u6d41\u8f6c\u5bf9\u8c61\uff0c\u60a8\u4e0d\u80fd\u518d\u62d2\u7edd\uff0c\u53ea\u80fd\u91cd\u65b0\u9009\u62e9\u5904\u7406\u4eba\u3002"));
        }
        currFlowDoc.validCanEditAndLock(_oFlowContext.getCurrUser());
        currFlowDoc.setWorked(true);
        currFlowDoc.update(_oFlowContext.getCurrUser());
        boolean bCreateFlowDocNeedDowith = false;
        if (currFlowDoc.getWorkModal() == 1) {
            this.setOtherSiblingsWorked(currFlowDoc);
            this.setParentWorked(currFlowDoc);
            bCreateFlowDocNeedDowith = true;
            this.makeNewFlowDocForRefuse(currFlowDoc, _oFlowContext, bCreateFlowDocNeedDowith, null);
        } else if (currFlowDoc.getWorkModal() == 0 || currFlowDoc.getWorkModal() == 2) {
            boolean bOthersCanProcessIfOneRefuse = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("OTHERS_CAN_PROCESS_IFONEREFUSE", "false"));
            if (bOthersCanProcessIfOneRefuse) {
                this.setOtherSiblingsWorked(currFlowDoc);
                this.setParentWorked(currFlowDoc);
                bCreateFlowDocNeedDowith = true;
            } else if (this.isLastUserOfTogether(currFlowDoc)) {
                bCreateFlowDocNeedDowith = true;
                this.setParentWorked(currFlowDoc);
            } else {
                bCreateFlowDocNeedDowith = false;
            }
            this.makeNewFlowDocForRefuse(currFlowDoc, _oFlowContext, bCreateFlowDocNeedDowith, null);
        } else if (currFlowDoc.getWorkModal() == 3) {
            FlowDocs _oPreFlowDocs = this.getSeperatorDealedFlowDocs(_oFlowContext);
            bCreateFlowDocNeedDowith = true;
            for (int k = 0; k <= _oPreFlowDocs.size(); ++k) {
                FlowDoc oFlowDoc = (FlowDoc)_oPreFlowDocs.getAt(k);
                this.makeNewFlowDocForRefuse(currFlowDoc, _oFlowContext, bCreateFlowDocNeedDowith, oFlowDoc);
            }
        }
        String sStatusId = ConfigServer.getServer().getSysConfigValue("REFUSE_TO_STATUS", String.valueOf(15));
        int nStatusId = Integer.parseInt(sStatusId);
        if (nStatusId > 0) {
            _oFlowContext.getFlowContent().updateStatus(_oFlowContext.getCurrUser(), nStatusId);
        }
        this.onEvent(_oFlowContext, 6);
        FlowingDocOptMarkScouter.updateOperationMark(_oFlowContext);
        this.autodeleteMessage(_oFlowContext);
        return true;
    }

    @Override
    public boolean forceEnd(FlowContext _oFlowContext) throws WCMException {
        User loginUser = _oFlowContext.getCurrUser();
        int nContentType = _oFlowContext.getFlowContent().getType();
        int nContentId = _oFlowContext.getFlowContent().getId();
        WCMFilter filter = new WCMFilter("", "Worked=0", "");
        FlowDocs oRunFlowDocs = FlowDocs.findOfContent(loginUser, nContentType, nContentId, filter);
        int nNodeId = 0;
        int nPreFlowDocId = 0;
        int nSize = oRunFlowDocs.size();
        for (int i = 0; i < nSize; ++i) {
            FlowDoc oRunFlowDoc = (FlowDoc)oRunFlowDocs.getAt(i);
            if (oRunFlowDoc == null) continue;
            if (oRunFlowDoc.getParentId() == 0) {
                nPreFlowDocId = oRunFlowDoc.getId();
            }
            oRunFlowDoc.validCanEditAndLock(_oFlowContext.getCurrUser());
            oRunFlowDoc.setWorked(true);
            oRunFlowDoc.update(_oFlowContext.getCurrUser());
            nNodeId = oRunFlowDoc.getNodeId() > 0 ? oRunFlowDoc.getNodeId() : oRunFlowDoc.getPreNodeId();
        }
        FlowDoc newFlowDoc = new FlowDoc();
        newFlowDoc.setPostUser(_oFlowContext.getPostUser());
        newFlowDoc.setPostDesc(_oFlowContext.getPostDesc());
        if (_oFlowContext.isFromRule()) {
            newFlowDoc.setFlag(18);
        } else {
            newFlowDoc.setFlag(7);
        }
        newFlowDoc.setContentType(_oFlowContext.getFlowContent().getType());
        newFlowDoc.setContentId(_oFlowContext.getFlowContent().getId());
        newFlowDoc.setNode(nNodeId);
        newFlowDoc.setPreNode(nNodeId);
        newFlowDoc.setAccepted();
        newFlowDoc.setWorked(true);
        newFlowDoc.setPreFlowDoc(nPreFlowDocId);
        newFlowDoc.setSerialNum(_oFlowContext.getSerialNum());
        newFlowDoc.setBranchSerialNum(_oFlowContext.getBranchSerialNum());
        newFlowDoc.insert(_oFlowContext.getCurrUser());
        FlowingDocOptMarkScouter.updateOperationMark(_oFlowContext, "RESERVED_FORCED_END");
        return true;
    }

    @Override
    public boolean doAccept(FlowContext _oFlowContext) throws WCMException {
        _oFlowContext.validate();
        FlowDoc currFlowDoc = _oFlowContext.getCurrFlowDoc();
        if (currFlowDoc.isAccepted()) {
            return true;
        }
        currFlowDoc.validCanEditAndLock(_oFlowContext.getCurrUser());
        currFlowDoc.setAccepted();
        currFlowDoc.update(_oFlowContext.getCurrUser());
        this.onEvent(_oFlowContext, 1);
        FlowingDocOptMarkScouter.updatePreOperationMark(_oFlowContext, I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label14", "\u5df2\u7b7e\u6536"));
        return true;
    }

    private void onEvent(FlowContext _oFlowContext, int _nRuleType) throws WCMException {
        ExecuteContext oExecContext = new ExecuteContext(_oFlowContext);
        FlowRule[] pRules = this.m_oRuleCacheServer.getRules(_oFlowContext.getCurrNode(), _nRuleType);
        RuleExecuteHelper.executeRules(oExecContext, pRules);
    }

    @Override
    public boolean doReceive(FlowContext _oFlowContext) throws WCMException {
        _oFlowContext.validate();
        FlowDoc currFlowDoc = _oFlowContext.getCurrFlowDoc();
        if (currFlowDoc.isReceived()) {
            return true;
        }
        currFlowDoc.validCanEditAndLock(_oFlowContext.getCurrUser());
        currFlowDoc.setReceiveTime();
        currFlowDoc.update(_oFlowContext.getCurrUser());
        this.onEvent(_oFlowContext, 0);
        FlowingDocOptMarkScouter.updatePreOperationMark(_oFlowContext, I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label15", "\u5df2\u6536\u5230"));
        return true;
    }

    @Override
    public IFlowContent[] getFlowContentsDoneByUser(User _currUser) throws WCMException {
        return this.getFlowContentsDoneByUser(_currUser, null);
    }

    @Override
    public IFlowContent[] getFlowContentsDoneByUser(User _currUser, CPager _cpager) throws WCMException {
        QueryFlowDocContext queryFlowDocContext = new QueryFlowDocContext();
        queryFlowDocContext.setCurrUser(_currUser);
        queryFlowDocContext.setPager(_cpager);
        return this.getFlowContentsDoneByUser(queryFlowDocContext);
    }

    @Override
    public IFlowContent[] getFlowContentsStartByUser(User _currUser, CPager _cpager) throws WCMException {
        QueryFlowDocContext queryFlowDocContext = new QueryFlowDocContext();
        queryFlowDocContext.setCurrUser(_currUser);
        queryFlowDocContext.setPager(_cpager);
        return this.getFlowContentsStartByUser(queryFlowDocContext);
    }

    @Override
    public IFlowContent[] getFlowContentsStartByUser(User _currUser) throws WCMException {
        return this.getFlowContentsStartByUser(_currUser, null);
    }

    private FlowDoc getCurrentFlowDoc(IFlowContent _flowContent, long _lSerialNum) throws WCMException {
        if (_lSerialNum < 0L) {
            return null;
        }
        WCMFilter filter = new WCMFilter("", "ObjType=? and ObjId=? and SerialNum=? and Worked=0 and ParentId=0", "FlowDocId Desc");
        filter.addSearchValues(_flowContent.getType());
        filter.addSearchValues(_flowContent.getId());
        filter.addSearchValues(_lSerialNum);
        filter.setMaxRowNumber(1);
        FlowDocs flowDocs = new FlowDocs(null);
        flowDocs.setMaxBufferSize(2);
        flowDocs.open(filter);
        if (flowDocs.isEmpty()) {
            return null;
        }
        return (FlowDoc)flowDocs.getAt(0);
    }

    private FlowDoc getCurrFlowDoc(IFlowContent _flowContent, long _lSerialNum, User currUser) throws WCMException {
        if (_lSerialNum < 0L) {
            return null;
        }
        WCMFilter filter = new WCMFilter("", "ObjType=? and ObjId=? and SerialNum=? and ParentId=0 and postuser=? and Flag=0", "FlowDocId Desc");
        filter.addSearchValues(_flowContent.getType());
        filter.addSearchValues(_flowContent.getId());
        filter.addSearchValues(_lSerialNum);
        filter.addSearchValues(currUser.getName());
        filter.setMaxRowNumber(1);
        FlowDocs flowDocs = new FlowDocs(null);
        flowDocs.setMaxBufferSize(2);
        flowDocs.open(filter);
        if (flowDocs.isEmpty()) {
            return null;
        }
        return (FlowDoc)flowDocs.getAt(0);
    }

    @Override
    public IFlowContent[] getFlowContentsInFlow(Flow _flow) throws WCMException {
        String SQL_QUERY_CONTENTS = "select distinct ObjType, ObjId, SerialNum from WCMFlowDoc where ParentId=0 and exists( select WCMFlowNode.NodeId  from WCMFlowNode  where WCMFlowNode.FlowId=? and WCMFlowDoc.NodeId=WCMFlowNode.NodeId) order by ObjId Desc, ObjType Desc";
        Connection conn = DBManager.getDBManager().getConnection();
        PreparedStatement pstm = null;
        ResultSet rsData = null;
        IFlowContent[] m_pFlowContents = new IFlowContent[]{};
        try {
            Object content;
            pstm = conn.prepareStatement("select distinct ObjType, ObjId, SerialNum from WCMFlowDoc where ParentId=0 and exists( select WCMFlowNode.NodeId  from WCMFlowNode  where WCMFlowNode.FlowId=? and WCMFlowDoc.NodeId=WCMFlowNode.NodeId) order by ObjId Desc, ObjType Desc");
            pstm.setInt(1, _flow.getId());
            rsData = pstm.executeQuery();
            while (rsData.next()) {
                content = FlowContentFactory.makeFlowContent(rsData.getInt(1), rsData.getInt(2));
                if (content == null || content.isDeleted()) continue;
                int nOldLength = m_pFlowContents.length;
                IFlowContent[] pTemp = new IFlowContent[nOldLength + 1];
                if (nOldLength > 0) {
                    System.arraycopy(m_pFlowContents, 0, pTemp, 0, nOldLength);
                }
                pTemp[nOldLength] = content;
                m_pFlowContents = pTemp;
                long lSerialNum = rsData.getLong("SerialNum");
                content.setSerialNum(lSerialNum);
                content.setFlowDoc(this.getCurrentFlowDoc((IFlowContent)content, lSerialNum));
            }
            content = m_pFlowContents;
            return content;
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label16", "\u6784\u9020\u5185\u5bb9\u5931\u8d25\uff01"), e);
        }
        finally {
            try {
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstm != null) {
                    pstm.close();
                }
            }
            catch (Exception exception) {}
            DBManager.getDBManager().freeConnection(conn);
        }
    }

    @Override
    public IFlowContent[] getFlowContentsOfUser(User _currUser) throws WCMException {
        return this.getFlowContentsOfUser(_currUser, null);
    }

    @Override
    public IFlowContent[] getFlowContentsOfUser(User _currUser, CPager _cpager) throws WCMException {
        QueryFlowDocContext queryFlowDocContext = new QueryFlowDocContext();
        queryFlowDocContext.setCurrUser(_currUser);
        queryFlowDocContext.setPager(_cpager);
        return this.getFlowContentsOfUser(queryFlowDocContext);
    }

    @Override
    public boolean submitTo(FlowContext _context) throws WCMException {
        boolean bEndNode;
        boolean bIsEndUser;
        if (_context == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label17", "\u6ca1\u6709\u6307\u5b9a\u7684\u5904\u7406\u53c2\u6570\uff01"));
        }
        if (_context.getCurrFlowDoc() != null && _context.getCurrFlowDoc().isWorked()) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label18", "\u5f53\u524d\u4e8b\u52a1\u53ef\u80fd\u5df2\u5904\u7406\u3002"));
        }
        if (_context.getWorkModal() == 1 && _context.getNextNode() == null && (bIsEndUser = this.isLastUserOfTogether(_context.getCurrFlowDoc()))) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label19", "\u60a8\u53ef\u80fd\u548c\u5176\u4ed6\u4eba\u540c\u65f6\u5904\u7406\u4e86\u8fd9\u4e2a\u4e8b\u52a1\uff0c\u8fd9\u6b21\u64cd\u4f5c\u65e0\u6548\uff0c\u60a8\u9700\u8981\u91cd\u65b0\u5904\u7406\u3002"));
        }
        FlowNodeBranch branch = _context.getBranch();
        FlowNode nextNode = _context.getNextNode();
        boolean bl = bEndNode = nextNode != null && nextNode.isEndNode();
        if (!_context.isStarting()) {
            this.doBeforeCreateNewFlowDoc(_context);
        }
        if (!bEndNode) {
            this.onEvent(_context, 3);
        }
        this.autodeleteMessage(_context);
        int nNewDocStatus = 0;
        int nOldDocStatus = 0;
        if (branch != null) {
            nNewDocStatus = branch.getStatusId();
            nOldDocStatus = _context.getFlowContent().getStatusId();
            boolean nNeedChangeStatus = true;
            if (nOldDocStatus == 10 && nextNode != null && nextNode.isEndNode()) {
                nNeedChangeStatus = false;
            }
            String isNeedChange = ConfigServer.getServer().getSysConfigValue("PUBLISHED_AFTER_EDIT", "1");
            if (nOldDocStatus == 1027 && isNeedChange.equals("0")) {
                nNeedChangeStatus = false;
            }
            if (nNeedChangeStatus && nNewDocStatus != nOldDocStatus) {
                _context.getFlowContent().updateStatus(_context.getCurrUser(), nNewDocStatus);
            }
        }
        try {
            if (bEndNode) {
                this.createEndFlowDoc(_context);
                this.onEvent(_context, 3);
            } else {
                this.createNewFlowDoc(_context);
            }
        }
        catch (Throwable ex) {
            if (nOldDocStatus > 0) {
                _context.getFlowContent().updateStatus(_context.getCurrUser(), nOldDocStatus);
            }
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label41", "\u6d41\u8f6c\u51fa\u73b0\u5f02\u5e38\uff01"), ex);
        }
        FlowingDocOptMarkScouter.updateOperationMark(_context);
        return true;
    }

    private void createEndFlowDoc(FlowContext _context) throws WCMException {
        int nPreNodeId = _context.isStarting() ? 0 : _context.getCurrFlowDoc().getNodeId();
        FlowDoc endFlowDoc = new FlowDoc();
        endFlowDoc.setPostUser(_context.getPostUser());
        endFlowDoc.setPostDesc(_context.getPostDesc());
        endFlowDoc.setFlag(18);
        endFlowDoc.setPreNode(nPreNodeId);
        endFlowDoc.setNode(_context.getNextNode());
        endFlowDoc.setFlowContent(_context.getFlowContent());
        endFlowDoc.setWorked(true);
        endFlowDoc.setSerialNum(_context.getSerialNum());
        endFlowDoc.setBranchSerialNum(this.makeBranchSerialNum(_context, FlowNode.findById(nPreNodeId)));
        endFlowDoc.setAccepted();
        endFlowDoc.insert(_context.getPostUser());
    }

    private void createNewFlowDoc(FlowContext _context) throws WCMException {
        int nPreNodeId = _context.getCurrNode().getId();
        int nCurrWorkModal = _context.getWorkModal();
        int nFlag = _context.isStarting() ? 0 : 1;
        switch (nCurrWorkModal) {
            case 0: 
            case 3: {
                break;
            }
            case 2: {
                if (_context.getNextNode() != null) break;
                return;
            }
            case 1: {
                this.createSingleSignFlowDoc(_context, nCurrWorkModal);
                boolean bIsEndUser = this.isLastUserOfTogether(_context.getCurrFlowDoc());
                if (!bIsEndUser) {
                    return;
                }
                nFlag = 12;
                _context.setPostDesc(FlowEngineHelper.makeTogetherComments(_context.getCurrFlowDoc().getParentId()));
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label20", "\u65e0\u6548\u7684\u4e8b\u52a1\u6a21\u5f0f\uff01"));
            }
        }
        int nNextWorkModal = 0;
        boolean bIsToSeperatorEnd = false;
        if (_context.getNextNode() != null) {
            nNextWorkModal = _context.getNextNode().getWorkModal();
            boolean bl = bIsToSeperatorEnd = nNextWorkModal == 3 && _context.getSerialNum() != _context.getBranchSerialNum();
        }
        if (bIsToSeperatorEnd) {
            this.createSingleSignFlowDoc(_context, nNextWorkModal);
            String sWhere = "ObjType=? and ObjId=? and ParentId=0 and Worked=0 and SerialNum=?";
            WCMFilter filter = new WCMFilter("", sWhere, "", "FlowDocId");
            filter.addSearchValues(_context.getCurrFlowDoc().getContentType());
            filter.addSearchValues(_context.getCurrFlowDoc().getContentId());
            filter.addSearchValues(_context.getSerialNum());
            filter.setMaxRowNumber(1);
            FlowDocs flowDocs = FlowDocs.openWCMObjs(null, filter);
            if (!flowDocs.isEmpty()) {
                return;
            }
        }
        boolean bUseSeperatorAsNormal = nNextWorkModal == 3 && _context.getSerialNum() == _context.getBranchSerialNum();
        this.createNewFlowDoc(_context, nPreNodeId, nFlag, bUseSeperatorAsNormal);
    }

    private void createSingleSignFlowDoc(FlowContext _context, int _nCurrWorkModal) throws WCMException {
        FlowDoc currFlowDoc = _context.getCurrFlowDoc();
        FlowDoc signFlowDoc = new FlowDoc();
        signFlowDoc.setContent(_context.getFlowContent());
        signFlowDoc.setPostUser(_context.getPostUser());
        signFlowDoc.setPostDesc(_context.getPostDesc());
        signFlowDoc.setFlag(_nCurrWorkModal == 1 ? 10 : 11);
        signFlowDoc.setWorked(true);
        signFlowDoc.setWorkModal(_nCurrWorkModal);
        signFlowDoc.setPreFlowDoc(_context.getCurrFlowDoc());
        if (_nCurrWorkModal == 1) {
            signFlowDoc.setNode(currFlowDoc.getNodeId());
            signFlowDoc.setPreNode(currFlowDoc.getNodeId());
        } else {
            int nNextNodeId = _context.getNextNode().getId();
            signFlowDoc.setNode(nNextNodeId);
            signFlowDoc.setPreNode(nNextNodeId);
        }
        signFlowDoc.setSerialNum(_context.getSerialNum());
        signFlowDoc.setBranchSerialNum(_context.getBranchSerialNum());
        signFlowDoc.insert(_context.getCurrUser());
    }

    private void createNewFlowDoc(FlowContext _context, int _nPreNodeId, int _nFlag) throws WCMException {
        this.createNewFlowDoc(_context, _nPreNodeId, _nFlag, false);
    }

    private void createNewFlowDoc(FlowContext _context, int _nPreNodeId, int _nFlag, boolean _bUseSeperatorAsNormal) throws WCMException {
        Users toUsers = _context.getToUsers();
        if (toUsers == null) {
            toUsers = this.getDealers(_context, _context.getNextNode());
        }
        if (toUsers == null || toUsers.isEmpty()) {
            return;
        }
        IWorkflowDelegateMgr m_oDelegateMgr = (IWorkflowDelegateMgr)DreamFactory.createObjectById("IWorkflowDelegateMgr");
        try {
            toUsers = m_oDelegateMgr.getDelegateUsers(toUsers, true);
        }
        catch (Throwable e) {
            throw new WCMException("\u83b7\u53d6\u59d4\u6258\u7528\u6237\u5931\u8d25\uff01", e);
        }
        int nSize = toUsers.size();
        User postUser = _context.getPostUser();
        FlowNode oFlowNode = _context.getNextNode();
        if (oFlowNode == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label40", "\u65e0\u6cd5\u627e\u5230\u4e0b\u4e00\u4e2a\u8282\u70b9\uff0c\u8282\u70b9\u6216\u8fde\u7ebf\u53ef\u80fd\u88ab\u5220\u9664\u3002"));
        }
        int nWorkModal = oFlowNode.getWorkModal();
        if (nWorkModal == 3 && _bUseSeperatorAsNormal) {
            nWorkModal = 0;
        }
        FlowDoc transmitFlowDoc = new FlowDoc();
        transmitFlowDoc.setPostUser(postUser);
        transmitFlowDoc.setPostDesc(_context.getPostDesc());
        transmitFlowDoc.setFlag(_nFlag);
        transmitFlowDoc.setPreNode(_nPreNodeId);
        transmitFlowDoc.setNode(_context.getNextNode());
        transmitFlowDoc.setFlowContent(_context.getFlowContent());
        transmitFlowDoc.setPreFlowDoc(_context.getCurrFlowDoc());
        transmitFlowDoc.setToUsers(toUsers.getIdListAsString());
        transmitFlowDoc.setSerialNum(_context.getSerialNum());
        long lBranchSerialNum = this.makeBranchSerialNum(_context, FlowNode.findById(_nPreNodeId));
        transmitFlowDoc.setBranchSerialNum(lBranchSerialNum);
        transmitFlowDoc.setNextId();
        if (nSize == 1) {
            if (nWorkModal == 1) {
                nWorkModal = 0;
            }
            transmitFlowDoc.setToUser(toUsers.getIdAt(0));
            this.sendNotify(postUser, (User)toUsers.getAt(0), _context.getNotifyTypes(), transmitFlowDoc.getId(), _context.getFlowContent());
        } else {
            for (int i = 0; i < nSize; ++i) {
                User toUser = (User)toUsers.getAt(i);
                if (toUser == null) continue;
                FlowDoc detailFlowDoc = new FlowDoc();
                detailFlowDoc.setPostUser(postUser);
                detailFlowDoc.setPostDesc(_context.getPostDesc());
                detailFlowDoc.setToUser(toUser);
                detailFlowDoc.setWorkModal(nWorkModal);
                detailFlowDoc.setFlag(_nFlag);
                detailFlowDoc.setPreNode(_nPreNodeId);
                detailFlowDoc.setNode(_context.getNextNode());
                detailFlowDoc.setFlowContent(_context.getFlowContent());
                detailFlowDoc.setParent(transmitFlowDoc.getId());
                detailFlowDoc.setPreFlowDoc(_context.getCurrFlowDoc());
                detailFlowDoc.setSerialNum(_context.getSerialNum());
                detailFlowDoc.setBranchSerialNum(lBranchSerialNum);
                detailFlowDoc.insert(postUser);
                this.sendNotify(postUser, toUser, _context.getNotifyTypes(), detailFlowDoc.getId(), _context.getFlowContent());
            }
        }
        transmitFlowDoc.setWorkModal(nWorkModal);
        transmitFlowDoc.insert(postUser);
        String sReffererTo = (String)_context.getProperty("ReffererTo");
        if ("true".equalsIgnoreCase(sReffererTo)) {
            this.onEvent(_context, 7);
        } else {
            _context.setCurrNode(_context.getNextNode());
            _context.setCurrFlowDoc(transmitFlowDoc);
            this.onEvent(_context, 5);
        }
    }

    private boolean isLastUserOfTogether(FlowDoc _currFlowDoc) throws WCMException {
        boolean bIsEndUser = false;
        String sQuerySQL = "select FlowDocId from WCMFlowDoc where ObjType=? and ObjId=? and Worked=0 and ParentId=? and FlowDocId<>? and SerialNum=" + _currFlowDoc.getSerialNum() + " and BranchSerialNum=" + _currFlowDoc.getBranchSerialNum();
        int[] pParams = new int[]{_currFlowDoc.getContentType(), _currFlowDoc.getContentId(), _currFlowDoc.getParentId(), _currFlowDoc.getId()};
        bIsEndUser = DBManager.getDBManager().sqlExecuteIntQuery(sQuerySQL, pParams) <= 0;
        return bIsEndUser;
    }

    private Users getDealers(FlowContext _oFlowContext, FlowNode _node) throws WCMException {
        ToUsersCreatorConfig toUsersCreatorConfig;
        if (_node == null) {
            return new Users(null);
        }
        String sToUsersCreator = _node.getPropertyAsString("ToUsersCreator");
        if (!CMyString.isEmpty(sToUsersCreator) && (toUsersCreatorConfig = this.m_oFlowConfigServer.getToUsersCreatorConfigByName(sToUsersCreator)) != null) {
            return toUsersCreatorConfig.getToUsers(_oFlowContext);
        }
        Users toUsers = _node.getOperUsers(null, true);
        return toUsers;
    }

    private void sendNotify(User _sender, User _receiver, String _sNotifyTypes, int _nRelFlowDocId, IFlowContent _oRelContent) throws WCMException {
        if (_sNotifyTypes != null && _sNotifyTypes.toUpperCase().equalsIgnoreCase("NONE")) {
            return;
        }
        IFlowNotify flowNotify = FlowContentNotifyFactory.getInstance().getFlowNotify(_oRelContent, _nRelFlowDocId);
        String sTitle = flowNotify.getTitle();
        String sDesc = flowNotify.getDesc();
        DBManager currDBManager = DBManager.getDBManager();
        FieldInfo fi = currDBManager.getFieldInfo("WCMMESSAGE", "Title");
        int length = this.getCompressLength(fi.getDataLength());
        if (CMyString.getBytesLength(sTitle) > length) {
            sTitle = CMyString.truncateStr(sTitle, length);
        }
        this.m_oNotify.addMsgEvent(_sender, _receiver, sTitle, sDesc, _sNotifyTypes);
    }

    private void doBeforeCreateNewFlowDoc(FlowContext _context) throws WCMException {
        boolean bIsEndUser;
        User postUser = _context.getCurrUser();
        _context.validate();
        FlowDoc currFlowDoc = _context.getCurrFlowDoc();
        if (_context.getPostUser().getId() != currFlowDoc.getToUserId()) {
            throw new WCMException(10, I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label24", "\u7528\u6237[") + _context.getPostUser().getName() + I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label25", "]\u4e0d\u80fd\u5904\u7406\u5f53\u524d\u4e8b\u52a1[FlowDocId=") + currFlowDoc.getId() + "]\uff01");
        }
        if (_context.getCurrFlowDoc().isWorked()) {
            throw new WCMException(10, I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label26", "\u5f53\u524d\u4e8b\u52a1\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\u8fc7\u4e86\uff0c\u4e0d\u80fd\u518d\u5904\u7406\uff01[FlowDocId=") + currFlowDoc.getId() + "]");
        }
        boolean bReffererTo = false;
        String sReffererTo = (String)_context.getProperty("ReffererTo");
        if (!CMyString.isEmpty(sReffererTo) && "true".equalsIgnoreCase(sReffererTo)) {
            bReffererTo = true;
        }
        if (_context.getCurrFlowDoc().getWorkModal() == 2 && _context.getNextNode() != null && !bReffererTo) {
            return;
        }
        currFlowDoc.validCanEditAndLock(postUser);
        currFlowDoc.setWorked(true);
        currFlowDoc.update(postUser);
        if ((currFlowDoc.getWorkModal() == 0 || currFlowDoc.getWorkModal() == 2 || currFlowDoc.getWorkModal() == 3) && currFlowDoc.getParentId() > 0) {
            this.setOtherSiblingsWorked(currFlowDoc);
            this.setParentWorked(currFlowDoc);
        }
        if (currFlowDoc.getWorkModal() == 1 && currFlowDoc.getParentId() > 0 && (bIsEndUser = this.isLastUserOfTogether(currFlowDoc))) {
            this.setParentWorked(currFlowDoc);
        }
    }

    private void setParentWorked(FlowDoc _currFlowDoc) throws WCMException {
        if (_currFlowDoc.getParentId() <= 0) {
            return;
        }
        String SQL_UPDATE_PARENT_WORKED = "update WCMFlowDoc set Worked=1,WorkTime=? where FlowDocId=? and  Worked=0";
        Object[] pParameters = new Object[]{CMyDateTime.now().toTimestamp(), new Integer(_currFlowDoc.getParentId())};
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{"update WCMFlowDoc set Worked=1,WorkTime=? where FlowDocId=? and  Worked=0"}, pParameters);
    }

    private void setChildrenWorked(FlowDoc _currFlowDoc) throws WCMException {
        if (_currFlowDoc.getParentId() > 0) {
            return;
        }
        String SQL_UPDATE_CHILDREN_WORKED = "update WCMFlowDoc set Worked=1,WorkTime=? where ParentId=? and  Worked=0";
        Object[] pParameters = new Object[]{CMyDateTime.now().toTimestamp(), new Integer(_currFlowDoc.getId())};
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{"update WCMFlowDoc set Worked=1,WorkTime=? where ParentId=? and  Worked=0"}, pParameters);
    }

    private void setOtherSiblingsWorked(FlowDoc _currFlowDoc) throws WCMException {
        if (_currFlowDoc.getParentId() <= 0) {
            return;
        }
        String SQL_UPDATE_FLOWDOC_FLAG = "update WCMFlowDoc set Flag=?,Worked=1,WorkTime=? where ParentId=? and FlowDocId<>? and Worked=0";
        Object[] pParameters = new Object[]{new Integer(9), CMyDateTime.now().toTimestamp(), new Integer(_currFlowDoc.getParentId()), new Integer(_currFlowDoc.getId())};
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{"update WCMFlowDoc set Flag=?,Worked=1,WorkTime=? where ParentId=? and FlowDocId<>? and Worked=0"}, pParameters);
    }

    private IFlowContent[] convertToFlowContents(FlowDocs _flowDocs, QueryFlowDocContext _oQueryFlowDocContext) throws WCMException {
        CPager cpager = _oQueryFlowDocContext.getPager();
        if (cpager == null) {
            cpager = new CPager();
        }
        int nSize = _flowDocs.size();
        cpager.setItemCount(nSize);
        ArrayList<IFlowContent> lstTempContents = new ArrayList<IFlowContent>();
        int nRemoved = 0;
        int nCurrCount = 0;
        for (int i = cpager.getFirstItemIndex() - 1; i < nSize; ++i) {
            FlowDoc flowDoc = (FlowDoc)_flowDocs.getAt(i);
            if (flowDoc == null) {
                ++nRemoved;
                continue;
            }
            IFlowContent content = FlowContentFactory.makeFlowContent(flowDoc.getContentType(), flowDoc.getContentId());
            if (content == null || content.isDeleted()) {
                ++nRemoved;
                continue;
            }
            boolean flag = true;
            String searchValue = _oQueryFlowDocContext.getParameter("SearchValue", "");
            Map valueMap = (Map)_oQueryFlowDocContext.getParameter("ValueMap");
            if (!"1".equals(_oQueryFlowDocContext.getParameter("searchType", ""))) {
                if (content.getInfo().indexOf(searchValue) < 0) {
                    flag = false;
                }
            } else {
                flag = FilterForFlowContentFactory.newInstance().doFilter(valueMap, content);
            }
            if (!flag) {
                ++nRemoved;
                continue;
            }
            lstTempContents.add(content);
            content.setFlowDoc(flowDoc);
            if (++nCurrCount >= cpager.getPageSize()) break;
        }
        int nRealContentCount = nSize - nRemoved;
        IFlowContent[] pContents = new IFlowContent[nRealContentCount];
        int nIndex = cpager.getFirstItemIndex() - 1;
        Iterator iter = lstTempContents.iterator();
        while (iter.hasNext()) {
            pContents[nIndex++] = (IFlowContent)iter.next();
        }
        return pContents;
    }

    @Override
    protected void doShutdown() {
    }

    @Override
    protected boolean doStart() throws WCMException {
        return true;
    }

    @Override
    public FlowDocs getFlowDocs(IFlowContent _content, WCMFilter _extrFilter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ObjType=? and ObjId=? and ParentId=0", "PostTime desc, FlowDocId desc");
        filter.addSearchValues(_content.getType());
        filter.addSearchValues(_content.getId());
        filter.mergeWith(_extrFilter);
        return FlowDocs.openWCMObjs(ContextHelper.getLoginUser(), filter);
    }

    @Override
    public FlowNodes getNextFlowNodes(FlowDoc _currFlowDoc, boolean _bIsResubmit) throws WCMException {
        FlowNode currNode;
        if (_currFlowDoc == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label29", "\u65e0\u6cd5\u627e\u5230\u8981\u5904\u7406\u7684\u8f68\u8ff9\u3002"));
        }
        FlowDoc flowDoc = _currFlowDoc;
        if (_bIsResubmit) {
            flowDoc = this.convertToRealFlowDoc(flowDoc);
            flowDoc = flowDoc.getPreFlowDoc();
            if ((flowDoc = this.convertToRealFlowDoc(flowDoc)) == null) {
                FlowNodes nodes = new FlowNodes(null, 1, 1);
                nodes.addElement(_currFlowDoc.getNode());
                return nodes;
            }
        }
        boolean bIsEndUser = true;
        if (flowDoc.getWorkModal() == 1) {
            bIsEndUser = this.isLastUserOfTogether(flowDoc);
        }
        if (flowDoc.getFlag() == 2 && (flowDoc.getWorkModal() != 1 || bIsEndUser)) {
            FlowNode preNode = flowDoc.getPreNode();
            if (preNode == null) {
                throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label30", "\u65e0\u6cd5\u627e\u5230\u6253\u56de\u7684\u8282\u70b9\uff0c\u53ef\u80fd\u8282\u70b9\u88ab\u5220\u9664\u6216\u6d41\u8f6c\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\u3002"));
            }
            FlowNodes nodes = new FlowNodes(null, 1, 1);
            nodes.addElement(preNode);
            return nodes;
        }
        if (flowDoc.getWorkModal() == 1) {
            if (_bIsResubmit) {
                return _currFlowDoc.getPreNode().getNextNodes(null);
            }
            if (!bIsEndUser) {
                return new FlowNodes(null, 1, 1);
            }
        }
        if ((currNode = flowDoc.getNode()) == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label31", "\u5f53\u524d\u6240\u5904\u8282\u70b9[") + flowDoc.getNodeId() + I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label32", "]\u4e0d\u80fd\u627e\u5230\uff01\u6570\u636e\u5e93\u4e2d\u88ab\u5220\u9664\u4e86\uff1f"));
        }
        WCMFilter filter = null;
        if (_currFlowDoc.getFlag() == 8 && currNode.getWorkModal() == 2) {
            String sWhere = "not exists(select 1 from WCMFlowDoc b where b.ObjType=? and b.ObjId=? and b.PreNodeId=? and b.Worked=0 and b.ParentId=0 and WCMFlowNode.NodeId=b.NodeId)";
            filter = new WCMFilter("", sWhere, "");
            filter.addSearchValues(_currFlowDoc.getContentType());
            filter.addSearchValues(_currFlowDoc.getContentId());
            filter.addSearchValues(_currFlowDoc.getNodeId());
        }
        return currNode.getNextNodes(null, filter);
    }

    @Override
    public FlowNodes getProcessedFlowNodes(FlowDoc _currFlowDoc) throws WCMException {
        if (_currFlowDoc == null) {
            throw new WCMException("\u5f53\u524d\u6d41\u8f6c\u8f68\u8ff9\u4e3a\u7a7a\uff01");
        }
        WCMFilter filter = new WCMFilter("", "", "", "NodeId, NodeName");
        int nNodeId = _currFlowDoc.getNodeId();
        int nContentType = _currFlowDoc.getContentType();
        int nContentId = _currFlowDoc.getContentId();
        long serialNum = _currFlowDoc.getSerialNum();
        long branchSerial = _currFlowDoc.getBranchSerialNum();
        String sWhere = "";
        if (_currFlowDoc.getWorkModal() == 3) {
            sWhere = " nodeid in (select distinct NodeId from WCMFlowDoc where FlowDocId<(select min(flowdocid) from WCMFLOWDOC where NODEID=? and ObjType=? and ObjId=? and ((Serialnum=?  and Serialnum=BranchSerialNum) or (BranchSerialNum=?  and Serialnum<>BranchSerialNum))) and ObjType=? and ObjId=?  and nodeid<>? and ((Serialnum=?  and Serialnum=BranchSerialNum) or (BranchSerialNum=?  and Serialnum<>BranchSerialNum)))";
            filter.addSearchValues(nNodeId);
            filter.addSearchValues(nContentType);
            filter.addSearchValues(nContentId);
            filter.addSearchValues(serialNum);
            filter.addSearchValues(branchSerial);
            filter.addSearchValues(nContentType);
            filter.addSearchValues(nContentId);
            filter.addSearchValues(nNodeId);
            filter.addSearchValues(serialNum);
            filter.addSearchValues(branchSerial);
        } else {
            sWhere = "nodeid in (select distinct NodeId from WCMFlowDoc where FlowDocId<(select min(flowdocid) from WCMFLOWDOC where NODEID=? and ObjType=? and ObjId=? and Serialnum=?) and ObjType=? and ObjId=? and nodeid<>? and Serialnum=?)";
            filter.addSearchValues(nNodeId);
            filter.addSearchValues(nContentType);
            filter.addSearchValues(nContentId);
            filter.addSearchValues(serialNum);
            filter.addSearchValues(nContentType);
            filter.addSearchValues(nContentId);
            filter.addSearchValues(nNodeId);
            filter.addSearchValues(serialNum);
        }
        filter.setWhere(sWhere);
        return FlowNodes.openWCMObjs(null, filter);
    }

    @Override
    public FlowNodes getWorkModalSepretorEndNodes(FlowDoc _flowDoc) throws WCMException {
        if (_flowDoc == null) {
            throw new WCMException("\u5f53\u524d\u6d41\u8f6c\u8f68\u8ff9\u4e3a\u7a7a\uff01");
        }
        FlowNode oNode = _flowDoc.getNode();
        int nFlowId = oNode.getFlowId();
        WCMFilter oFilter = new WCMFilter("", "FLOWID=? AND WORKMODAL=?", "");
        oFilter.addSearchValues(nFlowId);
        oFilter.addSearchValues(3);
        return FlowNodes.openWCMObjs(null, oFilter);
    }

    private FlowDoc convertToRealFlowDoc(FlowDoc _flowDoc) throws WCMException {
        return FlowServerImpl.convertToFlowDocNotFlags(_flowDoc, new int[]{4});
    }

    public static FlowDoc convertToFlowDocNotFlags(FlowDoc _flowDoc, int[] _pFlags) throws WCMException {
        if (_flowDoc == null) {
            return null;
        }
        FlowDoc realFlowDoc = _flowDoc;
        int nCount = 0;
        int nMaxCount = 1000;
        while (realFlowDoc != null && FlowServerImpl.isInFlag(realFlowDoc.getFlag(), _pFlags)) {
            int nPreFlowDocId = realFlowDoc.getId();
            if ((realFlowDoc = realFlowDoc.getPreFlowDoc()).getId() == nPreFlowDocId) break;
            if (++nCount <= nMaxCount) continue;
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label33", "\u9519\u8bef\u6570\u636e\uff0c\u5bfc\u81f4\u6b7b\u5faa\u73af\uff01[FlowDocId=") + realFlowDoc.getId() + "]");
        }
        return realFlowDoc;
    }

    private static boolean isInFlag(int _nFlag, int[] _pFlags) {
        for (int i = 0; i < _pFlags.length; ++i) {
            if (_pFlags[i] != _nFlag) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContentProcessInfo getProcessInfoOfContent(IFlowContent _content) throws WCMException {
        WCMFilter filter = new WCMFilter("WCMFlowDoc", "ObjType=? and ObjId=? and Flag=?", "SerialNum desc", "PostUser, SerialNum");
        filter.addSearchValues(_content.getType());
        filter.addSearchValues(_content.getId());
        filter.addSearchValues(0);
        String sStartUserName = "";
        long lSerailNum = -1L;
        FlowDocs flowDocs = new FlowDocs(null, 1, 1);
        flowDocs.setMaxSize(1);
        flowDocs.open(filter);
        if (!flowDocs.isEmpty()) {
            FlowDoc startFlowDoc = (FlowDoc)flowDocs.getAt(0);
            sStartUserName = startFlowDoc.getPostUserName();
            lSerailNum = startFlowDoc.getSerialNum();
        }
        FlowDoc currFlowDoc = this.getCurrentFlowDoc(_content, lSerailNum);
        if (_content.getFlowDoc() == null) {
            _content.setFlowDoc(currFlowDoc);
        }
        boolean bEnd = currFlowDoc == null;
        Users toUsers = null;
        if (currFlowDoc != null) {
            toUsers = currFlowDoc.getToUsers(null);
        }
        return new ContentProcessInfo(bEnd, _content, sStartUserName, toUsers);
    }

    @Override
    public FlowDoc autoToNextNode(FlowContext _context, FlowNode _nextNode) throws WCMException {
        return this.autoToNextNode(_context, _nextNode, null);
    }

    @Override
    public FlowDoc autoToNextNode(FlowContext _context, FlowNode _nextNode, Users _toUsers) throws WCMException {
        FlowDoc currFlowDoc = _context.getCurrFlowDoc();
        if (currFlowDoc.isWorked()) {
            return null;
        }
        currFlowDoc.validCanEditAndLock(_context.getCurrUser());
        currFlowDoc.setWorked(true);
        currFlowDoc.update(_context.getCurrUser());
        this.setOtherSiblingsWorked(currFlowDoc);
        this.setParentWorked(currFlowDoc);
        if (_nextNode == null) {
            return null;
        }
        if (_context.getNextNode() == null) {
            _context.setNextNode(_nextNode);
        }
        if (_nextNode.getWorkModal() == 3) {
            this.createSingleSignFlowDoc(_context, _nextNode.getWorkModal());
            String sWhere = "ObjType=? and ObjId=? and ParentId=0 and Worked=0 and SerialNum=?";
            WCMFilter filter = new WCMFilter("", sWhere, "", "FlowDocId");
            filter.addSearchValues(_context.getCurrFlowDoc().getContentType());
            filter.addSearchValues(_context.getCurrFlowDoc().getContentId());
            filter.addSearchValues(_context.getSerialNum());
            filter.setMaxRowNumber(1);
            FlowDocs flowDocs = FlowDocs.openWCMObjs(null, filter);
            if (!flowDocs.isEmpty()) {
                return null;
            }
        }
        User postUser = _context.getPostUser();
        int nContentType = currFlowDoc.getContentType();
        int nContentId = currFlowDoc.getContentId();
        int nPreNodeId = currFlowDoc.getNodeId();
        FlowNode preNode = currFlowDoc.getPreNode();
        Users toUsers = _toUsers;
        if (toUsers == null || toUsers.isEmpty()) {
            toUsers = this.getDealers(_context, _nextNode);
        }
        if (toUsers == null || toUsers.isEmpty()) {
            return null;
        }
        int nSize = toUsers.size();
        int nWorkModal = _nextNode.getWorkModal();
        FlowDoc transmitFlowDoc = new FlowDoc();
        transmitFlowDoc.setPostUser(postUser);
        transmitFlowDoc.setPostDesc(_context.getPostDesc());
        transmitFlowDoc.setFlag(3);
        transmitFlowDoc.setPreNode(nPreNodeId);
        transmitFlowDoc.setNode(_nextNode);
        transmitFlowDoc.setFlowContent(nContentType, nContentId);
        transmitFlowDoc.setToUsers(toUsers.getIdListAsString());
        transmitFlowDoc.setPreFlowDoc(currFlowDoc.getId());
        transmitFlowDoc.setSerialNum(_context.getSerialNum());
        long lBranchSerialNum = this.makeBranchSerialNum(_context, preNode);
        transmitFlowDoc.setBranchSerialNum(lBranchSerialNum);
        transmitFlowDoc.setNextId();
        if (nSize == 1) {
            if (nWorkModal == 1) {
                nWorkModal = 0;
            }
            transmitFlowDoc.setToUser(toUsers.getIdAt(0));
            this.sendNotify(postUser, (User)toUsers.getAt(0), _context.getNotifyTypes(), transmitFlowDoc.getId(), _context.getFlowContent());
        } else {
            for (int i = 0; i < nSize; ++i) {
                User toUser = (User)toUsers.getAt(i);
                if (toUser == null) continue;
                FlowDoc detailFlowDoc = new FlowDoc();
                detailFlowDoc.setPostUser(postUser);
                detailFlowDoc.setPostDesc(_context.getPostDesc());
                detailFlowDoc.setToUser(toUser);
                detailFlowDoc.setWorkModal(nWorkModal);
                detailFlowDoc.setFlag(3);
                detailFlowDoc.setPreNode(nPreNodeId);
                detailFlowDoc.setNode(_nextNode);
                detailFlowDoc.setFlowContent(nContentType, nContentId);
                detailFlowDoc.setParent(transmitFlowDoc.getId());
                detailFlowDoc.setPreFlowDoc(currFlowDoc.getId());
                detailFlowDoc.setSerialNum(_context.getSerialNum());
                detailFlowDoc.setBranchSerialNum(lBranchSerialNum);
                detailFlowDoc.insert(postUser);
                this.sendNotify(postUser, toUser, _context.getNotifyTypes(), detailFlowDoc.getId(), _context.getFlowContent());
            }
        }
        transmitFlowDoc.setWorkModal(nWorkModal);
        transmitFlowDoc.insert(postUser);
        FlowNodeBranch branch = transmitFlowDoc.getPreNode().getBranchTo(null, transmitFlowDoc.getNode());
        if (branch != null) {
            _context.getFlowContent().updateStatus(_context.getCurrUser(), branch.getStatusId());
        }
        _context.setCurrNode(_nextNode);
        _context.setCurrFlowDoc(transmitFlowDoc);
        this.onEvent(_context, 5);
        FlowingDocOptMarkScouter.updateOperationMark(_context);
        this.autodeleteMessage(_context);
        return transmitFlowDoc;
    }

    private long makeBranchSerialNum(FlowContext _context, FlowNode preNode) throws WCMException {
        long lBranchSerialNum = 0L;
        lBranchSerialNum = preNode != null ? (preNode.getWorkModal() == 2 && _context.getCurrFlowDoc().getFlag() != 2 ? System.currentTimeMillis() : (preNode.getWorkModal() == 3 ? _context.getSerialNum() : _context.getBranchSerialNum())) : _context.getBranchSerialNum();
        return lBranchSerialNum;
    }

    @Override
    public boolean resubmitTo(FlowContext _oFlowContext) throws WCMException {
        _oFlowContext.validate();
        FlowDoc currFlowDoc = _oFlowContext.getCurrFlowDoc();
        int nWorkModal = currFlowDoc.getWorkModal();
        User currUser = _oFlowContext.getCurrUser();
        if (nWorkModal != 2 && currFlowDoc.isWorked()) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label34", "\u5f53\u524d\u8f68\u8ff9\u5df2\u7ecf\u88ab\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u65b0\u5904\u7406\u3002"));
        }
        if (currFlowDoc.getParentId() > 0) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label35", "\u5f53\u524d\u8f68\u8ff9\u4e0d\u662f\u9876\u7ea7\u8f68\u8ff9\uff0c\u4e0d\u80fd\u91cd\u65b0\u5904\u7406\u3002"));
        }
        if (!currUser.getName().equals(currFlowDoc.getPostUserName())) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label36", "\u5f53\u524d\u7528\u6237[") + currUser.getName() + I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label37", "]\u4e0d\u662f\u5f53\u524d\u8f68\u8ff9\u7684\u5904\u7406\u8005\uff0c\u4e0d\u80fd\u91cd\u65b0\u5904\u7406\u3002"));
        }
        if (currFlowDoc.getFlag() == 2 || currFlowDoc.getFlag() == 8) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label38", "\u5f53\u524d\u5904\u7406\u7684\u662f\u8981\u6c42\u8fd4\u5de5\u6216\u8005\u62d2\u7edd\u7684\u8f68\u8ff9\uff0c\u4e0d\u80fd\u91cd\u65b0\u5904\u7406\u3002"));
        }
        if (!currFlowDoc.isWorked()) {
            currFlowDoc.validCanEditAndLock(currUser);
            currFlowDoc.setWorked(true);
            currFlowDoc.update(currUser);
            this.setChildrenWorked(currFlowDoc);
            if (nWorkModal == 2) {
                String SQL_SET_FLOWDOC_WORKED = "update WCMFlowDoc set Worked=1,WorkTime=? where ObjType=? and ObjId=? and Worked=0";
                Object[] pParameters = new Object[]{CMyDateTime.now().toTimestamp(), new Integer(currFlowDoc.getContentType()), new Integer(currFlowDoc.getContentId())};
                DBManager.getDBManager().sqlExecuteUpdate(new String[]{"update WCMFlowDoc set Worked=1,WorkTime=? where ObjType=? and ObjId=? and Worked=0"}, pParameters);
            }
        }
        this.createNewFlowDoc(_oFlowContext, currFlowDoc.getPreNodeId(), 4);
        FlowingDocOptMarkScouter.updateOperationMark(_oFlowContext);
        return true;
    }

    @Override
    public IFlowContent[] getFlowContentsDoneByUser(QueryFlowDocContext _oQueryFlowDocContext) throws WCMException {
        if (_oQueryFlowDocContext.getCurrUser() == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label39", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u7528\u6237\uff01"));
        }
        String sWhere = "PostUser=? and flag <> 0 and ParentId=0 and isObjDeleted <> 1";
        sWhere = _oQueryFlowDocContext.getContentType() > 0 ? sWhere + " and ObjType=?" : sWhere + " and ObjType <> 1844552626";
        String sOrderBy = _oQueryFlowDocContext.getParameter("OrderBy", "FlowDocId Desc");
        WCMFilter filter = new WCMFilter("", sWhere, sOrderBy);
        filter.addSearchValues(_oQueryFlowDocContext.getCurrUser().getName());
        if (_oQueryFlowDocContext.getContentType() > 0) {
            filter.addSearchValues(_oQueryFlowDocContext.getContentType());
        }
        FlowDocs flowDocs = FlowDocs.openWCMObjs(null, filter);
        return this.convertToFlowContents(flowDocs, _oQueryFlowDocContext);
    }

    @Override
    public IFlowContent[] getFlowContentsOfUser(QueryFlowDocContext _oQueryFlowDocContext) throws WCMException {
        if (_oQueryFlowDocContext.getCurrUser() == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label39", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u7528\u6237\uff01"));
        }
        String sWhere = "ToUserId=? and Worked=0 and isObjDeleted <> 1";
        sWhere = _oQueryFlowDocContext.getContentType() > 0 ? sWhere + " and ObjType=?" : sWhere + " and ObjType <> 1844552626";
        String sOrderBy = _oQueryFlowDocContext.getParameter("OrderBy", "FlowDocId Desc");
        WCMFilter filter = new WCMFilter("", sWhere, sOrderBy);
        filter.addSearchValues(_oQueryFlowDocContext.getCurrUser().getId());
        if (_oQueryFlowDocContext.getContentType() > 0) {
            filter.addSearchValues(_oQueryFlowDocContext.getContentType());
        }
        FlowDocs flowDocs = FlowDocs.openWCMObjs(null, filter);
        return this.convertToFlowContents(flowDocs, _oQueryFlowDocContext);
    }

    @Override
    public IFlowContent[] getFlowContentsStartByUser(QueryFlowDocContext _oQueryFlowDocContext) throws WCMException {
        if (_oQueryFlowDocContext.getCurrUser() == null) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label39", "\u6ca1\u6709\u6307\u5b9a\u5f53\u524d\u7528\u6237\uff01"));
        }
        int nContentType = _oQueryFlowDocContext.getContentType();
        String sSearchValue = _oQueryFlowDocContext.getParameter("SearchValue", "");
        String sSearchType = _oQueryFlowDocContext.getParameter("searchType", "");
        String sOrderBy = _oQueryFlowDocContext.getParameter("OrderBy", "PostTime Desc");
        String SQL_QUERY_CONTENTS = "select ObjType, ObjId, PostTime, SerialNum from WCMFlowDoc where PostUser=? and Flag=? and ParentId=0" + (nContentType > 0 ? " and ObjType=?" : " and ObjType <> 1844552626") + " and isObjDeleted <> 1 order by " + sOrderBy;
        CPager cpager = _oQueryFlowDocContext.getPager();
        if (cpager == null) {
            cpager = new CPager();
        }
        cpager.setItemCount(1000);
        Connection conn = DBManager.getDBManager().getConnection();
        PreparedStatement pstm = null;
        ResultSet rsData = null;
        int nRemove = 0;
        int nRowNum = 0;
        try {
            pstm = conn.prepareStatement(SQL_QUERY_CONTENTS);
            pstm.setString(1, _oQueryFlowDocContext.getCurrUser().getName());
            pstm.setInt(2, 0);
            if (nContentType > 0) {
                pstm.setInt(3, nContentType);
            }
            rsData = pstm.executeQuery();
            ArrayList<IFlowContent> lstTempContents = new ArrayList<IFlowContent>();
            while (rsData.next()) {
                if (++nRowNum < cpager.getFirstItemIndex() || lstTempContents.size() >= cpager.getPageSize()) continue;
                IFlowContent content = FlowContentFactory.makeFlowContent(rsData.getInt(1), rsData.getInt(2));
                if (content == null || content.isDeleted()) {
                    ++nRemove;
                    continue;
                }
                boolean flag = true;
                String searchValue = _oQueryFlowDocContext.getParameter("SearchValue", "");
                Map valueMap = (Map)_oQueryFlowDocContext.getParameter("ValueMap");
                if (!"1".equals(_oQueryFlowDocContext.getParameter("searchType", ""))) {
                    if (content.getInfo().indexOf(searchValue) < 0) {
                        flag = false;
                    }
                } else {
                    flag = FilterForFlowContentFactory.newInstance().doFilter(valueMap, content);
                }
                if (!flag) {
                    ++nRemove;
                    continue;
                }
                content.setStartTime(new CMyDateTime(rsData.getTimestamp("PostTime").getTime()));
                lstTempContents.add(content);
                long lSerialNum = rsData.getLong("SerialNum");
                content.setSerialNum(lSerialNum);
                content.setFlowDoc(this.getCurrentFlowDoc(content, lSerialNum));
            }
            int nRealCount = nRowNum - nRemove;
            IFlowContent[] m_pFlowContents = new IFlowContent[nRealCount];
            nRowNum = cpager.getFirstItemIndex() - 1;
            Iterator iter = lstTempContents.iterator();
            while (iter.hasNext()) {
                m_pFlowContents[nRowNum++] = (IFlowContent)iter.next();
            }
            IFlowContent[] iFlowContentArray = m_pFlowContents;
            return iFlowContentArray;
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(FlowServerImpl.class, "FlowServerImpl.label16", "\u6784\u9020\u53d1\u8d77\u7684\u5185\u5bb9\u5931\u8d25\uff01"), e);
        }
        finally {
            try {
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstm != null) {
                    pstm.close();
                }
            }
            catch (Exception exception) {}
            DBManager.getDBManager().freeConnection(conn);
        }
    }

    private void makeNewFlowDocForRefuse(FlowDoc _oFlowDoc, FlowContext _oFlowContext, boolean _bCreateFlowDocNeedDowith, FlowDoc _oPreSeperatorFlowDoc) throws WCMException {
        FlowDoc newFlowDoc = new FlowDoc();
        newFlowDoc.setContentType(_oFlowDoc.getContentType());
        newFlowDoc.setContentId(_oFlowDoc.getContentId());
        newFlowDoc.setPostUser(_oFlowContext.getPostUser());
        newFlowDoc.setPostTime(CMyDateTime.now());
        newFlowDoc.setPostDesc(_oFlowContext.getPostDesc());
        if (_oPreSeperatorFlowDoc == null) {
            newFlowDoc.setToUser(_oFlowDoc.getPostUser());
        } else {
            newFlowDoc.setToUser(_oPreSeperatorFlowDoc.getPostUser());
        }
        newFlowDoc.setFlag(8);
        newFlowDoc.setPreNode(_oFlowDoc.getNodeId());
        if (_oPreSeperatorFlowDoc == null) {
            newFlowDoc.setNode(_oFlowDoc.getPreNodeId());
        } else {
            newFlowDoc.setNode(_oPreSeperatorFlowDoc.getPreNodeId());
        }
        newFlowDoc.setPreFlowDoc(_oFlowDoc.getId());
        newFlowDoc.setWorked(!_bCreateFlowDocNeedDowith);
        newFlowDoc.setSerialNum(_oFlowContext.getSerialNum());
        newFlowDoc.setBranchSerialNum(_oFlowContext.getBranchSerialNum());
        newFlowDoc.insert(_oFlowContext.getCurrUser());
    }

    private FlowDocs getSeperatorDealedFlowDocs(FlowContext _oFlowContext) throws WCMException {
        String sWhere = "ObjType=? and ObjId=? and Worked=1 and SerialNum=? and NodeId=? and ToUsers is null";
        WCMFilter filter = new WCMFilter("", sWhere, "", "*");
        filter.addSearchValues(_oFlowContext.getCurrFlowDoc().getContentType());
        filter.addSearchValues(_oFlowContext.getCurrFlowDoc().getContentId());
        filter.addSearchValues(_oFlowContext.getSerialNum());
        filter.addSearchValues(_oFlowContext.getCurrFlowDoc().getNodeId());
        filter.setMaxRowNumber(1);
        FlowDocs flowDocs = FlowDocs.openWCMObjs(null, filter);
        return flowDocs;
    }

    private int getCompressLength(int _nOldLength) {
        return (int)Math.floor((float)_nOldLength / 1.5f);
    }

    private void autodeleteMessage(FlowContext _oFlowContext) throws WCMException {
        String sDeleteMessage = ConfigServer.getServer().getSysConfigValue("DELETE_MESSAGE_AFTER_PROCESS", "false");
        if ("true".equalsIgnoreCase(sDeleteMessage)) {
            FlowDoc currFlowDoc = _oFlowContext.getCurrFlowDoc();
            if (currFlowDoc == null) {
                return;
            }
            MessageServer.deleteMessage(currFlowDoc.getId(), _oFlowContext.getCurrUser());
        }
    }
}

