/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.content.ImgRec;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class HTMLContent {
    private static Logger s_logger = Logger.getLogger(HTMLContent.class);
    private static String[] HTML_TAG_NAMES;
    private static String[] HTML_TAG_SRCS;
    private String m_sSrcHTMLContent = null;
    private List<String> m_listFiles = null;
    private List<String> m_listWCMFiles = null;
    private static boolean s_bDeleteUploadPic;
    protected List<String> m_listSrcFiles = null;

    public HTMLContent(String _sContent) {
        this.m_sSrcHTMLContent = _sContent;
    }

    public List<String> getFiles() throws WCMException {
        if (this.m_listFiles == null) {
            this.m_listFiles = new ArrayList<String>();
            this.parseHTMLContent(this.m_listFiles, null, true, false);
        }
        return this.m_listFiles;
    }

    public List<String> getWCMFiles() throws WCMException {
        if (this.m_listWCMFiles == null) {
            this.m_listWCMFiles = new ArrayList<String>();
            this.parseHTMLContent(this.m_listWCMFiles, null, true, true);
        }
        return this.m_listWCMFiles;
    }

    public String parseHTMLContent(String _sImgSrcPre) throws WCMException {
        return this.parseHTMLContentWihtMultImgPre(new String[]{_sImgSrcPre});
    }

    public String parseHTMLContentWihtMultImgPre(String[] _pImgSrcPre) throws WCMException {
        if (this.m_listWCMFiles == null) {
            this.m_listWCMFiles = new ArrayList<String>();
        }
        return this.parseHTMLContent(this.m_listWCMFiles, _pImgSrcPre, false, true);
    }

    public String parseHTMLContentWithDomainPre(String _pImgSrcPre) throws WCMException {
        if (this.m_listWCMFiles == null) {
            this.m_listWCMFiles = new ArrayList<String>();
        }
        return this.parseHTMLContent(this.m_listWCMFiles, new String[]{_pImgSrcPre}, false, true, true);
    }

    private String parseHTMLContent(List<String> _listFiles, String[] _pImgSrcPre, boolean _bOnlyParseFile, boolean _bParseWebPicFile) throws WCMException {
        return this.parseHTMLContent(_listFiles, _pImgSrcPre, _bOnlyParseFile, _bParseWebPicFile, false);
    }

    private String parseHTMLContent(List _listFiles, String[] _pImgSrcPre, boolean _bOnlyParseFile, boolean _bParseWebPicFile, boolean _bFileDomain) throws WCMException {
        if (_bOnlyParseFile) {
            _listFiles.clear();
        }
        if (this.m_sSrcHTMLContent == null || this.m_sSrcHTMLContent.length() == 0) {
            return "";
        }
        String sResult = this.m_sSrcHTMLContent;
        String[] arTagName = HTMLContent.getTagNames();
        String[] arTagSrcName = HTMLContent.getTagSrcs();
        if (arTagName == null || arTagSrcName == null) {
            return this.m_sSrcHTMLContent;
        }
        int nTagSize = arTagName.length > arTagSrcName.length ? arTagName.length : arTagSrcName.length;
        FilesMan aFilesMan = FilesMan.getFilesMan();
        try {
            int nImageSrcPreIndex = 0;
            for (int nTagIndex = 0; nTagIndex < nTagSize; ++nTagIndex) {
                HtmlElement element;
                String currTagName = arTagName[nTagIndex];
                String currTagSrcName = arTagSrcName[nTagIndex];
                HtmlElementFinder imgFinder = new HtmlElementFinder(sResult);
                while ((element = imgFinder.findNextElement(currTagName, true)) != null) {
                    int nPos;
                    String sFileName = element.getAttributeValue(currTagSrcName);
                    if (sFileName == null || sFileName.length() == 0) {
                        imgFinder.putElement(element);
                        continue;
                    }
                    if (_bOnlyParseFile) {
                        if (_bParseWebPicFile ^ FilesMan.isValidFile(sFileName, "W0")) {
                            imgFinder.putElement(element);
                            continue;
                        }
                        nPos = sFileName.lastIndexOf(47);
                        if (nPos > 0) {
                            sFileName = sFileName.substring(nPos + 1);
                        }
                        _listFiles.add(sFileName);
                    } else {
                        if (!FilesMan.isValidFile(sFileName, "W0")) {
                            imgFinder.putElement(element);
                            continue;
                        }
                        nPos = sFileName.lastIndexOf(47);
                        if (nPos > 0) {
                            sFileName = sFileName.substring(nPos + 1);
                        }
                        _listFiles.add(sFileName);
                        String _sImgSrcPre = _pImgSrcPre[nImageSrcPreIndex++];
                        if (nImageSrcPreIndex >= _pImgSrcPre.length) {
                            nImageSrcPreIndex = 0;
                        }
                        if (!_bFileDomain) {
                            String sFilePath = _sImgSrcPre;
                            if (sFilePath == null) {
                                sFilePath = aFilesMan.mapFilePath(sFileName, 1);
                            }
                            element.setAttribute(currTagSrcName, sFilePath + sFileName);
                        } else {
                            element.setAttribute(currTagSrcName, CMyString.showEmpty(_sImgSrcPre) + aFilesMan.mapFilePath(sFileName, 1) + sFileName);
                        }
                    }
                    imgFinder.putElement(element);
                }
                sResult = imgFinder.getContent();
            }
            return sResult;
        }
        catch (Exception ex) {
            throw new WCMException(2, I18NMessage.get(HTMLContent.class, "HTMLContent.label1", "\u4f7f\u7528\u56fe\u7247\u8fc7\u6ee4\u5668\u63d0\u53d6\u6587\u6863HTML\u5185\u5bb9\u5931\u8d25(Document.getHtmlContentWithImgFilter)"), ex);
        }
    }

    public static String saveHtmlContent(String _sHTMLContent) throws WCMException {
        return HTMLContent.saveHtmlContent(_sHTMLContent, false, true);
    }

    public static String saveHtmlContent(String _sHTMLContent, boolean _bRecopyAllPics, boolean _bDownloadA) throws WCMException {
        return HTMLContent.saveHtmlContent(_sHTMLContent, _bRecopyAllPics, _bDownloadA, null);
    }

    private static String saveHtmlContent(String _sHTMLContent, boolean _bRecopyAllPics, boolean _bDownloadA, HashMap<String, String> _hmOutFile) throws WCMException {
        String[] arTagName = HTMLContent.getTagNames();
        String[] arTagSrcName = HTMLContent.getTagSrcs();
        if (arTagName == null) {
            return _sHTMLContent;
        }
        int nTagSize = arTagName.length > arTagSrcName.length ? arTagName.length : arTagSrcName.length;
        HtmlElementFinder imgFinder = null;
        HtmlElement element = null;
        Vector<ImgRec> vImgRecs = new Vector<ImgRec>();
        ImgRec imgRec = null;
        try {
            for (int nTagIndex = 0; nTagIndex < nTagSize; ++nTagIndex) {
                String currTagName = arTagName[nTagIndex];
                if (!_bDownloadA && currTagName.equalsIgnoreCase("A")) continue;
                String currTagSrcName = arTagSrcName[nTagIndex];
                imgFinder = new HtmlElementFinder(_sHTMLContent);
                while ((element = imgFinder.findNextElement(currTagName, true)) != null) {
                    String sIgnore = element.getAttributeValue("IGNORE");
                    String sImgSrc = element.getAttributeValue(currTagSrcName);
                    if (sIgnore != null && sIgnore.equals("1") || sImgSrc == null || (sImgSrc = sImgSrc.trim()).length() == 0) {
                        imgFinder.putElement(element);
                        continue;
                    }
                    String sFileName = null;
                    imgRec = HTMLContent.getRepeatedImg(sImgSrc, vImgRecs);
                    if (imgRec != null) {
                        element.setAttribute(currTagSrcName, imgRec.oldSrc);
                        element.setAttribute("OLDSRC", imgRec.oldSrc);
                        imgFinder.putElement(element);
                        continue;
                    }
                    sFileName = HTMLContent.saveFile(element, sImgSrc, _bRecopyAllPics, _hmOutFile);
                    if (sFileName != null) {
                        imgRec = new ImgRec();
                        imgRec.src = sImgSrc;
                        imgRec.oldSrc = sFileName;
                        vImgRecs.add(imgRec);
                        element.setAttribute(currTagSrcName, sFileName);
                        element.setAttribute("OLDSRC", imgRec.oldSrc);
                    }
                    imgFinder.putElement(element);
                }
                _sHTMLContent = imgFinder.getContent();
            }
            return _sHTMLContent;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(HTMLContent.class, "HTMLContent.label2", "\u4fdd\u5b58HTML\u5185\u5bb9\u5931\u8d25!"), ex);
        }
    }

    private static String saveFile(HtmlElement element, String _sImgSrc, boolean _bRecopyAllPics, HashMap<String, String> _hmOutFile) {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (_hmOutFile != null) {
            String sImgFileName = CMyFile.extractFileName(_sImgSrc, "/");
            String sSrcFile = _hmOutFile.get((sImgFileName = CMyFile.extractFileName(sImgFileName, "\\")).toLowerCase());
            if (sSrcFile != null) {
                try {
                    return filesMan.copyFile(sSrcFile, "W0", false);
                }
                catch (Exception ignore) {
                    s_logger.error((Object)(I18NMessage.get(HTMLContent.class, "HTMLContent.label3", "\u62f7\u8d1d\u6587\u4ef6[") + sSrcFile + I18NMessage.get(HTMLContent.class, "HTMLContent.label4", "]\u5931\u8d25\uff01")), (Throwable)ignore);
                    return null;
                }
            }
        }
        if (FilesMan.isValidFile(_sImgSrc, "W0")) {
            if (_bRecopyAllPics) {
                try {
                    return filesMan.copyWCMFile(_sImgSrc, "W0");
                }
                catch (WCMException ignore) {
                    return null;
                }
            }
            int nPos = _sImgSrc.lastIndexOf(47);
            if (nPos >= 0) {
                return _sImgSrc.substring(nPos + 1);
            }
        } else {
            String sUploadPic = element.getAttributeValue("UploadPic");
            if (sUploadPic == null || sUploadPic.length() < 8) {
                sUploadPic = _sImgSrc;
            }
            return HTMLContent.saveNewPic(element, sUploadPic);
        }
        return null;
    }

    private static String saveNewPic(HtmlElement _currElement, String _currImgSrc) {
        FilesMan currFilesMan = FilesMan.getFilesMan();
        String sFileName = null;
        if (FilesMan.isValidFile(_currImgSrc, "U0") || FilesMan.isValidFile(_currImgSrc, "ST")) {
            try {
                sFileName = currFilesMan.copyWCMFile(_currImgSrc, "W0");
                if (s_bDeleteUploadPic) {
                    currFilesMan.deleteFile(_currImgSrc);
                }
                _currElement.removeAttribute("UploadPic");
            }
            catch (Exception ex) {
                s_logger.error((Object)(I18NMessage.get(HTMLContent.class, "HTMLContent.label5", "\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff1aaddNewPic\uff1a") + _currImgSrc), (Throwable)ex);
                sFileName = null;
            }
            return sFileName;
        }
        if (!HTMLContent.isNeedDownload(_currElement, _currImgSrc)) {
            return null;
        }
        sFileName = HTMLContent.downloadFile(_currImgSrc);
        if (sFileName != null && sFileName.length() > 0) {
            sFileName = CMyFile.extractFileName(sFileName);
        }
        return sFileName;
    }

    public static boolean isNeedDownload(HtmlElement _currElement, String _sSrc) {
        char nLasChar = _sSrc.charAt(_sSrc.length() - 1);
        if (nLasChar == '/' || nLasChar == '\\') {
            return false;
        }
        String sSrcFile = _sSrc;
        int nParameterPos = _sSrc.lastIndexOf("?");
        if (nParameterPos >= 0) {
            sSrcFile = _sSrc.substring(0, nParameterPos);
        }
        if (FileHelper.isForbidFileExt(sSrcFile)) {
            return false;
        }
        boolean bResult = true;
        if (_currElement.getName().equalsIgnoreCase("A")) {
            bResult = _currElement.getAttribute("NeedDownload") != null && !HTMLContent.isHTMLContent(_sSrc);
            _currElement.removeAttribute("NeedDownload");
        } else {
            bResult = _currElement.getAttribute("NeedDownload") != null;
            _currElement.removeAttribute("NeedDownload");
            if (bResult) {
                return true;
            }
            boolean bl = bResult = _sSrc.toUpperCase().indexOf("HTTP:") == 0 || _sSrc.toUpperCase().indexOf("HTTPS:") == 0;
            if (!bResult) {
                return bResult;
            }
            int nPos = _sSrc.lastIndexOf(47);
            String sFileExt = nPos >= 0 ? _sSrc.substring(nPos + 1) : "";
            nPos = sFileExt.indexOf(46);
            sFileExt = nPos >= 0 ? sFileExt.substring(nPos + 1) : "";
            String[] sForbiddenTypes = new String[]{"ASP", "JSP", "PHP"};
            int nLenght = sForbiddenTypes.length;
            for (int m = 0; m < nLenght; ++m) {
                if (!sFileExt.toUpperCase().startsWith(sForbiddenTypes[m])) continue;
                bResult = false;
                break;
            }
        }
        return bResult;
    }

    public static ImgRec getRepeatedImg(String _sCurrImg, Vector<ImgRec> _vImgRecs) {
        for (int i = 0; i < _vImgRecs.size(); ++i) {
            ImgRec aImgRec = _vImgRecs.get(i);
            if (_sCurrImg.compareToIgnoreCase(aImgRec.src) != 0) continue;
            return aImgRec;
        }
        return null;
    }

    public static String[] getTagNames() {
        if (HTML_TAG_NAMES != null) {
            return HTML_TAG_NAMES;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String sTagNames = configServer.getInitProperty("DOC_HTML_TAG_NAMES");
        if (sTagNames == null || sTagNames.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_NAMES = CMyString.split(sTagNames, ",");
        }
        catch (Exception ex) {
            HTML_TAG_NAMES = null;
        }
        return HTML_TAG_NAMES;
    }

    public static String[] getTagSrcs() {
        if (HTML_TAG_SRCS != null) {
            return HTML_TAG_SRCS;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String sTagSrcs = configServer.getInitProperty("DOC_HTML_TAG_SRCS");
        if (sTagSrcs == null || sTagSrcs.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_SRCS = CMyString.split(sTagSrcs, ",");
        }
        catch (Exception ex) {
            HTML_TAG_SRCS = null;
        }
        return HTML_TAG_SRCS;
    }

    private static boolean isHTMLContent(String _sFileName) {
        String sExt = CMyFile.extractFileExt(_sFileName).toLowerCase();
        if (sExt.indexOf("htm") >= 0) {
            return true;
        }
        if (sExt.indexOf("asp") >= 0) {
            return true;
        }
        if (sExt.indexOf("jsp") >= 0) {
            return true;
        }
        return sExt.indexOf("php") >= 0;
    }

    private static String downloadFile(String _sUrlFile) {
        try {
            FilesMan filesMan = FilesMan.getFilesMan();
            String sExt = CMyFile.extractFileExt(_sUrlFile);
            String sFilePathName = filesMan.getNextFilePathName("W0", sExt);
            if (CMyFile.fileExists(_sUrlFile)) {
                CMyFile.copyFile(_sUrlFile, sFilePathName);
            } else {
                CMy3WLib.getFile(_sUrlFile, sFilePathName);
            }
            return sFilePathName;
        }
        catch (Exception ex) {
            s_logger.error((Object)("Fail to download[" + _sUrlFile + "]!"), (Throwable)ex);
            return null;
        }
    }

    public static String saveHTMLContentFromOut(String _sHTMLContent, HashMap<String, String> _hmOutFile) throws WCMException {
        return HTMLContent.saveHtmlContent(_sHTMLContent, false, true, _hmOutFile);
    }

    public static String getBodyContent(String _sHTMLContent) throws WCMException {
        try {
            String sContent = _sHTMLContent.toUpperCase();
            int nStartPose = sContent.indexOf("<BODY>");
            if (nStartPose < 0) {
                nStartPose = sContent.indexOf("<BODY ");
                if (nStartPose < 0) {
                    return sContent;
                }
                HtmlElement elBody = new HtmlElement();
                elBody.ONLY_SEARCH_SELF = true;
                nStartPose += elBody.fromString(_sHTMLContent.substring(nStartPose));
            }
            if (nStartPose < 0) {
                return _sHTMLContent;
            }
            int nEndPose = sContent.lastIndexOf("</BODY>");
            if (nEndPose < 0) {
                return _sHTMLContent.substring(nStartPose);
            }
            return _sHTMLContent.substring(nStartPose, nEndPose);
        }
        catch (Exception ex) {
            s_logger.error((Object)I18NMessage.get(HTMLContent.class, "HTMLContent.label6", "\u83b7\u53d6\u6587\u6863Body\u7684HTML\u5185\u5bb9\u53d1\u751f\u5f02\u5e38!"), (Throwable)ex);
            throw new WCMException(1100, I18NMessage.get(HTMLContent.class, "HTMLContent.label6", "\u83b7\u53d6\u6587\u6863Body\u7684HTML\u5185\u5bb9\u53d1\u751f\u5f02\u5e38!"), ex);
        }
    }

    public static String makeHTMLContentWithPre(String _sHTMLContent, String ... _pImgSrcPre) throws WCMException {
        if (CMyString.isEmpty(_sHTMLContent)) {
            return _sHTMLContent;
        }
        String sResult = _sHTMLContent;
        String[] arTagName = HTMLContent.getTagNames();
        String[] arTagSrcName = HTMLContent.getTagSrcs();
        if (arTagName == null || arTagSrcName == null) {
            return _sHTMLContent;
        }
        int nTagSize = arTagName.length > arTagSrcName.length ? arTagName.length : arTagSrcName.length;
        try {
            int nImageSrcPreIndex = 0;
            for (int nTagIndex = 0; nTagIndex < nTagSize; ++nTagIndex) {
                HtmlElement element;
                String currTagName = arTagName[nTagIndex];
                String currTagSrcName = arTagSrcName[nTagIndex];
                HtmlElementFinder imgFinder = new HtmlElementFinder(sResult);
                while ((element = imgFinder.findNextElement(currTagName, true)) != null) {
                    String sFileName = element.getAttributeValue(currTagSrcName);
                    if (sFileName == null || sFileName.length() == 0) {
                        imgFinder.putElement(element);
                        continue;
                    }
                    if (sFileName.matches("(?is)^<TRS.*")) {
                        imgFinder.putElement(element);
                        continue;
                    }
                    if (sFileName.startsWith("http:") || sFileName.startsWith("https:") || sFileName.startsWith("ftp:")) {
                        imgFinder.putElement(element);
                        continue;
                    }
                    String _sImgSrcPre = _pImgSrcPre[nImageSrcPreIndex++];
                    if (nImageSrcPreIndex >= _pImgSrcPre.length) {
                        nImageSrcPreIndex = 0;
                    }
                    element.setAttribute(currTagSrcName, _sImgSrcPre + sFileName);
                    imgFinder.putElement(element);
                }
                sResult = imgFinder.getContent();
            }
            return sResult;
        }
        catch (Exception ex) {
            throw new WCMException("\u8ffd\u52a0\u524d\u7f00\u5931\u8d25\uff01", ex);
        }
    }

    public static void main(String[] args) {
        try {
            HTMLContent aHTMLContent = new HTMLContent("<P align=center><IMG src='U020041026612707828449.gif'></P>" + I18NMessage.get(HTMLContent.class, "HTMLContent.label7", "<P>\u6b63\u6587\u5185\u5bb91</P><P align=center>") + I18NMessage.get(HTMLContent.class, "HTMLContent.label8", "<IMG src='U020041026612707828449.gif'></P><P>\u6b63\u6587\u5185\u5bb92</P>") + "<P align=center><IMG src='U020041026370966871586.html'></P>" + I18NMessage.get(HTMLContent.class, "HTMLContent.label9", "<P>\u6b63\u6587\u5185\u5bb93</P><P>\u6b63\u6587\u5185\u5bb92</P>") + "<P align=center><IMG src='W020080724538753281750.gif' OLDSRC=W020080724538753281750.gif></P><P align=center><IMG src='W020080724538753281750.gif' OLDSRC=W020080724538753281750.gif></P><P align=center><IMG src='W020080724538753281750.gif' OLDSRC=W020080724538753281750.gif></P>" + I18NMessage.get(HTMLContent.class, "HTMLContent.label10", "<P>\u6b63\u6587\u5185\u5bb93</P>"));
            s_logger.info((Object)"===============WEBPIC===============");
            s_logger.info((Object)aHTMLContent.parseHTMLContent(null));
            s_logger.info((Object)"===============IMAGES===============");
            s_logger.info((Object)aHTMLContent.parseHTMLContentWihtMultImgPre(new String[]{"im1/", "im2/"}));
            List<String> listHTMLWCMFiles = aHTMLContent.getWCMFiles();
            for (int i = 0; i < listHTMLWCMFiles.size(); ++i) {
                s_logger.info((Object)(i + ":" + listHTMLWCMFiles.get(i)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    static {
        s_bDeleteUploadPic = false;
    }
}

