/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUserCacheMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.util.CMyBitsValue;
import org.apache.log4j.Logger;

public class RightValue
extends CMyBitsValue {
    private static Logger logger = Logger.getLogger(RightValue.class);
    public static final long RIGHTVALUE_WHEN_NOT_EXISTS = -1L;
    private static int nCount = 63;
    private static RightValue s_oAdministratorRightValue = new RightValue(0L);
    private static StringBuffer sbAdministratorRightValue = new StringBuffer(nCount);
    public static long VALUE_ADMINISTRATOR;

    public RightValue() {
    }

    public RightValue(long _lValue) {
        super(_lValue);
    }

    public RightValue(String _sValue) {
        super(_sValue);
    }

    public RightValue(RightValue _rightValue) {
        this.copy(_rightValue);
    }

    public boolean isHasRight(int _index) {
        return this.getBit(_index);
    }

    public void setHasRight(int _index, boolean _blHasRight) {
        this.setBit(_index, _blHasRight);
    }

    public RightValue setRight(int _index, boolean _blHasRight) {
        this.setBit(_index, _blHasRight);
        return this;
    }

    public void copy(RightValue _rightValue) {
        this.setValue(_rightValue.getValue());
    }

    public void load(int _operatorType, int _operatorId, int _objType, int _objId) throws WCMException {
        if (_operatorId <= 0 || _objId <= 0) {
            throw new WCMException(10, I18NMessage.get(RightValue.class, "RightValue.label1", "\u65e0\u6548\u7684\u5bf9\u8c61ID(RightValue.load)"));
        }
        switch (_operatorType) {
            case 204: {
                User theUser = User.findById(_operatorId);
                if (theUser == null) {
                    throw new WCMException(10, I18NMessage.get(RightValue.class, "RightValue.label2", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(RightValue.load)"));
                }
                this.load(theUser, _objType, _objId, true);
                break;
            }
            case 203: {
                Role theRole = Role.findById(_operatorId);
                if (theRole == null) {
                    throw new WCMException(10, I18NMessage.get(RightValue.class, "RightValue.label3", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61(RightValue.load)"));
                }
                this.load(theRole, _objType, _objId);
                break;
            }
            case 201: {
                Group theGroup = Group.findById(_operatorId);
                if (theGroup == null) {
                    throw new WCMException(10, I18NMessage.get(RightValue.class, "RightValue.label4", "\u65e0\u6548\u7684\u7528\u6237\u7ec4\u5bf9\u8c61(RightValue.load)"));
                }
                this.load(theGroup, _objType, _objId);
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(RightValue.class, "RightValue.label5", "\u65e0\u6548\u7684\u64cd\u4f5c\u8005\u7c7b\u578b(RightValue.load)"));
            }
        }
    }

    public void load(User _user, int _objType, int _objId) throws WCMException {
        this.load(_user, _objType, _objId, true);
    }

    public void load(User _user, int _objType, int _objId, boolean _bIncludeGrpAndRole) throws WCMException {
        BaseObjs roles = null;
        BaseObjs groups = null;
        if (_user == null || !_user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RightValue.class, "RightValue.label2", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(RightValue.load)"));
        }
        RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        RoleUserCacheMgr roleUserCacheMgr = (RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr");
        try {
            long lTemp;
            int i;
            long lRightValue = rightCacheMgr.getRightValue(_objType, _objId, 204, _user.getId(), -1L);
            if (lRightValue != -1L) {
                this.value = lRightValue;
                return;
            }
            if (!_bIncludeGrpAndRole) {
                return;
            }
            roles = _objType == 1 && _objId == 1 ? _user.getRoles() : roleUserCacheMgr.getRoles(_user, RightValue.getSite(_objType, _objId));
            lRightValue = lRightValue > 0L ? lRightValue : 0L;
            for (i = 0; i < roles.size(); ++i) {
                Role role = (Role)roles.getAt(i);
                if (role == null) {
                    logger.error((Object)("The cache is error? The role[ID=" + roles.getIdAt(i) + "] of user[" + _user.getName() + "] not exists!"));
                    continue;
                }
                lTemp = 0L;
                if (role.isSystemRole()) {
                    if (_objType == 605) continue;
                    lTemp = role.getRightValue();
                } else {
                    lTemp = rightCacheMgr.getRightValue(_objType, _objId, 203, roles.getIdAt(i), -1L);
                }
                if (lTemp <= 0L) continue;
                lRightValue |= lTemp;
            }
            groups = _user.getGroups();
            for (i = 0; i < groups.size(); ++i) {
                Group currGroup = (Group)groups.getAt(i);
                if (currGroup == null || (lTemp = this.makeGroupRightValueOfObject(currGroup, _objType, _objId)) <= 0L) continue;
                lRightValue |= lTemp;
            }
            this.value = lRightValue;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(RightValue.class, "RightValue.label6", "\u53d6\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25(RightValue.load)"), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(RightValue.class, "RightValue.label6", "\u53d6\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25(RightValue.load)"), ex);
        }
        finally {
            if (roles != null) {
                roles.clear();
            }
            if (groups != null) {
                groups.clear();
            }
        }
    }

    public static WebSite getSite(int _nObjType, int _nObjId) throws WCMException {
        switch (_nObjType) {
            case 103: {
                return WebSite.findById(_nObjId);
            }
            case 101: {
                Channel channel = Channel.findById(_nObjId);
                if (channel == null) break;
                return channel.getSite();
            }
        }
        return null;
    }

    private long makeGroupRightValueOfObject(Group _currGroup, int _objType, int _objId) throws WCMException {
        if (_currGroup == null) {
            return -1L;
        }
        RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        long lTemp = rightCacheMgr.getRightValue(_objType, _objId, 201, _currGroup.getId(), -1L);
        if (lTemp != -1L) {
            return lTemp;
        }
        return this.makeGroupRightValueOfObject(_currGroup.getParent(), _objType, _objId);
    }

    public void load(Role _role, int _objType, int _objId) throws WCMException {
        if (_role == null || !_role.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RightValue.class, "RightValue.label3", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61(RightValue.load)"));
        }
        long lTemp = 0L;
        if (_role.isSystemRole()) {
            lTemp = _role.getRightValue();
        } else {
            RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
            lTemp = rightCacheMgr.getRightValue(_objType, _objId, 203, _role.getId(), 0L);
        }
        this.value = lTemp;
    }

    public void load(Group _group, int _objType, int _objId) throws WCMException {
        if (_group == null || !_group.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RightValue.class, "RightValue.label3", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61(RightValue.load)"));
        }
        long lTempRightValue = this.makeGroupRightValueOfObject(_group, _objType, _objId);
        this.value = lTempRightValue == -1L ? 0L : lTempRightValue;
    }

    public static void main(String[] args) {
        RightValue rightValue = new RightValue(0L);
        for (int i = 0; i < 63; ++i) {
            rightValue.setHasRight(i, true);
        }
    }

    public static RightValue getAdministratorRightValue() {
        return s_oAdministratorRightValue;
    }

    public static String getAdministratorValues() {
        return sbAdministratorRightValue.toString();
    }

    static {
        for (int i = 0; i < nCount; ++i) {
            sbAdministratorRightValue.append(1);
            s_oAdministratorRightValue.setBit(i, true);
        }
        VALUE_ADMINISTRATOR = s_oAdministratorRightValue.getValue();
    }
}

