/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ObjectMemberMgr
implements IObjectMemberMgr {
    private static final int MEMBER_RIGHT_VISIBLE = 1;
    private static final int MEMBER_RIGHT_OPERATION = 2;
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");

    @Override
    public boolean canOperate(User _oUser, int _nObjType, int _nObjId) throws WCMException {
        String key = this.makeKey(_oUser, _nObjType, _nObjId);
        this.insureCacheLoaded();
        Integer iValue = (Integer)cache.get(this.getKey(key));
        if (iValue != null && iValue >= 2) {
            return true;
        }
        Groups groups = _oUser.getGroups();
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null || !this.canOperate(group, _nObjType, _nObjId)) continue;
            return true;
        }
        Roles roles = _oUser.getRoles();
        int nSize2 = roles.size();
        for (int i = 0; i < nSize2; ++i) {
            Role role = (Role)roles.getAt(i);
            if (role == null || role.isSystemRole() || !this.canOperate(role, _nObjType, _nObjId)) continue;
            return true;
        }
        return false;
    }

    private String getKey() {
        return ObjectMemberMgr.class.getName();
    }

    private String getKey(String key) {
        return ObjectMemberMgr.class.getName() + "." + key;
    }

    @Override
    public boolean canOperate(Group _oGroup, int _nObjType, int _nObjId) throws WCMException {
        boolean bResult;
        if (_oGroup == null) {
            return false;
        }
        this.insureCacheLoaded();
        String key = this.makeKey(_oGroup, _nObjType, _nObjId);
        Integer iValue = (Integer)cache.get(this.getKey(key));
        int nValue = 0;
        if (iValue != null) {
            nValue = iValue;
        }
        boolean bl = bResult = nValue >= 2;
        if (bResult) {
            return true;
        }
        if (_oGroup.getParentId() <= 0) {
            return false;
        }
        return this.canOperate(_oGroup.getParent(), _nObjType, _nObjId);
    }

    @Override
    public boolean canOperate(Role _oRole, int _nObjType, int _nObjId) throws WCMException {
        if (_oRole.isSystemRole()) {
            return false;
        }
        String key = this.makeKey(_oRole, _nObjType, _nObjId);
        this.insureCacheLoaded();
        Integer iValue = (Integer)cache.get(this.getKey(key));
        if (iValue == null) {
            return false;
        }
        return iValue >= 2;
    }

    @Override
    public boolean canOperate(CMSObj _oOperator, int _nObjType, int _nObjId) throws WCMException {
        if (_oOperator instanceof User) {
            return this.canOperate((User)_oOperator, _nObjType, _nObjId);
        }
        String key = this.makeKey(_oOperator, _nObjType, _nObjId);
        this.insureCacheLoaded();
        Integer iValue = (Integer)cache.get(this.getKey(key));
        if (iValue == null) {
            return false;
        }
        return iValue >= 2;
    }

    @Override
    public boolean isVisible(User _oUser, int _nObjType, int _nObjId) throws WCMException {
        this.insureCacheLoaded();
        String key = this.makeKey(_oUser, _nObjType, _nObjId);
        Integer iValue = (Integer)cache.get(this.getKey(key));
        if (iValue != null && iValue >= 1) {
            return true;
        }
        Groups groups = _oUser.getGroups();
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null || !this.isVisible(group, _nObjType, _nObjId)) continue;
            return true;
        }
        Roles roles = _oUser.getRoles();
        int nSize2 = roles.size();
        for (int i = 0; i < nSize2; ++i) {
            Role role = (Role)roles.getAt(i);
            if (role == null || role.isSystemRole() || !this.isVisible(role, _nObjType, _nObjId)) continue;
            return true;
        }
        return false;
    }

    private void insureCacheLoaded() throws WCMException {
        if (!cache.exists(this.getKey()).booleanValue()) {
            this.doStart();
        }
    }

    @Override
    public boolean isVisible(Group _oGroup, int _nObjType, int _nObjId) throws WCMException {
        if (_oGroup == null) {
            return false;
        }
        this.insureCacheLoaded();
        String key = this.makeKey(_oGroup, _nObjType, _nObjId);
        Integer iValue = (Integer)cache.get(this.getKey(key));
        int nValue = 0;
        if (iValue != null) {
            nValue = iValue;
        }
        if (nValue >= 1) {
            return true;
        }
        if (_oGroup.getParentId() <= 0) {
            return false;
        }
        return this.isVisible(_oGroup.getParent(), _nObjType, _nObjId);
    }

    @Override
    public boolean isVisible(Role _oRole, int _nObjType, int _nObjId) throws WCMException {
        if (_oRole.isSystemRole()) {
            return false;
        }
        this.insureCacheLoaded();
        String key = this.makeKey(_oRole, _nObjType, _nObjId);
        Integer iValue = (Integer)cache.get(this.getKey(key));
        if (iValue == null) {
            return false;
        }
        return iValue >= 1;
    }

    @Override
    public boolean isVisible(CMSObj _oOperator, int _nObjType, int _nObjId) throws WCMException {
        this.insureCacheLoaded();
        if (_oOperator instanceof User) {
            return this.isVisible((User)_oOperator, _nObjType, _nObjId);
        }
        String key = this.makeKey(_oOperator, _nObjType, _nObjId);
        Integer iValue = (Integer)cache.get(this.getKey(key));
        if (iValue == null) {
            return false;
        }
        return iValue >= 1;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean init() throws WCMException {
        return this.doStart();
    }

    private synchronized boolean doStart() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return true;
        }
        cache.set(this.getKey(), "true");
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        DBManager dbMgr = DBManager.getDBManager();
        String strSQL = "select MemberType, MemberId, ObjType, ObjId, Visible, DoOperation from XWCMOBJECTMEMBER";
        try {
            oConn = dbMgr.getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            oStmt.setFetchSize(1000);
            rsData = oStmt.executeQuery();
            while (rsData.next()) {
                String key = this.makeKey(rsData.getInt("MemberType"), rsData.getInt("MemberId"), rsData.getInt("ObjType"), rsData.getInt("ObjId"));
                int nValue = 0;
                if (rsData.getInt("Visible") > 0) {
                    ++nValue;
                }
                if (rsData.getInt("DoOperation") > 0) {
                    nValue += 2;
                }
                cache.set(this.getKey(key), new Integer(nValue));
            }
        }
        catch (SQLException ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + strSQL, ex);
        }
        finally {
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            // empty if block
        }
        return this.doStart();
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        this.insureCacheLoaded();
        if (_oObjAdded instanceof ObjectMember) {
            this.putToCache((ObjectMember)_oObjAdded);
            return;
        }
        if (_oObjAdded instanceof Right) {
            Right right = (Right)_oObjAdded;
            String sInherit = right.getAttributeValue("ISINHERIT");
            if (!CMyString.isEmpty(sInherit) && "true".equalsIgnoreCase(sInherit)) {
                return;
            }
            BaseChannel currBaseChannel = this.makeCurrBaseChannel(right);
            if (currBaseChannel == null) {
                return;
            }
            if (right.getValueAsInt() == 0L) {
                this.removeOperation(right.getCrUser(), right.getOperatorType(), right.getOperatorId(), right.getObjType(), right.getObjId());
            } else {
                this.addOperation(right.getCrUser(), right.getOperatorType(), right.getOperatorId(), right.getObjType(), right.getObjId());
                if (currBaseChannel.isSite()) {
                    return;
                }
                for (BaseChannel parent = currBaseChannel.getHost(); parent != null; parent = parent.getHost()) {
                    this.addVisible(right.getCrUser(), right.getOperatorType(), right.getOperatorId(), parent.getWCMType(), parent.getId());
                    if (parent.isSite()) break;
                }
            }
        }
    }

    @Override
    public void addOperation(User _currUser, int _nMemberType, int _nMemberId, int _nObjType, int _nObjId) throws WCMException {
        String key = this.makeKey(_nMemberType, _nMemberId, _nObjType, _nObjId);
        Integer iValue = (Integer)cache.get(this.getKey(key));
        if (iValue == null) {
            ObjectMember member = ObjectMember.createNewInstance();
            member.setMemberType(_nMemberType);
            member.setMemberId(_nMemberId);
            member.setObjType(_nObjType);
            member.setObjId(_nObjId);
            member.setVisible(true);
            member.setDoOperation(true);
            member.insert(_currUser);
        } else if (iValue < 2) {
            ObjectMember member = ObjectMember.findByMemberObj(_nMemberType, _nMemberId, _nObjType, _nObjId);
            if (member == null) {
                cache.clear(this.getKey(key));
                this.addOperation(_currUser, _nMemberType, _nMemberId, _nObjType, _nObjId);
                return;
            }
            member.setVisible(true);
            member.setDoOperation(true);
            member.update(_currUser);
        }
    }

    @Override
    public void addVisible(User _currUser, int _nMemberType, int _nMemberId, int _nObjType, int _nObjId) throws WCMException {
        String key = this.makeKey(_nMemberType, _nMemberId, _nObjType, _nObjId);
        Integer iValue = (Integer)cache.get(this.getKey(key));
        if (iValue == null) {
            ObjectMember member = ObjectMember.createNewInstance();
            member.setMemberType(_nMemberType);
            member.setMemberId(_nMemberId);
            member.setObjType(_nObjType);
            member.setObjId(_nObjId);
            member.setVisible(true);
            member.insert(_currUser);
        } else if (iValue < 1) {
            ObjectMember objMember = ObjectMember.findByMemberObj(_nMemberType, _nMemberId, _nObjType, _nObjId);
            if (objMember == null) {
                cache.clear(this.getKey(key));
                this.addVisible(_currUser, _nMemberType, _nMemberId, _nObjType, _nObjId);
                return;
            }
            objMember.setVisible(true);
            objMember.update(_currUser);
        }
    }

    private BaseChannel makeCurrBaseChannel(Right _right) throws WCMException {
        int nObjType = _right.getObjType();
        BaseChannel currBaseChannel = null;
        switch (nObjType) {
            case 101: {
                currBaseChannel = Channel.findById(_right.getObjId());
                break;
            }
            case 103: {
                currBaseChannel = WebSite.findById(_right.getObjId());
                break;
            }
            default: {
                return null;
            }
        }
        return currBaseChannel;
    }

    private void removeOperation(User _currUser, int _nMemberType, int _nMemberId, int _nObjType, int _nObjId) throws WCMException {
        String key = this.makeKey(_nMemberType, _nMemberId, _nObjType, _nObjId);
        Integer iValue = (Integer)cache.get(this.getKey(key));
        if (iValue == null || iValue < 2) {
            return;
        }
        ObjectMember member = ObjectMember.findByMemberObj(_nMemberType, _nMemberId, _nObjType, _nObjId);
        if (member == null) {
            return;
        }
        member.canEdit(_currUser);
        member.setDoOperation(false);
        member.update(_currUser);
    }

    private void removeVisible(User _currUser, int _nMemberType, int _nMemberId, int _nObjType, int _nObjId) throws WCMException {
        String key = this.makeKey(_nMemberType, _nMemberId, _nObjType, _nObjId);
        Integer iValue = (Integer)cache.get(this.getKey(key));
        if (iValue == null || iValue < 2) {
            return;
        }
        ObjectMember member = ObjectMember.findByMemberObj(_nMemberType, _nMemberId, _nObjType, _nObjId);
        if (member == null) {
            return;
        }
        member.delete(_currUser);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        this.insureCacheLoaded();
        if (_oObjDeleted instanceof ObjectMember) {
            this.removeFromCache((ObjectMember)_oObjDeleted);
        } else if (_oObjDeleted instanceof Right) {
            Right right = (Right)_oObjDeleted;
            User oLoginUser = this.getLoginUser();
            this.removeOperation(oLoginUser, right.getOperatorType(), right.getOperatorId(), right.getObjType(), right.getObjId());
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        this.insureCacheLoaded();
        if (_oObjModified instanceof ObjectMember) {
            ObjectMember member = (ObjectMember)_oObjModified;
            String key = this.makeKey(member);
            int nNewValue = 0;
            if (_oObjModified.isChangeProperty("VISIBLE")) {
                if (_oObjModified.getNewPropertyAsInt("VISIBLE", 0) > 0) {
                    ++nNewValue;
                }
            } else if (_oObjModified.getPropertyAsInt("VISIBLE", 0) > 0) {
                ++nNewValue;
            }
            if (_oObjModified.isChangeProperty("DOOPERATION")) {
                if (_oObjModified.getNewPropertyAsInt("DOOPERATION", 0) > 0) {
                    nNewValue += 2;
                }
            } else if (_oObjModified.getPropertyAsInt("DOOPERATION", 0) > 0) {
                nNewValue += 2;
            }
            cache.set(this.getKey(key), new Integer(nNewValue));
            return;
        }
        if (_oObjModified instanceof Right) {
            Right right = (Right)_oObjModified;
            if (!right.isChangeProperty("RIGHTVALUE")) {
                return;
            }
            long lNewValue = ((Number)right.getNewProperty("RIGHTVALUE")).longValue();
            BaseChannel currBaseChannel = this.makeCurrBaseChannel(right);
            if (currBaseChannel == null) {
                return;
            }
            User oLoginUser = this.getLoginUser();
            if (lNewValue == 0L) {
                this.removeOperation(oLoginUser, right.getOperatorType(), right.getOperatorId(), right.getObjType(), right.getObjId());
            } else if (lNewValue > 0L) {
                this.addOperation(oLoginUser, right.getOperatorType(), right.getOperatorId(), right.getObjType(), right.getObjId());
                if (currBaseChannel.isSite()) {
                    return;
                }
                for (BaseChannel parent = currBaseChannel.getHost(); parent != null; parent = parent.getHost()) {
                    this.addVisible(oLoginUser, right.getOperatorType(), right.getOperatorId(), parent.getWCMType(), parent.getId());
                    if (parent.isSite()) break;
                }
            }
        }
    }

    private String makeKey(ObjectMember _oMember) {
        return this.makeKey(_oMember.getMemberType(), _oMember.getMemberId(), _oMember.getObjType(), _oMember.getObjId());
    }

    private String makeKey(BaseObj _currMember, int _nObjType, int _nObjId) {
        return this.makeKey(_currMember.getWCMType(), _currMember.getId(), _nObjType, _nObjId);
    }

    private String makeKey(int _nMemberType, int _nMemberId, int _nObjType, int _nObjId) {
        StringBuffer sbKey = new StringBuffer(32);
        sbKey.append(_nMemberType);
        sbKey.append(".");
        sbKey.append(_nMemberId);
        sbKey.append(".");
        sbKey.append(_nObjType);
        sbKey.append(".");
        sbKey.append(_nObjId);
        return sbKey.toString().intern();
    }

    private void removeFromCache(ObjectMember oMember) {
        String key = this.makeKey(oMember);
        cache.clear(this.getKey(key));
    }

    private void putToCache(ObjectMember oMember) {
        String key = this.makeKey(oMember);
        int nValue = 0;
        if (oMember.isVisible()) {
            ++nValue;
        }
        if (oMember.isDoOperation()) {
            nValue += 2;
        }
        cache.set(this.getKey(key), new Integer(nValue));
    }

    @Override
    public ObjectMember getObjectMember(int _nMemberType, int _nMemberId, int _nObjType, int _nObjId) throws WCMException {
        return ObjectMember.findByMemberObj(_nMemberType, _nMemberId, _nObjType, _nObjId);
    }

    @Override
    public ObjectMembers getObjectMembers(CMSObj _obj) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ObjType=? and ObjId=?", "");
        filter.addSearchValues(_obj.getWCMType());
        filter.addSearchValues(_obj.getId());
        ObjectMembers members = ObjectMembers.openWCMObjs(null, filter);
        return members;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

