/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.DocLevels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class DocLevelServiceProvider
implements IGlueServiceProvider {
    @Override
    public void delete(MethodContext context) throws Throwable {
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        WCMFilter filter = new WCMFilter("", "LVALUE>0", "LVALUE desc");
        User loginUser = ContextHelper.getLoginUser();
        DocLevels doclevels = DocLevels.openWCMObjs(loginUser, filter);
        int nSize = doclevels.size();
        for (int i = 0; i < nSize; ++i) {
            DocLevel element = (DocLevel)doclevels.getAt(i);
            if (element != null) continue;
        }
        doclevels.addElement(DocLevel.findById(1), 0);
        return doclevels;
    }

    public Object queryBySecurityDesc(MethodContext context) throws Throwable {
        WCMFilter filter = new WCMFilter("", "LVALUE>0", "LVALUE asc");
        User loginUser = ContextHelper.getLoginUser();
        DocLevels doclevels = DocLevels.openWCMObjs(loginUser, filter);
        doclevels.addElement(DocLevel.findById(1));
        return doclevels;
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        String sDocLevelName;
        int nDocLevelId = context.getObjectId();
        User loginUser = ContextHelper.getLoginUser();
        DocLevel currDocLevel = null;
        if (nDocLevelId > 0) {
            currDocLevel = DocLevel.findById(nDocLevelId);
            if (currDocLevel == null) {
                throw new WCMException("\u6307\u5b9a\u7684\u6587\u6863\u5bc6\u7ea7[ObjectId=" + nDocLevelId + "]\u4e0d\u5b58\u5728");
            }
        } else {
            currDocLevel = DocLevel.createNewInstance();
        }
        if (this.existsSimilarName(nDocLevelId, sDocLevelName = context.getValue("LNAME"))) {
            throw new WCMException("\u5df2\u7ecf\u5b58\u5728\u5bc6\u7ea7\u540d\u79f0\u4e3a[" + sDocLevelName + "]\u7684\u5bc6\u7ea7!");
        }
        if (currDocLevel.isAddMode()) {
            int nPreDocLevelId = context.getValue("PreDocLevelId", 0);
            int nLValue = this.calculateNextLevelValue(nPreDocLevelId);
            context.setValue("LVALUE", nLValue);
        }
        String[] pLogicFields = new String[]{"ObjectId", "PreDocLevelId"};
        currDocLevel = (DocLevel)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, currDocLevel, pLogicFields);
        currDocLevel.save(loginUser);
        return currDocLevel.getId();
    }

    private int calculateNextLevelValue(int _DocLevelId) throws WCMException {
        DocLevel currDocLevel = DocLevel.findById(_DocLevelId);
        if (_DocLevelId == -1 || _DocLevelId == 0) {
            currDocLevel = DocLevel.createNewInstance();
        } else {
            currDocLevel = DocLevel.findById(_DocLevelId);
            if (currDocLevel == null) {
                throw new WCMException("\u6307\u5b9a\u7684\u6587\u6863\u5bc6\u7ea7[ObjectId=" + _DocLevelId + "]\u4e0d\u5b58\u5728");
            }
        }
        int nLValue = currDocLevel.getLValue();
        String sWhere = "LVALUE>?";
        WCMFilter filter = new WCMFilter("XWCMDOCLEVEL", sWhere, "LVALUE ASC", "LVALUE");
        filter.addSearchValues(nLValue);
        DBManager dbManager = DBManager.getDBManager();
        int nNextLValue = dbManager.sqlExecuteIntQuery(filter);
        int nStepSize = 100;
        if (nNextLValue == -999) {
            return nLValue + 100;
        }
        if (nNextLValue - nLValue == 1) {
            throw new WCMException("\u5f53\u524d\u6587\u6863\u5bc6\u7ea7[" + currDocLevel + "]\u7684LValue=" + nLValue + "\uff0c\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728\u5bc6\u7ea7\u503cLValue=" + nNextLValue + "\u7684\u8bb0\u5f55");
        }
        int nNewValue = (nLValue + nNextLValue) / 2;
        return nNewValue;
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }

    public boolean existsSimilarName(MethodContext _oMethodContext) throws Throwable {
        int nDocLevelId = _oMethodContext.getValue("DOCLEVELID", 0);
        String sDocLevelName = _oMethodContext.getValue("LNAME");
        return this.existsSimilarName(nDocLevelId, sDocLevelName);
    }

    private boolean existsSimilarName(int _nDocLevelId, String _sDocLevelName) throws Exception {
        WCMFilter existFilter = new WCMFilter("XWCMDOCLEVEL", "DOCLEVELID <> ? and LNAME = ?", "", "DOCLEVELID");
        existFilter.addSearchValues(_nDocLevelId);
        existFilter.addSearchValues(_sDocLevelName);
        return DBManager.getDBManager().sqlExecuteIntQuery(existFilter) > 0;
    }
}

