/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.filter.logicProcessor;

import com.trs.idm.client.filter.logicProcessor.AbstractIDSCmdProcessor;
import com.trs.idm.interact.agent.AgentUtil;
import com.trs.idm.interact.agent.IAgent;
import com.trs.idm.util.CookieHelper;
import java.io.IOException;
import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class LogoutProcessor
extends AbstractIDSCmdProcessor {
    private static final Logger LOG = Logger.getLogger(LogoutProcessor.class);
    private IAgent agent;
    private final String idsCmd = "logout";

    public LogoutProcessor(IAgent agent) {
        this.agent = agent;
    }

    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String sessionId = this.agent.getServletAppActorV2().getSessionId(req, resp, false);
        if (sessionId == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ignore expired session. sessionId=" + sessionId + ", apphost=" + InetAddress.getLocalHost()));
            }
            resp.getOutputStream().print(String.valueOf(this.agent.getAgentName()) + "logout" + " " + sessionId);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("process logout ssoSession[" + sessionId + "] by idsCmd[" + "logout" + "], agentName[" + this.agent.getAgentName() + "]"));
        }
        if (resp.isCommitted()) {
            return;
        }
        AgentUtil.removeSSOBind((CookieHelper)new CookieHelper(req, resp), (IAgent)this.agent);
        this.agent.getServletAppActorV2().logout(req, resp);
        if (resp.isCommitted()) {
            return;
        }
        resp.getOutputStream().print(String.valueOf(this.agent.getAgentName()) + "logout" + " " + sessionId);
    }

    public String getIDSCmd() {
        return "logout";
    }
}

