/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.MapUtil;
import com.trs.idm.util.UrlUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConfigFileModifier {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Logger LOG = Logger.getLogger(ConfigFileModifier.class);
    private File file;
    private StringBuffer sb;
    private Properties modifiedProps;
    private Map toDelProps;
    private Map toRemProps;

    public ConfigFileModifier(String fileName) {
        this(new File(fileName));
    }

    public ConfigFileModifier(File f) {
        this.file = f;
        this.modifiedProps = new Properties();
        this.toDelProps = new HashMap();
        this.toRemProps = new HashMap();
    }

    public ConfigFileModifier(URL fileUrl) {
        this(UrlUtil.decode(fileUrl.getFile()));
    }

    public void remPropertyAsNewLine(String key) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        this.toRemProps.put(key, key);
    }

    public void removeProperty(String key) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        this.toDelProps.put(key, key);
    }

    public void modifyProperty(String key, String newValue) {
        if (newValue != null) {
            try {
                this.modifiedProps.put(key, new String(newValue.getBytes(), "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.toString(), e);
            }
        }
    }

    public void modifyProperty(String key, int newValue) {
        this.modifiedProps.put(key, String.valueOf(newValue));
    }

    public void modifyProperties(Map modifiedProperties) {
        if (modifiedProperties == null) {
            return;
        }
        for (String key : modifiedProperties.keySet()) {
            this.modifyProperty(key, (String)modifiedProperties.get(key));
        }
    }

    public void modifyProperty(String key, boolean bool) {
        this.modifiedProps.put(key, String.valueOf(bool));
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void saveModifies() throws IOException {
        if (!this.file.isFile()) {
            throw new FileNotFoundException("The file: " + this.file.getAbsolutePath() + " not exist or not a file!");
        }
        if (this.modifiedProps.size() == 0 && this.toDelProps.size() == 0 && this.toRemProps.size() == 0) {
            if (ConfigFileModifier.LOG.isDebugEnabled()) {
                ConfigFileModifier.LOG.debug((Object)"Modified properties size = 0, so return directly!");
            }
            return;
        }
        if (ConfigFileModifier.LOG.isDebugEnabled()) {
            ConfigFileModifier.LOG.debug((Object)("modifiedProps[" + MapUtil.toString(this.modifiedProps) + "], toDelProps[" + MapUtil.toString(this.toDelProps) + "], toRemProps[" + MapUtil.toString(this.toRemProps) + "]"));
        }
        isr = new InputStreamReader((InputStream)new FileInputStream(this.file), "ISO-8859-1");
        br = new BufferedReader(isr);
        bufferSize = this.file.length() > 32767L ? 32767 : (int)this.file.length();
        this.sb = new StringBuffer(bufferSize);
        key = null;
        newValue = null;
        lineDone = false;
        canReadFile = false;
        try {
            try {
                line = br.readLine();
                while (line != null) {
                    block28: {
                        block29: {
                            block27: {
                                if (!canReadFile) {
                                    canReadFile = true;
                                }
                                if ((trimedLine = line.trim()).length() != 0 && !trimedLine.startsWith("#")) break block27;
                                this.sb.append(line);
                                this.sb.append(ConfigFileModifier.NEWLINE);
                                break block28;
                            }
                            indexEqualChar = trimedLine.indexOf(61);
                            indexSpaceChar = trimedLine.indexOf(32);
                            if (indexEqualChar > 0 || indexSpaceChar > 0) break block29;
                            this.sb.append(line);
                            this.sb.append(ConfigFileModifier.NEWLINE);
                            break block28;
                        }
                        if (indexEqualChar <= 0) ** GOTO lbl-1000
                        curKey = trimedLine.substring(0, indexEqualChar).trim();
                        if (this.toRemProps.containsKey(curKey)) {
                            trimedLine = "#" + trimedLine;
                            this.sb.append(trimedLine);
                            this.sb.append(ConfigFileModifier.NEWLINE);
                            if (ConfigFileModifier.LOG.isDebugEnabled()) {
                                ConfigFileModifier.LOG.debug((Object)("Rem property key[" + curKey + "], value[" + trimedLine + "]"));
                            }
                        }
                        if (this.toDelProps.containsKey(curKey)) {
                            if (ConfigFileModifier.LOG.isDebugEnabled()) {
                                ConfigFileModifier.LOG.debug((Object)("Delete property key[" + curKey + "]"));
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            lineDone = false;
                            for (String key : this.modifiedProps.keySet()) {
                                newValue = this.modifiedProps.getProperty(key);
                                if (!trimedLine.startsWith(key) || trimedLine.startsWith(String.valueOf(key) + ".")) continue;
                                this.sb.append(key).append('=').append(newValue);
                                this.sb.append(ConfigFileModifier.NEWLINE);
                                lineDone = true;
                                this.modifiedProps.remove(key);
                                if (!ConfigFileModifier.LOG.isDebugEnabled()) break;
                                ConfigFileModifier.LOG.debug((Object)("Modify property key[" + key + "], value[" + newValue + "]"));
                                break;
                            }
                            if (!lineDone) {
                                this.sb.append(line);
                                this.sb.append(ConfigFileModifier.NEWLINE);
                            }
                            if (ConfigFileModifier.LOG.isDebugEnabled()) {
                                ConfigFileModifier.LOG.debug((Object)("Trimed Line[" + trimedLine + "]"));
                            }
                        }
                    }
                    line = br.readLine();
                }
                for (String key : this.modifiedProps.keySet()) {
                    newValue = this.modifiedProps.getProperty(key);
                    this.sb.append(key).append('=').append(newValue);
                    this.sb.append(ConfigFileModifier.NEWLINE);
                }
            }
            catch (IOException e) {
                ConfigFileModifier.LOG.error((Object)("fail! key=" + key + ", value=" + newValue), (Throwable)e);
                throw e;
            }
        }
        finally {
            br.close();
        }
        if (this.sb.length() > 0 && canReadFile) {
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "ISO-8859-1");
                writer.write(this.sb.toString());
                writer.close();
                if (ConfigFileModifier.LOG.isDebugEnabled()) {
                    ConfigFileModifier.LOG.debug((Object)("Update config file[" + this.file.getAbsolutePath() + "], sb.length=" + this.sb.length() + ", content=" + this.sb.toString()));
                } else {
                    ConfigFileModifier.LOG.info((Object)("Update config file[" + this.file.getAbsolutePath() + "], sb.length=" + this.sb.length()));
                }
                this.modifiedProps.clear();
            }
            catch (Exception e) {
                ConfigFileModifier.LOG.error((Object)("Can't write config file[" + this.file.getAbsolutePath() + "]:" + e.getMessage()), (Throwable)e);
            }
        } else {
            ConfigFileModifier.LOG.error((Object)("Can't update config file[" + this.file.getAbsolutePath() + "]: content length[" + this.sb.length() + "], canReadFile[" + canReadFile + "]!"));
        }
    }
}

