/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent.socket;

import com.trs.idm.interact.agent.ClientTransferManager;
import com.trs.idm.interact.agent.socket.SocketHostManager;

public class SocketHost {
    private String serverName;
    private int createdSocketCount;
    private int socketCountThreshold;
    private int errorSocketCount;
    private int idleSocketCount;
    private int activeSocketCount;
    private String serverHost;
    private int serverPort;
    private SocketHostManager manager;

    public SocketHost(SocketHostManager manager, String host, int port) {
        this.manager = manager;
        this.serverHost = host;
        this.serverPort = port;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getCreatedSocketCount() {
        return this.createdSocketCount;
    }

    public int getSocketCountThreshold() {
        return this.socketCountThreshold;
    }

    public int getErrorSocketCount() {
        return this.errorSocketCount;
    }

    public int getIdleSocketCount() {
        return this.idleSocketCount;
    }

    public int getActiveSocketCount() {
        return this.activeSocketCount;
    }

    public ClientTransferManager getClientTransferManager() {
        return this.manager.getClientTransferManager();
    }

    public synchronized void onOpened() {
        ++this.createdSocketCount;
    }

    public synchronized void OnEnterError() {
        ++this.errorSocketCount;
    }

    public synchronized void onLeaveError() {
        --this.errorSocketCount;
    }

    public synchronized void onEnterIdle() {
        ++this.idleSocketCount;
    }

    public synchronized void onLeaveIdle() {
        --this.idleSocketCount;
    }

    public synchronized void onActived() {
        ++this.activeSocketCount;
    }

    public synchronized void onFinished() {
        --this.activeSocketCount;
    }

    public synchronized void onClosed() {
        --this.createdSocketCount;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isActive() {
        return this.errorSocketCount < this.createdSocketCount;
    }

    public int getTotalSocketCount() {
        return this.errorSocketCount + this.activeSocketCount + this.idleSocketCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SocketHost@").append(this.hashCode()).append(" [serverName=");
        sb.append(this.serverName).append(", (").append(this.serverHost).append(":").append(this.serverPort);
        sb.append(";(Idle, Busy, Error, All)=");
        sb.append(this.idleSocketCount);
        sb.append(',');
        sb.append(this.activeSocketCount);
        sb.append(',');
        sb.append(this.errorSocketCount);
        sb.append(',');
        sb.append(this.createdSocketCount);
        sb.append("]");
        return sb.toString();
    }
}

