/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.StringHelper;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    public static <T> boolean contain(T[] anArray, T anElement) {
        if (anArray == null) {
            return false;
        }
        int i = 0;
        while (i < anArray.length) {
            if (anArray[i].equals(anElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Object[] subArray(Object[] aArray, int startPos, int maxResult) {
        if (aArray == null) {
            return null;
        }
        if (startPos >= aArray.length) {
            return new Object[0];
        }
        if (startPos + maxResult > aArray.length) {
            maxResult = aArray.length - startPos;
        }
        Object[] dest = new Object[maxResult];
        System.arraycopy(aArray, startPos, dest, 0, maxResult);
        return dest;
    }

    public static List getDiffList(List newList, List oldList) {
        ArrayList diffList = new ArrayList();
        for (Object item : newList) {
            if (oldList.contains(item)) continue;
            diffList.add(item);
        }
        return diffList;
    }

    public static List merge(List firstList, List secondList, boolean removeRepeat) {
        if (firstList == null && secondList == null) {
            return null;
        }
        if (secondList == null) {
            secondList = firstList;
        }
        for (Object obj : secondList) {
            if (removeRepeat && firstList.contains(obj)) continue;
            firstList.add(obj);
        }
        return firstList;
    }

    public static boolean isEmpty(List objects) {
        return objects == null || objects.size() == 0;
    }

    public static String toString(List objects, String seperator) {
        if (ArrayUtil.isEmpty(objects)) {
            return "";
        }
        if (StringHelper.isEmpty(seperator)) {
            seperator = ",";
        }
        StringBuffer objectArrayBuffer = new StringBuffer();
        objectArrayBuffer.append(objects.get(0));
        int i = 1;
        while (i < objects.size()) {
            objectArrayBuffer.append(seperator).append(objects.get(i));
            ++i;
        }
        return objectArrayBuffer.toString();
    }

    public static List union(List firstList, List secondList) {
        ArrayList result = new ArrayList();
        if (firstList == null || secondList == null) {
            return result;
        }
        if (firstList.size() == 0 || secondList.size() == 0) {
            return result;
        }
        for (Object obj : firstList) {
            if (result.contains(obj) || !secondList.contains(obj)) continue;
            result.add(obj);
        }
        return result;
    }
}

