/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.mina;

import com.trs.dev4.jdk16.mina.MessageServerMBean;
import com.trs.dev4.jdk16.mina.impl.MessageServerSessionHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageServer
extends Thread
implements MessageServerMBean {
    private static final Logger logger = LoggerFactory.getLogger(MessageServer.class);
    private boolean running = true;
    private MessageServerSessionHandler messageServerSessionHandler;
    private int port;

    protected void listener() {
        NioSocketAcceptor acceptor = new NioSocketAcceptor();
        acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        acceptor.setHandler((IoHandler)this.messageServerSessionHandler);
        try {
            acceptor.bind((SocketAddress)new InetSocketAddress(this.port));
            logger.info("Listening on port :" + this.port + ",server is start!");
        }
        catch (IOException e) {
            logger.error("Bind on port " + this.port + " failed: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void start() {
        this.listener();
    }

    public void registerJMX() {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            ObjectName MessageServer2 = new ObjectName("trs.UC:name=TRSUC");
            server.registerMBean(this, MessageServer2);
        }
        catch (MalformedObjectNameException e) {
            logger.error("registerJMX MalformedObjectNameException: ", (Object)e.getMessage(), (Object)e);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.error("registerJMX InstanceAlreadyExistsException: ", (Object)e.getMessage(), (Object)e);
        }
        catch (MBeanRegistrationException e) {
            logger.error("registerJMX MBeanRegistrationException: ", (Object)e.getMessage(), (Object)e);
        }
        catch (NotCompliantMBeanException e) {
            logger.error("registerJMX NotCompliantMBeanException:", (Object)e.getMessage(), (Object)e);
        }
        catch (NullPointerException e) {
            logger.error("registerJMX NullPointerException:", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void run() {
        this.registerJMX();
        while (this.running) {
            try {
                MessageServer.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("Server sleep exception: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.running = false;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public MessageServerSessionHandler getMessageServerSessionHandler() {
        return this.messageServerSessionHandler;
    }

    public void setMessageServerSessionHandler(MessageServerSessionHandler messageServerSessionHandler) {
        this.messageServerSessionHandler = messageServerSessionHandler;
    }
}

