/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util.dbcp.impl;

import com.trs.util.dbcp.impl.ConnectionWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;

final class HookConnection
implements InvocationHandler {
    private Connection m_actualConn;
    private volatile ConnectionWrapper m_wrapedConn;

    HookConnection(Connection conn) {
        this.m_actualConn = conn;
        this.m_wrapedConn = null;
    }

    HookConnection(ConnectionWrapper cw) {
        this.m_actualConn = cw.getConnection();
        this.m_wrapedConn = cw;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.m_actualConn == null) {
            throw new SQLException("Attempted to use Connection after closed() was called.");
        }
        if ("close".equals(method.getName())) {
            this.m_actualConn = null;
            ConnectionWrapper cw = this.m_wrapedConn;
            this.m_wrapedConn = null;
            if (cw != null) {
                cw.recycle();
            }
        } else {
            return method.invoke((Object)this.m_actualConn, args);
        }
        return null;
    }
}

