/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.http.rfc1867.impl;

import com.trs.net.http.rfc1867.FormPart;
import com.trs.net.http.rfc1867.FormPartFactory;
import com.trs.net.http.rfc1867.impl.FileFormPart;
import java.io.File;

public class FileFormPartFactory
implements FormPartFactory {
    private File m_oTempPath;

    public final File getTempPath() {
        if (this.m_oTempPath == null) {
            File tempDir;
            String sTempPath = System.getProperty("java.io.tmpdir");
            if (sTempPath == null) {
                sTempPath = System.getProperty("user.dir");
            }
            if (sTempPath == null) {
                sTempPath = ".";
            }
            if (!(tempDir = new File(sTempPath)).exists()) {
                tempDir.mkdirs();
            }
            this.m_oTempPath = tempDir;
        }
        return this.m_oTempPath;
    }

    public final void setTempPath(File path) {
        this.m_oTempPath = path;
    }

    public FormPart createFormPart(String sPartName, String sValue) {
        FileFormPart part = new FileFormPart();
        part.m_sName = sPartName;
        part.m_sValue = sValue;
        part.setMimeType("text/plain");
        return part;
    }

    public FormPart createFormPart(String partName, String filePath, String mimeType) {
        FileFormPart part = new FileFormPart();
        part.m_sName = partName;
        part.setFilePath(filePath);
        part.setMimeType(mimeType);
        part.setTempFile(this.createTempFileName());
        return part;
    }

    protected File createTempFileName() {
        try {
            return File.createTempFile("rfc1867", "tmp", this.m_oTempPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

