/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl.transport;

import com.trs.infra.cluster.Callbackable;
import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.impl.ClusterReceiverBase;
import com.trs.infra.cluster.impl.transport.AddressByTCP;
import com.trs.infra.cluster.io.ByteArrayOutputStream;
import com.trs.infra.cluster.io.FilterStreamReader;
import com.trs.infra.cluster.io.FilterStreamWriter;
import com.trs.infra.cluster.io.TransportTracer;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.log4j.Logger;

public class ReceiverByTCP
extends ClusterReceiverBase {
    private static final Logger s_logger;
    private Socket socket;
    private FilterStreamReader reader;
    private FilterStreamWriter writer;
    private Member remoteMember;
    private final byte[] headerBuffer = new byte[32];
    private TransportTracer transportTracer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.transport.ReceiverByTCP");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public ReceiverByTCP(Socket socket, FilterStreamReader reader, Member member) {
        super("ReceiverByTCP");
        this.socket = socket;
        this.reader = reader;
        this.remoteMember = member;
    }

    protected void doReceive() {
        try {
            this.doReceive(this.reader);
        }
        catch (EOFException e) {
            StringBuffer sb = new StringBuffer(256);
            sb.append("Unexpected EOF, receiver end.");
            sb.append(" local:").append(this.getLocalAddress());
            sb.append(" remote:").append(this.getRemoteAddress());
            s_logger.error((Object)sb.toString(), (Throwable)e);
            this.suicide();
        }
        catch (SocketException e) {
            StringBuffer sb = new StringBuffer(256);
            sb.append("Unexpected socket error, receiver end.");
            sb.append(" local:").append(this.getLocalAddress());
            sb.append(" remote:").append(this.getRemoteAddress());
            s_logger.error((Object)sb.toString(), (Throwable)e);
            this.suicide();
        }
        catch (SocketTimeoutException e) {
            s_logger.error((Object)"doReceive socket read timeout", (Throwable)e);
        }
        catch (IOException e) {
            s_logger.error((Object)"doReceive failed", (Throwable)e);
        }
    }

    private final void doReceive(final FilterStreamReader is) throws IOException {
        ClusterMessage message;
        byte[] buffer = this.headerBuffer;
        is.readFully(buffer, 0, 32);
        if (this.transportTracer != null) {
            this.transportTracer.trace(buffer, 0, 32);
        }
        if ((message = this.getMessageFromHeader(buffer)) == null) {
            return;
        }
        message.setSourceAddress(this.getRemoteAddress());
        if (!message.isDelayReceive()) {
            message._load(is);
        } else {
            Callbackable callback = new Callbackable(){

                public Object callBack(Object args) {
                    return is;
                }
            };
            message.setCallback(callback);
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("TCP receive:" + message));
        }
        this.dispatch(message, this.remoteMember);
        if (this.transportTracer != null) {
            ByteArrayOutputStream bypass = this.reader.getBypass();
            this.transportTracer.writeData(bypass.getBuffer(), 0, bypass.size());
        }
    }

    protected long getReadBytes() {
        return this.reader.size();
    }

    public Member getRemoteMember() {
        return this.remoteMember;
    }

    protected void startup() {
        try {
            String path;
            AddressByTCP local = new AddressByTCP(this.socket.getLocalAddress(), this.socket.getLocalPort());
            this.setLocalAddress(local);
            AddressByTCP remote = new AddressByTCP(this.socket.getInetAddress(), this.socket.getPort());
            this.setRemoteAddress(remote);
            this.writer = new FilterStreamWriter(this.socket.getOutputStream());
            if (s_logger.isDebugEnabled() && (path = this.getConfig().getTracerDirectory()) != null) {
                String file = this.getName();
                this.transportTracer = TransportTracer.newTracer(path, file);
                if (this.transportTracer != null) {
                    this.transportTracer = this.transportTracer.initialize(this.socket, false);
                }
                if (this.transportTracer != null) {
                    this.reader.setBypass(new ByteArrayOutputStream(65536));
                }
            }
        }
        catch (IOException e) {
            String info = "ReceiverByTCP startup failed";
            s_logger.fatal((Object)info, (Throwable)e);
            throw new RuntimeException(info, e);
        }
    }

    protected void cleanup() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                s_logger.error((Object)"Close socket input stream failed", (Throwable)e);
            }
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception e) {
                s_logger.error((Object)"Close socket output stream failed", (Throwable)e);
            }
            this.writer = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                s_logger.error((Object)"Close socket failed", (Throwable)e);
            }
            this.socket = null;
        }
    }
}

