/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.member;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.trs.infra.cluster.Address;
import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.cluster.ClusterContext;
import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.MemberListener;
import com.trs.infra.cluster.MemberManager;
import com.trs.infra.cluster.Startable;
import com.trs.infra.cluster.impl.transport.AddressByUDP;
import com.trs.infra.cluster.member.MemberImpl;
import com.trs.infra.cluster.member.MemberMessage;
import com.trs.infra.cluster.util.DaemonThreadBase;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class MemberManagerImpl
implements MemberManager,
Startable {
    private static final Logger s_logger;
    private static final int HEARTBEAT_CYCLE = 500;
    private static final int HEARTBEAT_SUSPECT = 2500;
    private int heartbeatSuspect = 2500;
    private static final int HEARTBEAT_TIMEOUT = 30000;
    private int heartbeatTimeout = 30000;
    private final HeartBeat threadHeartBeat = new HeartBeat();
    private final MemberShip threadMemberShip = new MemberShip();
    private ClusterContext context;
    private final Map freshmen = new ConcurrentHashMap();
    private final Map synQueue = new ConcurrentHashMap();
    private final Map denyList = new ConcurrentHashMap();
    private final Map allMembers = new HashMap();
    private MemberImpl[] listMembers = null;
    private final MemberImpl localMember = new LocalMemberImpl();
    private MemberListener[] memberListeners;
    private final Object memberListenersMutex = new Object();
    private boolean m_zBrotherConfiged = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.member.MemberManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public final ClusterContext getClusterContext() {
        return this.context;
    }

    public final void setClusterContext(ClusterContext clusterContext) {
        this.context = clusterContext;
    }

    public void start() {
        this.threadHeartBeat.startup();
        this.threadMemberShip.startup();
        this.m_zBrotherConfiged = this.context.getConfig().getBrotherAddresses() != null;
    }

    public void close() {
        this.sendMemberLeft();
        this.threadHeartBeat.terminate();
        this.threadMemberShip.terminate();
        this.freshmen.clear();
        this.allMembers.clear();
    }

    public void prepare() {
        this.initMemebersLocal();
    }

    private void initMemebersLocal() {
        ClusterConfig config = this.context.getConfig();
        this.localMember.setLocal(true);
        this.localMember.setMaster(config.isMaster());
        this.localMember.setName(config.getMemberName());
        this.localMember.setHost(config.getMemberHost());
        try {
            this.localMember.setTCPAddress(config.getInetTCPListenAddress());
        }
        catch (UnknownHostException e) {
            s_logger.fatal((Object)"Unknown TCP listen address", (Throwable)e);
            throw new RuntimeException("Unknown TCP listen address", e);
        }
        this.localMember.setTCPPort(config.getTCPListenPort());
        try {
            this.localMember.setUDPAddress(config.getInetUDPListenAddress());
        }
        catch (UnknownHostException e) {
            s_logger.fatal((Object)"Unknown UDP listen address", (Throwable)e);
            throw new RuntimeException("Unknown UDP listen address", e);
        }
        this.localMember.setUDPPort(config.getUDPListenPort());
        this.localMember.setMaxMemory(Runtime.getRuntime().maxMemory());
        this.localMember.setState(Member.State.NORMAL);
        this.addMember(this.localMember);
    }

    public int getAcceptedMessage() {
        return 4;
    }

    public void receive(ClusterMessage msg, Member sender) {
        if (msg == null) {
            return;
        }
        if (!(msg instanceof MemberMessage)) {
            return;
        }
        MemberMessage message = (MemberMessage)msg;
        switch (msg.getMinorId()) {
            case 1: {
                this.receiveHeartBeat(message);
                break;
            }
            case 2: {
                this.receiveWelcome(message);
                break;
            }
            case 3: {
                this.receiveDeclare(message);
                break;
            }
            case 4: {
                this.receiveAccepted(message);
                break;
            }
            case 5: {
                this.receiveAcceptACK(message);
                break;
            }
            case 6: {
                this.receiveMemberLeft(message);
                break;
            }
            case 7: {
                this.receiveMemberAttribute(message);
                break;
            }
            case 8: {
                this.receiveAreYouOK(sender);
                break;
            }
            default: {
                s_logger.error((Object)"Unknown minor message id ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveHeartBeat(MemberMessage message) {
        MemberImpl member = null;
        String fromGUID = message.getFromGUID();
        boolean isLoggerDebugEnabled = s_logger.isDebugEnabled();
        if (isLoggerDebugEnabled) {
            s_logger.debug((Object)("receive heartbeat from:" + fromGUID));
        }
        if (fromGUID == null) {
            return;
        }
        member = (MemberImpl)this.allMembers.get(fromGUID);
        if (member == null) {
            member = (MemberImpl)this.freshmen.get(fromGUID);
            if (isLoggerDebugEnabled) {
                s_logger.debug((Object)("receive heartbeat check freshmen:" + member));
            }
        }
        if (member != null) {
            if (isLoggerDebugEnabled) {
                s_logger.debug((Object)("receive heartbeat from:" + member));
            }
            member.setPulseTime(System.currentTimeMillis());
            member.setFreeMemory(message.getFreeMemory());
            member.setTotalMemory(message.getTotalMemory());
            member.setTimeDifference(message.getCurrentTime() - member.getPulseTime());
            return;
        }
        String fromAddress = message.getSourceAddress().getHostAddress();
        if (this.denyList.containsKey(fromAddress)) {
            if (isLoggerDebugEnabled) {
                s_logger.debug((Object)("receive heartbeat from:" + fromGUID + ",in denyList:" + fromAddress));
            }
            return;
        }
        if (this.synQueue.containsKey(message.getFromGUID())) {
            if (isLoggerDebugEnabled) {
                s_logger.debug((Object)("receive heartbeat from:" + fromGUID + ", in synQueue:" + this.synQueue));
            }
            this.sendWelcome(message);
            return;
        }
        boolean addSynQueue = false;
        Map map = this.synQueue;
        synchronized (map) {
            if (this.synQueue.containsKey(fromGUID)) {
                addSynQueue = false;
            } else {
                SYN syn = new SYN();
                syn.guid = fromGUID;
                syn.times = System.currentTimeMillis();
                this.synQueue.put(fromGUID, syn);
                addSynQueue = true;
            }
        }
        if (addSynQueue) {
            if (isLoggerDebugEnabled) {
                s_logger.debug((Object)("receive heartbeat add synQueue:" + fromGUID));
            }
        } else {
            if (isLoggerDebugEnabled) {
                s_logger.debug((Object)("receive heartbeat from:" + fromGUID + ", in synQueue:" + this.synQueue));
            }
            return;
        }
        this.sendWelcome(message);
    }

    void sendHeartBeat() {
        if (this.m_zBrotherConfiged) {
            Address[] brothers = this.context.getConfig().getBrotherAddresses();
            int i = 0;
            int len = brothers.length;
            while (i < len) {
                MemberMessage message = this.buildHearBeatMessage();
                Address address = brothers[i];
                if (address != null) {
                    message.setTargetAddress(address);
                }
                this.context.send(message);
                ++i;
            }
        } else {
            MemberMessage message = this.buildHearBeatMessage();
            this.context.send(message);
        }
    }

    private void sendHeartBeat(Member sender) {
        MemberMessage message = this.buildHearBeatMessage();
        this.context.send((ClusterMessage)message, sender);
    }

    protected MemberMessage buildHearBeatMessage() {
        Runtime runtime = Runtime.getRuntime();
        MemberImpl member = this.localMember;
        member.setFreeMemory(runtime.freeMemory());
        member.setTotalMemory(runtime.totalMemory());
        MemberMessage message = new MemberMessage();
        message.setMinorId(1);
        message.setFromGUID(this.localMember._guid());
        message.setFreeMemory(member.getFreeMemory());
        message.setTotalMemory(member.getTotalMemory());
        message.setCurrentTime(System.currentTimeMillis());
        return message;
    }

    void receiveWelcome(MemberMessage message) {
        String toGUID = message.getToGUID();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("receive welcome to:" + toGUID));
        }
        if (!this.localMember._guid().equals(toGUID)) {
            return;
        }
        MemberImpl member = null;
        String fromGUID = message.getFromGUID();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("receive welcome from:" + fromGUID));
        }
        if ((member = (MemberImpl)this.allMembers.get(fromGUID)) != null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("receive welcome direct accept:" + member));
            }
            this.sendAcceptedNoACK(message);
            return;
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("receive welcome send declare :" + fromGUID));
        }
        this.sendDeclare(message);
    }

    void sendWelcome(MemberMessage message) {
        if (this.m_zBrotherConfiged) {
            if (this.context.getState() != ClusterContext.State.RUNNING) {
                return;
            }
            String fromAddress = message.getSourceAddress().getHostAddress();
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(fromAddress);
                message.setTargetAddress(new AddressByUDP(inetAddress, this.context.getConfig().getUDPListenPort()));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        message.setMinorId(2);
        message.setToGUID(message.getFromGUID());
        message.setFromGUID(this.localMember._guid());
        message.setPublicKey(this.localMember.getPublicKey());
        message.setListenAddress(this.localMember.getUDPAddress());
        message.setListenPort(this.localMember.getUDPPort());
        this.context.send(message);
    }

    void receiveDeclare(MemberMessage message) {
        MemberImpl member = message.getDeclareMember();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("receive declare :" + member));
        }
        if (this.allMembers.containsKey(member._guid())) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("receive stale declare:" + member));
            }
            this.synQueue.remove(member._guid());
            return;
        }
        SYN syn = (SYN)this.synQueue.get(member._guid());
        if (syn == null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("receive invalid declare:" + member));
            }
            return;
        }
        member.setState(Member.State.SYN_RECV);
        member.setPulseTime(System.currentTimeMillis());
        this.freshmen.put(member._guid(), member);
        syn.times = System.currentTimeMillis();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("receive declare add to freshmen, need ack :" + member));
        }
        this.sendAcceptedNeedACK(message);
    }

    void sendDeclare(MemberMessage message) {
        message.setTargetAddress(message.getListenAddress());
        message.setTargetPort(message.getListenPort());
        message.setMinorId(3);
        message.setDeclareMember(this.localMember);
        this.context.send(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveAccepted(MemberMessage message) {
        MemberImpl member = message.getDeclareMember();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("receive accepted :" + member + ",ack:" + message.isNeedAcceptACK()));
        }
        if (this.allMembers.containsKey(member._guid())) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("receive stale accepted:" + member));
            }
            if (message.isNeedAcceptACK()) {
                this.sendAcceptACK(message);
            }
            return;
        }
        Map map = this.synQueue;
        synchronized (map) {
            member.setState(Member.State.NORMAL);
            member.setPulseTime(System.currentTimeMillis());
            this.freshmen.put(member._guid(), member);
            this.synQueue.remove(member._guid());
            this.threadMemberShip.runow();
        }
        if (message.isNeedAcceptACK()) {
            this.sendAcceptACK(message);
        }
    }

    void sendAcceptedNeedACK(MemberMessage message) {
        MemberImpl member = message.getDeclareMember();
        message.setTargetAddress(member.getUDPAddress());
        message.setTargetPort(member.getUDPPort());
        message.setMinorId(4);
        message.setDeclareMember(this.localMember);
        message.setNeedAcceptACK(true);
        this.context.send(message);
    }

    void sendAcceptedNoACK(MemberMessage message) {
        message.setTargetAddress(message.getListenAddress());
        message.setTargetPort(message.getListenPort());
        message.setMinorId(4);
        message.setDeclareMember(this.localMember);
        message.setNeedAcceptACK(false);
        this.context.send(message);
    }

    void receiveAcceptACK(MemberMessage message) {
        MemberImpl member;
        String fromGUID = message.getFromGUID();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("receive AcceptACK:" + fromGUID));
        }
        if ((member = (MemberImpl)this.freshmen.get(fromGUID)) != null && member.getState() == Member.State.SYN_RECV) {
            member.setState(Member.State.NORMAL);
            this.threadMemberShip.runow();
            return;
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("receive invalid AcceptACK:" + member));
        }
    }

    void sendAcceptACK(MemberMessage message) {
        message.setMinorId(5);
        message.setFromGUID(this.localMember._guid());
        this.context.send(message);
    }

    void receiveMemberLeft(MemberMessage message) {
        MemberImpl member;
        String fromGUID = message.getFromGUID();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("receive member left:" + fromGUID));
        }
        if ((member = (MemberImpl)this.allMembers.get(fromGUID)) != null) {
            member.setState(Member.State.LEFT);
            return;
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("receive member left:" + member));
        }
    }

    void sendMemberLeft() {
        MemberMessage message = new MemberMessage();
        message.setMinorId(6);
        message.setFromGUID(this.localMember._guid());
        this.context.send(message);
    }

    void sendMemberAttribute(String attributeName, Serializable attributeValue) {
        MemberMessage message = new MemberMessage();
        message.setMinorId(7);
        message.setFromGUID(this.localMember._guid());
        message.setAttributeName(attributeName);
        message.setAttributeValue(attributeValue);
        this.context.send(message);
    }

    void receiveMemberAttribute(MemberMessage message) {
        MemberImpl member;
        String fromGUID = message.getFromGUID();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("receive member atrribute:" + fromGUID));
        }
        if ((member = (MemberImpl)this.allMembers.get(fromGUID)) != null && !member.isLocal()) {
            member.setAttribute(message.getAttributeName(), message.getAttributeValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addListener(MemberListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.memberListenersMutex;
        synchronized (object) {
            MemberListener[] oldListeners = this.memberListeners;
            MemberListener[] newListeners = null;
            if (oldListeners == null || oldListeners.length <= 0) {
                newListeners = new MemberListener[]{listener};
                this.memberListeners = newListeners;
                return;
            }
            int oldLength = oldListeners.length;
            newListeners = new MemberListener[oldLength + 1];
            int oldIndex = 0;
            while (oldIndex < oldLength) {
                MemberListener tempListener = oldListeners[oldIndex];
                if (tempListener == listener) {
                    s_logger.warn((Object)("Duplicate MemberListener: " + listener));
                    return;
                }
                newListeners[oldIndex] = tempListener;
                ++oldIndex;
            }
            newListeners[oldLength] = listener;
            this.memberListeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MemberListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.memberListenersMutex;
        synchronized (object) {
            MemberListener[] oldListeners = this.memberListeners;
            MemberListener[] newListeners = null;
            if (oldListeners == null || oldListeners.length <= 0) {
                return;
            }
            int oldLength = oldListeners.length;
            if (oldLength > 1) {
                newListeners = new MemberListener[oldLength - 1];
            }
            int oldIndex = 0;
            int newIndex = 0;
            while (oldIndex < oldLength) {
                MemberListener tempListener;
                if ((tempListener = oldListeners[oldIndex++]) == listener) continue;
                newListeners[newIndex++] = tempListener;
            }
            if (oldIndex > newIndex) {
                this.memberListeners = newListeners;
            } else {
                s_logger.warn((Object)("MemberListener not exist: " + listener));
            }
        }
    }

    private void heartBeat() {
        this.sendHeartBeat();
    }

    private void dealQueue() {
        SYN syn;
        if (this.synQueue.size() <= 0) {
            return;
        }
        ArrayList<SYN> deadlist = new ArrayList<SYN>();
        long currentTime = System.currentTimeMillis();
        long endLifeTime = currentTime - 30000L;
        Iterator<Object> itr = this.synQueue.values().iterator();
        while (itr.hasNext()) {
            syn = (SYN)itr.next();
            if (syn == null || syn.times > endLifeTime) continue;
            deadlist.add(syn);
        }
        if (deadlist.size() > 0) {
            itr = deadlist.iterator();
            while (itr.hasNext()) {
                syn = (SYN)itr.next();
                if (syn == null) continue;
                this.synQueue.remove(syn.guid);
            }
        }
        deadlist.clear();
        deadlist = null;
    }

    private void dealFresh() {
        MemberImpl member;
        if (this.freshmen.size() <= 0) {
            return;
        }
        ArrayList<MemberImpl> todolist = new ArrayList<MemberImpl>();
        Iterator<Object> itr = this.freshmen.values().iterator();
        while (itr.hasNext()) {
            member = (MemberImpl)itr.next();
            if (member == null || member.isLocal() || member.getState() == Member.State.SYN_RECV) continue;
            todolist.add(member);
        }
        if (todolist.size() > 0) {
            itr = todolist.iterator();
            while (itr.hasNext()) {
                member = (MemberImpl)itr.next();
                if (member == null) continue;
                member.prepareTransport();
                if (this.addMember(member)) {
                    this.fireMemberJoined(member);
                }
                this.freshmen.remove(member._guid());
            }
        }
        todolist.clear();
        todolist = null;
    }

    private void checkDead() {
        MemberImpl member;
        MemberImpl[] loopMembers = this.listMembers;
        if (loopMembers == null || loopMembers.length <= 0) {
            return;
        }
        ArrayList<MemberImpl> deadlist = new ArrayList<MemberImpl>();
        long tCurrent = System.currentTimeMillis();
        int i = loopMembers.length - 1;
        while (i >= 0) {
            member = loopMembers[i];
            if (member != null && !member.isLocal()) {
                if (member.getState() == Member.State.LEFT) {
                    deadlist.add(member);
                } else {
                    long times = tCurrent - member.getPulseTime();
                    if (times > (long)this.heartbeatTimeout) {
                        member.setState(Member.State.FAILED);
                        deadlist.add(member);
                    } else if (times > (long)this.heartbeatSuspect) {
                        if (member.getState() == Member.State.NORMAL) {
                            member.setState(Member.State.SUSPECT);
                            this.sendAreYouOK(member);
                            s_logger.warn((Object)("Member suspect: " + member));
                        }
                    } else if (member.getState() == Member.State.SUSPECT) {
                        member.setState(Member.State.NORMAL);
                        s_logger.info((Object)("Member normal: " + member));
                    }
                }
            }
            --i;
        }
        if (deadlist.size() > 0) {
            Iterator itr = deadlist.iterator();
            while (itr.hasNext()) {
                member = (MemberImpl)itr.next();
                if (member == null || member.isLocal()) continue;
                if (!this.removeMember(member)) {
                    return;
                }
                if (member.getState() == Member.State.LEFT) {
                    this.fireMemberLeft(member);
                    continue;
                }
                if (member.getState() != Member.State.FAILED) continue;
                this.fireMemberFailed(member);
            }
        }
        deadlist.clear();
        deadlist = null;
    }

    void sendAreYouOK(Member member) {
        MemberMessage message = new MemberMessage();
        message.setMinorId(8);
        message.setFromGUID(this.localMember._guid());
        this.context.send((ClusterMessage)message, member);
    }

    void receiveAreYouOK(Member sender) {
        s_logger.info((Object)("Receive Are You OK from: " + sender));
        this.sendHeartBeat(sender);
    }

    private final boolean addMember(MemberImpl member) {
        if (this.allMembers.containsKey(member._guid())) {
            s_logger.fatal((Object)("Member already in list, member:" + member));
            return false;
        }
        this.allMembers.put(member._guid(), member);
        if (member.isLocal()) {
            return false;
        }
        MemberImpl[] oldArray = this.listMembers;
        int odLength = oldArray != null ? oldArray.length : 0;
        MemberImpl[] newArray = new MemberImpl[odLength + 1];
        if (odLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, odLength);
        }
        newArray[odLength] = member;
        this.listMembers = newArray;
        return true;
    }

    private final boolean removeMember(MemberImpl member) {
        int oldLength;
        if (!this.allMembers.containsKey(member._guid())) {
            s_logger.fatal((Object)("Member not in list, member:" + member));
            return false;
        }
        this.allMembers.remove(member._guid());
        if (member.isLocal()) {
            return false;
        }
        MemberImpl[] oldArray = this.listMembers;
        int n = oldLength = oldArray != null ? oldArray.length : 0;
        if (oldLength <= 1) {
            this.listMembers = null;
            return true;
        }
        MemberImpl[] newArray = new MemberImpl[oldLength - 1];
        int oldIndex = 0;
        int newIndex = 0;
        while (oldIndex < oldLength) {
            MemberImpl oldMember = oldArray[oldIndex];
            if (!oldMember._guid().equals(member._guid())) {
                newArray[newIndex++] = oldMember;
            }
            ++oldIndex;
        }
        this.listMembers = newArray;
        return true;
    }

    protected void fireMemberFailed(Member member) {
        s_logger.info((Object)("Member failed: " + member));
        MemberListener[] listeners = this.memberListeners;
        if (listeners == null || listeners.length <= 0) {
            return;
        }
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            MemberListener listener = listeners[i];
            if (listener != null) {
                try {
                    listener.memberFailed(member);
                }
                catch (Throwable e) {
                    s_logger.error((Object)"Error on memberFailed", e);
                }
            }
            ++i;
        }
    }

    protected void fireMemberJoined(Member member) {
        s_logger.info((Object)("Member joined: " + member));
        MemberListener[] listeners = this.memberListeners;
        if (listeners == null || listeners.length <= 0) {
            return;
        }
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            MemberListener listener = listeners[i];
            if (listener != null) {
                try {
                    listener.memberJoined(member);
                }
                catch (Throwable e) {
                    s_logger.error((Object)"Error on memberJoined", e);
                }
            }
            ++i;
        }
    }

    protected void fireMemberLeft(Member member) {
        s_logger.info((Object)("Member left: " + member));
        MemberListener[] listeners = this.memberListeners;
        if (listeners == null || listeners.length <= 0) {
            return;
        }
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            MemberListener listener = listeners[i];
            if (listener != null) {
                try {
                    listener.memberLeft(member);
                }
                catch (Throwable e) {
                    s_logger.error((Object)"Error on memberLeft", e);
                }
            }
            ++i;
        }
    }

    public final MemberImpl memberArrive(String guid) {
        MemberImpl member = null;
        member = (MemberImpl)this.allMembers.get(guid);
        if (member != null) {
            member.prepareTransport();
            return member;
        }
        member = (MemberImpl)this.freshmen.get(guid);
        if (member != null) {
            member.prepareTransport();
            if (member.getState() == Member.State.SYN_RECV) {
                member.setState(Member.State.NORMAL);
            }
            this.threadMemberShip.runow();
            return member;
        }
        return null;
    }

    public final MemberImpl[] membersArray() {
        return this.listMembers;
    }

    public boolean hasMember() {
        return this.listMembers != null && this.listMembers.length >= 1;
    }

    public Iterator members() {
        return new Iterator(){
            Iterator itr;
            {
                this.itr = MemberManagerImpl.this.allMembers.values().iterator();
            }

            public void remove() {
            }

            public Object next() {
                return this.itr.next();
            }

            public boolean hasNext() {
                return this.itr.hasNext();
            }
        };
    }

    public Member member() {
        return this.localMember;
    }

    public int count() {
        return this.allMembers.size();
    }

    public Member find(String name) {
        return (Member)this.allMembers.get(name);
    }

    public Member find(Member member) {
        return this.find(member._guid());
    }

    public final int getHeartbeatSuspect() {
        return this.heartbeatSuspect;
    }

    public final void setHeartbeatSuspect(int heartbeatSuspect) {
        if (heartbeatSuspect > 0) {
            this.heartbeatSuspect = heartbeatSuspect * 500;
        }
    }

    public final int getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public final void setHeartbeatTimeout(int heartbeatTimeout) {
        if (heartbeatTimeout > 0) {
            this.heartbeatTimeout = heartbeatTimeout * 500;
        }
    }

    private class HeartBeat
    extends DaemonThreadBase {
        public HeartBeat() {
            super("MemberManagerImpl$HeartBeat");
        }

        public void loop() {
            try {
                MemberManagerImpl.this.heartBeat();
            }
            catch (Throwable e) {
                s_logger.error((Object)"Unexpected exception", e);
            }
        }

        protected int getCycle() {
            return 500;
        }
    }

    private class LocalMemberImpl
    extends MemberImpl {
        private LocalMemberImpl() {
        }

        public void setAttribute(String name, Object value) {
            super.setAttribute(name, value);
            if (value instanceof Serializable) {
                MemberManagerImpl.this.sendMemberAttribute(name, (Serializable)value);
            }
        }
    }

    private class MemberShip
    extends DaemonThreadBase {
        public MemberShip() {
            super("MemberManagerImpl$MemberShip");
        }

        public void loop() {
            try {
                MemberManagerImpl.this.dealFresh();
            }
            catch (Throwable e) {
                s_logger.error((Object)"Unexpected exception", e);
            }
            try {
                MemberManagerImpl.this.checkDead();
            }
            catch (Throwable e) {
                s_logger.error((Object)"Unexpected exception", e);
            }
            try {
                MemberManagerImpl.this.dealQueue();
            }
            catch (Throwable e) {
                s_logger.error((Object)"Unexpected exception", e);
            }
        }

        protected int getCycle() {
            return 500;
        }
    }

    private class SYN {
        private String guid;
        private long times;

        private SYN() {
        }
    }
}

