/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.access;

import java.lang.reflect.InvocationTargetException;
import javax.ejb.CreateException;
import javax.ejb.EJBLocalObject;
import javax.naming.NamingException;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.ejb.access.AbstractSlsbInvokerInterceptor;

public class LocalSlsbInvokerInterceptor
extends AbstractSlsbInvokerInterceptor {
    protected EJBLocalObject newSessionBeanInstance() throws NamingException, InvocationTargetException {
        Object ejbInstance;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Trying to create reference to local EJB");
        }
        if (!((ejbInstance = this.create()) instanceof EJBLocalObject)) {
            throw new AspectException("EJB instance [" + ejbInstance + "] is not a local SLSB");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Obtained reference to local EJB: " + ejbInstance));
        }
        return (EJBLocalObject)ejbInstance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        EJBLocalObject ejb = null;
        try {
            try {
                ejb = this.newSessionBeanInstance();
                object = invocation.getMethod().invoke((Object)ejb, invocation.getArguments());
                Object var6_6 = null;
                if (ejb == null) return object;
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Method of local EJB [" + this.getJndiName() + "] threw exception"), targetException);
                }
                if (!(targetException instanceof CreateException)) throw targetException;
                throw new AspectException("Could not create local EJB [" + this.getJndiName() + "]", targetException);
            }
            catch (Throwable ex) {
                throw new AspectException("Failed to invoke local EJB [" + this.getJndiName() + "]", ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (ejb == null) throw throwable;
            try {
                ejb.remove();
                throw throwable;
            }
            catch (Throwable ex) {
                this.logger.warn((Object)"Could not invoke 'remove' on local EJB proxy", ex);
                throw throwable;
            }
        }
        try {}
        catch (Throwable ex) {
            this.logger.warn((Object)"Could not invoke 'remove' on local EJB proxy", ex);
            return object;
        }
        ejb.remove();
        return object;
    }
}

