/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.xml.parsers.SAXParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ejb.DescriptorHandler;
import org.apache.tools.ant.taskdefs.optional.ejb.EJBDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.InnerClassFilenameFilter;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GenericDeploymentTool
implements EJBDeploymentTool {
    protected static final String META_DIR = "META-INF/";
    protected static final String EJB_DD = "ejb-jar.xml";
    private File srcDir;
    private File descriptorDir;
    private File destDir;
    private String baseJarName;
    private boolean flatDestDir = false;
    private String baseNameTerminator = "-";
    private String genericJarSuffix = "-generic.jar";
    private Task task;

    protected void addFileToJar(JarOutputStream jStream, FileInputStream iStream, String filename) throws BuildException {
        try {
            ZipEntry zipEntry = new ZipEntry(filename);
            jStream.putNextEntry(zipEntry);
            byte[] byteBuffer = new byte[2048];
            int count = 0;
            do {
                jStream.write(byteBuffer, 0, count);
            } while ((count = iStream.read(byteBuffer, 0, byteBuffer.length)) != -1);
            iStream.close();
        }
        catch (IOException ioe) {
            String msg = "IOException while adding entry " + filename + "to jarfile." + ioe.getMessage();
            throw new BuildException(msg, ioe);
        }
    }

    protected void addVendorFiles(Hashtable ejbFiles, String baseName) {
    }

    public void configure(File srcDir, File descriptorDir, String baseNameTerminator, String baseJarName, boolean flatDestDir) {
        this.srcDir = srcDir;
        this.descriptorDir = descriptorDir;
        this.baseJarName = baseJarName;
        this.baseNameTerminator = baseNameTerminator;
        this.flatDestDir = flatDestDir;
    }

    protected String getBaseJarName() {
        return this.baseJarName;
    }

    protected String getBaseNameTerminator() {
        return this.baseNameTerminator;
    }

    protected File getDescriptorDir() {
        return this.descriptorDir;
    }

    protected DescriptorHandler getDescriptorHandler(File srcDir) {
        return new DescriptorHandler(srcDir);
    }

    protected File getDestDir() {
        return this.destDir;
    }

    protected File getSrcDir() {
        return this.srcDir;
    }

    protected Task getTask() {
        return this.task;
    }

    File getVendorOutputJarFile(String baseName) {
        return new File(this.destDir, String.valueOf(baseName) + this.genericJarSuffix);
    }

    public void processDescriptor(String descriptorFileName, SAXParser saxParser) {
        try {
            DescriptorHandler handler = this.getDescriptorHandler(this.srcDir);
            saxParser.parse(new InputSource(new FileInputStream(new File(this.getDescriptorDir(), descriptorFileName))), (HandlerBase)handler);
            Hashtable ejbFiles = handler.getFiles();
            String baseName = "";
            if (this.baseJarName != null) {
                baseName = this.baseJarName;
            } else {
                int lastSeparatorIndex = descriptorFileName.lastIndexOf(File.separator);
                int endBaseName = -1;
                endBaseName = lastSeparatorIndex != -1 ? descriptorFileName.indexOf(this.baseNameTerminator, lastSeparatorIndex) : descriptorFileName.indexOf(this.baseNameTerminator);
                if (endBaseName != -1) {
                    baseName = descriptorFileName.substring(0, endBaseName);
                }
                baseName = descriptorFileName.substring(0, endBaseName);
            }
            ejbFiles.put("META-INF/ejb-jar.xml", new File(this.getDescriptorDir(), descriptorFileName));
            this.addVendorFiles(ejbFiles, baseName);
            if (this.flatDestDir && baseName.length() != 0) {
                int startName = baseName.lastIndexOf(File.separator);
                if (startName == -1) {
                    startName = 0;
                }
                int endName = baseName.length();
                baseName = baseName.substring(startName, endName);
            }
            File jarFile = this.getVendorOutputJarFile(baseName);
            boolean needBuild = true;
            if (jarFile.exists()) {
                long lastBuild = jarFile.lastModified();
                Iterator fileIter = ejbFiles.values().iterator();
                needBuild = false;
                while (!needBuild && fileIter.hasNext()) {
                    File currentFile = (File)fileIter.next();
                    boolean bl = needBuild = lastBuild < currentFile.lastModified();
                }
            }
            if (needBuild) {
                this.getTask().log("building " + jarFile.getName() + " with " + String.valueOf(ejbFiles.size()) + " files", 2);
                this.writeJar(baseName, jarFile, ejbFiles);
            } else {
                this.getTask().log(String.valueOf(jarFile.toString()) + " is up to date.", 2);
            }
        }
        catch (SAXException se) {
            String msg = "SAXException while parsing '" + descriptorFileName.toString() + "'. This probably indicates badly-formed XML." + "  Details: " + se.getMessage();
            throw new BuildException(msg, se);
        }
        catch (IOException ioe) {
            String msg = "IOException while parsing'" + descriptorFileName.toString() + "'.  This probably indicates that the descriptor" + " doesn't exist. Details: " + ioe.getMessage();
            throw new BuildException(msg, ioe);
        }
    }

    public void setDestdir(File inDir) {
        this.destDir = inDir;
    }

    public void setGenericJarSuffix(String inString) {
        this.genericJarSuffix = inString;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    protected boolean usingBaseJarName() {
        return this.baseJarName != null;
    }

    public void validateConfigured() throws BuildException {
        if (this.destDir == null) {
            throw new BuildException("The destdir attribute must be specified");
        }
    }

    protected void writeJar(String baseName, File jarfile, Hashtable files) throws BuildException {
        JarOutputStream jarStream = null;
        Iterator entryIterator = null;
        String entryName = null;
        File entryFile = null;
        File entryDir = null;
        String[] innerfiles = null;
        try {
            if (jarfile.exists()) {
                jarfile.delete();
            }
            jarfile.getParentFile().mkdirs();
            jarfile.createNewFile();
            jarStream = new JarOutputStream(new FileOutputStream(jarfile));
            jarStream.setMethod(8);
            entryIterator = files.keySet().iterator();
            while (entryIterator.hasNext()) {
                entryName = (String)entryIterator.next();
                entryFile = (File)files.get(entryName);
                this.getTask().log("adding file '" + entryName + "'", 3);
                this.addFileToJar(jarStream, new FileInputStream(entryFile), entryName);
                InnerClassFilenameFilter flt = new InnerClassFilenameFilter(entryFile.getName());
                entryDir = entryFile.getParentFile();
                innerfiles = entryDir.list(flt);
                int i = 0;
                int n = innerfiles.length;
                while (i < n) {
                    entryName = String.valueOf(entryName.substring(0, entryName.lastIndexOf(entryFile.getName()) - 1)) + File.separatorChar + innerfiles[i];
                    entryFile = new File(this.srcDir, entryName);
                    this.getTask().log("adding innerclass file '" + entryName + "'", 3);
                    this.addFileToJar(jarStream, new FileInputStream(entryFile), entryName);
                    ++i;
                }
            }
            jarStream.close();
        }
        catch (IOException ioe) {
            String msg = "IOException while processing ejb-jar file '" + jarfile.toString() + "'. Details: " + ioe.getMessage();
            throw new BuildException(msg, ioe);
        }
    }
}

