/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.nio;

import com.rabbitmq.client.impl.nio.NioHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ByteBufferInputStream
extends InputStream {
    private final ReadableByteChannel channel;
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ReadableByteChannel channel, ByteBuffer buffer) {
        this.channel = channel;
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException {
        ByteBufferInputStream.readFromNetworkIfNecessary(this.channel, this.buffer);
        return this.readFromBuffer(this.buffer);
    }

    private int readFromBuffer(ByteBuffer buffer) {
        return buffer.get() & 0xFF;
    }

    private static void readFromNetworkIfNecessary(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        if (!buffer.hasRemaining()) {
            buffer.clear();
            int read = NioHelper.read(channel, buffer);
            if (read <= 0) {
                NioHelper.retryRead(channel, buffer);
            }
            buffer.flip();
        }
    }
}

