/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;

public class DeleteBucketTest
extends TestBase {
    @Test
    public void testDeleteExistingBucket() {
        String bucketName = "delete-existing-bucket";
        try {
            secondClient.createBucket("delete-existing-bucket");
            secondClient.deleteBucket("delete-existing-bucket");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeleteNonexistentBucket() {
        String bucketName = "delete-nonexistent-bucket";
        try {
            secondClient.deleteBucket("delete-nonexistent-bucket");
            Assert.fail((String)"Delete bucket should not be successful.");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
    }

    @Test
    public void testDeleteNonemptyBucket() {
        String bucketName = "delete-nonempty-bucket";
        String key = "delete-nonempty-bucket-key";
        try {
            try {
                secondClient.createBucket("delete-nonempty-bucket");
                ArrayList<String> keys = new ArrayList<String>();
                keys.add("delete-nonempty-bucket-key");
                if (!TestUtils.batchPutObject(secondClient, "delete-nonempty-bucket", keys)) {
                    Assert.fail((String)"batch put object failed");
                }
                secondClient.deleteBucket("delete-nonempty-bucket");
                Assert.fail((String)"Delete bucket should not be successful.");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"BucketNotEmpty", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("The bucket you tried to delete is not empty."));
                DeleteBucketTest.deleteBucketWithObjects(secondClient, "delete-nonempty-bucket");
            }
        }
        finally {
            DeleteBucketTest.deleteBucketWithObjects(secondClient, "delete-nonempty-bucket");
        }
    }

    @Test
    public void testDeleteBucketWithoutOwnership() {
        String bucketWithoutOwnership = "oss";
        try {
            secondClient.deleteBucket("oss");
            Assert.fail((String)"Delete bucket should not be successful.");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
        }
    }
}

