/*
 * Decompiled with CFR 0.152.
 */
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ListPartsRequest;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.PartSummary;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class MultipartUploadSample {
    private static String endpoint = "*** Provide OSS endpoint ***";
    private static String accessKeyId = "*** Provide your AccessKeyId ***";
    private static String accessKeySecret = "*** Provide your AccessKeySecret ***";
    private static OSSClient client = null;
    private static String bucketName = "*** Provide bucket name ***";
    private static String key = "*** Provide key ***";
    private static String localFilePath = "*** Provide local file path ***";
    private static ExecutorService executorService = Executors.newFixedThreadPool(5);
    private static List<PartETag> partETags = Collections.synchronizedList(new ArrayList());

    public static void main(String[] args) throws IOException {
        client = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            try {
                String uploadId = MultipartUploadSample.claimUploadId();
                System.out.println("Claiming a new upload id " + uploadId + "\n");
                long partSize = 0x500000L;
                File sampleFile = MultipartUploadSample.createSampleFile();
                long fileLength = sampleFile.length();
                int partCount = (int)(fileLength / 0x500000L);
                if (fileLength % 0x500000L != 0L) {
                    ++partCount;
                }
                if (partCount > 10000) {
                    throw new RuntimeException("Total parts count should not exceed 10000");
                }
                System.out.println("Total parts count " + partCount + "\n");
                System.out.println("Begin to upload multiparts to OSS from a file\n");
                int i = 0;
                while (i < partCount) {
                    long startPos = (long)i * 0x500000L;
                    long curPartSize = i + 1 == partCount ? fileLength - startPos : 0x500000L;
                    executorService.execute(new PartUploader(sampleFile, startPos, curPartSize, i + 1, uploadId));
                    ++i;
                }
                executorService.shutdown();
                while (!executorService.isTerminated()) {
                    try {
                        executorService.awaitTermination(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (partETags.size() != partCount) {
                    throw new IllegalStateException("Upload multiparts fail due to some parts are not finished yet");
                }
                System.out.println("Succeed to complete multiparts into an object named " + key + "\n");
                MultipartUploadSample.listAllParts(uploadId);
                MultipartUploadSample.completeMultipartUpload(uploadId);
                System.out.println("Fetching an object");
                client.getObject(new GetObjectRequest(bucketName, key), new File(localFilePath));
            }
            catch (OSSException oe) {
                System.out.println("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
                System.out.println("Error Message: " + oe.getErrorCode());
                System.out.println("Error Code:       " + oe.getErrorCode());
                System.out.println("Request ID:      " + oe.getRequestId());
                System.out.println("Host ID:           " + oe.getHostId());
                if (client != null) {
                    client.shutdown();
                }
            }
            catch (ClientException ce) {
                System.out.println("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
                System.out.println("Error Message: " + ce.getMessage());
                if (client != null) {
                    client.shutdown();
                }
            }
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    private static File createSampleFile() throws IOException {
        File file = File.createTempFile("oss-java-sdk-", ".txt");
        file.deleteOnExit();
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
        int i = 0;
        while (i < 1000000) {
            writer.write("abcdefghijklmnopqrstuvwxyz\n");
            writer.write("0123456789011234567890\n");
            ++i;
        }
        ((Writer)writer).close();
        return file;
    }

    private static String claimUploadId() {
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucketName, key);
        InitiateMultipartUploadResult result = client.initiateMultipartUpload(request);
        return result.getUploadId();
    }

    private static void completeMultipartUpload(String uploadId) {
        Collections.sort(partETags, new Comparator<PartETag>(){

            @Override
            public int compare(PartETag p1, PartETag p2) {
                return p1.getPartNumber() - p2.getPartNumber();
            }
        });
        System.out.println("Completing to upload multiparts\n");
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, key, uploadId, partETags);
        client.completeMultipartUpload(completeMultipartUploadRequest);
    }

    private static void listAllParts(String uploadId) {
        System.out.println("Listing all parts......");
        ListPartsRequest listPartsRequest = new ListPartsRequest(bucketName, key, uploadId);
        PartListing partListing = client.listParts(listPartsRequest);
        int partCount = partListing.getParts().size();
        int i = 0;
        while (i < partCount) {
            PartSummary partSummary = partListing.getParts().get(i);
            System.out.println("\tPart#" + partSummary.getPartNumber() + ", ETag=" + partSummary.getETag());
            ++i;
        }
        System.out.println();
    }

    private static class PartUploader
    implements Runnable {
        private File localFile;
        private long startPos;
        private long partSize;
        private int partNumber;
        private String uploadId;

        public PartUploader(File localFile, long startPos, long partSize, int partNumber, String uploadId) {
            this.localFile = localFile;
            this.startPos = startPos;
            this.partSize = partSize;
            this.partNumber = partNumber;
            this.uploadId = uploadId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                FileInputStream instream = null;
                try {
                    try {
                        instream = new FileInputStream(this.localFile);
                        ((InputStream)instream).skip(this.startPos);
                        UploadPartRequest uploadPartRequest = new UploadPartRequest();
                        uploadPartRequest.setBucketName(bucketName);
                        uploadPartRequest.setKey(key);
                        uploadPartRequest.setUploadId(this.uploadId);
                        uploadPartRequest.setInputStream(instream);
                        uploadPartRequest.setPartSize(this.partSize);
                        uploadPartRequest.setPartNumber(this.partNumber);
                        UploadPartResult uploadPartResult = client.uploadPart(uploadPartRequest);
                        System.out.println("Part#" + this.partNumber + " done\n");
                        List list = partETags;
                        synchronized (list) {
                            partETags.add(uploadPartResult.getPartETag());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (instream == null) break block15;
                        try {
                            ((InputStream)instream).close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    if (instream != null) {
                        try {
                            ((InputStream)instream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

