/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import java.net.URLDecoder;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;

public class ListObjectsTest
extends TestBase {
    private static final int DEFAULT_MAX_RETURNED_KEYS = 100;
    private static final int MAX_RETURNED_KEYS_LIMIT = 1000;

    @Test
    public void testNormalListObjects() {
        String bucketName = "normal-list-objects";
        try {
            try {
                secondClient.createBucket("normal-list-objects");
                ObjectListing objectListing = secondClient.listObjects("normal-list-objects");
                Assert.assertEquals((int)0, (int)objectListing.getObjectSummaries().size());
                Assert.assertEquals((int)100, (int)objectListing.getMaxKeys());
                Assert.assertEquals((int)0, (int)objectListing.getCommonPrefixes().size());
                Assert.assertEquals((String)"normal-list-objects", (String)objectListing.getBucketName());
                Assert.assertNull((Object)objectListing.getDelimiter());
                Assert.assertNull((Object)objectListing.getPrefix());
                Assert.assertNull((Object)objectListing.getMarker());
                Assert.assertNull((Object)objectListing.getNextMarker());
                Assert.assertFalse((boolean)objectListing.isTruncated());
                ArrayList<String> existingKeys = new ArrayList<String>();
                int lv1KeyCount = 102;
                int lv2KeyCount = 11;
                int keyCount = 1012;
                String lv0KeyPrefix = "normal-list-lv0-objects-";
                String lv1KeyPrefix = "normal-list-lv0-objects/lv1-objects-";
                String lv2KeyPrefix = "normal-list-lv0-objects/lv1-objects/lv2-objects-";
                int i = 0;
                while (i < 1012) {
                    if (i % 10 != 0) {
                        existingKeys.add("normal-list-lv0-objects-" + i);
                    } else {
                        existingKeys.add("normal-list-lv0-objects/lv1-objects-" + i);
                        if (i % 100 == 0) {
                            existingKeys.add("normal-list-lv0-objects/lv1-objects/lv2-objects-" + i);
                        }
                    }
                    ++i;
                }
                if (!TestUtils.batchPutObject(secondClient, "normal-list-objects", existingKeys)) {
                    Assert.fail((String)"batch put object failed");
                }
                objectListing = secondClient.listObjects("normal-list-objects");
                Assert.assertEquals((int)100, (int)objectListing.getObjectSummaries().size());
                Assert.assertEquals((int)100, (int)objectListing.getMaxKeys());
                Assert.assertEquals((int)0, (int)objectListing.getCommonPrefixes().size());
                Assert.assertEquals((String)"normal-list-objects", (String)objectListing.getBucketName());
                Assert.assertNull((Object)objectListing.getDelimiter());
                Assert.assertNull((Object)objectListing.getPrefix());
                Assert.assertNull((Object)objectListing.getMarker());
                Assert.assertNotNull((Object)objectListing.getNextMarker());
                Assert.assertTrue((boolean)objectListing.isTruncated());
                objectListing = secondClient.listObjects("normal-list-objects", "normal-list-lv0-objects/lv1-objects-");
                Assert.assertEquals((int)100, (int)objectListing.getObjectSummaries().size());
                Assert.assertEquals((int)100, (int)objectListing.getMaxKeys());
                Assert.assertEquals((int)0, (int)objectListing.getCommonPrefixes().size());
                Assert.assertEquals((String)"normal-list-objects", (String)objectListing.getBucketName());
                Assert.assertNull((Object)objectListing.getDelimiter());
                Assert.assertEquals((String)"normal-list-lv0-objects/lv1-objects-", (String)objectListing.getPrefix());
                Assert.assertNull((Object)objectListing.getMarker());
                Assert.assertNotNull((Object)objectListing.getNextMarker());
                Assert.assertTrue((boolean)objectListing.isTruncated());
                objectListing = secondClient.listObjects("normal-list-objects", "normal-list-lv0-objects-");
                Assert.assertEquals((int)100, (int)objectListing.getObjectSummaries().size());
                Assert.assertEquals((int)100, (int)objectListing.getMaxKeys());
                Assert.assertEquals((int)0, (int)objectListing.getCommonPrefixes().size());
                Assert.assertEquals((String)"normal-list-objects", (String)objectListing.getBucketName());
                Assert.assertNull((Object)objectListing.getDelimiter());
                Assert.assertEquals((String)"normal-list-lv0-objects-", (String)objectListing.getPrefix());
                Assert.assertNull((Object)objectListing.getMarker());
                Assert.assertNotNull((Object)objectListing.getNextMarker());
                Assert.assertTrue((boolean)objectListing.isTruncated());
                String marker = objectListing.getNextMarker();
                objectListing = secondClient.listObjects(new ListObjectsRequest("normal-list-objects", "normal-list-lv0-objects-", marker, null, null));
                Assert.assertEquals((int)100, (int)objectListing.getObjectSummaries().size());
                Assert.assertEquals((int)100, (int)objectListing.getMaxKeys());
                Assert.assertEquals((int)0, (int)objectListing.getCommonPrefixes().size());
                Assert.assertEquals((String)"normal-list-objects", (String)objectListing.getBucketName());
                Assert.assertNull((Object)objectListing.getDelimiter());
                Assert.assertEquals((String)"normal-list-lv0-objects-", (String)objectListing.getPrefix());
                Assert.assertEquals((String)marker, (String)objectListing.getMarker());
                Assert.assertNotNull((Object)objectListing.getNextMarker());
                Assert.assertTrue((boolean)objectListing.isTruncated());
                String delimiter = "/";
                String keyPrefix0 = "normal-list-lv0-objects/";
                String keyPrefix1 = "normal-list-lv0-objects/lv1-objects/";
                objectListing = secondClient.listObjects(new ListObjectsRequest("normal-list-objects", "normal-list-lv0-objects/", null, "/", 1000));
                Assert.assertEquals((int)102, (int)objectListing.getObjectSummaries().size());
                Assert.assertEquals((int)1000, (int)objectListing.getMaxKeys());
                Assert.assertEquals((int)1, (int)objectListing.getCommonPrefixes().size());
                Assert.assertEquals((String)"normal-list-lv0-objects/lv1-objects/", (String)objectListing.getCommonPrefixes().get(0));
                Assert.assertEquals((String)"normal-list-objects", (String)objectListing.getBucketName());
                Assert.assertEquals((String)"/", (String)objectListing.getDelimiter());
                Assert.assertEquals((String)"normal-list-lv0-objects/", (String)objectListing.getPrefix());
                Assert.assertNull((Object)objectListing.getMarker());
                Assert.assertNull((Object)objectListing.getNextMarker());
                Assert.assertFalse((boolean)objectListing.isTruncated());
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                ListObjectsTest.deleteBucketWithObjects(secondClient, "normal-list-objects");
            }
        }
        finally {
            ListObjectsTest.deleteBucketWithObjects(secondClient, "normal-list-objects");
        }
    }

    @Test
    public void testUnormalListObjects() {
        String bucketName = "unormal-list-objects";
        try {
            try {
                secondClient.createBucket("unormal-list-objects");
                String nonexistentBucket = "unormal-list-objects-bucket";
                try {
                    secondClient.listObjects("unormal-list-objects-bucket");
                    Assert.fail((String)"List objects should not be successful");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
                }
                String bucketWithoutOwnership = "oss";
                try {
                    secondClient.listObjects("oss");
                    Assert.fail((String)"List objects should not be successful");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
                }
                ArrayList<String> existingKeys = new ArrayList<String>();
                int keyCount = 100;
                String keyPrefix = "unormal-list-objects-";
                int unluckyNumber = 13;
                int i = 0;
                while (i <= 100) {
                    if (i != 13) {
                        existingKeys.add("unormal-list-objects-" + i);
                    }
                    ++i;
                }
                if (!TestUtils.batchPutObject(secondClient, "unormal-list-objects", existingKeys)) {
                    Assert.fail((String)"batch put object failed");
                }
                String nonexistentMarker = "unormal-list-objects-13";
                try {
                    ListObjectsRequest request = new ListObjectsRequest("unormal-list-objects", null, "unormal-list-objects-13", null, null);
                    ObjectListing objectListing = secondClient.listObjects(request);
                    Assert.assertTrue((objectListing.getObjectSummaries().size() < 100 ? 1 : 0) != 0);
                    Assert.assertEquals((int)100, (int)objectListing.getMaxKeys());
                    Assert.assertEquals((int)0, (int)objectListing.getCommonPrefixes().size());
                    Assert.assertEquals((String)"unormal-list-objects", (String)objectListing.getBucketName());
                    Assert.assertNull((Object)objectListing.getDelimiter());
                    Assert.assertNull((Object)objectListing.getPrefix());
                    Assert.assertEquals((String)"unormal-list-objects-13", (String)objectListing.getMarker());
                    Assert.assertNull((Object)objectListing.getNextMarker());
                    Assert.assertFalse((boolean)objectListing.isTruncated());
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                int maxKeysExceedLowerLimit = -1;
                try {
                    ListObjectsRequest request = new ListObjectsRequest("unormal-list-objects");
                    request.setMaxKeys(-1);
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                }
                int maxKeysExceedUpperLimit = 1001;
                try {
                    ListObjectsRequest request = new ListObjectsRequest("unormal-list-objects");
                    request.setMaxKeys(1001);
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                ListObjectsTest.deleteBucketWithObjects(secondClient, "unormal-list-objects");
            }
        }
        finally {
            ListObjectsTest.deleteBucketWithObjects(secondClient, "unormal-list-objects");
        }
    }

    @Test
    public void testListObjectsWithEncodingType() {
        String objectPrefix = "object-with-special-characters-";
        try {
            ArrayList<String> existingKeys = new ArrayList<String>();
            existingKeys.add("object-with-special-characters-\u0001\u0007");
            existingKeys.add("object-with-special-characters-\u0002\u0007");
            if (!TestUtils.batchPutObject(secondClient, bucketName, existingKeys)) {
                Assert.fail((String)"batch put object failed");
            }
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
            try {
                secondClient.listObjects(listObjectsRequest);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof OSSException));
                Assert.assertEquals((String)"InvalidResponse", (String)((OSSException)e).getErrorCode());
            }
            listObjectsRequest = new ListObjectsRequest(bucketName);
            listObjectsRequest.setEncodingType("url");
            ObjectListing objectListing = secondClient.listObjects(listObjectsRequest);
            for (OSSObjectSummary s : objectListing.getObjectSummaries()) {
                String decodedKey = URLDecoder.decode(s.getKey(), "UTF-8");
                Assert.assertTrue((boolean)existingKeys.contains(decodedKey));
            }
            Assert.assertEquals((String)"url", (String)objectListing.getEncodingType());
            Assert.assertEquals((int)existingKeys.size(), (int)objectListing.getObjectSummaries().size());
            Assert.assertEquals((int)100, (int)objectListing.getMaxKeys());
            Assert.assertEquals((int)0, (int)objectListing.getCommonPrefixes().size());
            Assert.assertEquals((String)bucketName, (String)objectListing.getBucketName());
            Assert.assertNull((Object)objectListing.getDelimiter());
            Assert.assertNull((Object)objectListing.getPrefix());
            Assert.assertNull((Object)objectListing.getMarker());
            Assert.assertNull((Object)objectListing.getNextMarker());
            Assert.assertFalse((boolean)objectListing.isTruncated());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

