/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.SetBucketLifecycleRequest;
import java.text.ParseException;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class BucketLifecycleTest
extends TestBase {
    @Test
    public void testNormalSetBucketLifecycle() throws ParseException {
        String bucketName = "normal-set-bucket-lifecycle";
        String ruleId0 = "delete obsoleted files";
        String matchPrefix0 = "obsoleted/";
        String ruleId1 = "delete temporary files";
        String matchPrefix1 = "temporary/";
        try {
            try {
                secondClient.createBucket("normal-set-bucket-lifecycle");
                SetBucketLifecycleRequest request = new SetBucketLifecycleRequest("normal-set-bucket-lifecycle");
                request.AddLifecycleRule(new LifecycleRule("delete obsoleted files", "obsoleted/", LifecycleRule.RuleStatus.Enabled, 3));
                request.AddLifecycleRule(new LifecycleRule("delete temporary files", "temporary/", LifecycleRule.RuleStatus.Enabled, DateUtil.parseIso8601Date("2022-10-12T00:00:00.000Z")));
                secondClient.setBucketLifecycle(request);
                List<LifecycleRule> rules = secondClient.getBucketLifecycle("normal-set-bucket-lifecycle");
                Assert.assertEquals((int)rules.size(), (int)2);
                LifecycleRule r0 = rules.get(0);
                Assert.assertEquals((String)r0.getId(), (String)"delete obsoleted files");
                Assert.assertEquals((String)r0.getPrefix(), (String)"obsoleted/");
                Assert.assertEquals((Object)((Object)r0.getStatus()), (Object)((Object)LifecycleRule.RuleStatus.Enabled));
                Assert.assertEquals((int)r0.getExpriationDays(), (int)3);
                LifecycleRule r1 = rules.get(1);
                Assert.assertEquals((String)r1.getId(), (String)"delete temporary files");
                Assert.assertEquals((String)r1.getPrefix(), (String)"temporary/");
                Assert.assertEquals((Object)((Object)r1.getStatus()), (Object)((Object)LifecycleRule.RuleStatus.Enabled));
                Assert.assertEquals((String)DateUtil.formatIso8601Date(r1.getExpirationTime()), (String)"2022-10-12T00:00:00.000Z");
                String nullRuleId = null;
                request.clearLifecycles();
                request.AddLifecycleRule(new LifecycleRule(nullRuleId, "obsoleted/", LifecycleRule.RuleStatus.Enabled, 7));
                secondClient.setBucketLifecycle(request);
                TestUtils.waitForCacheExpiration(5);
                rules = secondClient.getBucketLifecycle("normal-set-bucket-lifecycle");
                Assert.assertEquals((int)rules.size(), (int)1);
                r0 = rules.get(0);
                Assert.assertEquals((String)"obsoleted/", (String)r0.getPrefix());
                Assert.assertEquals((Object)((Object)r0.getStatus()), (Object)((Object)LifecycleRule.RuleStatus.Enabled));
                Assert.assertEquals((int)r0.getExpriationDays(), (int)7);
                secondClient.deleteBucketLifecycle("normal-set-bucket-lifecycle");
                try {
                    secondClient.getBucketLifecycle("normal-set-bucket-lifecycle");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"NoSuchLifecycle", (String)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().startsWith("No Row found in Lifecycle Table."));
                }
            }
            catch (OSSException e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("normal-set-bucket-lifecycle");
            }
        }
        finally {
            secondClient.deleteBucket("normal-set-bucket-lifecycle");
        }
    }

    @Test
    public void testUnormalSetBucketLifecycle() throws ParseException {
        String bucketName = "unormal-set-bucket-lifecycle";
        String ruleId0 = "delete obsoleted files";
        String matchPrefix0 = "obsoleted/";
        try {
            LifecycleRule invalidRule;
            SetBucketLifecycleRequest request;
            SetBucketLifecycleRequest request2;
            secondClient.createBucket("unormal-set-bucket-lifecycle");
            String nonexistentBucket = "nonexistent-bucket";
            LifecycleRule r = new LifecycleRule("delete obsoleted files", "obsoleted/", LifecycleRule.RuleStatus.Enabled, 3);
            try {
                SetBucketLifecycleRequest request3 = new SetBucketLifecycleRequest("nonexistent-bucket");
                request3.AddLifecycleRule(r);
                secondClient.setBucketLifecycle(request3);
                Assert.fail((String)"Set bucket lifecycle should not be successful");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
            }
            String bucketWithoutOwnership = "oss";
            try {
                SetBucketLifecycleRequest request4 = new SetBucketLifecycleRequest("oss");
                request4.AddLifecycleRule(r);
                secondClient.setBucketLifecycle(request4);
                Assert.fail((String)"Set bucket lifecycle should not be successful");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
            }
            String ruleId256 = TestUtils.genRandomString(256);
            try {
                request2 = new SetBucketLifecycleRequest("unormal-set-bucket-lifecycle");
                request2.AddLifecycleRule(new LifecycleRule(ruleId256, "obsoleted/", LifecycleRule.RuleStatus.Enabled, 3));
                Assert.fail((String)"Set bucket lifecycle should not be successful");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
            }
            try {
                request2 = new SetBucketLifecycleRequest("nonexistent-bucket");
                int i = 0;
                while (i < 1001) {
                    request2.AddLifecycleRule(r);
                    ++i;
                }
                Assert.fail((String)"Set bucket lifecycle should not be successful");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
            }
            String nullRuleId = null;
            String nullMatchPrefix = null;
            try {
                request = new SetBucketLifecycleRequest("unormal-set-bucket-lifecycle");
                request.AddLifecycleRule(new LifecycleRule(nullRuleId, nullMatchPrefix, LifecycleRule.RuleStatus.Enabled, 3));
                secondClient.setBucketLifecycle(request);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            try {
                request = new SetBucketLifecycleRequest("nonexistent-bucket");
                invalidRule = new LifecycleRule();
                invalidRule.setId("delete obsoleted files");
                invalidRule.setPrefix("obsoleted/");
                invalidRule.setStatus(LifecycleRule.RuleStatus.Enabled);
                invalidRule.setExpirationTime(DateUtil.parseIso8601Date("2022-10-12T00:00:00.000Z"));
                invalidRule.setExpriationDays(3);
                request.AddLifecycleRule(invalidRule);
                Assert.fail((String)"Set bucket lifecycle should not be successful");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
            }
            try {
                request = new SetBucketLifecycleRequest("nonexistent-bucket");
                invalidRule = new LifecycleRule();
                invalidRule.setId("delete obsoleted files");
                invalidRule.setPrefix("obsoleted/");
                invalidRule.setStatus(LifecycleRule.RuleStatus.Enabled);
                request.AddLifecycleRule(invalidRule);
                Assert.fail((String)"Set bucket lifecycle should not be successful");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
            }
        }
        finally {
            secondClient.deleteBucket("unormal-set-bucket-lifecycle");
        }
    }

    @Test
    public void testUnormalGetBucketLifecycle() {
        String nonexistentBucket = "unormal-get-bucket-lifecycle";
        try {
            secondClient.getBucketLifecycle("unormal-get-bucket-lifecycle");
            Assert.fail((String)"Get bucket lifecycle should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
        String bucketWithoutOwnership = "oss";
        try {
            secondClient.getBucketLogging("oss");
            Assert.fail((String)"Get bucket lifecycle should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
        }
        String bucketWithoutLifecycleConfiguration = "bucket-without-lifecycle-configuration";
        try {
            try {
                secondClient.createBucket("bucket-without-lifecycle-configuration");
                secondClient.getBucketLifecycle("bucket-without-lifecycle-configuration");
                Assert.fail((String)"Get bucket lifecycle should not be successful");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"NoSuchLifecycle", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("No Row found in Lifecycle Table."));
                TestUtils.waitForCacheExpiration(5);
                secondClient.deleteBucket("bucket-without-lifecycle-configuration");
            }
        }
        finally {
            TestUtils.waitForCacheExpiration(5);
            secondClient.deleteBucket("bucket-without-lifecycle-configuration");
        }
    }

    @Test
    public void testUnormalDeleteBucketLifecycle() {
        String nonexistentBucket = "unormal-delete-bucket-lifecycle";
        try {
            secondClient.deleteBucketLifecycle("unormal-delete-bucket-lifecycle");
            Assert.fail((String)"Delete bucket lifecycle should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
        String bucketWithoutOwnership = "oss";
        try {
            secondClient.deleteBucketLifecycle("oss");
            Assert.fail((String)"Delete bucket lifecycle should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
        }
        String bucketWithoutLifecycleConfiguration = "bucket-without-lifecycle-configuration";
        try {
            try {
                secondClient.createBucket("bucket-without-lifecycle-configuration");
                secondClient.deleteBucketLifecycle("bucket-without-lifecycle-configuration");
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("bucket-without-lifecycle-configuration");
            }
        }
        finally {
            secondClient.deleteBucket("bucket-without-lifecycle-configuration");
        }
    }
}

