/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.common.comm.HttpMesssage;
import com.aliyun.oss.model.WebServiceRequest;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;

public class RequestMessage
extends HttpMesssage {
    private String resourcePath;
    private URI endpoint;
    private HttpMethod method = HttpMethod.GET;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private URL absoluteUrl;
    private boolean useUrlSignature = false;
    private boolean useChunkEncoding = false;
    private final WebServiceRequest originalRequest;

    public RequestMessage() {
        this(null);
    }

    public RequestMessage(WebServiceRequest originalRequest) {
        this.originalRequest = originalRequest == null ? WebServiceRequest.NOOP : originalRequest;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters.clear();
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters.putAll(parameters);
        }
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public void removeParameter(String key) {
        this.parameters.remove(key);
    }

    public boolean isRepeatable() {
        return this.getContent() == null || this.getContent().markSupported();
    }

    public String toString() {
        return "Endpoint: " + this.getEndpoint().getHost() + ", ResourcePath: " + this.getResourcePath() + ", Headers:" + this.getHeaders();
    }

    public URL getAbsoluteUrl() {
        return this.absoluteUrl;
    }

    public void setAbsoluteUrl(URL absoluteUrl) {
        this.absoluteUrl = absoluteUrl;
    }

    public boolean isUseUrlSignature() {
        return this.useUrlSignature;
    }

    public void setUseUrlSignature(boolean useUrlSignature) {
        this.useUrlSignature = useUrlSignature;
    }

    public boolean isUseChunkEncoding() {
        return this.useChunkEncoding;
    }

    public void setUseChunkEncoding(boolean useChunkEncoding) {
        this.useChunkEncoding = useChunkEncoding;
    }

    public WebServiceRequest getOriginalRequest() {
        return this.originalRequest;
    }
}

