/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.util;

import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLParser;
import org.htmlparser.HTMLRemarkNode;
import org.htmlparser.HTMLStringNode;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLLinkTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLEnumeration;
import org.htmlparser.util.HTMLParserException;

public class Generate {
    protected HTMLParser parser = new HTMLParser("http://www.w3.org/TR/REC-html40/sgml/entities.html");
    protected static final String nl = System.getProperty("line.separator", "\n");

    public Generate() throws HTMLParserException {
        this.parser.registerScanners();
    }

    public String translate(String string) {
        int amp;
        StringBuffer ret = new StringBuffer(4096);
        int index = 0;
        while (index < string.length() && -1 != (amp = string.indexOf(38, index))) {
            ret.append(string.substring(index, amp));
            if (string.startsWith("&nbsp;", amp)) {
                ret.append(" ");
                index = amp + 6;
                continue;
            }
            if (string.startsWith("&lt;", amp)) {
                ret.append("<");
                index = amp + 4;
                continue;
            }
            if (string.startsWith("&gt;", amp)) {
                ret.append(">");
                index = amp + 4;
                continue;
            }
            if (string.startsWith("&amp;", amp)) {
                ret.append("&");
                index = amp + 5;
                continue;
            }
            if (string.startsWith("&quote;", amp)) {
                ret.append("\"");
                index = amp + 7;
                continue;
            }
            if (string.startsWith("&divide;", amp)) {
                ret.append('\u00f7');
                index = amp + 8;
                continue;
            }
            if (string.startsWith("&copy;", amp)) {
                ret.append('\u00a9');
                index = amp + 6;
                continue;
            }
            System.out.println("unknown special character starting with ".concat(String.valueOf(String.valueOf(string.substring(amp, amp + 7)))));
            ret.append("&");
            index = amp + 1;
        }
        ret.append(string.substring(index));
        return ret.toString();
    }

    public void parse() throws HTMLParserException {
        StringBuffer buffer = new StringBuffer(4096);
        HTMLEnumeration e = this.parser.elements();
        while (e.hasMoreNodes()) {
            String contents;
            HTMLNode node = e.nextHTMLNode();
            if (node instanceof HTMLStringNode) {
                HTMLStringNode stringNode = (HTMLStringNode)node;
                buffer.append(stringNode.getText());
                continue;
            }
            if (node instanceof HTMLLinkTag) {
                HTMLLinkTag linkNode = (HTMLLinkTag)node;
                buffer.append(linkNode.getLinkText());
                continue;
            }
            if (node instanceof HTMLTag) {
                contents = ((HTMLTag)node).getText();
                if (!contents.equals("BR") && !contents.equals("P")) continue;
                buffer.append(nl);
                continue;
            }
            if (node instanceof HTMLEndTag) {
                contents = ((HTMLEndTag)node).getText();
                if (!contents.equals("BR") && !contents.equals("P")) continue;
                buffer.append(nl);
                continue;
            }
            if (node instanceof HTMLRemarkNode) continue;
            System.out.println();
            node.print();
        }
        String text = this.translate(buffer.toString());
        this.sgml(text);
    }

    public int indexOfWhitespace(String string, int index) {
        int space = string.indexOf(" ", index);
        int cr = string.indexOf(nl, index);
        int ret = -1 == space ? cr : (-1 == cr ? space : Math.min(space, cr));
        return ret;
    }

    public String pack(String string) {
        StringBuffer ret;
        block3: {
            int spaces;
            ret = new StringBuffer(string.length());
            if (string.startsWith("-- ")) {
                string = string.substring(3);
            }
            int index = 0;
            while (index < string.length() && -1 != (spaces = this.indexOfWhitespace(string, index))) {
                ret.append(string.substring(index, spaces));
                ret.append(" ");
                while (spaces < string.length() && Character.isWhitespace(string.charAt(spaces))) {
                    ++spaces;
                }
                index = spaces;
            }
            if (index >= string.length()) break block3;
            ret.append(string.substring(index));
        }
        return ret.toString();
    }

    public String pretty(String string) {
        StringBuffer ret;
        block3: {
            int spaces;
            ret = new StringBuffer(string.length());
            int index = 0;
            while (index < string.length() && -1 != (spaces = string.indexOf("  ", index))) {
                ret.append("        // ".concat(String.valueOf(String.valueOf(string.substring(index, spaces)))));
                if (!string.substring(index, spaces).endsWith(nl)) {
                    ret.append(nl);
                }
                while (spaces < string.length() && Character.isWhitespace(string.charAt(spaces))) {
                    ++spaces;
                }
                index = spaces;
            }
            if (index >= string.length()) break block3;
            ret.append("        // ".concat(String.valueOf(String.valueOf(string.substring(index)))));
        }
        return ret.toString();
    }

    public String pad(String string, char character, int length) {
        StringBuffer ret = new StringBuffer(length);
        ret.append(string);
        while (length > ret.length()) {
            ret.insert(0, character);
        }
        return ret.toString();
    }

    public String unicode(String string) {
        if (string.startsWith("\"&#") && string.endsWith(";\"")) {
            string = string.substring(3, string.length() - 2);
            try {
                int code = Integer.parseInt(string);
                string = String.valueOf(String.valueOf(new StringBuffer("new Character ('\\u").append(this.pad(Integer.toHexString(code), '0', 4)).append("')")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return string;
        }
        return string;
    }

    public void extract(String string) {
        if (string.startsWith("<!--")) {
            System.out.println(this.pretty(string.substring(4, string.length() - 3).trim()));
        } else if (string.startsWith("<!ENTITY")) {
            int space = (string = string.substring(8, string.length() - 3).trim()).indexOf(" ");
            if (-1 != space) {
                String token = string.substring(0, space);
                if ((string = string.substring(space).trim()).startsWith("CDATA")) {
                    space = (string = string.substring(5).trim()).indexOf(" ");
                    if (-1 != space) {
                        String code = string.substring(0, space).trim();
                        code = this.unicode(code);
                        string = string.substring(space).trim();
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("        mRefChar.put (\"").append(token).append("\",").append(this.pad(code, ' ', code.length() + 9 - token.length())).append(");").append(" // ").append(this.pack(string)))));
                    } else {
                        System.out.println(string);
                    }
                } else {
                    System.out.println(string);
                }
            } else {
                System.out.println(string);
            }
        } else {
            System.out.println(string);
        }
    }

    public void sgml(String string) {
        int begin;
        StringBuffer ret = new StringBuffer(4096);
        int index = 0;
        while (-1 != (begin = string.indexOf("<", index))) {
            int end = string.indexOf("-->", begin);
            if (-1 != end) {
                this.extract(string.substring(begin, end + 3));
                index = end + 3;
                continue;
            }
            index = begin + 1;
        }
    }

    public static void main(String[] args) throws HTMLParserException {
        Generate filter = new Generate();
        System.out.println("import java.util.Hashtable;");
        System.out.println("import java.util.Iterator;");
        System.out.println();
        System.out.println("/**");
        System.out.println(" * Translate numeric character references and character entity references to unicode characters.");
        System.out.println(" * Based on tables found at <a href=\"http://www.w3.org/TR/REC-html40/sgml/entities.html\">");
        System.out.println(" * http://www.w3.org/TR/REC-html40/sgml/entities.html</a>");
        System.out.println(" * <p><b>Note: Do not edit! This class is created by the Generate class.</b>");
        System.out.println(" * <p>Typical usage:");
        System.out.println(" * <pre>");
        System.out.println(" *      String s = Translate.decode (getTextFromHtmlPage ());");
        System.out.println(" * </pre>");
        System.out.println(" * @author <a href='mailto:DerrickOswald@users.sourceforge.net?subject=Character Reference Translation class'>Derrick Oswald</a>");
        System.out.println(" */");
        System.out.println("public class Translate");
        System.out.println("{");
        System.out.println("    /**");
        System.out.println("     * Table mapping entity reference kernel to character.");
        System.out.println("     * <p><code>String</code>-><code>Character</code>");
        System.out.println("     */");
        System.out.println("    protected static Hashtable mRefChar;");
        System.out.println("    static");
        System.out.println("    {");
        System.out.println("        mRefChar = new Hashtable (1000);");
        System.out.println();
        filter.parse();
        System.out.println("    }");
        System.out.println();
        System.out.println("    /**");
        System.out.println("     * Table mapping character to entity reference kernel.");
        System.out.println("     * <p><code>Character</code>-><code>String</code>");
        System.out.println("     */");
        System.out.println("    protected static Hashtable mCharRef;");
        System.out.println("    static");
        System.out.println("    {");
        System.out.println("        mCharRef = new Hashtable (mRefChar.size ());");
        System.out.println();
        System.out.println("        Iterator iterator = mRefChar.keySet ().iterator ();");
        System.out.println("        while (iterator.hasNext ())");
        System.out.println("        {");
        System.out.println("            String key = (String)iterator.next ();");
        System.out.println("            Character character = (Character)mRefChar.get (key);");
        System.out.println("            mCharRef.put (character, key);");
        System.out.println("        }");
        System.out.println("    }");
        System.out.println();
        System.out.println("    /**");
        System.out.println("     * Private constructor.");
        System.out.println("     * This class is fully static and thread safe.");
        System.out.println("     */");
        System.out.println("    private Translate ()");
        System.out.println("    {");
        System.out.println("    }");
        System.out.println();
        System.out.println("    /**");
        System.out.println("     * Convert a reference to a unicode character.");
        System.out.println("     * Convert a single numeric character reference or character entity reference");
        System.out.println("     * to a unicode character.");
        System.out.println("     * @param string The string to convert. Of the form &xxxx; or &amp;#xxxx; with");
        System.out.println("     * or without the leading ampersand or trailing semi-colon.");
        System.out.println("     * @return The converted character or '\\0' (zero) if the string is an");
        System.out.println("     * invalid reference.");
        System.out.println("     */");
        System.out.println("    public static char convertToChar (String string)");
        System.out.println("    {");
        System.out.println("        int length;");
        System.out.println("        Character item;");
        System.out.println("        char ret;");
        System.out.println();
        System.out.println("        ret = 0;");
        System.out.println("        length = string.length ();");
        System.out.println("        if ('&' == string.charAt (0))");
        System.out.println("        {");
        System.out.println("            string = string.substring (1);");
        System.out.println("            length--;");
        System.out.println("        }");
        System.out.println("        if (';' == string.charAt (length - 1))");
        System.out.println("            string = string.substring (0, --length);");
        System.out.println("        if ('#' == string.charAt (0))");
        System.out.println("            try");
        System.out.println("            {");
        System.out.println("                ret = (char)Integer.parseInt (string.substring (1));");
        System.out.println("            }");
        System.out.println("            catch (NumberFormatException nfe)");
        System.out.println("            {");
        System.out.println("                /* failed conversion, return 0 */");
        System.out.println("            }");
        System.out.println("        else");
        System.out.println("        {");
        System.out.println("            item = (Character)mRefChar.get (string);");
        System.out.println("            if (null != item)");
        System.out.println("                ret = item.charValue ();");
        System.out.println("        }");
        System.out.println();
        System.out.println("        return (ret);");
        System.out.println("    }");
        System.out.println();
        System.out.println("    /**");
        System.out.println("     * Decode a string containing references.");
        System.out.println("     * Change all numeric character reference and character entity references");
        System.out.println("     * to unicode characters.");
        System.out.println("     * @param string The string to translate.");
        System.out.println("     */");
        System.out.println("    public static String decode (String string)");
        System.out.println("    {");
        System.out.println("        int index;");
        System.out.println("        int length;");
        System.out.println("        int amp;");
        System.out.println("        int semi;");
        System.out.println("        String code;");
        System.out.println("        char character;");
        System.out.println("        StringBuffer ret;");
        System.out.println();
        System.out.println("        ret = new StringBuffer (string.length ());");
        System.out.println();
        System.out.println("        index = 0;");
        System.out.println("        length = string.length ();");
        System.out.println("        while ((index < length) && (-1 != (amp = string.indexOf ('&', index))))");
        System.out.println("        {");
        System.out.println("            ret.append (string.substring (index, amp));");
        System.out.println("            index = amp + 1;");
        System.out.println("            if (amp < length - 1)");
        System.out.println("            {");
        System.out.println("                semi = string.indexOf (';', amp);");
        System.out.println("                if (-1 != semi)");
        System.out.println("                    code = string.substring (amp, semi + 1);");
        System.out.println("                else");
        System.out.println("                    code = string.substring (amp);");
        System.out.println("                if (0 != (character = convertToChar (code)))");
        System.out.println("                    index += code.length () - 1;");
        System.out.println("                else");
        System.out.println("                    character = '&';");
        System.out.println("            }");
        System.out.println("            else");
        System.out.println("                character = '&';");
        System.out.println("            ret.append (character);");
        System.out.println("        }");
        System.out.println("        if (index < length)");
        System.out.println("            ret.append (string.substring (index));");
        System.out.println();
        System.out.println("        return (ret.toString ());");
        System.out.println("    }");
        System.out.println();
        System.out.println("    /**");
        System.out.println("     * Convert a character to a character entity reference.");
        System.out.println("     * Convert a unicode character to a character entity reference of");
        System.out.println("     * the form &xxxx;.");
        System.out.println("     * @param character The character to convert.");
        System.out.println("     * @return The converted character or <code>null</code> if the character");
        System.out.println("     * is not one of the known entity references.");
        System.out.println("     */");
        System.out.println("    public static String convertToString (Character character)");
        System.out.println("    {");
        System.out.println("        StringBuffer buffer;");
        System.out.println("        String ret;");
        System.out.println();
        System.out.println("        if (null != (ret = (String)mCharRef.get (character)))");
        System.out.println("        {");
        System.out.println("            buffer = new StringBuffer (ret.length () + 2);");
        System.out.println("            buffer.append ('&');");
        System.out.println("            buffer.append (ret);");
        System.out.println("            buffer.append (';');");
        System.out.println("            ret = buffer.toString ();");
        System.out.println("        }");
        System.out.println();
        System.out.println("        return (ret);");
        System.out.println("    }");
        System.out.println();
        System.out.println("    /**");
        System.out.println("     * Convert a character to a numeric character reference.");
        System.out.println("     * Convert a unicode character to a numeric character reference of");
        System.out.println("     * the form &amp;#xxxx;.");
        System.out.println("     * @param character The character to convert.");
        System.out.println("     * @return The converted character.");
        System.out.println("     */");
        System.out.println("    public static String convertToString (int character)");
        System.out.println("    {");
        System.out.println("        StringBuffer ret;");
        System.out.println();
        System.out.println("        ret = new StringBuffer (13); /* &#2147483647; */");
        System.out.println("        ret.append (\"&#\");");
        System.out.println("        ret.append (character);");
        System.out.println("        ret.append (';');");
        System.out.println();
        System.out.println("        return (ret.toString ());");
        System.out.println("    }");
        System.out.println();
        System.out.println("    /**");
        System.out.println("     * Encode a string to use references.");
        System.out.println("     * Change all characters that are not ASCII to their numeric character");
        System.out.println("     * reference or character entity reference.");
        System.out.println("     * This implementation is inefficient, allocating a new");
        System.out.println("     * <code>Character</code> for each character in the string,");
        System.out.println("     * but this class is primarily intended to decode strings");
        System.out.println("     * so efficiency and speed in the encoding was not a priority.");
        System.out.println("     * @param string The string to translate.");
        System.out.println("     */");
        System.out.println("    public static String encode (String string)");
        System.out.println("    {");
        System.out.println("        int length;");
        System.out.println("        char c;");
        System.out.println("        Character character;");
        System.out.println("        String value;");
        System.out.println("        StringBuffer ret;");
        System.out.println();
        System.out.println("        ret = new StringBuffer (string.length () * 6);");
        System.out.println("        length  = string.length ();");
        System.out.println("        for (int i = 0; i < length; i++)");
        System.out.println("        {");
        System.out.println("            c = string.charAt (i);");
        System.out.println("            character = new Character (c);");
        System.out.println("            if (null != (value = convertToString (character)))");
        System.out.println("                ret.append (value);");
        System.out.println("            else if (!((c > 0x001F) && (c < 0x007F)))");
        System.out.println("            {");
        System.out.println("                value = convertToString (c);");
        System.out.println("                ret.append (value);");
        System.out.println("            }");
        System.out.println("            else");
        System.out.println("                ret.append (character);");
        System.out.println("        }");
        System.out.println();
        System.out.println("        return (ret.toString ());");
        System.out.println("    }");
        System.out.println("}");
    }
}

