/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.domain.AutoTransmitMgr;
import com.trs.components.wcm.content.domain.ChannelExporter;
import com.trs.components.wcm.content.domain.ChannelImporter;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.domain.ContentLinkMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.ReplaceMgr;
import com.trs.components.wcm.content.domain.SiteMemberIdsMan;
import com.trs.components.wcm.content.domain.SiteMemberMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelSyn;
import com.trs.components.wcm.content.persistent.ChannelSyns;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.ContentLink;
import com.trs.components.wcm.content.persistent.ContentLinks;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Replace;
import com.trs.components.wcm.content.persistent.Replaces;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.service.IChannelService;
import com.trs.service.IDocumentService;
import com.trs.service.ServiceHelper;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ChannelService
implements IChannelService {
    private static Logger logger = Logger.getLogger(ChannelService.class);

    @Override
    public List getChildren(BaseChannel _parentChannel, int _nRightIndex, int _nChannelType) throws WCMException {
        return this.getChildren(_parentChannel, _nRightIndex, new int[]{_nChannelType});
    }

    @Override
    public List getChildren(BaseChannel _parentChannel, int _nRightIndex, int[] _nArrayChannelType) throws WCMException {
        if (_parentChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label1", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u5b50\u9891\u9053\uff01"));
        }
        List<Channel> listChildren = _parentChannel.getChildren(ContextHelper.getLoginUser(), _nArrayChannelType);
        if (AuthServer.hasSuperRight(this.getLoginUser(), _parentChannel)) {
            return listChildren;
        }
        for (int i = listChildren.size() - 1; i >= 0; --i) {
            BaseChannel currObj = listChildren.get(i);
            if (currObj != null && this.isVisible(this.getLoginUser(), currObj, _nRightIndex)) continue;
            listChildren.remove(i);
        }
        return listChildren;
    }

    @Override
    public List getChildren(BaseChannel _parentChannel, int _nRightIndex, int[] _nArrayChannelType, StringBuffer _sbNoRightIds) throws WCMException {
        if (_parentChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label1", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u5b50\u9891\u9053\uff01"));
        }
        List<Channel> listChildren = _parentChannel.getChildren(ContextHelper.getLoginUser(), _nArrayChannelType);
        if (AuthServer.hasSuperRight(this.getLoginUser(), _parentChannel)) {
            return listChildren;
        }
        for (int i = listChildren.size() - 1; i >= 0; --i) {
            BaseChannel currObj = listChildren.get(i);
            DebugTimer timer = new DebugTimer();
            if (logger.isDebugEnabled()) {
                timer.start();
            }
            if (currObj == null || !this.isVisible(this.getLoginUser(), currObj, _nRightIndex)) {
                listChildren.remove(i);
            }
            if (!logger.isDebugEnabled()) continue;
            timer.stop();
            logger.debug((Object)(ContextHelper.getLoginUser() + " is visible on " + currObj + " use [" + timer.getTime() + "]ms!"));
        }
        return listChildren;
    }

    @Override
    public List getChildren(BaseChannel _oChannel, int _nRightIndex) throws WCMException {
        return this.getChildren(_oChannel, _nRightIndex, -1);
    }

    @Override
    public List getChildren(BaseChannel _oChannel) throws WCMException {
        return this.getChildren(_oChannel, 64);
    }

    @Override
    public Channels getRecycleChannels(BaseChannel _oChannel) throws WCMException {
        return this.getRecycleChannels(_oChannel, null);
    }

    @Override
    public Channels getRecycleChannels(BaseChannel _oChannel, WCMFilter _filter) throws WCMException {
        return this.getChannelMgr().getRecycleChannels(_oChannel, _filter);
    }

    @Override
    public Documents getDocuments(int _nChnlId) throws WCMException {
        return this.getDocuments(_nChnlId, null);
    }

    @Override
    public Documents getDocuments(int _nChnlId, WCMFilter _filter) throws WCMException {
        if (_nChnlId <= 0) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label2", "\u65e0\u6548\u7684\u9891\u9053id[") + _nChnlId + "]");
        }
        Channel currChannel = Channel.findById(_nChnlId);
        if (currChannel == null) {
            throw new WCMException(200006, I18NMessage.get(ChannelService.class, "ChannelService.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053"));
        }
        return this.getDocuments(currChannel, _filter);
    }

    @Override
    public Documents getDocuments(BaseChannel _oChannel) throws WCMException {
        return this.getDocuments(_oChannel, null);
    }

    @Override
    public Documents getDocuments(BaseChannel _oChannel, WCMFilter _docFilter) throws WCMException {
        DocumentMgr aDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return aDocumentMgr.getDocuments(_oChannel, _docFilter);
    }

    @Override
    public Documents getRecycleDocuments(int _nChnlId) throws WCMException {
        return this.getRecycleDocuments(_nChnlId, null);
    }

    @Override
    public Documents getRecycleDocuments(int _nChnlId, WCMFilter _filter) throws WCMException {
        if (_nChnlId <= 0) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label2", "\u65e0\u6548\u7684\u9891\u9053id[") + _nChnlId + "]");
        }
        Channel currChnl = Channel.findById(_nChnlId);
        if (currChnl == null) {
            throw new WCMException(200006, I18NMessage.get(ChannelService.class, "ChannelService.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053"));
        }
        return this.getRecycleDocuments(currChnl, _filter);
    }

    @Override
    public Documents getRecycleDocuments(BaseChannel _oChannel, WCMFilter _docFilter) throws WCMException {
        DocumentMgr aDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return aDocumentMgr.getRecycleDocuments(_oChannel, _docFilter);
    }

    @Override
    public boolean delete(String _sChannelIds, boolean _bDrop) throws WCMException {
        if (_sChannelIds == null || _sChannelIds.length() <= 0) {
            return true;
        }
        Channels aChannels = Channels.findByIds(this.getLoginUser(), _sChannelIds);
        return this.delete(aChannels, _bDrop);
    }

    @Override
    public boolean delete(Channels _currChannels, boolean _bDrop) throws WCMException {
        if (_currChannels == null || _currChannels.isEmpty()) {
            return true;
        }
        for (int i = _currChannels.size() - 1; i >= 0; --i) {
            BaseChannel oChannel = (BaseChannel)_currChannels.getAt(i);
            this.delete(oChannel, _bDrop);
        }
        return true;
    }

    @Override
    public boolean delete(BaseChannel _oChannel, boolean _bDrop) throws WCMException {
        if (_oChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label4", "\u65e0\u6548\u7684\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61"));
        }
        int nRightIndex = 0;
        nRightIndex = _oChannel.isSite() ? 2 : 12;
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_oChannel, nRightIndex)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label5", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5220\u9664\u8be5\u7ad9\u70b9(\u9891\u9053)!"));
        }
        String sDesc = I18NMessage.get(ChannelService.class, "ChannelService.label6", "\u5220\u9664") + _oChannel;
        String sOperType = _oChannel.isSite() ? "SITE_DEL" : "CHANNEL_DEL";
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), sOperType, sDesc, _oChannel);
        try {
            this.getChannelMgr().delete(_oChannel, _bDrop);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, null);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label7", "\u5220\u9664[") + _oChannel + I18NMessage.get(ChannelService.class, "ChannelService.label8", "]\u5931\u8d25!"), e);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return true;
    }

    @Override
    public BaseChannel save(BaseChannel _currBaseChannel) throws WCMException {
        if (_currBaseChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label9", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        int nRightIndex = 0;
        User loginUser = this.getLoginUser();
        if (_currBaseChannel.isSite()) {
            int n = nRightIndex = _currBaseChannel.isAddMode() ? 0 : 1;
            if (!AuthServer.hasRight(loginUser, (CMSObj)_currBaseChannel, nRightIndex)) {
                throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label10", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fdd\u5b58\u5f53\u524d\u7ad9\u70b9/\u9891\u9053!"));
            }
        } else {
            nRightIndex = _currBaseChannel.isAddMode() ? 11 : 13;
            BaseChannel parent = _currBaseChannel.getHost();
            if (parent == null) {
                throw new WCMException(I18NMessage.get(ChannelService.class, "ChannelService.label11", "\u7236\u5bf9\u8c61\u6ca1\u6709\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u5224\u65ad\u9891\u9053\u7684\u6743\u9650\uff01"));
            }
            if (!AuthServer.hasRight(loginUser, (CMSObj)_currBaseChannel, nRightIndex) && !AuthServer.hasRight(loginUser, (CMSObj)parent, nRightIndex)) {
                throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label10", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fdd\u5b58\u5f53\u524d\u7ad9\u70b9/\u9891\u9053!"));
            }
        }
        long lLogStartTime = LogServer.startRecord(loginUser.getName(), this.getOperTypeNameForSave(_currBaseChannel), I18NMessage.get(ChannelService.class, "ChannelService.label12", "\u4fdd\u5b58") + _currBaseChannel, _currBaseChannel);
        try {
            _currBaseChannel = this.getChannelMgr().save(_currBaseChannel);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lLogStartTime, null);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label13", "\u4fdd\u5b58\u7ad9\u70b9/\u9891\u9053\u5931\u8d25!"), e);
        }
        LogServer.endRecordSucceedOperation(lLogStartTime);
        return _currBaseChannel;
    }

    private String getOperTypeNameForSave(BaseChannel _siteOrChannel) {
        boolean bAddMode = _siteOrChannel.isAddMode();
        if (_siteOrChannel.isSite()) {
            return bAddMode ? "SITE_ADD" : "SITE_EDIT";
        }
        return bAddMode ? "CHANNEL_ADD" : "CHANNEL_EDIT";
    }

    @Override
    public Channels getSynSrcChannel(Channel _currChannel) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_currChannel, 13)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label14", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fee\u6539\u9891\u9053\u7684\u6587\u6863\u5206\u53d1\u8bbe\u7f6e!"));
        }
        return this.getAutoTransmitMgr().getSynSrcChannels(_currChannel);
    }

    @Override
    public Channels getSynToChannel(Channel _currChannel) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_currChannel, 13)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label14", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fee\u6539\u9891\u9053\u7684\u6587\u6863\u5206\u53d1\u8bbe\u7f6e!"));
        }
        return this.getAutoTransmitMgr().getSynToChannels(_currChannel);
    }

    @Override
    public Replace saveReplace(Replace _aReplace) throws WCMException {
        ReplaceMgr currMgr = (ReplaceMgr)DreamFactory.createObjectById("ReplaceMgr");
        Replace replace = _aReplace;
        String sLogDesc = I18NMessage.get(ChannelService.class, "ChannelService.label15", "\u4fdd\u5b58:") + _aReplace;
        String sOper = _aReplace.isAddMode() ? "REPLACE_ADD" : "REPLACE_EDIT";
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), sOper, sLogDesc, _aReplace);
        try {
            replace = currMgr.save(_aReplace);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label16", "\u4fdd\u5b58\u66ff\u6362\u5185\u5bb9\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return replace;
    }

    @Override
    public boolean deleteReplace(Replace _aReplace) throws WCMException {
        ReplaceMgr currMgr = (ReplaceMgr)DreamFactory.createObjectById("ReplaceMgr");
        boolean bOK = false;
        String sLogDesc = I18NMessage.get(ChannelService.class, "ChannelService.label17", "\u5220\u9664:") + _aReplace;
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "REPLACE_DEL", sLogDesc, _aReplace);
        try {
            bOK = currMgr.delete(_aReplace);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label18", "\u5220\u9664\u66ff\u6362\u5185\u5bb9\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return bOK;
    }

    @Override
    public boolean deleteReplace(Replaces _aReplaces) throws WCMException {
        if (_aReplaces == null || _aReplaces.isEmpty()) {
            return true;
        }
        Replace aReplace = null;
        for (int i = 0; i < _aReplaces.size(); ++i) {
            aReplace = (Replace)_aReplaces.getAt(i);
            if (aReplace == null) continue;
            this.deleteReplace(aReplace);
        }
        return true;
    }

    @Override
    public Replaces getReplaces(Channel _oChannel, WCMFilter _filter) throws WCMException {
        ReplaceMgr currMgr = (ReplaceMgr)DreamFactory.createObjectById("ReplaceMgr");
        return currMgr.getReplaces(_oChannel, _filter);
    }

    @Override
    public void restore(BaseChannel _oChannel) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_oChannel.getSite(), 1)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label19", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u6062\u590d\u6b64\u7ad9\u70b9/\u9891\u9053"));
        }
        String sOperType = _oChannel.isSite() ? "SITE_RESTORE" : "CHANNEL_RESTORE";
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), sOperType, I18NMessage.get(ChannelService.class, "ChannelService.label20", "\u6062\u590d") + _oChannel, _oChannel);
        try {
            this.getChannelMgr().restore(_oChannel);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label21", "\u6062\u590d\u7ad9\u70b9/\u9891\u9053\u5931\u8d25!"), e);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
    }

    @Override
    public void restore(Channels _currChannels) throws WCMException {
        if (_currChannels == null || _currChannels.isEmpty()) {
            return;
        }
        for (int i = _currChannels.size() - 1; i >= 0; --i) {
            BaseChannel oChannel = (BaseChannel)_currChannels.getAt(i);
            this.restore(oChannel);
        }
    }

    @Override
    public void restore(WebSites _currSites) throws WCMException {
        if (_currSites == null || _currSites.isEmpty()) {
            return;
        }
        for (int i = _currSites.size() - 1; i >= 0; --i) {
            BaseChannel oChannel = (BaseChannel)_currSites.getAt(i);
            this.restore(oChannel);
        }
    }

    @Override
    public WebSites getWebSites(WCMFilter _filter) throws WCMException {
        User currUser = this.getLoginUser();
        if (currUser == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label22", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61!"));
        }
        return this.getSiteMemberMgr().getUserSites(currUser, _filter);
    }

    @Override
    public void moveTo(Channel _fromChannel, WebSite _toWebSite, int _nMoveToType) throws WCMException {
        if (_fromChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label23", "\u6b32\u79fb\u52a8\u7684\u9891\u9053\u4e3a\u7a7a\uff01"));
        }
        if (_toWebSite == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label24", "\u76ee\u6807\u7ad9\u70b9\u4e3a\u7a7a\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_fromChannel, 12)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label25", "\u60a8\u6682\u65f6\u65e0\u6cd5\u79fb\u52a8\u9891\u9053\uff1a") + _fromChannel.getName());
        }
        String sDesc = I18NMessage.get(ChannelService.class, "ChannelService.label26", "\u79fb\u52a8[") + _fromChannel + I18NMessage.get(ChannelService.class, "ChannelService.label27", "]\u81f3[") + _toWebSite + "]";
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "CHANNEL_MOVE", sDesc, _fromChannel);
        try {
            this.getChannelMgr().moveTo(_fromChannel, _toWebSite, _nMoveToType);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, null);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label28", "\u79fb\u52a8\u9891\u9053\u5931\u8d25!"), e);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
    }

    @Override
    public void moveTo(Channel _fromChannel, Channel _toChannel, int _nMoveToType) throws WCMException {
        if (_fromChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label23", "\u6b32\u79fb\u52a8\u7684\u9891\u9053\u4e3a\u7a7a\uff01"));
        }
        if (_toChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label29", "\u76ee\u6807\u9891\u9053\u4e3a\u7a7a\uff01"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_fromChannel, 12)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label25", "\u60a8\u6682\u65f6\u65e0\u6cd5\u79fb\u52a8\u9891\u9053\uff1a") + _fromChannel.getName());
        }
        String sDesc = I18NMessage.get(ChannelService.class, "ChannelService.label26", "\u79fb\u52a8[") + _fromChannel + "]";
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "CHANNEL_MOVE", sDesc, _fromChannel);
        try {
            this.getChannelMgr().moveTo(_fromChannel, _toChannel, _nMoveToType);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, null);
            throw e;
        }
        LogServer.endRecordSucceedOperation(lStartTime);
    }

    @Override
    public void moveTo(WebSite _fromWebSite, WebSite _toWebSite, int _nMoveToType) throws WCMException {
        throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label30", "\u7cfb\u7edf\u6682\u65f6\u4e0d\u652f\u6301\u7ad9\u70b9\u7684\u79fb\u52a8\uff01"));
    }

    @Override
    public WebSites getUserSites(User _currUser, WCMFilter _currFilter) throws WCMException {
        return this.getSiteMemberMgr().getUserSites(_currUser, _currFilter);
    }

    @Override
    public Users getSiteUsers(WebSite _currSite, WCMFilter _currFilter) throws WCMException {
        return this.getSiteMemberMgr().getSiteUsers(_currSite, _currFilter);
    }

    @Override
    public void addUsersToSite(String _sUserIds, WebSite _currSite) throws WCMException {
        this.checkDoSiteMemberRight(_currSite);
        this.setSiteMembers(_currSite, 204, _sUserIds);
    }

    @Override
    public void addSitesToUser(String _sSiteIds, User _currUser) throws WCMException {
        WebSites currSites = WebSites.findByIds(this.getLoginUser(), _sSiteIds);
        for (int i = 0; i < currSites.size(); ++i) {
            WebSite currSite = (WebSite)currSites.getAt(i);
            if (currSite == null) continue;
            this.checkDoSiteMemberRight(currSite);
            this.getSiteMemberMgr().addSiteUser(currSite, _currUser);
        }
    }

    @Override
    public void removeUsersFromSite(String _sUserIds, WebSite _currSite) throws WCMException {
        this.checkDoSiteMemberRight(_currSite);
        Users currUsers = Users.findByIds(this.getLoginUser(), _sUserIds);
        for (int i = 0; i < currUsers.size(); ++i) {
            User currUser = (User)currUsers.getAt(i);
            if (currUser == null) continue;
            this.getSiteMemberMgr().removeSiteUser(_currSite, currUser);
        }
    }

    @Override
    public void removeSitesFromUser(String _sSiteIds, User _currUser) throws WCMException {
        WebSites currSites = WebSites.findByIds(this.getLoginUser(), _sSiteIds);
        for (int i = 0; i < currSites.size(); ++i) {
            WebSite currSite = (WebSite)currSites.getAt(i);
            if (currSite == null) continue;
            this.checkDoSiteMemberRight(currSite);
            this.getSiteMemberMgr().removeSiteUser(currSite, _currUser);
        }
    }

    private ChannelMgr getChannelMgr() {
        return (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
    }

    private void checkDoSiteMemberRight(WebSite _site) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_site, 6)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label31", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5728") + _site + I18NMessage.get(ChannelService.class, "ChannelService.label32", "\u4e0a\u8fdb\u884c\u7528\u6237/\u7ec4\u7ec7\u7684\u6dfb\u52a0\u4e0e\u5220\u9664."));
        }
    }

    @Override
    public boolean isVisible(User _currUser, BaseChannel _currChannel) throws WCMException {
        return this.isVisible(_currUser, _currChannel, 64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isVisible(User _currUser, BaseChannel _currChannel, int _nRightIndex) throws WCMException {
        if (_currUser == null) {
            return false;
        }
        DebugTimer timer = new DebugTimer();
        if (logger.isDebugEnabled()) {
            timer.start();
            logger.debug((Object)(_currUser + " is visisble on " + _currChannel));
        }
        try {
            if (_currChannel.isSite()) {
                boolean bl = this.getSiteMemberMgr().isBelongToSite(_currUser, (WebSite)_currChannel);
                return bl;
            }
            if (AuthServer.hasRightOnSelf(_currUser, _currChannel, _nRightIndex)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (logger.isDebugEnabled()) {
                timer.stop();
                logger.debug((Object)(_currUser + " is visisble on " + _currChannel + " use [" + timer.getTime() + "]ms"));
            }
        }
        return false;
    }

    @Override
    public Reports importFromFile(String _sFile, String _sXslFile, BaseChannel _destSiteOrChnl) throws WCMException {
        ChannelImporter importer = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
        long lStartTime = 0L;
        String strOperType = null;
        String strOperDesc = null;
        BaseObj obj = null;
        if (_destSiteOrChnl == null) {
            strOperType = "SITE_IMPORT";
            strOperDesc = I18NMessage.get(ChannelService.class, "ChannelService.label33", "\u5bfc\u5165\u7ad9\u70b9");
            obj = new BaseObj(){

                @Override
                public int getWCMType() {
                    return 100;
                }

                @Override
                public String getDbTableName() {
                    return null;
                }

                @Override
                public String getIdFieldName() {
                    return null;
                }

                @Override
                public boolean isValid() {
                    return false;
                }

                public String toString() {
                    return I18NMessage.get(ChannelService.class, "ChannelService.label34", "\u7cfb\u7edf");
                }
            };
        } else {
            strOperType = "CHANNEL_IMPORT";
            strOperDesc = I18NMessage.get(ChannelService.class, "ChannelService.label35", "\u5bfc\u5165\u9891\u9053");
            obj = _destSiteOrChnl;
        }
        lStartTime = LogServer.startRecord(this.getLoginUserName(), strOperType, strOperDesc, obj);
        Reports importReports = new Reports("");
        try {
            importReports = importer.importFromFile(_sFile, _sXslFile, _destSiteOrChnl);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            importReports.addFailedReport(strOperDesc + I18NMessage.get(ChannelService.class, "ChannelService.label36", "\u5931\u8d25"), e);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label75", "") + strOperDesc + I18NMessage.get(ChannelService.class, "ChannelService.label37", "\u5931\u8d25!"), e);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return importReports;
    }

    @Override
    public String export(BaseChannel _fromChannel, boolean _bWithChildren, boolean _bWithRelated) throws WCMException {
        if (_fromChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label38", "\u8981\u5bfc\u51fa\u7684\u7ad9\u70b9/\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        ChannelExporter exporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        return exporter.export(_fromChannel, _bWithChildren, _bWithRelated);
    }

    @Override
    public String export(WebSites _fromWebSites, boolean _bWithChildren, boolean _bWithRelated) throws WCMException {
        if (_fromWebSites == null || _fromWebSites.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label39", "\u8981\u5bfc\u51fa\u7684\u7ad9\u70b9\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        ChannelExporter exporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        return exporter.export(_fromWebSites, _bWithChildren, _bWithRelated);
    }

    @Override
    public String export(Channels _fromChannels, boolean _bWithChildren, boolean _bWithRelated) throws WCMException {
        if (_fromChannels == null || _fromChannels.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label40", "\u8981\u5bfc\u51fa\u7684\u9891\u9053\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        ChannelExporter exporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        return exporter.export(_fromChannels, _bWithChildren, _bWithRelated);
    }

    @Override
    public String exportChannels(String _sChnlIds, boolean _bWithChildren, boolean _bWithRelated) throws WCMException {
        if (_sChnlIds == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label40", "\u8981\u5bfc\u51fa\u7684\u9891\u9053\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        Channels exportChannels = Channels.findByIds(ContextHelper.getLoginUser(), _sChnlIds);
        return this.export(exportChannels, _bWithChildren, _bWithRelated);
    }

    @Override
    public String exportSites(String _sSiteIds, boolean _bWithChildren, boolean _bWithRelated) throws WCMException {
        if (_sSiteIds == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label39", "\u8981\u5bfc\u51fa\u7684\u7ad9\u70b9\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        WebSites exportSites = WebSites.findByIds(ContextHelper.getLoginUser(), _sSiteIds);
        if (exportSites == null || exportSites.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label39", "\u8981\u5bfc\u51fa\u7684\u7ad9\u70b9\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        return this.export(exportSites, _bWithChildren, _bWithRelated);
    }

    @Override
    public ContentLinks getContentLinks(WebSite _site, WCMFilter _filter) throws WCMException {
        return this.getContentLinkMgr().getContentLinks(_site, _filter);
    }

    @Override
    public ContentLink saveContentLink(ContentLink _contentLink) throws WCMException {
        WebSite site = _contentLink.getSite();
        this.assertRightOnContentLink(site);
        String sLogDesc = I18NMessage.get(ChannelService.class, "ChannelService.label15", "\u4fdd\u5b58:") + _contentLink;
        String sOper = _contentLink.isAddMode() ? "CONTENTLINK_ADD" : "CONTENTLINK_EDIT";
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), sOper, sLogDesc, _contentLink);
        ContentLink link = _contentLink;
        try {
            link = this.getContentLinkMgr().save(_contentLink);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label41", "\u4fdd\u5b58\u5185\u5bb9\u8d85\u94fe\u63a5\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return link;
    }

    @Override
    public void deleteContentLink(ContentLink _contentLink) throws WCMException {
        String sLogDesc = I18NMessage.get(ChannelService.class, "ChannelService.label17", "\u5220\u9664:") + _contentLink;
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "CONTENTLINK_DEL", sLogDesc, _contentLink);
        try {
            this.getContentLinkMgr().delete(_contentLink);
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label42", "\u5220\u9664\u5185\u5bb9\u8d85\u94fe\u63a5\u5931\u8d25!"), t);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
    }

    @Override
    public void deleteContentLinks(ContentLinks _contentLinks) throws WCMException {
        if (_contentLinks == null || _contentLinks.isEmpty()) {
            return;
        }
        for (int i = 0; i < _contentLinks.size(); ++i) {
            ContentLink link = (ContentLink)_contentLinks.getAt(i);
            if (link == null) continue;
            this.deleteContentLink(link);
        }
    }

    private ContentLinkMgr getContentLinkMgr() {
        return (ContentLinkMgr)DreamFactory.createObjectById("ContentLinkMgr");
    }

    private void assertRightOnContentLink(WebSite _site) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_site, 1)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label43", "\u4f60\u65e0\u6743\u7ba1\u7406\u7ad9\u70b9\u7684\u5185\u5bb9\u8d85\u94fe\u63a5!"));
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getLoginUserName() {
        return this.getLoginUser().getName();
    }

    private AutoTransmitMgr getAutoTransmitMgr() {
        return (AutoTransmitMgr)DreamFactory.createObjectById("AutoTransmitMgr");
    }

    @Override
    public void deleteChannelSyn(int _nChnlSynId) throws WCMException {
        ChannelSyn currChnlSyn = ChannelSyn.findById(_nChnlSynId);
        if (currChnlSyn == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label44", "\u4f20\u5165\u53c2\u6570\u65e0\u6548\uff0c\u6ca1\u6709\u627e\u5230ID\u4e3a[") + _nChnlSynId + I18NMessage.get(ChannelService.class, "ChannelService.label45", "]\u7684ChannelSyn\uff0c\u5220\u9664\u64cd\u4f5c\u4e2d\u6b62\uff01"));
        }
        this.getAutoTransmitMgr().delete(currChnlSyn);
    }

    @Override
    public void deleteChannelSyns(String _sChnlSynIds) throws WCMException {
        if (_sChnlSynIds == null || _sChnlSynIds.trim().length() <= 0) {
            return;
        }
        StringTokenizer stIds = new StringTokenizer(_sChnlSynIds, ",");
        while (stIds.hasMoreTokens()) {
            this.deleteChannelSyn(Integer.parseInt(stIds.nextToken()));
        }
    }

    @Override
    public ChannelSyns getChannelSyns(int _nChannelId, WCMFilter _filter) throws WCMException {
        Channel currChnl = Channel.findById(_nChannelId);
        if (currChnl == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label76", "\u4f20\u5165\u53c2\u6570\u65e0\u6548\uff0c\u6ca1\u6709\u627e\u5230ID\u4e3a[") + _nChannelId + I18NMessage.get(ChannelService.class, "ChannelService.label46", "]\u7684\u9891\u9053\uff01"));
        }
        return this.getAutoTransmitMgr().getChannelSyns(currChnl, _filter);
    }

    @Override
    public ChannelSyns saveChannelSyns(ChannelSyn _currChnlSyn, String _sToChannelIds) throws WCMException {
        if (_sToChannelIds == null || _sToChannelIds.trim().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label47", "\u4f20\u5165\u9891\u9053ID\u4e3a\u7a7a\uff0c\u5fc5\u987b\u6307\u5b9a\u63a5\u6536\u5206\u53d1\u7684\u9891\u9053\uff01"));
        }
        StringTokenizer stToChannelIds = new StringTokenizer(_sToChannelIds, ",");
        ChannelSyns currChnlSyns = ChannelSyns.createNewInstance(this.getLoginUser());
        while (stToChannelIds.hasMoreTokens()) {
            ChannelSyn currChnlSyn = (ChannelSyn)_currChnlSyn.cloneToNewObj();
            currChnlSyn.setToChannelId(Integer.parseInt(stToChannelIds.nextToken()));
            currChnlSyn = this.saveChannelSyn(currChnlSyn);
            currChnlSyns.addElement(currChnlSyn);
        }
        return currChnlSyns;
    }

    @Override
    public ChannelSyn saveChannelSyn(ChannelSyn _currChnlSyn) throws WCMException {
        return this.getAutoTransmitMgr().save(_currChnlSyn);
    }

    @Override
    public WebSites getRecycleSites(WCMFilter _filter) throws WCMException {
        return this.getChannelMgr().getRecycleSites(_filter);
    }

    @Override
    public Reports createFrom(int _nSiteId, boolean _bWithRelated) throws WCMException {
        WebSite site = WebSite.findById(_nSiteId);
        if (site == null) {
            throw new WCMException(200006, I18NMessage.get(ChannelService.class, "ChannelService.label48", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9,[id=") + _nSiteId + "].");
        }
        return this.createFrom(site, _bWithRelated);
    }

    @Override
    public Reports createFrom(WebSite _srcSite, boolean _bWithRelated) throws WCMException {
        if (_srcSite == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label49", "\u6ca1\u6709\u6307\u5b9a\u7c7b\u4f3c\u521b\u5efa\u7684\u6e90\u7ad9\u70b9!"));
        }
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "SITE_CREATEFROM", I18NMessage.get(ChannelService.class, "ChannelService.label50", "\u7c7b\u4f3c\u521b\u5efa\u7ad9\u70b9"), _srcSite);
        Reports importReports = new Reports("");
        try {
            ChannelExporter exporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
            String sXmlFile = null;
            sXmlFile = _bWithRelated ? exporter.export(_srcSite, true, true) : exporter.export(_srcSite, true, false);
            ChannelImporter importer = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
            importReports = importer.importFromFile(sXmlFile, null, null);
            importReports.setTitle(I18NMessage.get(ChannelService.class, "ChannelService.label50", "\u7c7b\u4f3c\u521b\u5efa\u7ad9\u70b9"));
            List reports = importReports.getSucessedReporter();
            Report report = null;
            if (!reports.isEmpty()) {
                report = (Report)reports.get(0);
                report.setRportTitle(I18NMessage.get(ChannelService.class, "ChannelService.label51", "\u6210\u529f\u521b\u5efa\u7ad9\u70b9!"));
            } else {
                report = importReports.getFailedReporterAt(0);
                report.setRportTitle(I18NMessage.get(ChannelService.class, "ChannelService.label52", "\u521b\u5efa\u7ad9\u70b9\u5931\u8d25!"));
            }
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            importReports.addFailedReport(I18NMessage.get(ChannelService.class, "ChannelService.label53", "\u7c7b\u4f3c\u521b\u5efa\u7ad9\u70b9\u5931\u8d25"), e);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label54", "\u7c7b\u4f3c\u521b\u5efa\u7ad9\u70b9\u5931\u8d25!"), e);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return importReports;
    }

    @Override
    public Reports createFrom(int _nChannelId, BaseChannel _parent) throws WCMException {
        Channel srcChannel = Channel.findById(_nChannelId);
        if (srcChannel == null) {
            throw new WCMException(200006, I18NMessage.get(ChannelService.class, "ChannelService.label55", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053,[id=") + _nChannelId + "]!");
        }
        return this.createFrom(srcChannel, _parent);
    }

    @Override
    public Reports createFrom(Channel _srcChannel, BaseChannel _parent) throws WCMException {
        if (_srcChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label56", "\u6ca1\u6709\u6307\u5b9a\u7c7b\u4f3c\u521b\u5efa\u7684\u6e90\u9891\u9053!"));
        }
        if (_parent == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label57", "\u6ca1\u6709\u6307\u5b9a\u65b0\u9891\u9053\u7684\u7236\u8282\u70b9!"));
        }
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "CHANNEL_CREATEFROM", I18NMessage.get(ChannelService.class, "ChannelService.label58", "\u7c7b\u4f3c\u521b\u5efa\u9891\u9053"), _srcChannel);
        Reports importReports = new Reports("");
        try {
            ChannelExporter exporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
            String sXmlFile = exporter.export(_srcChannel, true, true);
            ChannelImporter importer = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
            importReports = importer.importFromFile(sXmlFile, null, _parent);
            importReports.setTitle(I18NMessage.get(ChannelService.class, "ChannelService.label58", "\u7c7b\u4f3c\u521b\u5efa\u9891\u9053"));
            List reports = importReports.getSucessedReporter();
            Report report = null;
            if (!reports.isEmpty()) {
                report = (Report)reports.get(0);
                report.setRportTitle(I18NMessage.get(ChannelService.class, "ChannelService.label59", "\u6210\u529f\u521b\u5efa\u9891\u9053!"));
            } else {
                report = importReports.getFailedReporterAt(0);
                report.setRportTitle(I18NMessage.get(ChannelService.class, "ChannelService.label60", "\u521b\u5efa\u9891\u9053\u5931\u8d25!"));
            }
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            importReports.addFailedReport(I18NMessage.get(ChannelService.class, "ChannelService.label61", "\u7c7b\u4f3c\u521b\u5efa\u9891\u9053\u5931\u8d25"), e);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label62", "\u7c7b\u4f3c\u521b\u5efa\u9891\u9053\u5931\u8d25!"), e);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return importReports;
    }

    private SiteMemberMgr getSiteMemberMgr() {
        return (SiteMemberMgr)DreamFactory.createObjectById("SiteMemberMgr");
    }

    @Override
    public void addGroupsToSite(String _sGroupIds, WebSite _site) throws WCMException {
        this.checkDoSiteMemberRight(_site);
        this.setSiteMembers(_site, 201, _sGroupIds);
    }

    @Override
    public void addSitesToGroup(String _sSiteIds, Group _group) throws WCMException {
        WebSites sites = WebSites.findByIds(this.getLoginUser(), _sSiteIds);
        for (int i = 0; i < sites.size(); ++i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (site == null) continue;
            this.checkDoSiteMemberRight(site);
            this.getSiteMemberMgr().addSiteGroup(site, _group);
        }
    }

    @Override
    public void removeGroupsFromSite(String _sGroupIds, WebSite _site) throws WCMException {
        this.checkDoSiteMemberRight(_site);
        Groups groups = Groups.findByIds(this.getLoginUser(), _sGroupIds);
        for (int i = 0; i < groups.size(); ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            this.getSiteMemberMgr().removeSiteGroup(_site, group);
        }
    }

    @Override
    public void removeSitesFromGroup(String _sSiteIds, Group _group) throws WCMException {
        WebSites sites = WebSites.findByIds(this.getLoginUser(), _sSiteIds);
        for (int i = 0; i < sites.size(); ++i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (site == null) continue;
            this.checkDoSiteMemberRight(site);
            this.getSiteMemberMgr().removeSiteGroup(site, _group);
        }
    }

    @Override
    public Groups getSiteGroups(WebSite _site, WCMFilter _filter) throws WCMException {
        return this.getSiteMemberMgr().getSiteGroups(_site, _filter);
    }

    @Override
    public Roles getSiteRoles(WebSite _site, WCMFilter _filter) throws WCMException {
        return this.getSiteMemberMgr().getSiteRoles(_site, _filter);
    }

    @Override
    public ContentExtField saveExtField(BaseChannel _siteOrChannel, ContentExtField _extfield, boolean _bInherited) throws WCMException {
        this.assertNotNull(_siteOrChannel);
        this.assertEditRightOnBaseChannel(_siteOrChannel);
        String sLogDesc = I18NMessage.get(ChannelService.class, "ChannelService.label63", "\u4fdd\u5b58") + _extfield;
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "EXTENTEDFIELD_EDIT", sLogDesc, _extfield);
        ContentExtField extfield = _extfield;
        try {
            extfield = this.getExtFieldMgr().save(_siteOrChannel, extfield, _bInherited);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            throw new WCMException(1100, I18NMessage.get(ChannelService.class, "ChannelService.label64", "\u4fdd\u5b58\u6269\u5c55\u5b57\u6bb5\u5931\u8d25!"), e);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return extfield;
    }

    @Override
    public void deleteExtFields(BaseChannel _siteOrChannel, String _extFieldIds, boolean _bDeleteInherited) throws WCMException {
        if (this.emptyString(_extFieldIds)) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label65", "\u65e0\u6548\u7684Id\u5e8f\u5217!"));
        }
        ContentExtFields extFields = ContentExtFields.findByIds(this.getLoginUser(), _extFieldIds);
        ContentExtField extfield = null;
        for (int i = 0; i < extFields.size(); ++i) {
            extfield = (ContentExtField)extFields.getAt(i);
            if (extfield == null) continue;
            this.deleteExtFiled(_siteOrChannel, extfield, _bDeleteInherited);
        }
    }

    @Override
    public void deleteExtFiled(BaseChannel _siteOrChannel, ContentExtField _extfield, boolean _bDeleteInherited) throws WCMException {
        this.assertNotNull(_siteOrChannel);
        this.assertEditRightOnBaseChannel(_siteOrChannel);
        this.assertCorrectData(_siteOrChannel, _extfield);
        String sLogDesc = I18NMessage.get(ChannelService.class, "ChannelService.label7", "\u5220\u9664[") + _extfield + "]";
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "EXTENTEDFIELD_DEL", sLogDesc, _extfield);
        try {
            this.getExtFieldMgr().delete(_siteOrChannel, _extfield, _bDeleteInherited);
            LogServer.endRecordSucceedOperation(lStartTime);
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            throw e;
        }
    }

    @Override
    public ContentExtFields getExtFields(BaseChannel _siteOrChannel, WCMFilter _filter) throws WCMException {
        return this.getExtFieldMgr().getExtFields(_siteOrChannel, _filter);
    }

    private void assertCorrectData(BaseChannel _siteOrChannel, ContentExtField extfield) throws WCMException {
        if (extfield.getObjId() != _siteOrChannel.getId() || extfield.getObjType() != _siteOrChannel.getWCMType()) {
            throw new WCMException(10, "[" + extfield + I18NMessage.get(ChannelService.class, "ChannelService.label66", "]\u4e0d\u662f[") + _siteOrChannel + I18NMessage.get(ChannelService.class, "ChannelService.label67", "]\u4e0b\u7684\u6269\u5c55\u5b57\u6bb5"));
        }
    }

    private void assertNotNull(BaseChannel _siteOrChannel) throws WCMException {
        if (_siteOrChannel == null) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label68", "\u6307\u5b9a\u7684\u7ad9\u70b9/\u9891\u9053\u65e0\u6548!"));
        }
    }

    private void assertEditRightOnBaseChannel(BaseChannel _siteOrChannel) throws WCMException {
        int nRightIndex = 19;
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_siteOrChannel, nRightIndex)) {
            throw new WCMException(1002, I18NMessage.get(ChannelService.class, "ChannelService.label69", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fee\u6539[") + _siteOrChannel + I18NMessage.get(ChannelService.class, "ChannelService.label70", "]\u7684\u6269\u5c55\u5b57\u6bb5!"));
        }
    }

    private boolean emptyString(String _string) {
        return _string == null || _string.trim().length() == 0;
    }

    private ContentExtFieldMgr getExtFieldMgr() {
        return (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
    }

    @Override
    public void setSiteMembers(int _nSiteId, int _nMemberType, String _sMemberIds) throws WCMException {
        WebSite site = WebSite.findById(_nSiteId);
        if (site == null) {
            throw new WCMException(200006, I18NMessage.get(ChannelService.class, "ChannelService.label71", "\u6ca1\u6709\u627e\u5230id\u4e3a[") + _nSiteId + I18NMessage.get(ChannelService.class, "ChannelService.label72", "]\u7684\u7ad9\u70b9!"));
        }
        this.setSiteMembers(site, _nMemberType, _sMemberIds);
    }

    @Override
    public void setSiteMembers(WebSite _site, int _nMemberType, String _sMemberIds) throws WCMException {
        this.assertNotNull(_site);
        SiteMemberIdsMan idsman = new SiteMemberIdsMan(_site, _nMemberType);
        idsman.dowithIds(_sMemberIds);
    }

    @Override
    public void addRolesToSite(String _sRoleIds, WebSite _site) throws WCMException {
        this.setSiteMembers(_site, 203, _sRoleIds);
    }

    @Override
    public void removeRolesFromSite(String _sRoleIds, WebSite _site) throws WCMException {
        this.checkDoSiteMemberRight(_site);
        Roles roles = Roles.findByIds(this.getLoginUser(), _sRoleIds);
        Role role = null;
        for (int i = 0; i < roles.size(); ++i) {
            role = (Role)roles.getAt(i);
            if (role == null) continue;
            this.getSiteMemberMgr().removeSiteMember(_site.getId(), 203, role.getId());
        }
    }

    @Override
    public void emptyRecycleBin(int _nChannelId) throws WCMException {
        Channel channel = Channel.findById(_nChannelId);
        this.assertChannelNotFound(channel, _nChannelId);
        Documents documents = this.getRecycleDocuments(channel, null);
        if (documents.isEmpty()) {
            return;
        }
        IDocumentService service = ServiceHelper.createDocumentService();
        service.delete(documents, channel, true);
    }

    @Override
    public void restoreAllInRecycleBin(int _nChannelId) throws WCMException {
        Channel channel = Channel.findById(_nChannelId);
        this.assertChannelNotFound(channel, _nChannelId);
        Documents documents = this.getRecycleDocuments(channel, null);
        if (documents.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(ChannelService.class, "ChannelService.label73", "\u6307\u5b9a\u7684\u9891\u9053\u56de\u6536\u7ad9\u4e2d\u6ca1\u6709\u6587\u6863!"));
        }
        IDocumentService service = ServiceHelper.createDocumentService();
        service.restore(documents.getIdListAsString(), _nChannelId);
    }

    private void assertChannelNotFound(Channel _channel, int _nChannelId) throws WCMException {
        if (_channel == null) {
            throw new WCMException(200006, I18NMessage.get(ChannelService.class, "ChannelService.label74", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9891\u9053![id=") + _nChannelId + "].");
        }
    }
}

