/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class WCMTagParserDocumentChannels
extends BaseTagParser4List {
    private static boolean m_zQuoteRecorded = false;

    private static Channels getChannels(Document _currDocument, int _nDocModal, String _sExtraChnlDocWhere) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(WCMTagParserDocumentChannels.class, "WCMTagParserDocumentChannels.label1", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u83b7\u53d6\u5b58\u5728\u8be5\u6587\u6863\u955c\u50cf\u7684\u6240\u6709\u9891\u9053\u5931\u8d25"));
        }
        if (_currDocument.isDraft()) {
            return null;
        }
        if (CMyString.isEmpty(_sExtraChnlDocWhere) && m_zQuoteRecorded) {
            String chnlids = "";
            if (_nDocModal == 2) {
                chnlids = _currDocument.getPropertyAsString("LINKQUOTE");
            } else if (_nDocModal == 3) {
                chnlids = _currDocument.getPropertyAsString("MIRRORQUOTE");
            } else {
                chnlids = String.valueOf(_currDocument.getChannelId());
                String sQuote = _currDocument.getPropertyAsString("LINKQUOTE");
                if (!CMyString.isEmpty(sQuote)) {
                    chnlids = chnlids + "," + sQuote;
                }
                if (!CMyString.isEmpty(sQuote = _currDocument.getPropertyAsString("MIRRORQUOTE"))) {
                    chnlids = chnlids + "," + sQuote;
                }
            }
            if (CMyString.isEmpty(chnlids)) {
                return new Channels(null);
            }
            return Channels.findByIds(null, chnlids);
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("select CHNLID from WCMCHNLDOC where ");
        if (!CMyString.isEmpty(_sExtraChnlDocWhere)) {
            sql.append("(").append(_sExtraChnlDocWhere).append(")");
            sql.append(" and ");
        }
        sql.append("CHNLID>=1 and DOCSTATUS>=1");
        boolean zModal = false;
        if (_nDocModal != 0) {
            sql.append(" and MODAL=?");
            zModal = true;
        }
        sql.append(" and DOCID=?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        DBManager dbmanger = DBManager.getDBManager();
        try {
            conn = dbmanger.getConnection();
            pstmt = conn.prepareStatement(sql.toString());
            int ix = 1;
            if (zModal) {
                pstmt.setInt(ix++, _nDocModal);
            }
            pstmt.setInt(ix, _currDocument.getId());
            rs = pstmt.executeQuery();
            Channels channels = new Channels(null);
            while (rs.next()) {
                channels.addElement(rs.getInt(1));
            }
            Channels channels2 = channels;
            return channels2;
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(WCMTagParserDocumentChannels.class, "WCMTagParserDocumentChannels.label2", "\u83b7\u53d6\u5206\u7c7b\u6cd5\u5931\u8d25"), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanger.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        String sExtraChnlDocWhere = _context.getAttribute("extraChnlDocWhere");
        Document oDocument = WCMTagParserHelper.findDocumentHost(_context);
        return WCMTagParserDocumentChannels.getChannels(oDocument, _context.getAttribute("Mode", 0), sExtraChnlDocWhere);
    }

    @Override
    protected boolean isValidate(PublishTagContext _context) {
        return true;
    }

    static {
        try {
            Document document = new Document();
            document.setProperty("LINKQUOTE", "test");
            m_zQuoteRecorded = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

