/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.DreamFactory;
import com.trs.components.wcm.advisor.Advisor;
import com.trs.components.wcm.advisor.AdvisorMgr;
import com.trs.components.wcm.advisor.StepXmlConverter;
import com.trs.components.wcm.advisor.Steps;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverterForSpecialProperty;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import com.trs.webframework.xmlserver.ConvertException;
import java.util.List;
import org.dom4j.Element;

public class AdvisorXmlConverter
extends BaseObjToXmlConverterForSpecialProperty {
    private static final int CHANNEL_ID = 1;
    private List m_listExportFiles;
    private AdvisorMgr m_oAdvisorMgr = null;

    public AdvisorXmlConverter(List listExportFiles) {
        this.m_listExportFiles = listExportFiles;
        this.m_oAdvisorMgr = (AdvisorMgr)DreamFactory.createObjectById("AdvisorMgr");
    }

    public List getExportFiles() {
        return this.m_listExportFiles;
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("CHANNELID", 1);
    }

    @Override
    protected String[][] getSpecialProperty(BaseObj obj, int propertyId, String propertyName, Object value) throws ConvertException {
        switch (propertyId) {
            case 1: {
                int nChnlId = ((Long)value).intValue();
                try {
                    Channel channel = Channel.findById(nChnlId);
                    return new String[][]{{"ChannelId", String.valueOf(nChnlId)}, {"ChnlName", channel.getName()}};
                }
                catch (WCMException e) {
                    throw new ConvertException("\u5904\u7406\u680f\u76ee\u5b57\u6bb5\u53d1\u751f\u5f02\u5e38\uff01", e);
                }
            }
        }
        return null;
    }

    @Override
    protected Element toXmlElement(BaseObj _baseObj, String _sFieldsList) throws WCMException {
        Advisor advisor = (Advisor)_baseObj;
        String sAppendixFileName = advisor.getAppendixFileName();
        if (!CMyString.isEmpty(sAppendixFileName)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            String sLocalAppendixFileName = filesMan.mapFilePath(sAppendixFileName, 0) + sAppendixFileName;
            this.getExportFiles().add(sLocalAppendixFileName);
        }
        return super.toXmlElement(_baseObj, _sFieldsList);
    }

    @Override
    protected Element[] getChildElement(BaseObj obj) throws WCMException {
        Steps steps = this.m_oAdvisorMgr.queryStepsByAdvisor((Advisor)obj, null);
        StepXmlConverter stepConverter = new StepXmlConverter(this, this.m_listExportFiles);
        return new Element[]{stepConverter.toXmlElement(steps, null)};
    }
}

