/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.DefaultObj;
import com.trs.cms.content.DefaultObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WCMTagParserViewDataAppendixs
extends BaseTagParser4List {
    private MetaViewData m_oMetaViewData;

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        IPublishElement upperHost = _context.getUpperHost();
        CMSObj substanceObj = upperHost.getSubstance();
        if (substanceObj instanceof MetaViewData) {
            this.m_oMetaViewData = (MetaViewData)substanceObj;
        } else if (substanceObj instanceof Document) {
            this.m_oMetaViewData = MetaViewData.findById(substanceObj.getId());
        } else {
            throw new WCMException("\u7f6e\u6807\u4e0d\u80fd\u5e94\u7528\u5230\u5f53\u524d\u573a\u666f\u4e0b\uff01[UpperHost=" + substanceObj.getClassName(true) + "]");
        }
        int nNum = _context.getAttribute("NUM", 0);
        String sField = _context.getAttributeTrim("FIELD");
        if (CMyString.isEmpty(sField)) {
            return new DefaultObjs(null);
        }
        String sInitNames = this.m_oMetaViewData.getPropertyAsString(sField);
        if (CMyString.isEmpty(sInitNames)) {
            return new DefaultObjs(null);
        }
        String[] pAppendixIds = sInitNames.trim().split("[ ]*,[ ]*");
        Matcher matcher = Pattern.compile("^[+-]?[0-9]+$").matcher(pAppendixIds[0]);
        if (matcher.find()) {
            return this.makeAppendixsByNewMode(nNum, sInitNames);
        }
        return this.makeAppendixsByOldMode(nNum, sInitNames);
    }

    private CMSBaseObjs makeAppendixsByNewMode(int nNum, String _sAppendixIds) throws WCMException {
        Appendixes appendixes = Appendixes.findByIds(null, _sAppendixIds);
        appendixes.setSelect("APPFILE,APPDESC,APPDOCID,APPENDIXID");
        DefaultObjs objs = new DefaultObjs(null);
        if (nNum == 0 || nNum > appendixes.size()) {
            nNum = appendixes.size();
        }
        objs.setPageSize(nNum);
        for (int i = 0; i < nNum; ++i) {
            Appendix appendix = (Appendix)appendixes.getAt(i);
            if (appendix == null) continue;
            DefaultObj obj = new DefaultObj();
            obj.setProperty("fileName", appendix.getFile(), false);
            obj.setProperty("originalFileName", appendix.getDesc(), false);
            obj.setProperty("viewData", this.m_oMetaViewData, false);
            obj.setId(appendix.getId());
            obj.setAddMode(false);
            objs.addElement(obj);
        }
        return objs;
    }

    private CMSBaseObjs makeAppendixsByOldMode(int nNum, String _sAppendixValues) throws WCMException {
        String[] arrInitNames = _sAppendixValues.split(";");
        DefaultObjs objs = new DefaultObjs(null);
        if (nNum == 0 || nNum > arrInitNames.length) {
            nNum = arrInitNames.length;
        }
        objs.setPageSize(nNum);
        for (int i = 0; i < nNum; ++i) {
            String sInitName = arrInitNames[i];
            String[] arrInitName = sInitName.split(",");
            String sFileName = "";
            String sOriginalName = "";
            if (arrInitName.length <= 1) continue;
            sFileName = arrInitName[0];
            sOriginalName = arrInitName[1];
            DefaultObj obj = new DefaultObj();
            obj.setProperty("fileName", sFileName, false);
            obj.setProperty("originalFileName", sOriginalName, false);
            obj.setProperty("viewData", this.m_oMetaViewData, false);
            obj.setId(i + 1);
            obj.setAddMode(false);
            objs.addElement(obj);
        }
        return objs;
    }

    @Override
    protected boolean isValidate(PublishTagContext _o_context) throws WCMException {
        return true;
    }
}

