/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.DreamFactory;
import com.trs.cluster.ClusterConfigHelper;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.config.persistent.LaborResourceConfig;
import com.trs.components.common.publish.domain.taskdispatch.ILaborResourceMgr;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskDispatcher;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskMgr;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskRuntime;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskWorker;
import com.trs.components.common.publish.domain.taskdispatch.ThreadPool;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.infra.I18NMessage;
import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.ContainerUtil;
import org.aton.container.IClearable;
import org.aton.container.IQueue;

public class PublishTaskDispatcherImpl
extends Thread
implements IPublishTaskDispatcher,
IClearable,
IObjectLCListenerOnAdd,
IObjectLCListenerOnDel {
    private static final boolean LOAD_UNFINISH_TASK = false;
    private Logger logger = Logger.getLogger((String)PublishTaskDispatcherImpl.class.getName());
    public static int RUN_INTERVAL = 100;
    private ThreadPool m_oThreadPool;
    private IPublishTaskMgr m_publishTaskMgr = null;
    private HashMap m_hTaskRecs = null;
    private HashMap m_hRunningWorkers = null;
    private IQueue m_waitingQueue = null;
    private ILaborResourceMgr m_laborResourceMgr = null;
    private boolean m_bEnabled = false;
    private boolean m_bRunning = false;
    private boolean m_bSlaveNode = false;

    public boolean isRunning() {
        return this.m_bRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        Object object;
        if (this.m_bRunning) {
            throw new InternalError("Task dispatcher can not be cleared when running!");
        }
        if (this.m_waitingQueue != null) {
            object = this.m_waitingQueue;
            synchronized (object) {
                this.m_waitingQueue.notifyAll();
            }
            this.m_waitingQueue.clear();
        }
        if (this.m_laborResourceMgr != null) {
            object = this.m_laborResourceMgr;
            synchronized (object) {
                this.m_laborResourceMgr.notifyAll();
            }
            this.m_laborResourceMgr.clear();
        }
        if (this.m_hTaskRecs != null) {
            ContainerUtil.clearContainer((Map)this.m_hTaskRecs);
        }
        if (this.m_hRunningWorkers != null) {
            ContainerUtil.clearContainer((Map)this.m_hRunningWorkers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeDeadLock() {
        Object object;
        if (this.m_waitingQueue != null) {
            object = this.m_waitingQueue;
            synchronized (object) {
                this.m_waitingQueue.notifyAll();
            }
        }
        if (this.m_laborResourceMgr != null) {
            object = this.m_laborResourceMgr;
            synchronized (object) {
                this.m_laborResourceMgr.notifyAll();
            }
        }
    }

    @Override
    public synchronized void startup() throws WCMException {
        if (this.m_bRunning) {
            return;
        }
        ClusterConfig config = ClusterConfigHelper.getConfig();
        boolean bl = this.m_bSlaveNode = config.isEnabled() && !config.isMaster();
        if (this.m_bSlaveNode) {
            return;
        }
        try {
            if (this.m_hTaskRecs == null) {
                this.m_hTaskRecs = new HashMap();
            }
            if (this.m_hRunningWorkers == null) {
                this.m_hRunningWorkers = new HashMap();
            }
            if (this.m_waitingQueue == null) {
                this.m_waitingQueue = (IQueue)DreamFactory.createObjectById("IQueue.Publish");
            }
            LaborResourceConfig laorConfig = PublishServerConfigMapper.getLaborResourceConfig();
            if (this.m_laborResourceMgr == null) {
                this.m_laborResourceMgr = (ILaborResourceMgr)DreamFactory.createObjectById("ILaborResourceMgr.Publish");
                this.m_laborResourceMgr.configure(laorConfig);
            }
            if (this.m_oThreadPool == null) {
                this.m_oThreadPool = (ThreadPool)DreamFactory.createObjectById("PublishThreadPool");
                this.m_oThreadPool.startup(laorConfig.getHighPriorityLaborsMax() + laorConfig.getLowPriorityLaborsMax());
            }
            if (this.m_publishTaskMgr == null) {
                this.m_publishTaskMgr = (IPublishTaskMgr)DreamFactory.createObjectById("IPublishTaskMgr");
            }
            this.updateUnfinishedTasks();
            this.m_bEnabled = true;
            this.start();
            this.logger.info((Object)"Publish task dispatcher has been started!");
        }
        catch (Exception ex) {
            this.logger.error((Object)"Failed to startup the publish task dispatcher!", (Throwable)ex);
            throw new WCMException(1100, I18NMessage.get(PublishTaskDispatcherImpl.class, "PublishTaskDispatcherImpl.label1", "\u542f\u52a8\u53d1\u5e03\u4efb\u52a1\u8c03\u5ea6\u8005\u5931\u8d25"), ex);
        }
    }

    private void loadUnfinishedTasks() throws Exception {
        BaseObjs tasks = null;
        PublishTask aTask = null;
        try {
            this.logger.debug((Object)"to load unfinished publish tasks...");
            tasks = this.m_publishTaskMgr.getUnfinishedTasks();
            for (int i = 0; i < tasks.size(); ++i) {
                aTask = (PublishTask)tasks.getAt(i);
                this.pushTaskRec(aTask);
                this.logger.debug((Object)("OK to load unfinished publish task: [" + i + "] Id=" + aTask.getId() + "; Title=" + aTask.getTitle()));
            }
            this.logger.debug((Object)"All unfinished publish tasks have been loaded!");
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to load the unfinished publish tasks!", ex);
        }
        finally {
            if (tasks != null) {
                tasks.clear();
            }
        }
    }

    private void updateUnfinishedTasks() throws Exception {
        String SQL_UPDATE_TASK = "update WCMPUBLISHTASK set TASKSTATUS=10 where TASKSTATUS<7";
        DBManager.getDBManager().sqlExecuteUpdate("update WCMPUBLISHTASK set TASKSTATUS=10 where TASKSTATUS<7");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (!this.m_bRunning || this.m_bSlaveNode) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"to shutdown ...");
        }
        this.m_bEnabled = false;
        Object object = this.m_waitingQueue;
        synchronized (object) {
            this.m_waitingQueue.notifyAll();
        }
        object = this.m_laborResourceMgr;
        synchronized (object) {
            this.m_laborResourceMgr.notifyAll();
        }
        try {
            this.cancelAllRunningTasks();
        }
        catch (Exception ex) {
            this.logger.error((Object)"Failed to cancel all running tasks!", (Throwable)ex);
        }
        this.m_bRunning = false;
        this.clear();
        this.logger.info((Object)"Publish task dispatcher has been shut down.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        boolean bOverloaded = false;
        this.m_bRunning = true;
        try {
            ContextHelper.setLoginUser(User.getSystem());
            while (this.m_bEnabled) {
                Object object = this.m_waitingQueue;
                // MONITORENTER : object
                while (this.m_waitingQueue.isEmpty() && this.m_bEnabled) {
                    try {
                        this.m_waitingQueue.wait(400L);
                    }
                    catch (Exception ex) {
                        try {
                            Thread.sleep(RUN_INTERVAL);
                        }
                        catch (Exception exception) {}
                    }
                }
                // MONITOREXIT : object
                if (!this.m_bEnabled) {
                    return;
                }
                TTaskRec taskRec = this.popTaskRec();
                if (taskRec == null) continue;
                object = this.m_laborResourceMgr;
                // MONITORENTER : object
                while (this.m_bEnabled && this.m_laborResourceMgr.applyForLabor(1, taskRec.getPriority()) <= 0) {
                    try {
                        bOverloaded = true;
                        this.logger.debug((Object)"to wait for free labor ...");
                        this.m_laborResourceMgr.wait();
                        this.logger.debug((Object)"awaked by free labor.");
                    }
                    catch (Exception ex) {
                        try {
                            Thread.sleep(RUN_INTERVAL);
                        }
                        catch (Exception exception) {}
                    }
                }
                // MONITOREXIT : object
                if (!this.m_bEnabled) {
                    return;
                }
                if (bOverloaded) {
                    try {
                        this.logger.debug((Object)"System is overloaded. Let me have a rest.");
                        PublishTaskDispatcherImpl.sleep(RUN_INTERVAL);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bOverloaded = false;
                }
                if (!this.m_bEnabled) {
                    return;
                }
                this.runTask(taskRec);
            }
            return;
        }
        finally {
            this.m_bRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushTaskRec(PublishTask _task) {
        Integer key = new Integer(_task.getId());
        HashMap hashMap = this.m_hTaskRecs;
        synchronized (hashMap) {
            this.m_hTaskRecs.put(key, new TTaskRec(_task));
        }
        hashMap = this.m_waitingQueue;
        synchronized (hashMap) {
            this.m_waitingQueue.push((Object)key);
            this.m_waitingQueue.notifyAll();
        }
        this.logger.debug((Object)("task[" + _task.getId() + "] is pushed into waiting queue(Total: " + this.m_waitingQueue.size() + ")"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TTaskRec popTaskRec() {
        IQueue iQueue = this.m_waitingQueue;
        synchronized (iQueue) {
            Object key = this.m_waitingQueue.pop();
            if (key == null) {
                return null;
            }
            return (TTaskRec)this.m_hTaskRecs.get(key);
        }
    }

    private void runTask(TTaskRec _taskRec) {
        PublishTaskWorker worker = new PublishTaskWorker(this);
        worker.setTask(_taskRec.task);
        if (!this.m_oThreadPool.runIt(worker)) {
            worker.start();
        }
        _taskRec.worker = worker;
        this.logger.debug((Object)(": start to run task[" + _taskRec.task.getId() + "]: " + _taskRec.task.getDesc()));
    }

    private void cancelAllRunningTasks() {
        Iterator itr = this.m_hTaskRecs.entrySet().iterator();
        while (itr.hasNext()) {
            TTaskRec taskRec = (TTaskRec)itr.next().getValue();
            PublishTaskWorker worker = taskRec.worker;
            if (worker == null) continue;
            worker.cancel();
        }
    }

    @Override
    public void pushTask(PublishTask _task) {
        if (this.m_bSlaveNode) {
            return;
        }
        this.pushTaskRec(_task);
    }

    @Override
    public boolean cancelTask(int _nTaskId) throws WCMException {
        if (this.m_bSlaveNode) {
            try {
                IClusterMsgCenter clusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
                clusterMsgCenter.send(-1676813972, _nTaskId, 3, null);
            }
            catch (Exception e) {
                throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u6d88\u606f\u5931\u8d25\uff01", e);
            }
            return true;
        }
        return this.cancelTask0(_nTaskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelTask0(int _nTaskId) throws WCMException {
        TTaskRec taskRec = null;
        Integer key = new Integer(_nTaskId);
        try {
            HashMap hashMap = this.m_hTaskRecs;
            synchronized (hashMap) {
                taskRec = (TTaskRec)this.m_hTaskRecs.remove(key);
            }
            if (taskRec == null) {
                return true;
            }
            PublishTaskWorker worker = taskRec.worker;
            if (worker == null) {
                IQueue iQueue = this.m_waitingQueue;
                synchronized (iQueue) {
                    this.m_waitingQueue.remove((Object)key);
                }
            } else {
                worker.cancel();
            }
            taskRec = null;
            return true;
        }
        catch (Exception ex) {
            if (taskRec != null) {
                HashMap hashMap = this.m_hTaskRecs;
                synchronized (hashMap) {
                    this.m_hTaskRecs.put(key, taskRec);
                }
            }
            throw new WCMException(225, I18NMessage.get(PublishTaskDispatcherImpl.class, "PublishTaskDispatcherImpl.label2", "\u53d6\u6d88\u53d1\u5e03\u4efb\u52a1[ID=") + _nTaskId + I18NMessage.get(PublishTaskDispatcherImpl.class, "PublishTaskDispatcherImpl.label3", "]\u5931\u8d25"), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWorkerStartup(PublishTaskWorker worker) {
        if (worker == null) {
            return;
        }
        PublishTask task = worker.getTask();
        if (task == null) {
            return;
        }
        if (task.getId() <= 0) {
            return;
        }
        PublishTaskDispatcherImpl publishTaskDispatcherImpl = this;
        synchronized (publishTaskDispatcherImpl) {
            this.m_hRunningWorkers.put(new Integer(task.getId()), worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWorkerCleanup(PublishTaskWorker worker) {
        if (worker == null) {
            return;
        }
        PublishTask task = worker.getTask();
        if (task == null) {
            return;
        }
        if (task.getId() <= 0) {
            return;
        }
        Integer key = new Integer(task.getId());
        Object object = this;
        synchronized (object) {
            this.m_hRunningWorkers.remove(key);
        }
        object = this.m_hTaskRecs;
        synchronized (object) {
            this.m_hTaskRecs.remove(key);
        }
    }

    public PublishTaskWorker getRunningWorker(int iTaskID) {
        if (this.m_bSlaveNode) {
            return null;
        }
        return (PublishTaskWorker)this.m_hRunningWorkers.get(new Integer(iTaskID));
    }

    public Iterator getRunningMonitors(int iTaskID) {
        PublishTaskWorker worker = this.getRunningWorker(iTaskID);
        if (worker != null) {
            return worker.allProgressMonitor();
        }
        return null;
    }

    @Override
    public PublishTask getRunningTask(int iTaskID) {
        return null;
    }

    @Override
    public Iterator getRunningTasks() {
        return null;
    }

    @Override
    public PublishTaskRuntime getTaskRuntime(int iTaskID) {
        return null;
    }

    @Override
    public boolean pauseTask(int iTaskID) throws WCMException {
        return false;
    }

    @Override
    public boolean resumeTask(int iTaskID) throws WCMException {
        return false;
    }

    @Override
    public boolean changeTaskPriority(int iTask, int iPriority) {
        return false;
    }

    @Override
    public void notifyOnAddObj(BaseObj objAdded) throws WCMException {
        this.pushTask((PublishTask)objAdded);
    }

    @Override
    public void notifyOnDelObj(BaseObj objDeleted, int eventType) throws WCMException {
        if (!this.m_bSlaveNode) {
            this.cancelTask0(objDeleted.getId());
        }
    }

    private class TTaskRec
    implements IClearable {
        public PublishTask task;
        public PublishTaskWorker worker;

        public TTaskRec(PublishTask _task, PublishTaskWorker _worker) {
            this.task = _task;
            this.worker = _worker;
        }

        public TTaskRec(PublishTask _task) {
            this.task = _task;
            this.worker = null;
        }

        public int getPriority() {
            return this.task.getPriority();
        }

        public void clear() {
            this.task = null;
            this.worker = null;
        }
    }
}

