/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.DefaultObj;
import com.trs.cms.content.DefaultObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.tagparser.WCMTagParserDocument;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TagParserDetailPages
extends BaseTagParser4List {
    private static final String DETAIL_PAGENAME = "__DETAIL_PAGENAME__";
    private static TagBeanInfo s_TagBeanInfo = null;
    protected TagItem m_tagItem;
    Logger m_logger = Logger.getLogger(TagParserDetailPages.class);

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TBI tbi = new TBI();
            tbi.setName("TRS_DetailPages");
            tbi.setDesc("TRS_DetailPages");
            TagBeanAttrInfo tbai = new TagBeanAttrInfo();
            tbai.setName("jslinked");
            tbai.setDesc("\u662f\u5426\u4f7f\u7528JS\u8df3\u8f6c\u5206\u9875");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("URLISABS");
            tbai.setDesc("\u662f\u5426\u663e\u793a\u7edd\u5bf9\u8def\u5f84");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String[] result = super.parse(_context);
        if (_context.getAttribute("jslinked", false) && result != null && result.length == 1) {
            String detailPageName = _context.getPageContext().getExtraAttribute(DETAIL_PAGENAME);
            result[0] = result[0] + this.makeGotoPage(detailPageName);
        }
        return result;
    }

    private String makeGotoPage(String pageName) {
        StringBuffer buff = new StringBuffer(256);
        buff.append("<script>");
        buff.append("function gotoPage(_pageIndex){");
        buff.append("if(_pageIndex==${PAGE_INDEX}){return false;}");
        buff.append("var sUrl=(_pageIndex==0)?'");
        buff.append(pageName);
        buff.append("':'");
        int lastDotIndex = pageName.lastIndexOf(46);
        buff.append(pageName.substring(0, lastDotIndex));
        buff.append("_'+_pageIndex+'");
        buff.append(pageName.substring(lastDotIndex));
        buff.append("';");
        buff.append("window.location.href=sUrl;return false;");
        buff.append("}");
        buff.append("</script>");
        return buff.toString();
    }

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        CMSObj host = this.findHost(_context);
        if (!(host instanceof Document)) {
            StringBuffer sb = new StringBuffer(256);
            sb.append(this.m_tagItem.getDescWithPos()).append(I18NMessage.get(WCMTagParserDocument.class, "TagParserDetailPages.label1", "\u7f6e\u6807\u4f7f\u7528\u7684\u573a\u666f\u4e0d\u5bf9,"));
            _context.addWarning(sb.toString());
            return new DefaultObjs(null);
        }
        Document document = (Document)host;
        String[] results = this.separatePages(_context, document.getHtmlContent());
        if (results == null || results.length == 0) {
            return new DefaultObjs(null);
        }
        IPublishContent content = (IPublishContent)_context.getUpperHost();
        String url = _context.getPathCompass().getHttpUrl(content, 0);
        String fileName = url.substring(url.lastIndexOf(47) + 1);
        _context.getPageContext().setExtraAttribute(DETAIL_PAGENAME, fileName);
        boolean zJsLinked = _context.getAttribute("jslinked", false);
        boolean bURLisAbs = _context.getAttribute("URLISABS", false);
        String sPatentLink = url.substring(0, url.lastIndexOf(47) + 1);
        DefaultObjs currObjs = new DefaultObjs(null, results.length, 1);
        int len = results.length;
        for (int i = 0; i < len; ++i) {
            DefaultObj obj = new DefaultObj();
            obj.setProperty("Title", results[i], false);
            String sCurrLink = (String)this.makeUrl(fileName, i, zJsLinked);
            obj.setProperty("_RECURL", bURLisAbs ? sPatentLink + sCurrLink : sCurrLink, false);
            obj.setId(1000 + i);
            obj.setAddMode(false);
            currObjs.addElement(obj);
        }
        return currObjs;
    }

    private Object makeUrl(String fileName, int pageIndex, boolean zJsLinked) {
        if (zJsLinked) {
            return "javascript:return gotoPage(" + pageIndex + ");";
        }
        if (pageIndex == 0) {
            return fileName;
        }
        int lastDotIndex = fileName.lastIndexOf(46);
        return fileName.substring(0, lastDotIndex) + '_' + pageIndex + fileName.substring(lastDotIndex);
    }

    public String[] separatePages(PublishTagContext _context, String _sText) {
        if (CMyString.isEmpty(_sText)) {
            return new String[0];
        }
        HtmlElementFinder finder = new HtmlElementFinder(_sText);
        String tagName = "TRS_PAGE_SEPARATOR";
        ArrayList<String> pages = new ArrayList<String>();
        HtmlElement page = null;
        boolean zFirst = true;
        while ((page = finder.findNextElement("TRS_PAGE_SEPARATOR", true)) != null) {
            if (zFirst) {
                zFirst = false;
                pages.add(CMyString.showEmpty(page.getAttributeValue("firstPageTitle")));
            }
            pages.add(CMyString.showEmpty(page.getAttributeValue("pageTitle")));
        }
        String[] result = new String[pages.size()];
        pages.toArray(result);
        return result;
    }

    @Override
    protected boolean isValidate(PublishTagContext _context) throws WCMException {
        return true;
    }

    protected CMSObj findHost(PublishTagContext _context) throws WCMException {
        IPublishElement content = _context.getUpperHost();
        if (content == null) {
            throw new WCMException(234, "Upper host object required in tag context!");
        }
        return content.getSubstance();
    }

    private class TBI
    extends TagBeanInfo {
        private TBI() {
        }

        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult) {
        }
    }
}

