/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.Locker;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class LockManager {
    private static final String SQL_INS = "insert into WCMCLUSTERLOCK(OBJTYPE,OBJID,LOCKEDUSER,LOCKEDTIME) values(?,?,?,?)";
    private static final String SQL_DEL = "delete from WCMCLUSTERLOCK where OBJTYPE=? and OBJID=? and LOCKEDUSER=?";
    private static final String SQL_DEL_BY_OBJ = "delete from WCMCLUSTERLOCK where OBJTYPE=? and OBJID=?";
    private static final LockManager INSTANCE = new LockManager();
    private static Logger logger = Logger.getLogger(LockManager.class);

    private LockManager() {
    }

    public static LockManager instance() {
        return INSTANCE;
    }

    public Locker getLocker(CMSObj _obj, boolean _bCreateWhenNotExists) {
        if (_obj == null || !_obj.isValidInstance()) {
            return null;
        }
        return this.getLocker(_obj.getWCMType(), _obj.getId(), _bCreateWhenNotExists);
    }

    public Locker getLocker(int _nObjType, int _nObjId, boolean _bCreateWhenNotExists) {
        Locker locker = this.findGlobalLock(_nObjType, _nObjId);
        if (locker != null) {
            return locker;
        }
        if (_bCreateWhenNotExists) {
            return this.globalLock(_nObjType, _nObjId);
        }
        return locker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Locker findGlobalLock(int _nObjType, int _nObjId) {
        String sql = "select LOCKEDUSER, LOCKEDTIME from WCMCLUSTERLOCK where OBJTYPE=? and OBJID=?";
        DBManager dbmanager = DBManager.getDBManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean bNeedDeleteLocker = false;
        String sLockerUserName = null;
        User lockerUser = null;
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, _nObjType);
            pstmt.setInt(2, _nObjId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Locker locker;
                boolean bLockerTimeout;
                sLockerUserName = rs.getString(1);
                lockerUser = User.findByName(sLockerUserName);
                if (lockerUser == null) {
                    bNeedDeleteLocker = true;
                    Locker locker2 = null;
                    return locker2;
                }
                long lCurrTimeMillis = System.currentTimeMillis();
                Timestamp dtExpireTime = rs.getTimestamp(2);
                long lValidTime = ((Date)dtExpireTime).getTime();
                boolean bl = bLockerTimeout = lValidTime < lCurrTimeMillis;
                if (bLockerTimeout) {
                    bNeedDeleteLocker = true;
                    Locker locker3 = null;
                    return locker3;
                }
                Locker locker4 = locker = new Locker(lockerUser, dtExpireTime);
                return locker4;
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to query lock info[Type" + _nObjType + ",Id=" + _nObjId + "]"), (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanager.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
            if (bNeedDeleteLocker) {
                this.globalUnlockByObj(_nObjType, _nObjId);
            }
        }
        return null;
    }

    public Locker removeLocker(CMSObj _obj) {
        if (_obj == null || _obj.isAddMode()) {
            return null;
        }
        return this.removeLocker(_obj.getWCMType(), _obj.getId());
    }

    public Locker removeLocker(int _nObjType, int _nObjId) {
        Locker locker = this.findGlobalLock(_nObjType, _nObjId);
        if (!(locker == null || locker.lockUserIs(ContextHelper.getLoginUser()) && this.globalUnlock(_nObjType, _nObjId))) {
            locker = null;
        }
        return locker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeLockedObjBy(User _currUser) {
        if (_currUser == null) {
            return;
        }
        String sql = "delete from WCMCLUSTERLOCK where LOCKEDUSER=?";
        DBManager dbmanager = DBManager.getDBManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, _currUser.getName());
            pstmt.executeUpdate();
        }
        catch (Exception exception) {
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanager.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockedObjIds(int _nObjType) {
        String sql = "select OBJTID from WCMCLUSTERLOCK where OBJTYPE=?";
        DBManager dbmanager = DBManager.getDBManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, _nObjType);
            rs = pstmt.executeQuery();
            StringBuffer buff = new StringBuffer(128);
            while (rs.next()) {
                buff.append(',').append(rs.getInt(1));
            }
            String string = buff.substring(1);
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanager.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Locker globalLock(int _nObjType, int _nObjId) {
        DBManager dbmanager = DBManager.getDBManager();
        PreparedStatement pstmt = null;
        Connection conn = null;
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(SQL_INS);
            User loginUser = ContextHelper.getLoginUser();
            pstmt.setInt(1, _nObjType);
            pstmt.setInt(2, _nObjId);
            pstmt.setString(3, loginUser.getName());
            long endTimeMillis = System.currentTimeMillis() + (long)(Locker.DEF_LOCKTIMEOUT * 1000);
            Timestamp dtExpireTime = new Timestamp(endTimeMillis);
            pstmt.setTimestamp(4, dtExpireTime);
            if (pstmt.executeUpdate() != 1) {
                Locker locker = null;
                return locker;
            }
            Locker locker = new Locker(loginUser, dtExpireTime);
            return locker;
        }
        catch (Exception ex) {
            logger.error((Object)("failed to lock obj[Type=" + _nObjType + ",Id=" + _nObjId + "]"), (Throwable)ex);
            Locker locker = null;
            return locker;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanager.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean globalUnlock(int _nObjType, int _nObjId) {
        DBManager dbmanager = DBManager.getDBManager();
        PreparedStatement pstmt = null;
        Connection conn = null;
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(SQL_DEL);
            pstmt.setInt(1, _nObjType);
            pstmt.setInt(2, _nObjId);
            pstmt.setString(3, ContextHelper.getLoginUser().getName());
            boolean bl = pstmt.executeUpdate() == 1;
            return bl;
        }
        catch (Exception ex) {
            logger.error((Object)("failed to unlock obj[Type" + _nObjType + ",Id=" + _nObjId + "]"), (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanager.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean globalUnlockByObj(int _nObjType, int _nObjId) {
        DBManager dbmanager = DBManager.getDBManager();
        PreparedStatement pstmt = null;
        Connection conn = null;
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(SQL_DEL_BY_OBJ);
            pstmt.setInt(1, _nObjType);
            pstmt.setInt(2, _nObjId);
            boolean bl = pstmt.executeUpdate() == 1;
            return bl;
        }
        catch (Exception ex) {
            logger.error((Object)("failed to unlock obj[Type" + _nObjType + ",Id=" + _nObjId + "]"), (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanager.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
    }
}

