/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent.validator;

import com.trs.idm.exception.FileReadException;
import com.trs.idm.exception.NoSuchFileException;
import com.trs.idm.interact.agent.AgentBase;
import com.trs.idm.interact.agent.validator.AgentConfigItem;
import com.trs.idm.interact.agent.validator.IAgentPropertiesValidator;
import com.trs.idm.util.PropertyUtil;
import com.trs.idm.util.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FilterAgentPropertiesValidator
implements IAgentPropertiesValidator {
    private static final Logger LOG = Logger.getLogger(FilterAgentPropertiesValidator.class);
    private Properties agentConfigProperties;
    private List necessaryItems;
    private List errorItems;
    StringBuffer detailCheckResult;

    public FilterAgentPropertiesValidator() {
        this.init();
    }

    private void init() {
        this.detailCheckResult = new StringBuffer(256);
        try {
            this.agentConfigProperties = PropertyUtil.assertAndLoadFromResource(AgentBase.class, "/trsids-agent.properties");
        }
        catch (NoSuchFileException e) {
            LOG.error((Object)"trsids-agent.properties is not exist !!!!!!!!!", (Throwable)e);
            this.detailCheckResult.append("trsids-agent.properties \u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5b58\u5728\u8be5\u6587\u4ef6\uff01");
            return;
        }
        catch (FileReadException e) {
            LOG.error((Object)"read trsids-agent.properties error !!!!!!!!!", (Throwable)e);
            this.detailCheckResult.append("trsids-agent.properties \u65e0\u6cd5\u8bfb\u53d6\uff0c\u8bf7\u786e\u8ba4\u8be5\u6587\u4ef6\u662f\u5426\u6b63\u88ab\u5176\u4ed6\u7a0b\u5e8f\u9501\u5b9a\uff01");
            return;
        }
        this.necessaryItems = this.initNecessaryItems();
        this.errorItems = new ArrayList();
    }

    private List initNecessaryItems() {
        ArrayList<AgentConfigItem> items = new ArrayList<AgentConfigItem>();
        AgentConfigItem agentNameItem = new AgentConfigItem();
        agentNameItem.setName("agent.name");
        agentNameItem.setNotNull(true);
        agentNameItem.setDesc("\u534f\u4f5c\u5e94\u7528\u540d(\u82f1\u6587)\uff0c\u5fc5\u987b\u548c\u5728\u6240\u8981\u8fde\u63a5IDS\u4e0a\u6ce8\u518c\u7684\u534f\u4f5c\u5e94\u7528\u540d\u4fdd\u6301\u4e00\u81f4\u3002");
        AgentConfigItem idsHostItem = new AgentConfigItem();
        idsHostItem.setName("idm.server.host");
        idsHostItem.setNotNull(true);
        idsHostItem.setDesc("\u6240\u8981\u8fde\u63a5IDS\u7684IP(\u6216\u4e3b\u673a)\uff0c\u5982\u679c\u8981\u8fde\u63a5\u7684IDS\u670d\u52a1\u5668\u4e3a\u96c6\u7fa4\uff0cIP\u5730\u5740\u4ee5\u7a7a\u683c\u9694\u5f00\u3002 ");
        AgentConfigItem idsPortItem = new AgentConfigItem();
        idsPortItem.setName("idm.server.port");
        idsPortItem.setNotNull(true);
        idsPortItem.setDesc("\u6240\u8981\u8fde\u63a5IDS\u7684\u7aef\u53e3\uff0c\u7aef\u53e3\u5fc5\u9700\u4e3a\u6570\u5b57\uff0c\u5e76\u4e14\u503c\u5728 1024 \u548c  65535\u4e4b\u95f4\u3002IDS\u9ed8\u8ba4\u7aef\u53e3\u4e3a2005\u3002");
        AgentConfigItem actorClassItem = new AgentConfigItem();
        actorClassItem.setName("coAppActor.className");
        actorClassItem.setNotNull(true);
        actorClassItem.setDesc("\u534f\u4f5c\u5e94\u7528\u5b9e\u73b0\u7684IDS\u56de\u8c03\u63a5\u53e3\u7684\u7c7b\u540d\u79f0(\u5305\u62ec\u5305\u8def\u5f84\u7684\u7c7b\u540d)\u3002\u8981\u6c42\u8be5\u7c7b\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u3002");
        AgentConfigItem loginActionUriItem = new AgentConfigItem();
        loginActionUriItem.setName("loginAction.uri");
        loginActionUriItem.setNotNull(true);
        loginActionUriItem.setDesc("\u534f\u4f5c\u5e94\u7528\u7684\u81ea\u6709\u767b\u5f55\u9875\u9762\u7684form action\u94fe\u63a5\uff0c\u5373\u5e94\u7528\u539f\u6709\u767b\u5f55\u9875\u9762\u4e0a\uff0c\u7528\u6237\u540d\u548c\u5bc6\u7801\u63d0\u4ea4\u7684aciton\u7684URI\u3002");
        items.add(agentNameItem);
        items.add(idsHostItem);
        items.add(idsPortItem);
        items.add(actorClassItem);
        items.add(loginActionUriItem);
        return items;
    }

    @Override
    public boolean check() {
        this.detailCheckResult = new StringBuffer(256);
        this.errorItems = new ArrayList();
        for (AgentConfigItem necessaryItem : this.necessaryItems) {
            if (this.agentConfigProperties.get(necessaryItem.getName()) != null) continue;
            AgentConfigItem missingItem = new AgentConfigItem();
            missingItem.setName(necessaryItem.getName());
            missingItem.setNotNull(necessaryItem.isNotNull());
            missingItem.setDesc(necessaryItem.getDesc());
            missingItem.setError(true);
            missingItem.setErrorMessage("\u65e0\u6cd5\u627e\u5230\u8be5\u914d\u7f6e\u9879\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u9879\u662f\u5426\u5728  trsids-agent.properties \u4e2d\u5b58\u5728\uff01");
            this.errorItems.add(missingItem);
        }
        this.checkIdmHost();
        this.checkAgentName();
        this.checkIDSPort();
        this.checkActorClass();
        this.checkLoginActionUrl();
        if (this.hasErrorItem()) {
            LOG.error((Object)"Error Config in trsids-agent.properties !!!!!!!!");
            LOG.error((Object)("all error items: " + this.errorItems));
            return false;
        }
        return true;
    }

    private void checkIdmHost() {
        if ("".equals(this.agentConfigProperties.get("idm.server.host"))) {
            AgentConfigItem emptyItem = new AgentConfigItem();
            emptyItem.setName("idm.server.host");
            emptyItem.setNotNull(true);
            emptyItem.setDesc("\u6240\u8981\u8fde\u63a5IDS\u7684IP(\u6216\u4e3b\u673a)\uff0c\u5982\u679c\u8981\u8fde\u63a5\u7684IDS\u670d\u52a1\u5668\u4e3a\u96c6\u7fa4\uff0cIP\u5730\u5740\u4ee5\u7a7a\u683c\u9694\u5f00\u3002 ");
            emptyItem.setError(true);
            emptyItem.setErrorMessage("\u914d\u7f6e\u9879\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            this.errorItems.add(emptyItem);
        }
    }

    private void checkAgentName() {
        if ("".equals(this.agentConfigProperties.get("agent.name"))) {
            AgentConfigItem emptyItem = new AgentConfigItem();
            emptyItem.setName("agent.name");
            emptyItem.setNotNull(true);
            emptyItem.setDesc("\u534f\u4f5c\u5e94\u7528\u540d(\u82f1\u6587)\uff0c\u5fc5\u987b\u548c\u5728\u6240\u8981\u8fde\u63a5IDS\u4e0a\u6ce8\u518c\u7684\u534f\u4f5c\u5e94\u7528\u540d\u4fdd\u6301\u4e00\u81f4\u3002");
            emptyItem.setError(true);
            emptyItem.setErrorMessage("\u914d\u7f6e\u9879\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            this.errorItems.add(emptyItem);
        }
    }

    private void checkIDSPort() {
        int port = PropertyUtil.getPropertyAsInt(this.agentConfigProperties, "idm.server.port", 2005);
        if (port <= 1024 || port > 65535) {
            AgentConfigItem errorItem = new AgentConfigItem();
            errorItem.setName("idm.server.port");
            errorItem.setValue(new Integer(port).toString());
            errorItem.setNotNull(true);
            errorItem.setDesc("\u6240\u8981\u8fde\u63a5IDS\u7684\u7aef\u53e3\uff0c\u7aef\u53e3\u5fc5\u9700\u4e3a\u6570\u5b57\uff0c\u5e76\u4e14\u503c\u5728 1024 \u548c  65535\u4e4b\u95f4\u3002IDS\u9ed8\u8ba4\u7aef\u53e3\u4e3a2005\u3002");
            errorItem.setError(true);
            errorItem.setErrorMessage("\u7aef\u53e3\u7684\u503c\u5fc5\u9700\u5728 1024 \u548c  65535\u4e4b\u95f4");
            this.errorItems.add(errorItem);
        }
    }

    private void checkActorClass() {
        String coAppClassName = this.agentConfigProperties.getProperty("coAppActor.className");
        AgentConfigItem errorItem = new AgentConfigItem();
        errorItem.setName("coAppActor.className");
        errorItem.setValue(coAppClassName);
        errorItem.setNotNull(true);
        errorItem.setDesc("\u534f\u4f5c\u5e94\u7528\u5b9e\u73b0\u7684IDS\u56de\u8c03\u63a5\u53e3\u7684\u7c7b\u540d\u79f0(\u5305\u62ec\u5305\u8def\u5f84\u7684\u7c7b\u540d)\u3002\u8981\u6c42\u8be5\u7c7b\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u3002");
        errorItem.setError(true);
        if (StringHelper.isEmpty(coAppClassName)) {
            errorItem.setErrorMessage("\u914d\u7f6e\u9879\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            this.errorItems.add(errorItem);
            return;
        }
        try {
            Class.forName(coAppClassName).newInstance();
        }
        catch (Throwable t) {
            LOG.error((Object)"can not load \u534f\u4f5c\u5e94\u7528\u5b9e\u73b0\u7684IDS\u56de\u8c03\u63a5\u53e3\u7684\u7c7b\u540d\u79f0(\u5305\u62ec\u5305\u8def\u5f84\u7684\u7c7b\u540d)\u3002\u8981\u6c42\u8be5\u7c7b\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u3002 which is defined in trsids-agent.properties", t);
            errorItem.setErrorMessage("\u65e0\u6cd5\u52a0\u8f7d " + coAppClassName + ", \u8bf7\u786e\u8ba4\u8be5\u914d\u7f6e\u9879\u5bf9\u5e94\u7684\u7c7b\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\uff01 ");
            this.errorItems.add(errorItem);
            return;
        }
    }

    private void checkLoginActionUrl() {
        String loginActionUri = this.agentConfigProperties.getProperty("loginAction.uri");
        AgentConfigItem errorItem = new AgentConfigItem();
        errorItem.setName("loginAction.uri");
        errorItem.setValue(loginActionUri);
        errorItem.setNotNull(true);
        errorItem.setDesc("\u534f\u4f5c\u5e94\u7528\u7684\u81ea\u6709\u767b\u5f55\u9875\u9762\u7684form action\u94fe\u63a5\uff0c\u5373\u5e94\u7528\u539f\u6709\u767b\u5f55\u9875\u9762\u4e0a\uff0c\u7528\u6237\u540d\u548c\u5bc6\u7801\u63d0\u4ea4\u7684aciton\u7684URI\u3002");
        errorItem.setError(true);
        if (StringHelper.isEmpty(loginActionUri)) {
            errorItem.setErrorMessage("\u914d\u7f6e\u9879\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            this.errorItems.add(errorItem);
            return;
        }
    }

    @Override
    public String getDetailCheckResult() {
        if (this.hasErrorItem()) {
            this.detailCheckResult.append(" IDS Agent\u914d\u7f6e\u9519\u8bef\uff0c\u5bfc\u81f4Agent\u542f\u52a8\u5931\u8d25 \uff01 ");
        }
        return this.detailCheckResult.toString();
    }

    @Override
    public boolean hasErrorItem() {
        return this.errorItems != null && this.errorItems.size() > 0;
    }

    @Override
    public List listAllErrorItem() {
        return this.errorItems;
    }

    @Override
    public Properties getAgentConfigProperties() {
        return this.agentConfigProperties;
    }

    @Override
    public void addErrorItem(AgentConfigItem errorItem) {
        if (errorItem != null || this.errorItems != null) {
            this.errorItems.add(errorItem);
        }
    }
}

