/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.util.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static Document loadDocument(String file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(file);
    }

    public static void saveDocument(Document dom, String file) throws TransformerException, IOException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("doctype-public", dom.getDoctype().getPublicId());
        transformer.setOutputProperty("doctype-system", dom.getDoctype().getSystemId());
        DOMSource source = new DOMSource(dom);
        StreamResult result = new StreamResult();
        FileOutputStream outputStream = new FileOutputStream(file);
        result.setOutputStream(outputStream);
        transformer.transform(source, result);
        outputStream.flush();
        outputStream.close();
    }

    public static void removeChildren(Node node) {
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        int i = length - 1;
        while (i > -1) {
            node.removeChild(childNodes.item(i));
            --i;
        }
    }
}

