/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmlutils;

import java.util.Hashtable;

public class XMLName {
    public static String SEPARATOR = "^";
    private static String COLON = ":";
    private static String XML = "xml";
    private static String XMLNS = "xmlns";
    private static String W3CNAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private String local;
    private String qualified;
    private String universal;
    private String prefix;
    private String uri;

    private XMLName() {
    }

    public static XMLName create(String string, String string2, String string3) {
        if (string3 != null && string == null) {
            throw new IllegalArgumentException("If prefix is non-null, URI must not be null.");
        }
        String string4 = string != null && string3 == null ? null : XMLName.getQualifiedName(string3, string2);
        String string5 = XMLName.getUniversalName(string, string2);
        XMLName xMLName = new XMLName();
        xMLName.local = string2;
        xMLName.prefix = string3;
        xMLName.uri = string;
        xMLName.qualified = string4;
        xMLName.universal = string5;
        return xMLName;
    }

    public static XMLName create(String string, String string2) {
        return XMLName.create(string, string2, null);
    }

    public static XMLName create(String string, Hashtable hashtable) {
        String string2 = string;
        String string3 = null;
        String string4 = null;
        XMLName.checkQualifiedName(string);
        int n = string.indexOf(COLON);
        if (n == -1) {
            if (hashtable != null && (string4 = (String)hashtable.get("")) != null) {
                string3 = "";
            }
        } else {
            if (hashtable == null) {
                throw new IllegalArgumentException("Argument uris must not be null when the qualified name contains a prefix.");
            }
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
            if (string3.toLowerCase().equals(XML)) {
                string4 = W3CNAMESPACE;
            } else if (!string3.toLowerCase().equals(XMLNS) && (string4 = (String)hashtable.get(string3)) == null) {
                throw new IllegalArgumentException("No namespace URI corresponding to prefix: " + string3);
            }
        }
        return XMLName.create(string4, string2, string3);
    }

    public static XMLName create(String string) {
        return XMLName.create(XMLName.getURIFromUniversal(string), XMLName.getLocalFromUniversal(string));
    }

    public static String getQualifiedName(String string, String string2) {
        XMLName.checkLocalName(string2);
        XMLName.checkPrefix(string);
        if (string == null || string.length() == 0) {
            return string2;
        }
        return String.valueOf(string) + COLON + string2;
    }

    public static String getQualifiedName(String string, Hashtable hashtable) {
        String string2 = XMLName.getURIFromUniversal(string);
        String string3 = XMLName.getLocalFromUniversal(string);
        if (string2 == null) {
            return string3;
        }
        if (hashtable == null) {
            throw new IllegalArgumentException("prefixes argument cannot be null when the universal name contains a URI.");
        }
        String string4 = (String)hashtable.get(string2);
        if (string4 == null) {
            throw new IllegalArgumentException("No prefix corresponding to the namespace URI: " + string2);
        }
        if (string4.length() == 0) {
            return string3;
        }
        return String.valueOf(string4) + COLON + string3;
    }

    public static String getUniversalName(String string, String string2) {
        XMLName.checkLocalName(string2);
        XMLName.checkURI(string);
        if (string == null) {
            return string2;
        }
        return String.valueOf(string) + SEPARATOR + string2;
    }

    public static String getUniversalName(String string, Hashtable hashtable) {
        String string2 = string;
        String string3 = null;
        String string4 = null;
        XMLName.checkQualifiedName(string);
        int n = string.indexOf(COLON);
        if (n == -1) {
            if (hashtable != null) {
                string4 = (String)hashtable.get("");
            }
        } else {
            if (hashtable == null) {
                throw new IllegalArgumentException("Argument uris must not be null when the qualified name contains a prefix.");
            }
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
            if (string3.toLowerCase().equals(XML)) {
                string4 = W3CNAMESPACE;
            } else if (!string3.toLowerCase().equals(XMLNS) && (string4 = (String)hashtable.get(string3)) == null) {
                throw new IllegalArgumentException("No namespace URI corresponding to prefix: " + string3);
            }
        }
        return XMLName.getUniversalName(string2, string4);
    }

    public static String getPrefixFromQualified(String string) {
        XMLName.checkQualifiedName(string);
        int n = string.indexOf(COLON);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getLocalFromQualified(String string) {
        XMLName.checkQualifiedName(string);
        int n = string.indexOf(COLON);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getURIFromUniversal(String string) {
        XMLName.checkUniversalName(string);
        int n = string.indexOf(SEPARATOR);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getLocalFromUniversal(String string) {
        XMLName.checkUniversalName(string);
        int n = string.indexOf(SEPARATOR);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public final String getLocalName() {
        return this.local;
    }

    public final String getQualifiedName() {
        if (this.qualified == null) {
            throw new IllegalStateException("Cannot return the qualified name when the prefix is not set.");
        }
        return this.qualified;
    }

    public final String getUniversalName() {
        return this.universal;
    }

    public final String getPrefix() {
        if (this.qualified == null) {
            throw new IllegalStateException("The prefix has not been set.");
        }
        return this.prefix;
    }

    public final String getURI() {
        return this.uri;
    }

    public final void setPrefix(String string) {
        if (this.uri == null) {
            throw new IllegalStateException("Cannot set the prefix when the URI is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("prefix argument must be non-null.");
        }
        this.qualified = XMLName.getQualifiedName(this.local, string);
        this.prefix = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof XMLName)) {
            return false;
        }
        String string = ((XMLName)object).getURI();
        if (this.uri == null ? string != null : !this.uri.equals(string)) {
            return false;
        }
        return this.local.equals(((XMLName)object).getLocalName());
    }

    public int hashCode() {
        return this.universal.hashCode();
    }

    private static void checkLocalName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Local name cannot be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Local name must have non-zero length.");
        }
        if (string.indexOf(COLON) != -1) {
            throw new IllegalArgumentException("Local name contains a colon: " + string);
        }
        if (string.indexOf(SEPARATOR) != -1) {
            throw new IllegalArgumentException("Local name contains a caret: " + string);
        }
    }

    private static void checkPrefix(String string) {
        if (string == null) {
            return;
        }
        if (string.indexOf(COLON) != -1) {
            throw new IllegalArgumentException("Prefix contains a colon: " + string);
        }
        if (string.indexOf(SEPARATOR) != -1) {
            throw new IllegalArgumentException("Prefix contains a caret: " + string);
        }
    }

    private static void checkURI(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Namespace URI must have non-zero length.");
        }
        if (string.indexOf(SEPARATOR) != -1) {
            throw new IllegalArgumentException("Namespace URI contains a caret: " + string);
        }
    }

    private static void checkQualifiedName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Qualified name cannot be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Qualified name must have non-zero length.");
        }
        int n = string.indexOf(COLON);
        if (n == -1) {
            XMLName.checkLocalName(string);
            return;
        }
        XMLName.checkPrefix(string.substring(0, n));
        XMLName.checkLocalName(string.substring(n + 1));
    }

    private static void checkUniversalName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Universal name cannot be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Universal name must have non-zero length.");
        }
        int n = string.indexOf(SEPARATOR);
        if (n == -1) {
            XMLName.checkLocalName(string);
            return;
        }
        XMLName.checkURI(string.substring(0, n));
        XMLName.checkLocalName(string.substring(n + 1));
    }
}

