/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.filters;

import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.filters.RelatedTableFilter;
import org.xmlmiddleware.xmldbms.maps.ClassTableMap;
import org.xmlmiddleware.xmldbms.maps.LinkInfo;
import org.xmlmiddleware.xmldbms.maps.PropertyTableMap;
import org.xmlmiddleware.xmldbms.maps.RelatedClassTableMap;
import org.xmlmiddleware.xmldbms.maps.Table;

public class TableFilter {
    private static String SEMICOLON = ";";
    private ClassTableMap classTableMap;
    private Hashtable relatedTableFilters = new Hashtable();

    protected TableFilter(ClassTableMap classTableMap) {
        this.classTableMap = classTableMap;
    }

    public final Table getTable() {
        return this.classTableMap.getTable();
    }

    public final RelatedTableFilter getRelatedTableFilter(String string, String string2, String string3, String string4, String string5, String string6) throws XMLMiddlewareException {
        String string7 = this.getHashName(string, string2, string3, string4, string5, string6);
        return (RelatedTableFilter)this.relatedTableFilters.get(string7);
    }

    public final RelatedTableFilter getRelatedTableFilter(RelatedClassTableMap relatedClassTableMap) {
        String string = this.getHashName(relatedClassTableMap.getClassTableMap().getTable(), relatedClassTableMap.getLinkInfo());
        return (RelatedTableFilter)this.relatedTableFilters.get(string);
    }

    public final RelatedTableFilter getRelatedTableFilter(PropertyTableMap propertyTableMap) {
        String string = this.getHashName(propertyTableMap.getTable(), propertyTableMap.getLinkInfo());
        return (RelatedTableFilter)this.relatedTableFilters.get(string);
    }

    public final Enumeration getRelatedTableFilters() {
        return this.relatedTableFilters.elements();
    }

    public RelatedTableFilter createRelatedTableFilter(String string, String string2, String string3, String string4, String string5, String string6) throws XMLMiddlewareException {
        LinkInfo linkInfo;
        Table table;
        Object object = this.getRelatedTableMap(string, string2, string3, string4, string5, string6);
        if (object instanceof PropertyTableMap) {
            PropertyTableMap propertyTableMap = (PropertyTableMap)object;
            table = propertyTableMap.getTable();
            linkInfo = propertyTableMap.getLinkInfo();
        } else {
            RelatedClassTableMap relatedClassTableMap = (RelatedClassTableMap)object;
            table = relatedClassTableMap.getClassTableMap().getTable();
            linkInfo = relatedClassTableMap.getLinkInfo();
        }
        String string7 = this.getHashName(table, linkInfo);
        if (this.relatedTableFilters.get(string7) != null) {
            throw new XMLMiddlewareException("Related table filter already exists for " + Table.getUniversalName(string, string2, string3, string4) + " with the parent key name '" + string5 + "' and the child key name '" + string6 + "'.");
        }
        RelatedTableFilter relatedTableFilter = new RelatedTableFilter(table, linkInfo.getParentKey().getName(), linkInfo.getChildKey().getName());
        this.relatedTableFilters.put(string7, relatedTableFilter);
        return relatedTableFilter;
    }

    public void removeRelatedTableFilter(String string, String string2, String string3, String string4, String string5, String string6) throws XMLMiddlewareException {
        String string7 = this.getHashName(string, string2, string3, string4, string5, string6);
        if (this.relatedTableFilters.remove(string7) == null) {
            throw new XMLMiddlewareException("Related table filter not found for " + Table.getUniversalName(string, string2, string3, string4) + " with the parent key name '" + string5 + "' and the child key name '" + string6 + "'.");
        }
    }

    public void removeAllRelatedTableFilters() {
        this.relatedTableFilters.clear();
    }

    private Object getRelatedTableMap(String string, String string2, String string3, String string4, String string5, String string6) throws XMLMiddlewareException {
        RelatedClassTableMap relatedClassTableMap = null;
        if (string5 == null && string6 != null || string5 != null && string6 == null) {
            throw new IllegalArgumentException("Parent key name and child key name must both be null or both be non-null.");
        }
        PropertyTableMap propertyTableMap = this.classTableMap.getPropertyTableMap(string, string2, string3, string4);
        if (propertyTableMap != null) {
            LinkInfo linkInfo = propertyTableMap.getLinkInfo();
            if (!(string5 == null || string5.equals(linkInfo.getParentKey().getName()) && string6.equals(linkInfo.getChildKey().getName()))) {
                throw new XMLMiddlewareException("The property table " + Table.getUniversalName(string, string2, string3, string4) + " is not linked to the class table " + this.classTableMap.getTable().getUniversalName() + " with the keys named " + string5 + " and " + string6);
            }
            return propertyTableMap;
        }
        int n = 0;
        Enumeration enumeration = this.classTableMap.getRelatedClassTableMap(string, string2, string3, string4);
        while (enumeration.hasMoreElements()) {
            relatedClassTableMap = (RelatedClassTableMap)enumeration.nextElement();
            ++n;
        }
        if (relatedClassTableMap == null) {
            throw new XMLMiddlewareException("The table " + Table.getUniversalName(string, string2, string3, string4) + " does not appear as a related class table or property table of the class table " + this.classTableMap.getTable().getUniversalName());
        }
        if (n == 1) {
            LinkInfo linkInfo = relatedClassTableMap.getLinkInfo();
            if (!(string5 == null || string5.equals(linkInfo.getParentKey().getName()) && string6.equals(linkInfo.getChildKey().getName()))) {
                throw new XMLMiddlewareException("The related class table " + Table.getUniversalName(string, string2, string3, string4) + " is never linked to the class table " + this.classTableMap.getTable().getUniversalName() + " with the keys named " + string5 + " and " + string6);
            }
        } else {
            if (string5 == null) {
                throw new XMLMiddlewareException(String.valueOf(Table.getUniversalName(string, string2, string3, string4)) + " appears more than once as a related class table of " + this.classTableMap.getTable().getUniversalName() + ". In this case, you must provide the names of the parent and child keys used to link the two tables.");
            }
            boolean bl = false;
            enumeration = this.classTableMap.getRelatedClassTableMap(string, string2, string3, string4);
            while (enumeration.hasMoreElements()) {
                relatedClassTableMap = (RelatedClassTableMap)enumeration.nextElement();
                LinkInfo linkInfo = relatedClassTableMap.getLinkInfo();
                if (!linkInfo.getParentKey().getName().equals(string5) || !linkInfo.getChildKey().getName().equals(string6)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new XMLMiddlewareException(String.valueOf(Table.getUniversalName(string, string2, string3, string4)) + " does not appear as a related table of " + this.classTableMap.getTable().getUniversalName() + " linked with the keys " + string5 + " and " + string6 + ".");
            }
        }
        return relatedClassTableMap;
    }

    private String getHashName(String string, String string2, String string3, String string4, String string5, String string6) throws XMLMiddlewareException {
        Object object = this.getRelatedTableMap(string, string2, string3, string4, string5, string6);
        if (object instanceof PropertyTableMap) {
            PropertyTableMap propertyTableMap = (PropertyTableMap)object;
            return this.getHashName(propertyTableMap.getTable(), propertyTableMap.getLinkInfo());
        }
        RelatedClassTableMap relatedClassTableMap = (RelatedClassTableMap)object;
        return this.getHashName(relatedClassTableMap.getClassTableMap().getTable(), relatedClassTableMap.getLinkInfo());
    }

    private String getHashName(Table table, LinkInfo linkInfo) {
        String string = Integer.toString(linkInfo.getParentKey().getName().hashCode());
        String string2 = Integer.toString(linkInfo.getParentKey().getName().hashCode());
        return String.valueOf(table.getHashName()) + SEMICOLON + string + SEMICOLON + string2;
    }
}

