/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.filters;

import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.filters.TableFilter;
import org.xmlmiddleware.xmldbms.maps.ClassTableMap;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;

public class FilterBase {
    protected XMLDBMSMap map;
    private Hashtable tableFilters = new Hashtable();

    protected FilterBase(XMLDBMSMap xMLDBMSMap) {
        this.map = xMLDBMSMap;
    }

    public final TableFilter getTableFilter(String string, String string2, String string3, String string4) {
        return (TableFilter)this.tableFilters.get(Table.getHashName(string, string2, string3, string4));
    }

    public final TableFilter getTableFilter(Table table) {
        return (TableFilter)this.tableFilters.get(table.getHashName());
    }

    public final Enumeration getTableFilters() {
        return this.tableFilters.elements();
    }

    public TableFilter createTableFilter(String string, String string2, String string3, String string4) throws XMLMiddlewareException {
        ClassTableMap classTableMap = this.map.getClassTableMap(string, string2, string3, string4);
        if (classTableMap == null) {
            throw new XMLMiddlewareException("Table not mapped as a class table: " + Table.getUniversalName(string, string2, string3, string4));
        }
        String string5 = Table.getHashName(string, string2, string3, string4);
        if (this.tableFilters.get(string5) != null) {
            throw new XMLMiddlewareException("Filter already exists for table: " + Table.getUniversalName(string, string2, string3, string4));
        }
        TableFilter tableFilter = new TableFilter(classTableMap);
        this.tableFilters.put(string5, tableFilter);
        return tableFilter;
    }

    public void removeTableFilter(String string, String string2, String string3, String string4) throws XMLMiddlewareException {
        Object v = this.tableFilters.remove(Table.getHashName(string, string2, string3, string4));
        if (v == null) {
            throw new XMLMiddlewareException("Filter does not exist for table: " + Table.getUniversalName(string, string2, string3, string4));
        }
    }

    public void removeAllTableFilters() {
        this.tableFilters.clear();
    }
}

