/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms;

import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlmiddleware.xmldbms.datahandlers.DataHandler;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;

public class TransferInfo {
    private static String DEFAULT = "Default";
    private XMLDBMSMap map;
    private Hashtable dataHandlers = new Hashtable();

    public TransferInfo(XMLDBMSMap xMLDBMSMap) {
        if (xMLDBMSMap == null) {
            throw new IllegalArgumentException("map argument must not be null.");
        }
        this.map = xMLDBMSMap;
    }

    public TransferInfo(XMLDBMSMap xMLDBMSMap, String string, DataHandler dataHandler) {
        if (xMLDBMSMap == null) {
            throw new IllegalArgumentException("map argument must not be null.");
        }
        if (dataHandler == null) {
            throw new IllegalArgumentException("dataHandler argument must not be null.");
        }
        this.map = xMLDBMSMap;
        if (string == null) {
            string = DEFAULT;
        }
        this.dataHandlers.put(string, dataHandler);
    }

    public final XMLDBMSMap getMap() {
        return this.map;
    }

    public void addDataHandler(String string, DataHandler dataHandler) {
        if (dataHandler == null) {
            throw new IllegalArgumentException("dataHandler argument must not be null.");
        }
        if (this.getDataHandler(string) != null) {
            throw new IllegalArgumentException("DataHandler for " + string + " already exists.");
        }
        if (string == null) {
            string = DEFAULT;
        }
        this.dataHandlers.put(string, dataHandler);
    }

    public final DataHandler getDataHandler(String string) {
        return (DataHandler)this.dataHandlers.get(string);
    }

    public final Enumeration getDataHandlers() {
        return this.dataHandlers.elements();
    }
}

