/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.Row;
import org.xmlmiddleware.xmldbms.TransferInfo;
import org.xmlmiddleware.xmldbms.datahandlers.DataHandler;
import org.xmlmiddleware.xmldbms.filters.FilterBase;
import org.xmlmiddleware.xmldbms.filters.FilterConditions;
import org.xmlmiddleware.xmldbms.filters.FilterSet;
import org.xmlmiddleware.xmldbms.filters.RelatedTableFilter;
import org.xmlmiddleware.xmldbms.filters.ResultSetFilter;
import org.xmlmiddleware.xmldbms.filters.RootFilter;
import org.xmlmiddleware.xmldbms.filters.TableFilter;
import org.xmlmiddleware.xmldbms.maps.ClassTableMap;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.ColumnMap;
import org.xmlmiddleware.xmldbms.maps.ElementInsertionList;
import org.xmlmiddleware.xmldbms.maps.ElementInsertionMap;
import org.xmlmiddleware.xmldbms.maps.Key;
import org.xmlmiddleware.xmldbms.maps.LinkInfo;
import org.xmlmiddleware.xmldbms.maps.OrderInfo;
import org.xmlmiddleware.xmldbms.maps.PropertyMapBase;
import org.xmlmiddleware.xmldbms.maps.PropertyTableMap;
import org.xmlmiddleware.xmldbms.maps.RelatedClassTableMap;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmlutils.FragmentBuilder;
import org.xmlmiddleware.xmlutils.ParserUtils;
import org.xmlmiddleware.xmlutils.XMLName;

public class DBMSToDOM {
    private XMLDBMSMap map;
    private FilterBase filterBase;
    private Document doc;
    private ParserUtils utils;
    private FragmentBuilder fragmentBuilder;
    private TransferInfo transferInfo;
    private String publicID;
    private String systemID;
    private static String EMPTYSTRING = "";
    private static String SPACE = " ";
    private static String FAKESTARTTAG = "<fake>";
    private static String FAKEENDTAG = "</fake>";
    private static String XMLNS = "xmlns:";
    private static String XMLNSURI = "http://www.w3.org/2000/xmlns/";
    private static final XMLName PCDATA = XMLName.create(null, "#PCDATA");

    public DBMSToDOM(ParserUtils parserUtils) throws SAXException, XMLMiddlewareException {
        this.utils = parserUtils;
        this.fragmentBuilder = new FragmentBuilder(parserUtils.getXMLReader(false));
    }

    public void setDTDInfo(String string, String string2) {
        if (string2 != null && string == null) {
            throw new IllegalArgumentException("If the public ID is non-null, the system ID must also be non-null.");
        }
        this.systemID = string;
        this.publicID = string2;
    }

    public Document retrieveDocument(TransferInfo transferInfo, FilterSet filterSet, Hashtable hashtable, Node node) throws SQLException, XMLMiddlewareException {
        Hashtable hashtable2 = new Hashtable();
        return this.retrieveDocument(transferInfo, hashtable2, filterSet, hashtable, node);
    }

    public Document retrieveDocument(TransferInfo transferInfo, ResultSet resultSet, FilterSet filterSet, Hashtable hashtable, Node node) throws SQLException, XMLMiddlewareException {
        Hashtable<String, ResultSet> hashtable2 = new Hashtable<String, ResultSet>();
        hashtable2.put("Default", resultSet);
        return this.retrieveDocument(transferInfo, hashtable2, filterSet, hashtable, node);
    }

    public Document retrieveDocument(TransferInfo transferInfo, Hashtable hashtable, FilterSet filterSet, Hashtable hashtable2, Node node) throws SQLException, XMLMiddlewareException {
        this.initGlobals(transferInfo);
        Vector vector = filterSet.getFilters();
        if (vector.size() < 1) {
            throw new IllegalArgumentException("You must specify at least one filter.");
        }
        filterSet.setFilterParameters(hashtable2);
        OrderedNode orderedNode = this.getOrderedRootNode(node, filterSet);
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            this.filterBase = (FilterBase)e;
            if (e instanceof RootFilter) {
                this.retrieveRootTableData(orderedNode, (RootFilter)e);
            } else {
                ResultSetFilter resultSetFilter = (ResultSetFilter)e;
                String string = resultSetFilter.getResultSetName();
                ResultSet resultSet = (ResultSet)hashtable.get(string);
                if (resultSet == null) {
                    throw new IllegalArgumentException("No result set found for the result set name: " + string);
                }
                this.retrieveResultSetData(orderedNode, resultSetFilter, resultSet);
            }
            ++n;
        }
        this.addNamespaceDeclsToChildren(orderedNode.realNode, this.map.getNamespaceURIs());
        return this.doc;
    }

    private void retrieveRootTableData(OrderedNode orderedNode, RootFilter rootFilter) throws SQLException, XMLMiddlewareException {
        FilterConditions filterConditions = rootFilter.getRootFilterConditions();
        Table table = filterConditions.getTable();
        ClassTableMap classTableMap = this.map.getClassTableMap(table);
        DataHandler dataHandler = this.transferInfo.getDataHandler(table.getDatabaseName());
        String string = filterConditions.getWhereCondition();
        Column[] columnArray = filterConditions.getColumns();
        Object[] objectArray = filterConditions.getParameterValues();
        ResultSet resultSet = dataHandler.select(table, null, null, string, columnArray, objectArray, null);
        this.processClassResultSet(orderedNode, resultSet, classTableMap.getElementTypeName(), null, classTableMap);
        resultSet.close();
    }

    private void retrieveResultSetData(OrderedNode orderedNode, ResultSetFilter resultSetFilter, ResultSet resultSet) throws SQLException, XMLMiddlewareException {
        ClassTableMap classTableMap = this.map.getClassTableMap(resultSetFilter.getDatabaseName(), resultSetFilter.getCatalogName(), resultSetFilter.getSchemaName(), resultSetFilter.getTableName());
        this.processClassResultSet(orderedNode, resultSet, classTableMap.getElementTypeName(), null, classTableMap);
    }

    private void processClassResultSet(OrderedNode orderedNode, ResultSet resultSet, XMLName xMLName, OrderInfo orderInfo, ClassTableMap classTableMap) throws SQLException, XMLMiddlewareException {
        Row row = new Row();
        Table table = classTableMap.getTable();
        while (resultSet.next()) {
            row.clear();
            row.setColumnValues(resultSet, table, this.map.emptyStringIsNull());
            Element element = this.doc.createElementNS(xMLName.getURI(), xMLName.getQualifiedName());
            long l = this.getOrderValue(row, orderInfo);
            boolean bl = this.getAscending(orderInfo);
            OrderedNode orderedNode2 = orderedNode.insertChild(xMLName, element, l, bl);
            this.processColumns(orderedNode2, row, classTableMap.getColumnMaps());
            TableFilter tableFilter = this.filterBase.getTableFilter(table.getDatabaseName(), table.getCatalogName(), table.getSchemaName(), table.getTableName());
            this.processRelatedTables(orderedNode2, row, classTableMap, tableFilter);
            orderedNode2.clearChildren();
        }
    }

    private void processColumns(OrderedNode orderedNode, Row row, Enumeration enumeration) throws SQLException, XMLMiddlewareException {
        while (enumeration.hasMoreElements()) {
            ColumnMap columnMap = (ColumnMap)enumeration.nextElement();
            if (columnMap.getColumn().getType() == 0) continue;
            OrderedNode orderedNode2 = this.addInlinedElements(orderedNode, row, columnMap.getElementInsertionList());
            this.processColumn(orderedNode2, row, columnMap);
        }
    }

    private void processColumn(OrderedNode orderedNode, Row row, PropertyMapBase propertyMapBase) throws SQLException, XMLMiddlewareException {
        String string = this.getStringValue(row, propertyMapBase.getColumn());
        if (string == null) {
            return;
        }
        long l = this.getOrderValue(row, propertyMapBase.getOrderInfo());
        boolean bl = this.getAscending(propertyMapBase.getOrderInfo());
        XMLName xMLName = propertyMapBase.getXMLName();
        switch (propertyMapBase.getType()) {
            case 1: {
                if (propertyMapBase.isTokenList()) {
                    this.addTokenToElement(orderedNode, xMLName, string, l, bl);
                    return;
                }
                this.addElement(orderedNode, xMLName, string, l, bl, propertyMapBase.containsXML());
                return;
            }
            case 2: {
                if (propertyMapBase.isTokenList()) {
                    this.addTokenToAttribute(orderedNode, xMLName, string);
                    return;
                }
                this.addAttribute(orderedNode, xMLName, string);
                return;
            }
            case 3: {
                if (propertyMapBase.isTokenList()) {
                    this.addTokenToPCDATA(orderedNode, string, l, bl);
                    return;
                }
                this.addPCDATA(orderedNode, string, l, bl);
                return;
            }
            case 0: {
                throw new XMLMiddlewareException("Column is not mapped to an element type, attribute, or PCDATA: " + propertyMapBase.getColumn().getName());
            }
        }
    }

    private void processRelatedTables(OrderedNode orderedNode, Row row, ClassTableMap classTableMap, TableFilter tableFilter) throws SQLException, XMLMiddlewareException {
        RelatedTableFilter relatedTableFilter;
        Enumeration enumeration = classTableMap.getRelatedClassTableMaps();
        while (enumeration.hasMoreElements()) {
            RelatedClassTableMap relatedClassTableMap = (RelatedClassTableMap)enumeration.nextElement();
            relatedTableFilter = tableFilter == null ? null : tableFilter.getRelatedTableFilter(relatedClassTableMap);
            this.processRelatedClassTable(orderedNode, row, relatedClassTableMap, relatedTableFilter);
        }
        Enumeration enumeration2 = classTableMap.getPropertyTableMaps();
        while (enumeration2.hasMoreElements()) {
            PropertyTableMap propertyTableMap = (PropertyTableMap)enumeration2.nextElement();
            relatedTableFilter = tableFilter == null ? null : tableFilter.getRelatedTableFilter(propertyTableMap);
            this.processPropertyTable(orderedNode, row, propertyTableMap, relatedTableFilter);
        }
    }

    private void processRelatedClassTable(OrderedNode orderedNode, Row row, RelatedClassTableMap relatedClassTableMap, RelatedTableFilter relatedTableFilter) throws SQLException, XMLMiddlewareException {
        String string = null;
        Column[] columnArray = null;
        Object[] objectArray = null;
        OrderedNode orderedNode2 = this.addInlinedElements(orderedNode, row, relatedClassTableMap.getElementInsertionList());
        LinkInfo linkInfo = relatedClassTableMap.getLinkInfo();
        Object[] objectArray2 = row.getColumnValues(linkInfo.getParentKey().getColumns());
        Key key = linkInfo.getChildKey();
        ClassTableMap classTableMap = relatedClassTableMap.getClassTableMap();
        Table table = classTableMap.getTable();
        DataHandler dataHandler = this.transferInfo.getDataHandler(table.getDatabaseName());
        if (relatedTableFilter != null) {
            string = relatedTableFilter.getWhereCondition();
            columnArray = relatedTableFilter.getColumns();
            objectArray = relatedTableFilter.getParameterValues();
        }
        OrderInfo orderInfo = relatedClassTableMap.getOrderInfo();
        ResultSet resultSet = dataHandler.select(table, key, objectArray2, string, columnArray, objectArray, orderInfo);
        this.processClassResultSet(orderedNode2, resultSet, relatedClassTableMap.getElementTypeName(), orderInfo, classTableMap);
        resultSet.close();
    }

    private void processPropertyTable(OrderedNode orderedNode, Row row, PropertyTableMap propertyTableMap, RelatedTableFilter relatedTableFilter) throws SQLException, XMLMiddlewareException {
        String string = null;
        Column[] columnArray = null;
        Object[] objectArray = null;
        OrderedNode orderedNode2 = this.addInlinedElements(orderedNode, row, propertyTableMap.getElementInsertionList());
        LinkInfo linkInfo = propertyTableMap.getLinkInfo();
        Object[] objectArray2 = row.getColumnValues(linkInfo.getParentKey().getColumns());
        Key key = linkInfo.getChildKey();
        Table table = propertyTableMap.getTable();
        DataHandler dataHandler = this.transferInfo.getDataHandler(table.getDatabaseName());
        if (relatedTableFilter != null) {
            string = relatedTableFilter.getWhereCondition();
            columnArray = relatedTableFilter.getColumns();
            objectArray = relatedTableFilter.getParameterValues();
        }
        OrderInfo orderInfo = propertyTableMap.isTokenList() ? propertyTableMap.getTokenListOrderInfo() : propertyTableMap.getOrderInfo();
        ResultSet resultSet = dataHandler.select(table, key, objectArray2, string, columnArray, objectArray, orderInfo);
        this.processPropResultSet(orderedNode2, resultSet, propertyTableMap);
        resultSet.close();
    }

    private void processPropResultSet(OrderedNode orderedNode, ResultSet resultSet, PropertyTableMap propertyTableMap) throws SQLException, XMLMiddlewareException {
        Row row = new Row();
        while (resultSet.next()) {
            row.clear();
            row.setColumnValues(resultSet, propertyTableMap.getTable(), this.map.emptyStringIsNull());
            this.processColumn(orderedNode, row, propertyTableMap);
        }
    }

    private void initGlobals(TransferInfo transferInfo) {
        this.transferInfo = transferInfo;
        this.map = transferInfo.getMap();
    }

    private OrderedNode getOrderedRootNode(Node node, FilterSet filterSet) throws XMLMiddlewareException {
        Node node2 = null;
        Vector vector = filterSet.getWrapperNames();
        if (node == null) {
            if (!vector.isEmpty()) {
                this.createDocument((XMLName)vector.elementAt(0));
                node2 = this.addWrapperElements(this.doc, vector, filterSet.getNamespaceURIs());
            } else {
                ClassTableMap classTableMap;
                Vector vector2 = filterSet.getFilters();
                if (vector2.size() > 1) {
                    throw new IllegalArgumentException("There is more than one root filter and no wrapper elements.");
                }
                Object e = vector2.elementAt(0);
                if (e instanceof RootFilter) {
                    Table table = ((RootFilter)e).getRootFilterConditions().getTable();
                    classTableMap = this.map.getClassTableMap(table);
                } else {
                    ResultSetFilter resultSetFilter = (ResultSetFilter)e;
                    classTableMap = this.map.getClassTableMap(resultSetFilter.getDatabaseName(), resultSetFilter.getCatalogName(), resultSetFilter.getSchemaName(), resultSetFilter.getTableName());
                }
                this.createDocument(classTableMap.getElementTypeName());
                node2 = this.doc;
            }
        } else {
            this.doc = node.getOwnerDocument();
            node2 = !vector.isEmpty() ? this.addWrapperElements(node, vector, filterSet.getNamespaceURIs()) : node;
        }
        return new OrderedNode(node2, Long.MIN_VALUE, null);
    }

    private void createDocument(XMLName xMLName) throws XMLMiddlewareException {
        DOMImplementation dOMImplementation = this.utils.getDOMImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType(xMLName.getQualifiedName(), this.publicID, this.systemID);
        this.doc = dOMImplementation.createDocument(xMLName.getURI(), xMLName.getQualifiedName(), documentType);
        Element element = this.doc.getDocumentElement();
        this.doc.removeChild(element);
    }

    private Node addWrapperElements(Node node, Vector vector, Hashtable hashtable) {
        if (vector.size() == 0) {
            return node;
        }
        Node node2 = node;
        int n = 0;
        while (n < vector.size()) {
            XMLName xMLName = (XMLName)vector.elementAt(n);
            Element element = this.doc.createElementNS(xMLName.getURI(), xMLName.getQualifiedName());
            node2.appendChild(element);
            node2 = element;
            ++n;
        }
        this.addNamespaceDecls((Element)node.getLastChild(), hashtable);
        return node2;
    }

    private void addNamespaceDeclsToChildren(Node node, Hashtable hashtable) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element) {
                this.addNamespaceDecls((Element)node2, hashtable);
            }
            node2 = node2.getNextSibling();
        }
    }

    private void addNamespaceDecls(Element element, Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            element.setAttributeNS(XMLNSURI, String.valueOf(XMLNS) + string, string2);
        }
    }

    private OrderedNode addInlinedElements(OrderedNode orderedNode, Row row, ElementInsertionList elementInsertionList) {
        if (elementInsertionList == null) {
            return orderedNode;
        }
        int n = 0;
        while (n < elementInsertionList.size()) {
            ElementInsertionMap elementInsertionMap = elementInsertionList.getElementInsertionMap(n);
            orderedNode = this.addInlinedElement(orderedNode, row, elementInsertionMap);
            ++n;
        }
        return orderedNode;
    }

    private OrderedNode addInlinedElement(OrderedNode orderedNode, Row row, ElementInsertionMap elementInsertionMap) {
        XMLName xMLName = elementInsertionMap.getElementTypeName();
        OrderedNode orderedNode2 = orderedNode.getUniqueChild(xMLName);
        if (orderedNode2 == null) {
            Element element = this.doc.createElementNS(xMLName.getURI(), xMLName.getQualifiedName());
            OrderInfo orderInfo = elementInsertionMap.getOrderInfo();
            long l = this.getOrderValue(row, orderInfo);
            boolean bl = this.getAscending(orderInfo);
            orderedNode2 = orderedNode.insertChild(xMLName, element, l, bl);
        }
        return orderedNode2;
    }

    private void addTokenToElement(OrderedNode orderedNode, XMLName xMLName, String string, long l, boolean bl) throws SQLException {
        OrderedNode orderedNode2 = orderedNode.getUniqueChild(xMLName);
        if (orderedNode2 == null) {
            this.addElement(orderedNode, xMLName, string, l, bl, false);
            return;
        }
        Text text = (Text)orderedNode2.realNode.getFirstChild();
        text.appendData(SPACE);
        text.appendData(string);
    }

    private void addElement(OrderedNode orderedNode, XMLName xMLName, String string, long l, boolean bl, boolean bl2) throws SQLException {
        Element element = this.doc.createElementNS(xMLName.getURI(), xMLName.getQualifiedName());
        orderedNode.insertChild(xMLName, element, l, bl);
        if (bl2) {
            DocumentFragment documentFragment;
            try {
                documentFragment = this.fragmentBuilder.parse(this.doc, String.valueOf(FAKESTARTTAG) + string + FAKEENDTAG);
            }
            catch (Exception exception) {
                throw new SQLException("[XML-DBMS]: Exception parsing column value: " + exception.getMessage());
            }
            element.appendChild(documentFragment);
            return;
        }
        Text text = this.doc.createTextNode(string);
        element.appendChild(text);
    }

    private void addTokenToAttribute(OrderedNode orderedNode, XMLName xMLName, String string) {
        Element element = (Element)orderedNode.realNode;
        Attr attr = element.getAttributeNodeNS(xMLName.getURI(), xMLName.getLocalName());
        if (attr == null) {
            this.addAttribute(orderedNode, xMLName, string);
            return;
        }
        Text text = (Text)attr.getFirstChild();
        text.appendData(SPACE);
        text.appendData(string);
    }

    private void addAttribute(OrderedNode orderedNode, XMLName xMLName, String string) {
        Attr attr = this.doc.createAttributeNS(xMLName.getURI(), xMLName.getQualifiedName());
        Text text = this.doc.createTextNode(string);
        attr.appendChild(text);
        Element element = (Element)orderedNode.realNode;
        element.setAttributeNodeNS(attr);
    }

    private void addTokenToPCDATA(OrderedNode orderedNode, String string, long l, boolean bl) {
        OrderedNode orderedNode2 = orderedNode.getUniqueChild(PCDATA);
        if (orderedNode2 == null) {
            this.addPCDATA(orderedNode, string, l, bl);
            return;
        }
        ((Text)orderedNode2.realNode).appendData(SPACE);
        ((Text)orderedNode2.realNode).appendData(string);
    }

    private void addPCDATA(OrderedNode orderedNode, String string, long l, boolean bl) {
        Text text = this.doc.createTextNode(string);
        orderedNode.insertChild(PCDATA, text, l, bl);
    }

    private String getStringValue(Row row, Column column) throws SQLException {
        Object object = row.getColumnValue(column);
        if (object == null) {
            return null;
        }
        StringFormatter stringFormatter = column.getFormatter();
        try {
            return stringFormatter.format(object);
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            throw new SQLException("[XML-DBMS] Conversion error: " + xMLMiddlewareException.getMessage());
        }
    }

    private boolean getAscending(OrderInfo orderInfo) {
        if (orderInfo == null) {
            return false;
        }
        return orderInfo.isAscending();
    }

    private long getOrderValue(Row row, OrderInfo orderInfo) {
        if (orderInfo == null) {
            return Long.MIN_VALUE;
        }
        if (orderInfo.orderValueIsFixed()) {
            return orderInfo.getFixedOrderValue();
        }
        Object object = row.getColumnValue(orderInfo.getOrderColumn());
        if (object == null) {
            return Long.MIN_VALUE;
        }
        return ((Number)object).longValue();
    }

    class OrderedNode {
        Node realNode;
        long orderValue;
        OrderedNode previousSibling;
        OrderedNode lastOrderedChild;
        OrderedNode firstUnorderedChild;
        Hashtable children = new Hashtable();

        OrderedNode(Node node, long l, OrderedNode orderedNode) {
            DBMSToDOM.this = DBMSToDOM.this;
            this.orderValue = l;
            this.realNode = node;
            this.previousSibling = orderedNode;
        }

        void clearChildren() {
            this.lastOrderedChild = null;
            this.firstUnorderedChild = null;
            this.children.clear();
        }

        OrderedNode getUniqueChild(XMLName xMLName) {
            return (OrderedNode)this.children.get(xMLName);
        }

        OrderedNode insertChild(XMLName xMLName, Node node, long l, boolean bl) {
            if (l == Long.MIN_VALUE) {
                return this.insertUnorderedChild(xMLName, node);
            }
            if (!bl) {
                l = -1L * l;
            }
            return this.insertOrderedChild(xMLName, node, l);
        }

        private OrderedNode insertOrderedChild(XMLName xMLName, Node node, long l) {
            OrderedNode orderedNode = this.lastOrderedChild;
            OrderedNode orderedNode2 = this.firstUnorderedChild;
            while (orderedNode != null) {
                if (l >= orderedNode.orderValue) break;
                orderedNode2 = orderedNode;
                orderedNode = orderedNode.previousSibling;
            }
            Node node2 = orderedNode2 == null ? null : orderedNode2.realNode;
            this.realNode.insertBefore(node, node2);
            OrderedNode orderedNode3 = new OrderedNode(node, l, orderedNode);
            if (orderedNode2 != null && orderedNode2 != this.firstUnorderedChild) {
                orderedNode2.previousSibling = orderedNode3;
            }
            if (orderedNode2 == this.firstUnorderedChild) {
                this.lastOrderedChild = orderedNode3;
            }
            this.children.put(xMLName, orderedNode3);
            return orderedNode3;
        }

        private OrderedNode insertUnorderedChild(XMLName xMLName, Node node) {
            this.realNode.appendChild(node);
            OrderedNode orderedNode = new OrderedNode(node, Long.MIN_VALUE, null);
            if (this.firstUnorderedChild == null) {
                this.firstUnorderedChild = orderedNode;
            }
            this.children.put(xMLName, orderedNode);
            return orderedNode;
        }
    }
}

