/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.xmlmiddleware.db.SPPreparedStatement;
import org.xmlmiddleware.db.SPStatementEvent;
import org.xmlmiddleware.db.SPStatementEventListener;
import org.xmlmiddleware.utils.Pool;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public class StatementPool
extends Pool
implements SPStatementEventListener {
    protected Connection m_connection;

    public StatementPool(Connection connection) {
        this.m_connection = connection;
    }

    public Object checkOut(Object object) throws XMLMiddlewareException {
        if (!(object instanceof String)) {
            throw new XMLMiddlewareException("Object ID must be a String.");
        }
        PreparedStatement preparedStatement = (PreparedStatement)super.checkOut(object);
        SPPreparedStatement sPPreparedStatement = new SPPreparedStatement(preparedStatement);
        sPPreparedStatement.addStatementEventListener(this);
        return sPPreparedStatement;
    }

    public void checkIn(Object object) throws XMLMiddlewareException {
        if (!(object instanceof SPPreparedStatement)) {
            throw new XMLMiddlewareException("StatementPool requires a SPPreparedStatement object.");
        }
        SPPreparedStatement sPPreparedStatement = (SPPreparedStatement)object;
        PreparedStatement preparedStatement = sPPreparedStatement.getUnderlyingStatement();
        sPPreparedStatement.invalidate();
        super.checkIn(preparedStatement);
        sPPreparedStatement.removeStatementEventListener(this);
    }

    public void statementClosed(SPStatementEvent sPStatementEvent) {
        try {
            SPPreparedStatement sPPreparedStatement = (SPPreparedStatement)sPStatementEvent.getSource();
            this.checkIn(sPPreparedStatement);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void statementErrorOccurred(SPStatementEvent sPStatementEvent) {
        try {
            SPPreparedStatement sPPreparedStatement = (SPPreparedStatement)sPStatementEvent.getSource();
            this.remove(sPPreparedStatement);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected Object createObject(Object object) throws XMLMiddlewareException {
        if (!(object instanceof String)) {
            throw new XMLMiddlewareException("StatementPool.createObject needs a String id.");
        }
        try {
            return this.m_connection.prepareStatement((String)object);
        }
        catch (SQLException sQLException) {
            throw new XMLMiddlewareException(sQLException);
        }
    }

    protected void closeObject(Object object) throws XMLMiddlewareException {
        if (!(object instanceof PreparedStatement)) {
            throw new XMLMiddlewareException("StatementPool.closeObject needs PreparedStatement.");
        }
        try {
            PreparedStatement preparedStatement = (PreparedStatement)object;
            preparedStatement.close();
            return;
        }
        catch (SQLException sQLException) {
            throw new XMLMiddlewareException(sQLException);
        }
    }

    protected void clear() {
        super.clear();
    }

    protected void remove(Object object) throws XMLMiddlewareException {
        if (!(object instanceof SPPreparedStatement)) {
            throw new XMLMiddlewareException("StatementPool requires a SPPreparedStatement object.");
        }
        SPPreparedStatement sPPreparedStatement = (SPPreparedStatement)object;
        PreparedStatement preparedStatement = sPPreparedStatement.getUnderlyingStatement();
        sPPreparedStatement.invalidate();
        super.remove(preparedStatement);
        sPPreparedStatement.removeStatementEventListener(this);
    }
}

