/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccessRightUpdater {
    private static Logger logger = Logger.getLogger(AccessRightUpdater.class);
    private RightCacheMgr m_oRightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
    private IObjectMemberMgr m_oObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
    private Map m_hOperatorsForObjCache = null;
    private long m_lOnlyVistValue = 0L;
    private User m_oCurrUser = null;

    public AccessRightUpdater(User _currUser) {
        CMyBitsValue oBitsValue = new CMyBitsValue();
        oBitsValue.setBit(14, true);
        this.m_lOnlyVistValue = oBitsValue.getValue();
        this.m_oCurrUser = _currUser;
    }

    public void updateAccessRight() throws WCMException {
        logger.warn((Object)"The system begin to create acccess rights.....");
        DebugTimer allTimer = new DebugTimer();
        allTimer.start();
        this.initCache();
        WCMFilter filterForChannel = new WCMFilter("WCMChannel a", "not exists(select 1 from WCMChannel b where a.ChannelId=b.ParentId)", "ParentId", "");
        Channels channels = Channels.openWCMObjs(null, filterForChannel);
        this.updateAccessRightOnSameLevel(channels);
        WebSites sites = WebSites.openWCMObjs(null, null);
        int nSize = sites.size();
        for (int i = 0; i < nSize; ++i) {
            this.updateAccessRight((WebSite)sites.getAt(i));
        }
        allTimer.stop();
        logger.warn((Object)("The system end to create access rights!use[" + allTimer.getTime() + "]ms"));
    }

    private void updateAccessRightOnSameLevel(Channels _oChannelsOnSameLevel) throws WCMException {
        if (_oChannelsOnSameLevel.isEmpty()) {
            return;
        }
        Channels oParentChannelsOnSameLevel = new Channels(null);
        int nSize = _oChannelsOnSameLevel.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)_oChannelsOnSameLevel.getAt(i);
            if (channel == null) {
                logger.error((Object)("Channel not exists![ID=" + _oChannelsOnSameLevel.getIdAt(i) + "]!"));
                continue;
            }
            this.updateAccessRight(channel);
            int nParentId = channel.getParentId();
            if (nParentId == 0) continue;
            oParentChannelsOnSameLevel.addElement(nParentId);
        }
        this.updateAccessRightOnSameLevel(oParentChannelsOnSameLevel);
    }

    private void updateAccessRight(BaseChannel _oChannelOrSite) throws WCMException {
        int[] pOprTypes = new int[]{201, 203, 204};
        for (int i = 0; i < pOprTypes.length; ++i) {
            this.updateAccessRight(_oChannelOrSite, pOprTypes[i]);
        }
    }

    private void updateAccessRight(BaseChannel _oChannelOrSite, int _nOprType) throws WCMException {
        BaseObjs operators = (BaseObjs)this.m_hOperatorsForObjCache.get(this.makeCacheKey(_oChannelOrSite.getWCMType(), _oChannelOrSite.getId(), _nOprType));
        this.synMember(_oChannelOrSite, _nOprType, operators);
        List<Channel> lChildren = _oChannelOrSite.getChildren(null);
        int nSize = lChildren.size();
        for (int i = 0; i < nSize; ++i) {
            Channel child = lChildren.get(i);
            if (child == null) continue;
            operators = (BaseObjs)this.m_hOperatorsForObjCache.get(this.makeCacheKey(child.getWCMType(), child.getId(), _nOprType));
            this.synMember(_oChannelOrSite, _nOprType, operators, true);
        }
    }

    private void synMember(BaseChannel _oChannelOrSite, int _nOprType, BaseObjs _oOperators) throws WCMException {
        this.synMember(_oChannelOrSite, _nOprType, _oOperators, false);
    }

    private void synMember(BaseChannel _oChannelOrSite, int _nOprType, BaseObjs _oOperators, boolean _bOnlyAccess) throws WCMException {
        if (_oOperators == null) {
            return;
        }
        int nSize = _oOperators.size();
        for (int i = 0; i < nSize; ++i) {
            BaseObj obj = _oOperators.getAt(i);
            if (obj == null) continue;
            boolean bOnlyAccess = _bOnlyAccess;
            if (!bOnlyAccess) {
                long lRightValue = this.m_oRightCacheMgr.getRightValue(_oChannelOrSite.getWCMType(), _oChannelOrSite.getId(), _nOprType, obj.getId(), 0L);
                boolean bl = bOnlyAccess = (lRightValue ^ this.m_lOnlyVistValue) == 0L;
            }
            if (bOnlyAccess) {
                this.m_oObjectMemberMgr.addVisible(this.m_oCurrUser, _nOprType, obj.getId(), _oChannelOrSite.getWCMType(), _oChannelOrSite.getId());
                continue;
            }
            this.m_oObjectMemberMgr.addOperation(this.m_oCurrUser, _nOprType, obj.getId(), _oChannelOrSite.getWCMType(), _oChannelOrSite.getId());
        }
    }

    private void initCache() throws WCMException {
        this.m_hOperatorsForObjCache = new HashMap(500);
        String SQL = "select ObjType, ObjId, OprType, OprId from WCMRight order by ObjType, ObjId, OprType";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet result = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("select ObjType, ObjId, OprType, OprId from WCMRight order by ObjType, ObjId, OprType");
            oPreStmt.setFetchSize(2000);
            result = oPreStmt.executeQuery();
            String sPreCurrKey = null;
            while (result.next()) {
                int nObjType = result.getInt(1);
                int nObjId = result.getInt(2);
                int nOprType = result.getInt(3);
                int nOprId = result.getInt(4);
                String sCurrKey = this.makeCacheKey(nObjType, nObjId, nOprType);
                BaseObjs currObjs = null;
                if (sCurrKey.equals(sPreCurrKey)) {
                    currObjs = (BaseObjs)this.m_hOperatorsForObjCache.get(sCurrKey);
                }
                if (currObjs == null) {
                    currObjs = this.makeOprObjs(nOprType);
                    this.m_hOperatorsForObjCache.put(sCurrKey, currObjs);
                }
                currObjs.addElement(nOprId);
                sPreCurrKey = sCurrKey;
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to Desc!", ex);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close result", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    private String makeCacheKey(int _nObjType, int _nObjId, int _nOprType) {
        StringBuffer sbCurrKey = new StringBuffer(30);
        sbCurrKey.append(_nObjType).append(".").append(_nObjId).append(".").append(_nOprType);
        return sbCurrKey.toString();
    }

    private BaseObjs makeOprObjs(int _nOprType) throws WCMException {
        CMSBaseObjs oCurrBaseObjs = null;
        switch (_nOprType) {
            case 201: {
                oCurrBaseObjs = new Groups(null, 1, 1);
                break;
            }
            case 203: {
                oCurrBaseObjs = new Roles(null, 1, 1);
                break;
            }
            case 204: {
                oCurrBaseObjs = new Users(null, 1, 1);
                break;
            }
            default: {
                throw new WCMException("\u672a\u77e5\u64cd\u4f5c\u8005\uff01[Type=" + _nOprType + "]");
            }
        }
        return oCurrBaseObjs;
    }
}

