/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.controler;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.XmlCharCheckedInputStream;
import com.trs.webframework.WebServiceHelper;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.config.ServiceConfig;
import com.trs.webframework.config.ServiceConfigHelper;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.controler.JSPRequestParmasValidator;
import com.trs.webframework.controler.JSPServiceContext;
import com.trs.webframework.controler.PostDataParser;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.xmlserver.parser.StreamBuddy;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.InputSource;

public class JSPRequestProcessor {
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    private String[] m_pSelectParameters = null;
    private String[] m_pEscapeParameters = null;
    private String[] m_pAppendParameters = null;
    private PostDataParser m_oPostDataParser = null;
    private JSPServiceContext m_oDefaultServiceContext = null;
    private BaseObj m_oCurrHost = null;
    private Map m_oContextCacheData = null;

    public JSPRequestProcessor() {
    }

    public JSPRequestProcessor(HttpServletRequest _request, HttpServletResponse _response) {
        this.request = _request;
        this.response = _response;
        if (_request != null) {
            this.m_oDefaultServiceContext = new JSPServiceContext(this.request, this.response);
        }
    }

    public void setSelectParameters(String[] _selectParameters) {
        this.m_pSelectParameters = _selectParameters;
    }

    public void setSelectParameters(String[] _selectParameters, boolean _bIncludeAppend) {
        this.m_pSelectParameters = _selectParameters;
        if (_bIncludeAppend && this.m_pAppendParameters != null) {
            if (this.m_pSelectParameters == null) {
                this.m_pSelectParameters = this.m_pAppendParameters;
                return;
            }
            String[] aTemp = new String[this.m_pAppendParameters.length + this.m_pSelectParameters.length];
            System.arraycopy(this.m_pSelectParameters, 0, aTemp, 0, this.m_pSelectParameters.length);
            System.arraycopy(this.m_pAppendParameters, 0, aTemp, this.m_pSelectParameters.length, this.m_pAppendParameters.length);
            this.m_pSelectParameters = aTemp;
        }
    }

    public void setEscapeParameters(String[] _escapeParameters) throws WCMException {
        if (_escapeParameters != null && _escapeParameters.length % 2 != 0) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label1", "\u8f6c\u4e49\u7684\u53c2\u6570\u4e0d\u662f\u6210\u5bf9\u51fa\u73b0\uff01"));
        }
        this.m_pEscapeParameters = _escapeParameters;
    }

    public void setAppendParameters(String[] _appendParameters) throws WCMException {
        if (_appendParameters != null && _appendParameters.length % 2 != 0) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label2", "\u8ffd\u52a0\u7684\u53c2\u6570\u4e0d\u662f\u6210\u5bf9\u51fa\u73b0\uff01"));
        }
        this.m_pAppendParameters = _appendParameters;
    }

    public void reset() {
        this.m_pAppendParameters = null;
        this.m_pEscapeParameters = null;
        this.m_pSelectParameters = null;
    }

    public Object excute(String _sServiceId, String _sMethodName) throws WCMException {
        return this.excute(_sServiceId, _sMethodName, null);
    }

    public Object excute(String _sServiceId, String _sMethodName, HashMap _parameters) throws WCMException {
        ServiceConfig serviceConfig;
        String sServiceId = _sServiceId;
        String sMethodName = _sMethodName;
        if (sServiceId.indexOf(95) == -1) {
            sServiceId = "wcm6_" + sServiceId;
        }
        if ((serviceConfig = ServiceConfigHelper.findServiceConfig(sServiceId)) == null) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label3", "\u670d\u52a1[") + sServiceId + I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label4", "]\u7684\u914d\u7f6e\u4fe1\u606f\u6ca1\u6709\u627e\u5230\uff0c\u662f\u5426\u662f\u6587\u4ef6") + ServiceConfigHelper.getSevicesConfigFileName(sServiceId) + I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label5", "\u4e0d\u5b58\u5728!"));
        }
        MethodConfig oMethodConfig = ServiceConfigHelper.findMethodConfig(sServiceId, sMethodName);
        if (oMethodConfig == null) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label6", "\u662f\u5426\u5728\u6587\u4ef6[") + ServiceConfigHelper.getSevicesConfigFileName(sServiceId) + I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label7", "]\u4e2d\u6ca1\u6709\u5b9a\u4e49\u65b9\u6cd5[") + sMethodName + "]?");
        }
        try {
            JSPServiceContext oServiceContext = null;
            if (_parameters != null) {
                if (this.m_oDefaultServiceContext == null) {
                    this.m_oDefaultServiceContext = oServiceContext = new JSPServiceContext(_parameters);
                } else {
                    oServiceContext = new JSPServiceContext(this.m_oDefaultServiceContext);
                    oServiceContext.setMapParameters(_parameters);
                }
            } else if (this.m_pSelectParameters != null && this.m_pSelectParameters.length > 0 || this.m_pEscapeParameters != null && this.m_pEscapeParameters.length > 0 || this.m_pAppendParameters != null && this.m_pAppendParameters.length > 0) {
                oServiceContext = new JSPServiceContext(this.m_oDefaultServiceContext);
                oServiceContext.setMapParameters(this.getNewParameters());
            } else {
                oServiceContext = this.m_oDefaultServiceContext;
            }
            MethodContext oMethodContext = new JSPRequestParmasValidator(oServiceContext, oMethodConfig).getMethodContext();
            oMethodContext.setServiceContext(oServiceContext);
            if (this.m_oCurrHost != null) {
                oMethodContext.setCurrHost(this.m_oCurrHost);
            }
            if (this.m_oContextCacheData != null) {
                oMethodContext.putContextCacheData(this.m_oContextCacheData);
            }
            return WebServiceHelper.execute(oMethodConfig, oMethodContext, true);
        }
        catch (BizError e) {
            throw e;
        }
        catch (Throwable e) {
            int nPos;
            int nNum = 1100;
            if (e instanceof CMyException) {
                nNum = ((CMyException)e).getErrNo();
            } else if (e instanceof ServiceInvocationException) {
                nNum = Integer.parseInt(((ServiceInvocationException)e).getErrorCode());
            }
            String sMsg = e.getMessage();
            if (sMsg != null && (nPos = sMsg.indexOf("[ERR-")) >= 0 && (nPos = sMsg.indexOf(93, nPos + 1)) > 0) {
                sMsg = sMsg.substring(nPos + 1);
            }
            throw new WCMException(nNum, sMsg, e);
        }
    }

    public Object excuteMult(String _sServiceId, String _sMethodName) throws WCMException {
        HashMap parameters;
        String sServiceId;
        if (this.m_oPostDataParser == null) {
            this.initPostDataParser();
        }
        if ((sServiceId = _sServiceId).indexOf("_") < 0) {
            sServiceId = "wcm6_" + sServiceId;
        }
        if ((parameters = this.m_oPostDataParser.findParameters(sServiceId, _sMethodName)) == null) {
            return null;
        }
        return this.excute(sServiceId, _sMethodName, this.makeMultParameters(parameters));
    }

    public Object[] excuteArrayMult(String _sServiceId, String _sMethodName) throws WCMException {
        HashMap[] parameters;
        String sServiceId;
        if (this.m_oPostDataParser == null) {
            this.initPostDataParser();
        }
        if ((sServiceId = _sServiceId).indexOf("_") < 0) {
            sServiceId = "wcm6_" + sServiceId;
        }
        if ((parameters = this.m_oPostDataParser.findArrayParameters(sServiceId, _sMethodName)) == null) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label10", "\u6307\u5b9a\u670d\u52a1\u7684\u53c2\u6570\u4e0d\u5b58\u5728![ServiceId=") + _sServiceId + ", MethodName=" + _sMethodName + "]");
        }
        Object[] result = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            result[i] = this.excute(sServiceId, _sMethodName, this.makeMultParameters(parameters[i]));
        }
        return result;
    }

    private HashMap makeMultParameters(HashMap parameters) {
        if (this.m_pAppendParameters != null && this.m_pAppendParameters.length > 0) {
            for (int i = 0; i < this.m_pAppendParameters.length; i += 2) {
                String sAppendParameterName = this.m_pAppendParameters[i];
                parameters.put(sAppendParameterName.toUpperCase(), this.m_pAppendParameters[i + 1]);
            }
        }
        Iterator iterMap = parameters.keySet().iterator();
        HashMap result = new HashMap();
        while (iterMap.hasNext()) {
            String sParamName = (String)iterMap.next();
            if (!this.isSelectParameter(sParamName)) continue;
            String[] pNewParamName = this.toEscapeParameters(sParamName);
            for (int nNewParamNameIndex = 0; nNewParamNameIndex < pNewParamName.length; ++nNewParamNameIndex) {
                String sNewParamName = pNewParamName[nNewParamNameIndex];
                result.put(sNewParamName, parameters.get(sParamName));
            }
        }
        return result;
    }

    public Object excuteMult(int _nServiceIndex) throws WCMException {
        HashMap parameters;
        if (this.m_oPostDataParser == null) {
            this.initPostDataParser();
        }
        if ((parameters = this.m_oPostDataParser.findParameters(_nServiceIndex)) == null) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label11", "\u6307\u5b9a\u670d\u52a1\u7684\u53c2\u6570\u4e0d\u5b58\u5728![ServiceIndex=") + _nServiceIndex + "]");
        }
        String sServiceId = this.m_oPostDataParser.findServiceId(_nServiceIndex);
        String sMethodName = this.m_oPostDataParser.findMethodName(_nServiceIndex);
        return this.excute(sServiceId, sMethodName, this.makeMultParameters(parameters));
    }

    private void initPostDataParser() throws WCMException {
        try {
            InputStream reqStream = StreamBuddy.copyRequestInputStream(new XmlCharCheckedInputStream((InputStream)this.request.getInputStream()));
            InputSource inputSource = StreamBuddy.getInputSource(reqStream, "utf-8");
            this.m_oPostDataParser = new PostDataParser();
            this.m_oPostDataParser.parse(inputSource);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(JSPRequestProcessor.class, "JSPRequestProcessor.label12", "\u89e3\u6790\u4f20\u5165\u7684\u6570\u636e\u5931\u8d25\uff01"));
        }
    }

    private boolean isSelectParameter(String _sParamName) {
        if (this.m_pSelectParameters == null || this.m_pSelectParameters.length <= 0) {
            return true;
        }
        for (int i = 0; i < this.m_pSelectParameters.length; ++i) {
            String sName = this.m_pSelectParameters[i];
            if (!_sParamName.equalsIgnoreCase(sName)) continue;
            return true;
        }
        return false;
    }

    private String[] toEscapeParameters(String _sParamName) {
        if (this.m_pEscapeParameters == null || this.m_pEscapeParameters.length <= 0) {
            return new String[]{_sParamName};
        }
        String[] pEscapeParameters = new String[]{};
        for (int i = 0; i < this.m_pEscapeParameters.length; i += 2) {
            String sName = this.m_pEscapeParameters[i];
            if (!_sParamName.equalsIgnoreCase(sName)) continue;
            String sNewParamName = this.m_pEscapeParameters[i + 1];
            String[] pTemp = new String[pEscapeParameters.length + 1];
            if (pTemp.length > 1) {
                System.arraycopy(pEscapeParameters, 0, pTemp, 0, pEscapeParameters.length);
            }
            pTemp[pEscapeParameters.length] = sNewParamName;
            pEscapeParameters = pTemp;
        }
        if (pEscapeParameters.length <= 0) {
            return new String[]{_sParamName};
        }
        return pEscapeParameters;
    }

    private HashMap getNewParameters() {
        String sNewParamName;
        int nNewParamNameIndex;
        String[] pNewParamName;
        HashMap<String, Object> hParameters = new HashMap<String, Object>();
        Enumeration enNames = this.request.getParameterNames();
        while (enNames.hasMoreElements()) {
            String sParamName = (String)enNames.nextElement();
            if (!this.isSelectParameter(sParamName)) continue;
            String[] paramValues = this.getParameterValues(sParamName);
            if (paramValues == null || paramValues.length == 0) break;
            pNewParamName = this.toEscapeParameters(sParamName);
            for (nNewParamNameIndex = 0; nNewParamNameIndex < pNewParamName.length; ++nNewParamNameIndex) {
                sNewParamName = pNewParamName[nNewParamNameIndex];
                if (paramValues.length == 1) {
                    hParameters.put(sNewParamName, paramValues[0]);
                    continue;
                }
                hParameters.put(sNewParamName, paramValues);
            }
        }
        if (this.m_pAppendParameters != null && this.m_pAppendParameters.length > 0) {
            for (int i = 0; i < this.m_pAppendParameters.length; i += 2) {
                String sAppendParameterName = this.m_pAppendParameters[i];
                if (!this.isSelectParameter(sAppendParameterName)) continue;
                pNewParamName = this.toEscapeParameters(sAppendParameterName);
                for (nNewParamNameIndex = 0; nNewParamNameIndex < pNewParamName.length; ++nNewParamNameIndex) {
                    sNewParamName = pNewParamName[nNewParamNameIndex];
                    hParameters.put(sNewParamName, this.m_pAppendParameters[i + 1]);
                }
            }
        }
        return hParameters;
    }

    public HashMap getServiceParameters() {
        return this.getNewParameters();
    }

    private String[] getParameterValues(String _sParameterName) {
        String[] pValues;
        if (this.m_pAppendParameters != null && this.m_pAppendParameters.length > 0) {
            for (int i = 0; i < this.m_pAppendParameters.length; i += 2) {
                String sAppendParameterName = this.m_pAppendParameters[i];
                if (!_sParameterName.equalsIgnoreCase(sAppendParameterName)) continue;
                return new String[]{this.m_pAppendParameters[i + 1]};
            }
        }
        if ((pValues = this.request.getParameterValues(_sParameterName)) == null) {
            return new String[0];
        }
        String[] pResult = new String[pValues.length];
        for (int i = 0; i < pValues.length; ++i) {
            pResult[i] = CMyString.getStr(pValues[i]);
        }
        return pResult;
    }

    public boolean getParam(String _sParameterName, boolean _bDefaultValue) {
        return this.m_oDefaultServiceContext.getParam(_sParameterName, _bDefaultValue);
    }

    public CMyDateTime getParam(String _sParameterName, CMyDateTime _dtDefaultValue) {
        return this.m_oDefaultServiceContext.getParam(_sParameterName, _dtDefaultValue);
    }

    public double getParam(String _sParameterName, double _dDefaultValue) {
        return this.m_oDefaultServiceContext.getParam(_sParameterName, _dDefaultValue);
    }

    public float getParam(String _sParameterName, float _fDefaultValue) {
        return this.m_oDefaultServiceContext.getParam(_sParameterName, _fDefaultValue);
    }

    public int getParam(String _sParameterName, int _nDefaultValue) {
        return this.m_oDefaultServiceContext.getParam(_sParameterName, _nDefaultValue);
    }

    public long getParam(String _sParameterName, long _lDefaultValue) {
        return this.m_oDefaultServiceContext.getParam(_sParameterName, _lDefaultValue);
    }

    public String getParam(String _sParameterName) {
        return this.m_oDefaultServiceContext.getParam(_sParameterName);
    }

    public void setCurrHost(BaseObj _oCurrHost) {
        this.m_oCurrHost = _oCurrHost;
    }

    public BaseObj getCurrHost() {
        return this.m_oCurrHost;
    }

    public void putContextCacheData(Map _oCacheData) {
        this.getContextCacheData().putAll(_oCacheData);
    }

    public void putContextCacheData(Object key, Object _value) {
        if (_value == null) {
            return;
        }
        this.getContextCacheData().put(key, _value);
    }

    public Object getContextCacheData(Object key) {
        if (key == null) {
            return null;
        }
        return this.getContextCacheData().get(key);
    }

    private Map getContextCacheData() {
        if (this.m_oContextCacheData == null) {
            this.m_oContextCacheData = new HashMap(1);
        }
        return this.m_oContextCacheData;
    }

    public boolean exists(String _sServiceId, String _sMethodName) throws WCMException {
        String sServiceId;
        if (this.m_oPostDataParser == null) {
            this.initPostDataParser();
        }
        if ((sServiceId = _sServiceId).indexOf("_") < 0) {
            sServiceId = "wcm6_" + sServiceId;
        }
        return this.m_oPostDataParser.findParameters(sServiceId, _sMethodName) != null;
    }

    public Map findParameters(String _sServiceId, String _sMethodName) throws WCMException {
        String sServiceId;
        if (this.m_oPostDataParser == null) {
            this.initPostDataParser();
        }
        if ((sServiceId = _sServiceId).indexOf("_") < 0) {
            sServiceId = "wcm6_" + sServiceId;
        }
        return this.m_oPostDataParser.findParameters(sServiceId, _sMethodName);
    }
}

