/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.context;

import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import java.util.StringTokenizer;

public class MethodContextHelper {
    public static final String ATTR_NAME_SEARCHKEY = "SearchKey";
    public static final String ATTR_NAME_SEARCHVALUE = "SearchValue";
    public static final String NAME_PARAMETER_ORDERBY_TYPE = "OrderType";
    public static final String NAME_PARAMETER_ORDERBY_FIELD = "OrderField";

    private MethodContextHelper() {
    }

    public static WCMFilter mergeMoreFilter(MethodContext _context, WCMFilter _filter) {
        String sWhere = MethodContextHelper.getWhereStr(_context);
        WCMFilter result = new WCMFilter();
        result.setWhere(sWhere);
        if (_filter == null) {
            _filter = new WCMFilter();
        }
        _filter.mergeWith(_context.getExtraWCMFilter());
        _filter.mergeWith(result);
        String sOrder = MethodContextHelper.getOrderStr(_context);
        if (!CMyString.isEmpty(sOrder)) {
            _filter.setOrder(sOrder);
        }
        return _filter;
    }

    private static String getOrderStr(MethodContext _context) {
        String sOrderField = _context.getValue(NAME_PARAMETER_ORDERBY_FIELD);
        if (CMyString.isEmpty(sOrderField)) {
            return null;
        }
        String sOrderType = _context.getValue(NAME_PARAMETER_ORDERBY_TYPE);
        if (!CMyString.isEmpty(sOrderType)) {
            sOrderField = sOrderField + " " + sOrderType;
        }
        return sOrderField;
    }

    private static String getWhereStr(MethodContext _context) {
        String sSearchKey = _context.getValue(ATTR_NAME_SEARCHKEY);
        String sSearchValue = _context.getValue(ATTR_NAME_SEARCHVALUE);
        if (CMyString.isEmpty(sSearchKey) || CMyString.isEmpty(sSearchValue)) {
            return "";
        }
        StringTokenizer stKeys = new StringTokenizer(sSearchKey, ",");
        String sWhere = "";
        boolean bFirst = true;
        while (stKeys.hasMoreTokens()) {
            String sKey = stKeys.nextToken();
            if (bFirst) {
                sWhere = MethodContextHelper.getSingleWhereSQL(sKey, sSearchValue);
                bFirst = sWhere.length() == 0;
                continue;
            }
            String temp = MethodContextHelper.getSingleWhereSQL(sKey, sSearchValue);
            if (temp.length() <= 0) continue;
            sWhere = sWhere + " or " + temp;
        }
        return sWhere;
    }

    private static String getSingleWhereSQL(String _sFieldName, String _sSearchValue) {
        String sSearchValue = CMyString.filterForSQL(_sSearchValue);
        return _sFieldName + " like '%" + sSearchValue + "%'";
    }
}

